#include "Arduino.h"
#include "BMZ00050.h"


#define HAL(func)   (_interface->func)

BMZ00050::BMZ00050(BMZ00050Interface &interface)
{
    _interface = &interface;
}

void BMZ00050::begin()
{
    HAL(begin)();
}

uint32_t BMZ00050::getFirmwareVersion(void)
{
    uint16_t response;
    BMZ00050_packetbuffer[0] = GETFIRMWAREVERSION;
    if (HAL(writeCommand)(BMZ00050_packetbuffer, 1))
    {
        return 0;
    }
    // read data packet
    int16_t status = HAL(readResponse)(BMZ00050_packetbuffer, sizeof(BMZ00050_packetbuffer));
    if (0 > status)
    {     
        return 0;
    }
    response = BMZ00050_packetbuffer[0];
    response <<= 8;
    response |= BMZ00050_packetbuffer[1];
    return response;
}
uint8_t BMZ00050::GetStatusRegister(void)
{
    uint8_t response;
    BMZ00050_packetbuffer[0] = GETSTATUSREGISTER;  
    if (HAL(writeCommand)(BMZ00050_packetbuffer, 1))
    {
        return 0;
    }
    // read data packet
    int16_t status = HAL(readResponse)(BMZ00050_packetbuffer, sizeof(BMZ00050_packetbuffer));
    if (0 > status)
    {     
        return 0;
    }
    response = BMZ00050_packetbuffer[0];
    return response;
}
uint8_t BMZ00050::ReadNFCMemoryEeprom(uint8_t buff[])
{
    BMZ00050_packetbuffer[0] = READNFCMEMORYEEPROM;  
    BMZ00050_packetbuffer[1] = 0x04;    //  Read NFC Memory Page4,first
    BMZ00050_packetbuffer[2] = 0x01;    //  read Page Length
    if (HAL(writeCommand)(BMZ00050_packetbuffer, 3))
    {
        return 0;
    }
    // read data packet
    int16_t status = HAL(readResponse)(BMZ00050_packetbuffer, sizeof(BMZ00050_packetbuffer));
    if (0 > status)
    {     
        return 0;
    }
    for(uint8_t i = 0; i < 6; i++)
    {
      buff[i] = BMZ00050_packetbuffer[i];
    }
    return 0x01;  
 }
uint8_t BMZ00050::WriteNFCMemoryEeprom(uint8_t buff[])
{
    BMZ00050_packetbuffer[0] = WRITENFCMEMORYEEPROM;  
    //BMZ00050_packetbuffer[1] = 0x04;    //  Read NFC Memory Page4,first
    //BMZ00050_packetbuffer[2] = 0x01;    //  read Page Length
    for(uint8_t i = 0; i < 6; i++)
    {
      BMZ00050_packetbuffer[i+1] = buff[i];
    }
    if (HAL(writeCommand)(BMZ00050_packetbuffer, 7))
    {
        return 0;
    }
    // read data packet
    int16_t status = HAL(readResponse)(BMZ00050_packetbuffer, sizeof(BMZ00050_packetbuffer));
    if (0 > status)
    {     
        return 0;
    }
    return 0x01;  
 }
uint8_t BMZ00050::ReadNFCMemorySram(uint8_t buff[])
{
    BMZ00050_packetbuffer[0] = READNFCMEMORYSRAM;  
    BMZ00050_packetbuffer[1] = 0x41;    //  Read NFC SRAM Page40,first page
    BMZ00050_packetbuffer[2] = 0x01;    //  read Page Length
    if (HAL(writeCommand)(BMZ00050_packetbuffer, 3))
    {
        return 0;
    }
    // read data packet
    int16_t status = HAL(readResponse)(BMZ00050_packetbuffer, sizeof(BMZ00050_packetbuffer));
    if (0 > status)
    {     
        return 0;
    }
    for(uint8_t i = 0; i < 6; i++)
    {
      buff[i] = BMZ00050_packetbuffer[i];
      BMZ00050_packetbuffer[i] = 0xff;
    }
    return 0x01;  
 }
uint8_t BMZ00050::WriteNFCMemorySram(uint8_t buff[])
{
    BMZ00050_packetbuffer[0] = WRITENFCMEMORYSRAM;  
    //BMZ00050_packetbuffer[1] = 0x40;    //  Read NFC Memory Page40,first
    //BMZ00050_packetbuffer[2] = 0x01;    //  read Page Length
    for(uint8_t i = 0; i < 6; i++)
    {
      BMZ00050_packetbuffer[i+1] = buff[i];
    }
    if (HAL(writeCommand)(BMZ00050_packetbuffer, 7))
    {
        return 0;
    }
    // read data packet
    int16_t status = HAL(readResponse)(BMZ00050_packetbuffer, sizeof(BMZ00050_packetbuffer));
    if (0 > status)
    {     
        return 0;
    }
    return 0x01;  
 }
 
uint32_t BMZ00050::T_getFirmwareVersion(void)
{
    uint16_t response;
    BMZ00050_packetbuffer[0] = 0x20;      //Header
    BMZ00050_packetbuffer[1] = GETFIRMWAREVERSION;
    if (HAL(T_writeCommand)(BMZ00050_packetbuffer, 2))
    {
        return 0;
    }

    // read data packet
    int16_t status = HAL(T_readResponse)(BMZ00050_packetbuffer, sizeof(BMZ00050_packetbuffer));
    if (0 > status)
    {     
        return 0;
    }

    response = BMZ00050_packetbuffer[0];
    response <<= 8;
    response |= BMZ00050_packetbuffer[1];

    return response;
}
uint8_t BMZ00050::T_GetStatusRegister(void)
{
    uint8_t response;
    BMZ00050_packetbuffer[0] = 0x20;      //Header
    BMZ00050_packetbuffer[1] = GETSTATUSREGISTER;
    if (HAL(T_writeCommand)(BMZ00050_packetbuffer, 2))
    {
        return 0;
    }
    // read data packet
    int16_t status = HAL(T_readResponse)(BMZ00050_packetbuffer, sizeof(BMZ00050_packetbuffer));
    if (0 > status)
    {     
        return 0;
    }
    response = BMZ00050_packetbuffer[0];
    return response;
}
uint8_t BMZ00050::T_Rx_Data_Packet(uint8_t buff[])
{
    uint8_t response;  
    if (HAL(Rx_Data_Packet)(BMZ00050_packetbuffer, 2))
    {
        return 0;
    }  
    for(uint8_t i = 0; i < BMZ00050_packetbuffer[1]+2; i++)
    {
      buff[i] = BMZ00050_packetbuffer[i];
    }
    return 1;
 }

uint16_t BMZ00050::GetPID(void)
{
    uint16_t response;
    BMZ00050_packetbuffer[0] = GETPID;
    if (HAL(writeCommand)(BMZ00050_packetbuffer, 1))
    {
        return 0;
    }
    // read data packet
    int16_t status = HAL(readResponse)(BMZ00050_packetbuffer, sizeof(BMZ00050_packetbuffer));
    if (0 > status)
    {     
        return 0;
    }
    response = BMZ00050_packetbuffer[0];
    response <<= 8;
    response |= BMZ00050_packetbuffer[1];
    return response;
}

uint16_t BMZ00050::GetVID(void)
{
    uint16_t response;
    BMZ00050_packetbuffer[0] = GETVID;
    if (HAL(writeCommand)(BMZ00050_packetbuffer, 1))
    {
        return 0;
    }
    // read data packet
    int16_t status = HAL(readResponse)(BMZ00050_packetbuffer, sizeof(BMZ00050_packetbuffer));
    if (0 > status)
    {     
        return 0;
    }
    response = BMZ00050_packetbuffer[0];
    response <<= 8;
    response |= BMZ00050_packetbuffer[1];
    return response;
}
uint8_t BMZ00050::GetLVD(void)
{
    uint8_t response;
    BMZ00050_packetbuffer[0] = GETLVD;  
    if (HAL(writeCommand)(BMZ00050_packetbuffer, 1))
    {
        return 0;
    }
    // read data packet
    int16_t status = HAL(readResponse)(BMZ00050_packetbuffer, sizeof(BMZ00050_packetbuffer));
    if (0 > status)
    {     
        return 0;
    }
    response = BMZ00050_packetbuffer[0];
    return response;
}
uint8_t BMZ00050::SetLVD(uint8_t setlvdr)
{
    BMZ00050_packetbuffer[0] = SETLVD;  
    BMZ00050_packetbuffer[1] = setlvdr;       
    if (HAL(writeCommand)(BMZ00050_packetbuffer, 2))
    {
        return 0;
    }
    // read data packet
    int16_t status = HAL(readResponse)(BMZ00050_packetbuffer, sizeof(BMZ00050_packetbuffer));
    if (0 > status)
    {     
        return 0;
    }
    return 0x01;
 }
 uint8_t BMZ00050::SetHaltMode(uint8_t sethm)
{
    BMZ00050_packetbuffer[0] = SETHALTMODE;  
    BMZ00050_packetbuffer[1] = sethm;      
    if (HAL(writeCommand)(BMZ00050_packetbuffer, 2))
    {
        return 0;
    }
    // read data packet
    int16_t status = HAL(readResponse)(BMZ00050_packetbuffer, sizeof(BMZ00050_packetbuffer));
    if (0 > status)
    {     
        return 0;
    }
    return 0x01;
 }
 uint8_t BMZ00050::GetHaltMode(void)
{
    uint8_t response;
    BMZ00050_packetbuffer[0] = GETHALTMODE;  
    if (HAL(writeCommand)(BMZ00050_packetbuffer, 1))
    {
        return 0;
    }
    // read data packet
    int16_t status = HAL(readResponse)(BMZ00050_packetbuffer, sizeof(BMZ00050_packetbuffer));
    if (0 > status)
    {     
        return 0;
    }
    response = BMZ00050_packetbuffer[0];
    return response;
}
