#ifndef __BMZ00050_H__
#define __BMZ00050_H__

#define GETFIRMWAREVERSION                  (0x00)
#define GETSTATUSREGISTER                   (0x0A)
#define READNFCMEMORYEEPROM                 (0x1E)
#define GETPID                              (0x02)
#define GETVID                              (0x04)
#define SETLVD                              (0x0C)
#define GETLVD                              (0x0E)
#define SETHALTMODE                         (0x18)
#define GETHALTMODE                         (0x1A)
#define WRITENFCMEMORYEEPROM                (0x1C)
#define READNFCMEMORYSRAM                   (0x20)
#define WRITENFCMEMORYSRAM                  (0x22)
#include <stdint.h>
#include "BMZ00050Interface.h"

class BMZ00050
{
public:
    BMZ00050(BMZ00050Interface &interface);
    void begin(void);

    uint32_t getFirmwareVersion(void);
    uint16_t GetPID(void);
    uint16_t GetVID(void);
    uint8_t SetLVD(uint8_t);
    uint8_t GetLVD(void);
    uint8_t SetHaltMode(uint8_t);
    uint8_t GetHaltMode(void);
    uint8_t GetStatusRegister(void);
    uint8_t ReadNFCMemoryEeprom(uint8_t buff[]);
    uint8_t WriteNFCMemoryEeprom(uint8_t buff[]);
    uint8_t ReadNFCMemorySram(uint8_t buff[]);
    uint8_t WriteNFCMemorySram(uint8_t buff[]);
    
    uint32_t T_getFirmwareVersion(void);
    uint8_t T_GetStatusRegister(void);   
    uint8_t T_Rx_Data_Packet(uint8_t buff[]) ;   
private:

    uint8_t BMZ00050_packetbuffer[255];
    BMZ00050Interface *_interface;
};


#endif
