#ifndef __BMZ00050_INTERFACE_H__
#define __BMZ00050_INTERFACE_H__

#include <stdint.h>

#define PREAMBLE                        (0x00)
#define STARTCODE1                      (0x00)
#define STARTCODE2                      (0xFF)
#define POSTAMBLE                       (0x00)

#define HOSTTOBMZ00050                  (0xD4)
#define BMZ00050TOHOST                  (0xD5)

#define BMZ00050_ACK_WAIT_TIME           (20)  // ms, timeout of waiting for ACK

#define BMZ00050_INVALID_ACK             (-1)
#define BMZ00050_TIMEOUT                 (-2)
#define BMZ00050_INVALID_FRAME           (-3)
#define BMZ00050_NO_SPACE                (-5)

#define  INT    8

class BMZ00050Interface
{
  public:
    virtual void begin() = 0; 
    virtual int8_t   writeCommand(const uint8_t *header, uint8_t hlen, const uint8_t *body = 0, uint8_t blen = 0) = 0;
    virtual int16_t  readResponse(uint8_t buf[], uint8_t len, uint16_t timeout = 2000) = 0;
    virtual int16_t  T_readResponse(uint8_t buf[], uint8_t len, uint16_t timeout = 2000) = 0;
    virtual int8_t   T_writeCommand(const uint8_t *header, uint8_t hlen, const uint8_t *body = 0, uint8_t blen = 0) = 0;
    virtual uint8_t  Rx_Data_Packet(uint8_t buf[], uint8_t len, uint16_t timeout = 2000)= 0;
};


#endif
