
#include "BMZ00050_SPI.h"
#include "BMZ00050_debug.h"
#include "Arduino.h"

#define STATUS_READ     2
#define DATA_WRITE      1
#define DATA_READ       3

BMZ00050_SPI::BMZ00050_SPI(SPIClass &spi, uint8_t ss)
{
    command = 0;
    _spi = &spi;
    _ss  = ss;
}

void BMZ00050_SPI::begin()
{
    pinMode(_ss, OUTPUT);

    _spi->begin();
    _spi->setDataMode(SPI_MODE0);   //BMZ00050 only supports mode0
    _spi->setBitOrder(MSBFIRST);    //MSB 

    _spi->setClockDivider(SPI_CLOCK_DIV128); // set clock 0.125MHz     16Mhz/128
}
int8_t BMZ00050_SPI::writeCommand(const uint8_t *header, uint8_t hlen, const uint8_t *body, uint8_t blen)
{
    command = header[0];
    writeFrame(header, hlen, body, blen);

    uint8_t timeout = BMZ00050_ACK_WAIT_TIME;
    while (!isReady()) 
    {
        delay(1);
        timeout--;
        if (0 == timeout)
        { 
            DMSG("Time out when waiting for ACK\n");
            return -2;
        }
    }
    if (readAckFrame()) 
    {
        DMSG("Invalid ACK\n");
        return BMZ00050_INVALID_ACK;
    }
    return 0;
}
int16_t BMZ00050_SPI::readResponse(uint8_t buf[], uint8_t len, uint16_t timeout)
{
    uint16_t time = 0;

    while (!isReady())
    {
        delay(1);
        time++;
        if (timeout > 0 && time > timeout) 
        {         
            return BMZ00050_TIMEOUT;
        }
    }

    digitalWrite(_ss, LOW);   

    int16_t result;
    uint8_t CodeHeader[3];
    do {
        write(DATA_READ);
        delayMicroseconds(20);    
        for(uint8_t i = 0; i < 3; i++)
        {
          CodeHeader[i] = read();
          delayMicroseconds(20); 
        }
        if( 0x00 !=CodeHeader[0] || 0x00 !=CodeHeader[1] || 0xFF !=CodeHeader[2])         // PREAMBLE,STARTCODE1,STARTCODE2                
        {              
           result = BMZ00050_INVALID_FRAME;
           break;                    
        }
   
        uint8_t length = read(); 

        delayMicroseconds(20); 
        if (0 != (uint8_t)(length + read())) {   // checksum of length
            
            result = BMZ00050_INVALID_FRAME;
            break;
        }               
        uint8_t cmd = command + 1;               // response command
        delayMicroseconds(20);
        if (BMZ00050TOHOST != read() )
        { 
            result = BMZ00050_INVALID_FRAME;
            break;
        }
        delayMicroseconds(20);
        if( (cmd) != read())
        {     
            result = BMZ00050_INVALID_FRAME;
            break;
        }
        DMSG("\nread:  ");
        DMSG_HEX(cmd);

        length -= 2;
        if (length > len) 
        {
            for (uint8_t i = 0; i < length; i++)
            { 
                delayMicroseconds(20); 
                DMSG_HEX(read());                 // dump message
            }
            DMSG("\nNot enough space\n");
            delayMicroseconds(20); 
            read();
            delayMicroseconds(20); 
            read();
            result = BMZ00050_NO_SPACE;  // not enough space
            break;
        }

        uint8_t sum = BMZ00050TOHOST + cmd;
        for (uint8_t i = 0; i < length; i++) {
            delayMicroseconds(20); 
            buf[i] = read();
            sum += buf[i];

            DMSG_HEX(buf[i]);
        }
        DMSG('\n');
        delayMicroseconds(20); 
        uint8_t checksum = read();
        if (0 != (uint8_t)(sum + checksum)) {
            DMSG("checksum is not ok\n");
            result = BMZ00050_INVALID_FRAME;
            break;
        }
        delayMicroseconds(20); 
        read();         // POSTAMBLE

        result = length;
    } while (0);

    digitalWrite(_ss, HIGH);
  
    return result;
}

boolean BMZ00050_SPI::isReady()
{
    digitalWrite(_ss, LOW);
    delayMicroseconds(20);
    write(STATUS_READ);
    delayMicroseconds(20); 
    uint8_t status = read() & 1;
    digitalWrite(_ss, HIGH);
    return status;
}
void BMZ00050_SPI::writeFrame(const uint8_t *header, uint8_t hlen, const uint8_t *body, uint8_t blen)
{
    digitalWrite(_ss, LOW);

    write(0x01);          
    write(PREAMBLE);
    write(STARTCODE1);
    write(STARTCODE2);
  
    uint8_t length = hlen + blen + 1;   // length of data field: TFI + DATA
    write(length);

    write(~length + 1);         // checksum of length

    write(HOSTTOBMZ00050);
    uint8_t sum = HOSTTOBMZ00050;    // sum of TFI + DATA

    DMSG("write: ");

    for (uint8_t i = 0; i < hlen; i++) {
   
        write(header[i]);
        sum += header[i];

        DMSG_HEX(header[i]);
    }
    for (uint8_t i = 0; i < blen; i++) {

        write(body[i]);
        sum += body[i];

      DMSG_HEX(body[i]);
    }

    uint8_t checksum = ~sum + 1;        // checksum of TFI + DATA

    write(checksum);

    write(POSTAMBLE);

    digitalWrite(_ss, HIGH);

    DMSG('\n');
}

int8_t BMZ00050_SPI::readAckFrame()
{
    const uint8_t BMZ00050_ACK[] = {0, 0, 0xFF, 0, 0xFF, 0};

    uint8_t ackBuf[sizeof(BMZ00050_ACK)];

    digitalWrite(_ss, LOW);

    write(DATA_READ);
    
    DMSG("Ack: ");
    
    for (uint8_t i = 0; i < sizeof(BMZ00050_ACK); i++)
    {
        delayMicroseconds(20);
        ackBuf[i] = read();
        DMSG_HEX(ackBuf[i]);
    }

    digitalWrite(_ss, HIGH);

    return memcmp(ackBuf, BMZ00050_ACK, sizeof(BMZ00050_ACK));
}
int8_t BMZ00050_SPI:: T_writeCommand(const uint8_t *header, uint8_t hlen, const uint8_t *body = 0, uint8_t blen = 0)
{
    digitalWrite(_ss, LOW);

    uint8_t write_count = 0;
    write_count = hlen + blen;
    
    write(0x80+write_count);

    for (uint8_t i = 0; i < hlen; i++)
    {         
        write(header[i]);
    }
    for (uint8_t i = 0; i < blen; i++)
    {         
        write(body[i]);
    }    
    digitalWrite(_ss, HIGH);
    return 0;
}
int16_t BMZ00050_SPI::T_readResponse(uint8_t buf[], uint8_t len, uint16_t timeout)
{
    uint8_t tmp[2];
    
    DMSG("\nRead:  ");   
    uint8_t time_count = 0; 
    uint8_t length[1] = {0}; 
    do
    {   
        time_count ++;
        delay(1);
        if(time_count > 20)
        {
          return BMZ00050_TIMEOUT;
        }
        if(digitalRead(INT) == 0)  
        {          
          digitalWrite(_ss, LOW);    
          write(0x40+63);
    
          delayMicroseconds(20);
          tmp[0] = read();   //  header
          DMSG_HEX(tmp[0]);
    
          delayMicroseconds(20);  
          tmp[1] = read();   //command;       
          DMSG_HEX(tmp[1]);
    
           delayMicroseconds(20);   
    
           length[0] = read();
           DMSG_HEX(length[0]);
              
           delayMicroseconds(20); 

           for (uint8_t i = 0; i < length[0]; i++) 
           {    
              delayMicroseconds(20); 
              buf[i] = read();
              DMSG_HEX(buf[i]);
           }  
           digitalWrite(_ss, HIGH);  
           break;        
         }
      }while(1);
    return length[0];
}
uint8_t BMZ00050_SPI::Rx_Data_Packet(uint8_t buf[], uint8_t len, uint16_t timeout)
{  
    if(digitalRead(INT) == 0)  
    { 
      digitalWrite(_ss, LOW);    
      write(0x40+63); 
          
      delayMicroseconds(20); 
      buf[0] = read();  //header
      
      delayMicroseconds(20); 
      buf[1] = read();  //length
      for (uint8_t i = 0; i < buf[1]; i++)
      {   
        delayMicroseconds(20);  
        buf[i+2] = read();    
      }   
      return 0;         
   } 
     return 1;
}
