#ifndef __BMZ00050_UART_H__
#define __BMZ00050_UART_H__

#include "BMZ00050Interface.h"
#include "Arduino.h"
#include "SoftwareSerial.h"

class BMZ00050_UART : public BMZ00050Interface 
{
  public:
    void begin(); 
    virtual int8_t writeCommand(const uint8_t *header, uint8_t hlen, const uint8_t *body = 0, uint8_t blen = 0);
    int8_t readAckFrame();
    int8_t receive(uint8_t *buf, int len, uint16_t timeout);
    int16_t readResponse(uint8_t buf[], uint8_t len, uint16_t timeout);
    int8_t T_writeCommand(const uint8_t *header, uint8_t hlen, const uint8_t *body = 0, uint8_t blen = 0);
     int16_t T_readResponse(uint8_t buf[], uint8_t len, uint16_t timeout)  ;
     uint8_t Rx_Data_Packet(uint8_t buf[], uint8_t len, uint16_t timeout);
  private:
    uint8_t command;

};
#endif
