#include "BMZ00050_UART.h"
#include "BMZ00050_debug.h"

SoftwareSerial mySerial(2, 3); // RX, TX

void BMZ00050_UART::begin()
{
    mySerial.begin(9600); 
}
int8_t BMZ00050_UART:: writeCommand(const uint8_t *header, uint8_t hlen, const uint8_t *body = 0, uint8_t blen = 0)
{


    command = header[0];
    mySerial.write(uint8_t(PREAMBLE));
    mySerial.write(uint8_t(STARTCODE1));
    mySerial.write(STARTCODE2);
    
    uint8_t length = hlen + blen + 1;     // length of data field: TFI + DATA
    mySerial.write(length);
    mySerial.write(~length + 1);          // checksum of length
    
    mySerial.write(HOSTTOBMZ00050);
    uint8_t sum = HOSTTOBMZ00050;         // sum of TFI + DATA
  
    mySerial.write(header, hlen);
    for (uint8_t i = 0; i < hlen; i++) 
    {
        sum += header[i];
    }

    mySerial.write(body, blen);
    for (uint8_t i = 0; i < blen; i++) 
    {
        sum += body[i];
    }
    
    uint8_t checksum = ~sum + 1;            // checksum of TFI + DATA
    mySerial.write(checksum);
//    mySerial.write(uint8_t(POSTAMBLE));   //使用模擬UART，BMZ00050響應返回值還在發送數據，導致接收輸出出錯，
    return readAckFrame();
}
int16_t BMZ00050_UART::readResponse(uint8_t buf[], uint8_t len, uint16_t timeout)
{
    uint8_t tmp[3];
    
    DMSG("\nRead:  ");
    
    /** Frame Preamble and Start Code */
    if(receive(tmp, 3, timeout)<=0)   //Read 3 byte, PREAMBLE,STARTCODE1,STARTCODE2
    {
        return BMZ00050_TIMEOUT;
    }
    if(0 != tmp[0] || 0!= tmp[1] || 0xFF != tmp[2])
    {
        DMSG("Preamble error");
        return BMZ00050_INVALID_FRAME;
    }
   
    /** receive length and check */
    uint8_t length[2];
    if(receive(length, 2, timeout) <= 0)
    {
        return BMZ00050_TIMEOUT;
    }
    if( 0 != (uint8_t)(length[0] + length[1]) )
    {
        DMSG("Length error");
        return BMZ00050_INVALID_FRAME;
    }
    length[0] -= 2;
    if( length[0] > len)
    {
        return BMZ00050_NO_SPACE;
    }
    
    /** receive command byte */
    uint8_t cmd = command + 1;               // response command
    if(receive(tmp, 2, timeout) <= 0)         //read TFI, Command 
    {
        return BMZ00050_TIMEOUT;
    }
    if( BMZ00050TOHOST != tmp[0] || cmd != tmp[1])
    {
        DMSG("Command error");
        return BMZ00050_INVALID_FRAME;
    }
    
    if(receive(buf, length[0], timeout) != length[0])
    {
        return BMZ00050_TIMEOUT;
    }
    uint8_t sum = BMZ00050TOHOST + cmd;
    for(uint8_t i=0; i<length[0]; i++)
    {
        sum += buf[i];
    }
    
    /** checksum and postamble */
    if(receive(tmp, 2, timeout) <= 0)
    {
        return BMZ00050_TIMEOUT;
    }
    if( 0 != (uint8_t)(sum + tmp[0]) || 0 != tmp[1] )
    {
        DMSG("Checksum error");
        return BMZ00050_INVALID_FRAME;
    }
    
    return length[0];
}

int8_t BMZ00050_UART::readAckFrame()
{
    const uint8_t BMZ00050_ACK[] = {0, 0, 0xFF, 0, 0xFF, 0};
    uint8_t ackBuf[sizeof(BMZ00050_ACK)];
    
    DMSG("\nAck: ");  //Debug use
    if( receive(ackBuf, sizeof(BMZ00050_ACK), BMZ00050_ACK_WAIT_TIME) <= 0 )
    {
        DMSG("\nTimeout\n");
        return BMZ00050_TIMEOUT;
    }

    if( memcmp(ackBuf, BMZ00050_ACK, sizeof(BMZ00050_ACK)) )  //Comparison is equal
    {
        DMSG("Invalid\n");
        return BMZ00050_INVALID_ACK;
    }   
    return 0;
}
int8_t BMZ00050_UART::receive(uint8_t *buf, int len, uint16_t timeout)
{
  int read_bytes = 0;
  int ret;
  unsigned long start_millis;

  while (read_bytes < len) 
  {
    start_millis = millis();
    do 
    {
      ret = mySerial.read();
      if (ret >= 0) 
      {
        break;
      }
    } while((timeout == 0) || ((millis()- start_millis ) < timeout));
    
    if (ret < 0) 
    {
        if(read_bytes)
        {
            return read_bytes;
        }
        else
        {
            return BMZ00050_TIMEOUT;
        }
    }
    buf[read_bytes] = (uint8_t)ret;
    DMSG_HEX(ret);
    read_bytes++;
 }
  return read_bytes;
}
/************************************************************/
int8_t BMZ00050_UART:: T_writeCommand(const uint8_t *header, uint8_t hlen, const uint8_t *body = 0, uint8_t blen = 0)
{
   mySerial.write(header, hlen);

   mySerial.write(body, blen);

    return 0;
}
int16_t BMZ00050_UART::T_readResponse(uint8_t buf[], uint8_t len, uint16_t timeout)
{
    uint8_t tmp[2];
    
    DMSG("\nRead:  ");
    
    if(receive(tmp, 2, timeout)<=0)   
    {
     
        return BMZ00050_TIMEOUT;
    }

    /** receive length and check */
    uint8_t length[1];
    if(receive(length, 1, timeout) <= 0)
    {
        return BMZ00050_TIMEOUT;
    }

    if(receive(buf, length[0], timeout) != length[0])
    {
        return BMZ00050_TIMEOUT;
    }
  
    return length[0];
}

uint8_t BMZ00050_UART::Rx_Data_Packet(uint8_t buf[], uint8_t len, uint16_t timeout)
{

  
    if(receive(buf, 1, timeout)<=0)   
    {     
        return BMZ00050_TIMEOUT;
    }  
 
    if(receive(buf+1, 1, timeout)<=0)  
    {     
        return BMZ00050_TIMEOUT;
    }  
   
    if(receive(buf+2, buf[1], timeout) != buf[1])
    {
        return BMZ00050_TIMEOUT;
    }
    return 0;
}
