/* Example code for BMZ00050 NFC module v1.1 */

/* Communication interface selection, default is UART */
#if 0   // change 0 to 1 if you use SPI to communicate with BMZ00050, otherwise keep 0
   #include <SPI.h>
   #include "BMZ00050_SPI.h"
   #include "BMZ00050.h"
   BMZ00050_SPI bmz00050spi(SPI, 10);   //slaveSelectPin
   BMZ00050 nfc(bmz00050spi);
 
#elif 1  // chagen 1 to 0 if you don't use UART to communicate with BMZ00050, keep 1 if you use UART                                
   #include "BMZ00050_UART.h"
   #include "BMZ00050.h"
   BMZ00050_UART bmz00050uart;
   BMZ00050 nfc(bmz00050uart);
    
#else     // use I2C interface to communicate with BMX00050
   #include <Wire.h>
   #include "BMZ00050_I2C.h"
   #include "BMZ00050.h"
   BMZ00050_I2C bmz00050i2c(Wire);
   BMZ00050 nfc(bmz00050i2c);  
    
#endif

#define  Mode   0      //0：register access mode ，1：transparent transmission mode
                       // connect the MODE pin to GND when using transparent transmission mode
void setup() 
{
    // put your setup code here, to run once:
    Serial.begin(115200);
    Serial.println("\nHello!");
    Serial.println("This is NFC Module BMZ00050");     
    
    pinMode(INT,INPUT_PULLUP);
    
    nfc.begin();
     if(!Mode) 
    {
      uint8_t ModuleStatusRegister;
      do
      {
         ModuleStatusRegister = nfc.GetStatusRegister();    // wait initialization
         delay(1);
         Serial.println("wait BMZ00050 initialization");      
      }while(!(ModuleStatusRegister & 0x08));
       Serial.println("Initialization ok\n");  
       Serial.println("BMZ00050 in register access mode");
       uint16_t versiondata = nfc.getFirmwareVersion();
       if (! versiondata) 
       {
            Serial.println("Didn't find BMZ00050 board");
            while (1); // halt
       }
  
       Serial.print("Firmware ver. ");      
       Serial.print((versiondata>>8) & 0xFF, DEC); 
       Serial.print(".");  
       Serial.println((versiondata) & 0xFF, DEC);    
       uint16_t modulepid = nfc.GetPID();
       Serial.print("NFC module PID: 0x");
       Serial.print((modulepid>>8) & 0xFF, HEX);
       Serial.print("  0x");
       Serial.println(modulepid & 0xFF, HEX);   
       uint16_t modulevid = nfc.GetVID();
       Serial.print("NFC module Vendor ID: 0x");
       Serial.print((modulevid>>8) & 0xFF, HEX);
       Serial.print(" 0x");
       Serial.println(modulevid & 0xFF, HEX);       
       uint8_t lvdr = nfc.GetLVD();   
       Serial.print("read LVD register = 0x");
       Serial.println(lvdr & 0xFF, HEX);
       Serial.println("Set LVD at 4.0V, write LVD register value 0x17");
       nfc.SetLVD(0x17); // enable LVD at 4.0V
       lvdr = nfc.GetLVD();   
       Serial.print("read LVD register = 0x");
       Serial.println(lvdr & 0xFF, HEX);
       Serial.println("Set LVD at 2.7V, write LVD register value 0x13");
       nfc.SetLVD(0x13); // enable LVD at 2.7V       
       lvdr = nfc.GetLVD();   
       Serial.print("read LVD register = 0x");
       Serial.println(lvdr & 0xFF, HEX);
       uint8_t hmr = nfc.GetHaltMode();   
       Serial.print("read HM register = 0x");
       Serial.println(hmr & 0xFF, HEX);
       Serial.println("Set non-halt mode , write HM = 0x17");
       nfc.SetHaltMode(0x17); // overflow time 2048ms non-halt mode
       hmr = nfc.GetHaltMode();   
       Serial.print("read HM register = 0x");
       Serial.println(hmr & 0xFF, HEX);
       Serial.println("Set default value, write HM = 0x1C");
       nfc.SetHaltMode(0x1C); // overflow time 8192ms halt mode       
       hmr = nfc.GetHaltMode();   
       Serial.print("read HM register = 0x");
       Serial.println(hmr & 0xFF, HEX);
       
       uint8_t NFC_Memory_Buff[6] = {0x4, 0x1, 0xaa, 0xbb, 0xcc, 0xdd};
       nfc.WriteNFCMemoryEeprom(NFC_Memory_Buff);  //write NFC EEPROM page 4
       nfc.ReadNFCMemoryEeprom(NFC_Memory_Buff); 
          Serial.print(" \n"); 
          Serial.print("Read NFC EEPROM first Page address: "); 
          Serial.println(NFC_Memory_Buff[0],HEX); 
          Serial.print("Read NFC EEPROM Page length: "); 
          Serial.println(NFC_Memory_Buff[1],HEX); 
          Serial.print("Read NFC EEPROM Page data: ");                    
          for(uint8_t i = 2; i < 6; i++)
          {
             Serial.print(" 0x"); 
             Serial.print(NFC_Memory_Buff[i],HEX);           
          }
       //  the read/write SRAM example code is for reference
       /*   
       uint8_t NFC_Memory_Buffer[6] = {0x41, 0x1, 0x66, 0x77, 0x88, 0x99};
       nfc.WriteNFCMemorySram(NFC_Memory_Buffer);
       nfc.ReadNFCMemorySram(NFC_Memory_Buffer); 
          Serial.print(" \n"); 
          Serial.print("Read NFC SRAM first Page address: 0x"); 
          Serial.println(NFC_Memory_Buffer[0],HEX); 
          Serial.print("Read NFC SRAM Page length: 0x"); 
          Serial.println(NFC_Memory_Buffer[1],HEX); 
          Serial.print("Read NFC SRAM Page data: ");                    
          for(uint8_t i = 2; i < 6; i++)
          {
             Serial.print(" 0x"); 
             Serial.print(NFC_Memory_Buffer[i],HEX);           
          }
       */   
    } 
    else
    {
     uint8_t T_ModuleStatusRegister;
      do
      {
         T_ModuleStatusRegister = nfc.T_GetStatusRegister();    // wait initialization
         delay(1);
         Serial.println("wait BMZ00050 initialization");      
      }while(!(T_ModuleStatusRegister & 0x08)); 
       Serial.println("Initialization ok\n");  
      
      Serial.println("BMZ00050 in transparent transmission mode");
      uint16_t versiondata = nfc.T_getFirmwareVersion();    // wait initialization T_getFirmwareVersion
     if (! versiondata) 
      {
           Serial.println("Didn't find BMZ00050 board");
           while (1); // halt
      } 
       Serial.print("Firmware ver. ");      
       Serial.print((versiondata>>8) & 0xFF, DEC); 
       Serial.print(".");  
       Serial.print((versiondata) & 0xFF, DEC);               
    }    
}

void loop() 
{
     // put your main code here, to run repeatedly:
    if(!Mode)
    {   
       if(digitalRead(INT) == 0)
       {   
          uint8_t NFC_Memory_Buff[6];
          nfc.ReadNFCMemoryEeprom(NFC_Memory_Buff); 
          Serial.print(" \n"); 
          Serial.print("Read NFC EEPROM Page: "); 
          Serial.println(NFC_Memory_Buff[0],DEC); 
          Serial.print("Read NFC EEPROM Page length: "); 
          Serial.println(NFC_Memory_Buff[1],DEC); 
          Serial.print("Read NFC EEPROM data: ");                    
          for(uint8_t i = 2; i < 6; i++)
          {
             Serial.print("   "); 
             Serial.print(NFC_Memory_Buff[i],DEC);           
          }   
       }     
     }   
     else
     {      
           uint8_t T_data_buff[64];
           if(!nfc.T_Rx_Data_Packet(T_data_buff))
           {          
              Serial.println(" \nWaiting for data sent by external NFC device");
              delay(1000);
           }
           else
           {
                Serial.print(" \n"); 
                Serial.print("Header: "); 
                Serial.println(T_data_buff[0],HEX); 
                Serial.print("data length: "); 
                Serial.println(T_data_buff[1],HEX); 
                Serial.print("data: ");                    
                for(uint8_t i = 2; i < T_data_buff[1]+2; i++)
                {
                   Serial.print("  "); 
                   Serial.print(T_data_buff[i],HEX);           
                }                         
           }
     }
}
