/*************************************************
File:         readGasValue.ino
Description:  Module driven DC motor rotation   
Note:         Module M1A, M1B, M2A, and M2B pins are connected to BMduino UNO pins 0, 1, 2, and 3, respectively
**************************************************/
#include "BM22D1221_1421.h"

BM22D1221_1421 dcmotor;                 //Creating DC Motor Objects
void setup()
{
  dcmotor.begin();                      //Object initialization
}
void loop()
{
  dcmotor.dcMotorRun(2,80);             //DC motor 2 rotates forward at a speed of 80 gears
  dcmotor.dcMotorRun(3,80);             //DC motor 3 rotates forward at a speed of 80 gears
  delay(3000);                          //DC motor rotates for 3 seconds
  dcmotor.dcMotorStop(2);               //DC motor 2 standby
  dcmotor.dcMotorStop(3);               //DC motor 3 standby
  delay(1000);                          //DC motor standby for 1 second
  dcmotor.dcMotorRun(2,-100);           //DC motor 2 reverses at a speed of 100 gears
  dcmotor.dcMotorRun(3,-100);           //DC motor 3 reverses at a speed of 100 gears
  delay(3000);                          //DC motor rotates for 3 seconds
  dcmotor.dcMotorBrake(2);              //DC motor 2 braking
  dcmotor.dcMotorBrake(3);              //DC motor 3 braking
  delay(1000);                          //DC motor braking for 1 second
}
