#ifndef _FONT_H
#define _FONT_H

#include <Arduino.h>

const unsigned char ASCII_8X8[95][8] = {
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, //0
{0x08,0x08,0x08,0x08,0x00,0x00,0x08,0x00}, //"!",0
{0x14,0x14,0x14,0x00,0x00,0x00,0x00,0x00}, //""",1
{0x14,0x14,0x3E,0x14,0x3E,0x14,0x14,0x00}, //"#",2
{0x08,0x3C,0x0A,0x1C,0x28,0x1E,0x08,0x00}, //"$",3
{0x06,0x26,0x10,0x08,0x04,0x62,0x60,0x00}, //"%",4
{0x0C,0x12,0x0A,0x04,0x2A,0x12,0x2C,0x00}, //"&",5
{0x0C,0x08,0x04,0x00,0x00,0x00,0x00,0x00}, //"'",6
{0x10,0x08,0x04,0x04,0x04,0x08,0x10,0x00}, //"(",7
{0x04,0x08,0x10,0x10,0x10,0x08,0x04,0x00}, //")",8
{0x00,0x08,0x2A,0x1C,0x2A,0x08,0x00,0x00}, //"*",9
{0x00,0x08,0x08,0x3E,0x08,0x08,0x00,0x00}, //"+",10
{0x00,0x00,0x00,0x00,0x0C,0x08,0x04,0x00}, //",",11
{0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x00}, //"-",12
{0x00,0x00,0x00,0x00,0x00,0x0C,0x0C,0x00}, //".",13
{0x00,0x20,0x10,0x08,0x04,0x02,0x00,0x00}, //"/",14
{0x1C,0x22,0x32,0x2A,0x26,0x22,0x1C,0x00}, //"0",15
{0x08,0x0C,0x08,0x08,0x08,0x08,0x1C,0x00}, //"1",16
{0x1C,0x22,0x20,0x10,0x08,0x04,0x3E,0x00}, //"2",17
{0x3E,0x10,0x08,0x10,0x20,0x22,0x1C,0x00}, //"3",18
{0x10,0x18,0x14,0x12,0x3E,0x10,0x10,0x00}, //"4",19
{0x3E,0x02,0x1E,0x20,0x20,0x22,0x1C,0x00}, //"5",20
{0x18,0x04,0x02,0x1E,0x22,0x22,0x1C,0x00}, //"6",21
{0x3E,0x22,0x20,0x10,0x08,0x08,0x08,0x00}, //"7",22
{0x1C,0x22,0x22,0x1C,0x22,0x22,0x1C,0x00}, //"8",23
{0x1C,0x22,0x22,0x3C,0x20,0x10,0x0C,0x00}, //"9",24
{0x00,0x0C,0x0C,0x00,0x0C,0x0C,0x00,0x00}, //":",25
{0x00,0x0C,0x0C,0x00,0x0C,0x08,0x04,0x00}, //";",26
{0x10,0x08,0x04,0x02,0x04,0x08,0x10,0x00}, //"<",27
{0x00,0x00,0x3E,0x00,0x3E,0x00,0x00,0x00}, //"=",28
{0x04,0x08,0x10,0x20,0x10,0x08,0x04,0x00}, //">",29
{0x1C,0x22,0x20,0x10,0x08,0x00,0x08,0x00}, //"?",30
{0x1C,0x22,0x20,0x2C,0x2A,0x2A,0x1C,0x00}, //"@",31
{0x08,0x14,0x22,0x22,0x3E,0x22,0x22,0x00}, //"A",32
{0x1E,0x22,0x22,0x1E,0x22,0x22,0x1E,0x00}, //"B",33
{0x1C,0x22,0x02,0x02,0x02,0x22,0x1C,0x00}, //"C",34
{0x0E,0x12,0x22,0x22,0x22,0x12,0x0E,0x00}, //"D",35
{0x3E,0x02,0x02,0x1E,0x02,0x02,0x3E,0x00}, //"E",36
{0x3E,0x02,0x02,0x1E,0x02,0x02,0x02,0x00}, //"F",37
{0x1C,0x22,0x02,0x3A,0x22,0x22,0x3C,0x00}, //"G",38
{0x22,0x22,0x22,0x3E,0x22,0x22,0x22,0x00}, //"H",39
{0x1C,0x08,0x08,0x08,0x08,0x08,0x1C,0x00}, //"I",40
{0x38,0x10,0x10,0x10,0x10,0x12,0x0C,0x00}, //"J",41
{0x22,0x12,0x0A,0x06,0x0A,0x12,0x22,0x00}, //"K",42
{0x02,0x02,0x02,0x02,0x02,0x02,0x3E,0x00}, //"L",43
{0x22,0x36,0x2A,0x2A,0x22,0x22,0x22,0x00}, //"M",44
{0x22,0x22,0x26,0x2A,0x32,0x22,0x22,0x00}, //"N",45
{0x1C,0x22,0x22,0x22,0x22,0x22,0x1C,0x00}, //"O",46
{0x1E,0x22,0x22,0x1E,0x02,0x02,0x02,0x00}, //"P",47
{0x1C,0x22,0x22,0x22,0x2A,0x12,0x2C,0x00}, //"Q",48
{0x1E,0x22,0x22,0x1E,0x0A,0x12,0x22,0x00}, //"R",49
{0x1C,0x22,0x02,0x1C,0x20,0x22,0x1C,0x00}, //"S",50
{0x3E,0x08,0x08,0x08,0x08,0x08,0x08,0x00}, //"T",51
{0x22,0x22,0x22,0x22,0x22,0x22,0x1C,0x00}, //"U",52
{0x22,0x22,0x22,0x22,0x22,0x14,0x08,0x00}, //"V",53
{0x22,0x22,0x22,0x2A,0x2A,0x2A,0x14,0x00}, //"W",54
{0x22,0x22,0x14,0x08,0x14,0x22,0x22,0x00}, //"X",55
{0x22,0x22,0x22,0x14,0x08,0x08,0x08,0x00}, //"Y",56
{0x3E,0x20,0x10,0x08,0x04,0x02,0x3E,0x00}, //"Z",57
{0x1C,0x04,0x04,0x04,0x04,0x04,0x1C,0x00}, //"[",58
{0x00,0x02,0x04,0x08,0x10,0x20,0x00,0x00}, //"\",59
{0x1C,0x10,0x10,0x10,0x10,0x10,0x1C,0x00}, //"]",60
{0x08,0x14,0x22,0x00,0x00,0x00,0x00,0x00}, //"^",61
{0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00}, //"_",62
{0x04,0x08,0x10,0x00,0x00,0x00,0x00,0x00}, //"`",63
{0x00,0x00,0x1C,0x20,0x3C,0x22,0x3C,0x00}, //"a",64
{0x02,0x02,0x1A,0x26,0x22,0x22,0x1E,0x00}, //"b",65
{0x00,0x00,0x1C,0x02,0x02,0x22,0x1C,0x00}, //"c",66
{0x20,0x20,0x2C,0x32,0x22,0x22,0x3C,0x00}, //"d",67
{0x00,0x00,0x1C,0x22,0x3E,0x02,0x1C,0x00}, //"e",68
{0x18,0x24,0x04,0x0E,0x04,0x04,0x04,0x00}, //"f",69
{0x00,0x00,0x3C,0x22,0x3C,0x20,0x1C,0x00}, //"g",70
{0x02,0x02,0x1A,0x26,0x22,0x22,0x22,0x00}, //"h",71
{0x08,0x00,0x08,0x0C,0x08,0x08,0x1C,0x00}, //"i",72
{0x10,0x00,0x18,0x10,0x10,0x12,0x0C,0x00}, //"j",73
{0x02,0x02,0x12,0x0A,0x06,0x0A,0x12,0x00}, //"k",74
{0x0C,0x08,0x08,0x08,0x08,0x08,0x1C,0x00}, //"l",75
{0x00,0x00,0x16,0x2A,0x2A,0x2A,0x22,0x00}, //"m",76
{0x00,0x00,0x1A,0x26,0x22,0x22,0x22,0x00}, //"n",77
{0x00,0x00,0x1C,0x22,0x22,0x22,0x1C,0x00}, //"o",78
{0x00,0x00,0x1E,0x22,0x1E,0x02,0x02,0x00}, //"p",79
{0x00,0x00,0x2C,0x32,0x3C,0x20,0x20,0x00}, //"q",80
{0x00,0x00,0x1A,0x26,0x02,0x02,0x02,0x00}, //"r",81
{0x00,0x00,0x1C,0x02,0x1C,0x20,0x1E,0x00}, //"s",82
{0x04,0x04,0x0E,0x04,0x04,0x24,0x18,0x00}, //"t",83
{0x00,0x00,0x22,0x22,0x22,0x32,0x2C,0x00}, //"u",84
{0x00,0x00,0x22,0x22,0x22,0x14,0x08,0x00}, //"v",85
{0x00,0x00,0x22,0x2A,0x2A,0x14,0x00,0x00}, //"w",86
{0x00,0x00,0x22,0x14,0x08,0x14,0x22,0x00}, //"x",87
{0x00,0x00,0x22,0x22,0x3C,0x20,0x1C,0x00}, //"y",88
{0x00,0x00,0x3E,0x10,0x08,0x04,0x3E,0x00}, //"z",89
{0x10,0x08,0x08,0x04,0x08,0x08,0x10,0x00}, //"{",90
{0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00}, //"|",91
{0x04,0x08,0x08,0x10,0x08,0x08,0x04,0x00}, //"}",92
{0x00,0x00,0x00,0x2C,0x1A,0x00,0x00,0x00}, //"~",93
};
const unsigned char ASCII_8X8_1[8][32] = {
{0,0,1,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1},
{0,0,1,0,0,1,0,0,1,1,1,0,0,1,0,0,0,1,0,0,0,1,1,1,0,0,1,0,0,1,0},
{0,0,1,0,0,1,0,1,0,0,0,1,0,1,0,0,1,1,1,0,1,0,0,0,1,0,1,0,1,0,0},
{0,0,1,1,1,1,0,1,0,0,0,1,0,1,0,0,0,1,0,0,1,1,1,1,0,0,1,1,0,0,0},
{0,0,1,0,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,0,0},
{0,0,1,0,0,1,0,0,1,1,1,0,0,1,0,0,0,1,0,1,0,1,1,1,0,0,1,0,1,0,0},
{0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1},

  
};
const unsigned char ASCII_8X8_2[16][56] = {
{0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1},
{0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0},
{0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0},
{0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0},
{0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0},
{0,0,1,0,0,0,0,1,0,0,1,1,1,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,0,0,1,0,0,0,0,0},
{0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,1,0,1,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0},
{0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0},
{0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,1,0,1,0,0,0,0,0,0},
{0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0},
{0,0,1,0,0,0,0,1,0,0,1,1,1,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0},
{0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,1,0,0,0},
{0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0},
{0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1},

};  
const unsigned char ASCII_8X8_3[192] = {
  0xE0, 0xE0, 0x18, 0xE6, 0xE6, 0x04, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x43,
  0x00, 0x00, 0x46, 0xFF, 0xFF, 0x00, 0xDF, 0xDF, 0x07, 0xE7, 0xE7, 0x05,
  0xDD, 0xDD, 0x17, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x55, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x5C, 0xFF, 0xFF, 0x00, 0xE4, 0xE4, 0x06,
  0xFF, 0xFF, 0x0A, 0x00, 0x00, 0x51, 0xFF, 0xFF, 0x00, 0xE9, 0xE9, 0x05,
  0xE6, 0xE6, 0x06, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x5B, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x50, 0xFF, 0xFF, 0x00, 0xEA, 0xEA, 0x04, 0xE8, 0xE8, 0x05,
  0xE9, 0xE9, 0x05, 0xE4, 0xE4, 0x06, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x42,
  0x21, 0x21, 0x46, 0xF6, 0xF6, 0x00, 0xE9, 0xE9, 0x05, 0xE7, 0xE7, 0x05,
  0xE7, 0xE7, 0x05, 0xE6, 0xE6, 0x05, 0xFF, 0xFF, 0x00, 0x1C, 0x1C, 0x38,
  0x00, 0x00, 0x50, 0xFF, 0xFF, 0x00, 0xE7, 0xE7, 0x06, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0xE1, 0xE1, 0x06, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x43,
  0xFF, 0xFF, 0x0A, 0x00, 0x00, 0x50, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x4C,
  0x00, 0x00, 0x50, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x5B, 0xFF, 0xFF, 0x00,
  0xDE, 0xDE, 0x17, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x4B, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x50, 0xFF, 0xFF, 0x00, 0xE6, 0xE6, 0x06
};
const unsigned char ASCII_8X8_4[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0E,
  0x0F, 0x0F, 0x0E, 0x0F, 0x0F, 0x0E, 0x0F, 0x0F, 0x0E, 0x0F, 0x0F, 0x0E,
  0x0F, 0x0F, 0x0E, 0x0F, 0x0F, 0x0E, 0x0F, 0x0F, 0x0E, 0x0F, 0x0F, 0x0E,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0E, 0x0F, 0x0F, 0x0E, 0x26, 0xBB, 0xED,
  0x26, 0xBB, 0xED, 0x26, 0xBB, 0xED, 0x26, 0xBB, 0xED, 0x26, 0xBB, 0xED,
  0x26, 0xBB, 0xED, 0x26, 0xBB, 0xED, 0x26, 0xBB, 0xED, 0x26, 0xBB, 0xED,
  0x0F, 0x0F, 0x0E, 0x0F, 0x0F, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x0F, 0x0E, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB,
  0x26, 0xBB, 0xED, 0x26, 0xBB, 0xED, 0x26, 0xBB, 0xED, 0x26, 0xBB, 0xED,
  0x26, 0xBB, 0xED, 0x26, 0xBB, 0xED, 0x26, 0xBB, 0xED, 0x26, 0xBB, 0xED,
  0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB, 0x0F, 0x0F, 0x0E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0E, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB,
  0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB, 0x26, 0xBB, 0xED, 0x0C, 0x0D, 0x0D,
  0x26, 0xBB, 0xED, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB,
  0x1F, 0x00, 0xEB, 0x0F, 0x0F, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0E, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB,
  0x0F, 0x0F, 0x0E, 0x1F, 0x00, 0xEB, 0x0F, 0x0F, 0x0E, 0x0F, 0x0F, 0x0E,
  0x0F, 0x0F, 0x0E, 0x1F, 0x00, 0xEB, 0x0F, 0x0F, 0x0E, 0x1F, 0x00, 0xEB,
  0x1F, 0x00, 0xEB, 0x0F, 0x0F, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0E, 0x1F, 0x00, 0xEB,
  0x0F, 0x0F, 0x0E, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB,
  0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB, 0x0F, 0x0F, 0x0E, 0x1F, 0x00, 0xEB,
  0x0F, 0x0F, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0E, 0x1F, 0x00, 0xEB,
  0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB,
  0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB,
  0x0F, 0x0F, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0E, 0x1F, 0x00, 0xEB,
  0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB,
  0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB,
  0x0F, 0x0F, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0E, 0x0F, 0x0F, 0x0E,
  0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB,
  0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB, 0x0F, 0x0F, 0x0E,
  0x0F, 0x0F, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0E, 0x49, 0xCA, 0xF5,
  0x0F, 0x0F, 0x0E, 0x0F, 0x0F, 0x0E, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB,
  0x1F, 0x00, 0xEB, 0x0F, 0x0F, 0x0E, 0x0F, 0x0F, 0x0E, 0x49, 0xCA, 0xF5,
  0x0F, 0x0F, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0E, 0x49, 0xCA, 0xF5,
  0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB, 0x0F, 0x0F, 0x0E, 0x0F, 0x0F, 0x0E,
  0x0F, 0x0F, 0x0E, 0x1F, 0x00, 0xEB, 0x1F, 0x00, 0xEB, 0x49, 0xCA, 0xF5,
  0x0F, 0x0F, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0E, 0x49, 0xCA, 0xF5,
  0x1F, 0x00, 0xEB, 0x0F, 0x0F, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0E, 0x1F, 0x00, 0xEB, 0x49, 0xCA, 0xF5,
  0x0F, 0x0F, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0E, 0x49, 0xCA, 0xF5,
  0x0F, 0x0F, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0E, 0x49, 0xCA, 0xF5,
  0x0F, 0x0F, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0E,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0E,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_5[192] = {
  0xDF, 0xE0, 0x0A, 0xE9, 0xE9, 0x04, 0xE5, 0xE5, 0x06, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x50, 0xFF, 0xFF, 0x00, 0xE6, 0xE6, 0x05, 0xEA, 0xEA, 0x05,
  0xE0, 0xE1, 0x09, 0xE8, 0xE7, 0x05, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x50, 0xFF, 0xFF, 0x00, 0xEA, 0xEA, 0x05,
  0xDE, 0xDF, 0x0A, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x50, 0x15, 0x15, 0x3A,
  0x00, 0x00, 0x46, 0x00, 0x00, 0x45, 0xFF, 0xFF, 0x00, 0xE8, 0xE8, 0x05,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x47,
  0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x48, 0x00, 0x00, 0x45, 0x00, 0x00, 0x46, 0x3E, 0x3E, 0x30,
  0x00, 0x00, 0x47, 0x00, 0x00, 0x46, 0x00, 0x00, 0x46, 0x04, 0x04, 0x3D,
  0xFD, 0xFC, 0x01, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x47,
  0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00,
  0xDF, 0xDF, 0x0B, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x51, 0x3F, 0x3F, 0x2F,
  0x00, 0x00, 0x46, 0x00, 0x00, 0x50, 0xFF, 0xFF, 0x00, 0xE9, 0xE9, 0x05,
  0xE2, 0xE2, 0x0A, 0xE9, 0xE9, 0x05, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x46,
  0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xE8, 0xE8, 0x05, 0xEB, 0xEB, 0x04
};
const unsigned char ASCII_8X8_6[192] = {
  0xFF, 0xFF, 0x08, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x4E, 0x00, 0x00, 0x45, 0x1C, 0x1C, 0x38, 0x00, 0x00, 0x47,
  0x00, 0x00, 0x48, 0x20, 0x20, 0x36, 0x00, 0x00, 0x48, 0x02, 0x02, 0x3E,
  0xF7, 0xF9, 0x0D, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x4A, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x4E, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00,
  0xD3, 0xD7, 0x15, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x4A, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x4E, 0xFF, 0xFF, 0x00, 0xE8, 0xE8, 0x03,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x4E, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x07, 0x07, 0x3C, 0x00, 0x00, 0x59, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x5D, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x49, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x4C, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x53,
  0xFF, 0xFF, 0x0A, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x49, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x4D, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00,
  0xD4, 0xD5, 0x17, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x49, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x4D, 0xFF, 0xFF, 0x00, 0xE2, 0xE2, 0x06
};
const unsigned char ASCII_8X8_7[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x4E, 0xC2,
  0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2,
  0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2,
  0x10, 0x4E, 0xC2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x4E, 0xC2,
  0x42, 0x44, 0x47, 0x42, 0x44, 0x47, 0x42, 0x44, 0x47, 0x42, 0x44, 0x47,
  0x42, 0x44, 0x47, 0x42, 0x44, 0x47, 0x42, 0x44, 0x47, 0x42, 0x44, 0x47,
  0x10, 0x4E, 0xC2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2,
  0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2,
  0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2,
  0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x4E, 0xC2,
  0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2,
  0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2,
  0x10, 0x4E, 0xC2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x42, 0x44, 0x47,
  0x42, 0x44, 0x47, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x42, 0x44, 0x47,
  0x42, 0x44, 0x47, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x4E, 0xC2,
  0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2,
  0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2,
  0x10, 0x4E, 0xC2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x4E, 0xC2,
  0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2,
  0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2,
  0x10, 0x4E, 0xC2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x42, 0x44, 0x47,
  0x42, 0x44, 0x47, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x44, 0x47,
  0x42, 0x44, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x44, 0x47,
  0x42, 0x44, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x44, 0x47,
  0x42, 0x44, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0x44, 0x47, 0x10, 0x4E, 0xC2, 0x42, 0x44, 0x47,
  0x42, 0x44, 0x47, 0x10, 0x4E, 0xC2, 0x42, 0x44, 0x47, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2,
  0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0x44, 0x47, 0x10, 0x4E, 0xC2, 0x42, 0x44, 0x47,
  0x42, 0x44, 0x47, 0x10, 0x4E, 0xC2, 0x42, 0x44, 0x47, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2,
  0x10, 0x4E, 0xC2, 0x10, 0x4E, 0xC2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_8[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0D, 0x0D, 0x0C, 0x0D, 0x0D, 0x0C, 0x0D, 0x0D, 0x0C,
  0x0D, 0x0D, 0x0C, 0x0D, 0x0D, 0x0C, 0x0D, 0x0D, 0x0C, 0x0D, 0x0D, 0x0C,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x0D, 0x0C,
  0x0D, 0x0D, 0x0C, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF,
  0x14, 0x7B, 0xC9, 0x14, 0x7B, 0xC9, 0x14, 0x7B, 0xC9, 0x14, 0x7B, 0xC9,
  0x0D, 0x0D, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x0D, 0x0C, 0x00, 0x87, 0xFF,
  0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF,
  0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x14, 0x7B, 0xC9,
  0x14, 0x7B, 0xC9, 0x0D, 0x0D, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x0D, 0x0C, 0x00, 0x87, 0xFF,
  0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF,
  0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF,
  0x14, 0x7B, 0xC9, 0x14, 0x7B, 0xC9, 0x0D, 0x0D, 0x0C, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x0D, 0x0C, 0x00, 0x87, 0xFF,
  0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF,
  0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF,
  0x00, 0x87, 0xFF, 0x14, 0x7B, 0xC9, 0x0D, 0x0D, 0x0C, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x0D, 0x0C, 0x00, 0x87, 0xFF,
  0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF,
  0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF,
  0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x0D, 0x0D, 0x0C, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x0D, 0x0C, 0x00, 0x87, 0xFF,
  0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0xE4, 0xED, 0xF0, 0x00, 0x87, 0xFF,
  0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF,
  0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x0D, 0x0D, 0x0C, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x0D, 0x0C,
  0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF,
  0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF,
  0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x0D, 0x0D, 0x0C, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x0D, 0x0C,
  0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x0D, 0x0D, 0x0C,
  0x0D, 0x0D, 0x0C, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF,
  0x00, 0x87, 0xFF, 0x0D, 0x0D, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0D, 0x0D, 0x0C, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF,
  0x73, 0xF0, 0x75, 0x00, 0x87, 0xFF, 0x00, 0x87, 0xFF, 0x0D, 0x0D, 0x0C,
  0x0D, 0x0D, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0D, 0x0D, 0x0C, 0x0D, 0x0D, 0x0C, 0x0D, 0x0D, 0x0C,
  0x73, 0xF0, 0x75, 0x06, 0xBD, 0x09, 0x0D, 0x0D, 0x0C, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0D, 0x0D, 0x0C, 0x73, 0xF0, 0x75, 0x06, 0xBD, 0x09, 0x0D, 0x0D, 0x0C,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0D, 0x0D, 0x0C, 0x11, 0xFF, 0x00, 0x11, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_9[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0xF1, 0xF7, 0xED, 0x00, 0x00, 0xFF,
  0xF1, 0xF7, 0xED, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xF1, 0xF7, 0xED, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0xF1, 0xF7, 0xED,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0xF8, 0xFA, 0xEB, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0xF1, 0xF7, 0xED, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0xF1, 0xF7, 0xED, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF1, 0xF7, 0xED,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0xF1, 0xF7, 0xED,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0xF1, 0xF7, 0xED, 0xF1, 0xF7, 0xED, 0x68, 0xC9, 0x3A,
  0xF1, 0xF7, 0xED, 0xF1, 0xF7, 0xED, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x68, 0xC9, 0x3A, 0x68, 0xC9, 0x3A, 0x68, 0xC9, 0x3A, 0x68, 0xC9, 0x3A,
  0x68, 0xC9, 0x3A, 0x68, 0xC9, 0x3A, 0x68, 0xC9, 0x3A, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x3A, 0x9E, 0x0B, 0x3A, 0x9E, 0x0B, 0x3A, 0x9E, 0x0B, 0x68, 0xC9, 0x3A,
  0x3A, 0x9E, 0x0B, 0x3A, 0x9E, 0x0B, 0x3A, 0x9E, 0x0B, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3A, 0x9E, 0x0B,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_10[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE8, 0x7D, 0x09, 0xE8, 0x7D, 0x09,
  0xE8, 0x7D, 0x09, 0xE8, 0x7D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF7, 0xF2, 0xE9, 0xF7, 0xF2, 0xE9,
  0xF7, 0xF2, 0xE9, 0xE8, 0x7D, 0x09, 0xF2, 0xBE, 0x63, 0xF2, 0xBE, 0x63,
  0xF2, 0xBE, 0x63, 0xE8, 0x7D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF7, 0xF2, 0xE9, 0xF7, 0xF2, 0xE9, 0xF7, 0xF2, 0xE9,
  0xF7, 0xF2, 0xE9, 0xF2, 0xBE, 0x63, 0xE8, 0x7D, 0x09, 0xE8, 0x7D, 0x09,
  0xE8, 0x7D, 0x09, 0xE8, 0x7D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xF7, 0xF2, 0xE9, 0xF7, 0xF2, 0xE9, 0xF7, 0xF2, 0xE9, 0xF7, 0xF2, 0xE9,
  0xF7, 0xF2, 0xE9, 0xF2, 0xBE, 0x63, 0xE8, 0x7D, 0x09, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xF7, 0xF2, 0xE9, 0xF7, 0xF2, 0xE9, 0xF7, 0xF2, 0xE9, 0xF7, 0xF2, 0xE9,
  0xF2, 0xBE, 0x63, 0xF2, 0xBE, 0x63, 0xE8, 0x7D, 0x09, 0xE8, 0x7D, 0x09,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE8, 0x7D, 0x09,
  0xE8, 0x7D, 0x09, 0xE8, 0x7D, 0x09, 0xE8, 0x7D, 0x09, 0xE8, 0x7D, 0x09,
  0xF2, 0xBE, 0x63, 0xF2, 0xBE, 0x63, 0xF2, 0xBE, 0x63, 0xF2, 0xBE, 0x63,
  0xE8, 0x7D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE8, 0x7D, 0x09, 0xF7, 0xF2, 0xE9,
  0xF7, 0xF2, 0xE9, 0xF7, 0xF2, 0xE9, 0xF7, 0xF2, 0xE9, 0xF2, 0xBE, 0x63,
  0xE8, 0x7D, 0x09, 0xF2, 0xBE, 0x63, 0xF2, 0xBE, 0x63, 0xF2, 0xBE, 0x63,
  0xF2, 0xBE, 0x63, 0xE8, 0x7D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x27, 0x93, 0xE6, 0x27, 0x93, 0xE6, 0xF7, 0xF2, 0xE9,
  0xF7, 0xF2, 0xE9, 0xCF, 0x7C, 0xEB, 0xF7, 0xF2, 0xE9, 0xF2, 0xBE, 0x63,
  0xF2, 0xBE, 0x63, 0xE8, 0x7D, 0x09, 0xF2, 0xBE, 0x63, 0xF2, 0xBE, 0x63,
  0xF2, 0xBE, 0x63, 0xE8, 0x7D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE8, 0x7D, 0x09, 0xF7, 0xF2, 0xE9,
  0x0D, 0x0C, 0x0B, 0xF7, 0xF2, 0xE9, 0xF7, 0xF2, 0xE9, 0xF2, 0xBE, 0x63,
  0xE8, 0x7D, 0x09, 0x00, 0x00, 0x00, 0xE8, 0x7D, 0x09, 0xF2, 0xBE, 0x63,
  0xF2, 0xBE, 0x63, 0xE8, 0x7D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE8, 0x7D, 0x09, 0xF7, 0xF2, 0xE9,
  0xF7, 0xF2, 0xE9, 0xF7, 0xF2, 0xE9, 0xF7, 0xF2, 0xE9, 0xF2, 0xBE, 0x63,
  0xE8, 0x7D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE8, 0x7D, 0x09,
  0xF2, 0xBE, 0x63, 0xE8, 0x7D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE8, 0x7D, 0x09,
  0xF2, 0xBE, 0x63, 0xF2, 0xBE, 0x63, 0xF2, 0xBE, 0x63, 0xE8, 0x7D, 0x09,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xE8, 0x7D, 0x09, 0xE8, 0x7D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xE8, 0x7D, 0x09, 0xE8, 0x7D, 0x09, 0xE8, 0x7D, 0x09, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xE8, 0x7D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_11[768] = {
  0x3B, 0x39, 0x00, 0x43, 0x40, 0x00, 0x39, 0x37, 0x00, 0x51, 0x51, 0x00,
  0x59, 0x58, 0x00, 0x47, 0x46, 0x00, 0x9B, 0x96, 0x03, 0xA5, 0xA0, 0x03,
  0x8A, 0x86, 0x03, 0xDD, 0xD7, 0x00, 0xEF, 0xE9, 0x00, 0xEF, 0xE9, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x43, 0x40, 0x00, 0x00, 0x00, 0x00, 0x40, 0x3E, 0x00, 0x5B, 0x5A, 0x00,
  0x00, 0x00, 0x00, 0x50, 0x50, 0x00, 0xAD, 0xA8, 0x03, 0x00, 0x00, 0x00,
  0x9C, 0x98, 0x03, 0xF7, 0xF1, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x39, 0x37, 0x00, 0x40, 0x3E, 0x00, 0x36, 0x34, 0x00, 0x49, 0x49, 0x00,
  0x50, 0x50, 0x00, 0x3E, 0x3E, 0x00, 0x92, 0x8E, 0x03, 0x9C, 0x98, 0x03,
  0x82, 0x7E, 0x03, 0xF7, 0xF1, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x53, 0x51, 0x00, 0x5B, 0x5A, 0x00, 0x49, 0x49, 0x00, 0xA3, 0x9E, 0x03,
  0xAD, 0xA8, 0x03, 0x92, 0x8E, 0x03, 0xE5, 0xDF, 0x00, 0xF7, 0xF1, 0x00,
  0xF7, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5A, 0x58, 0x00, 0x00, 0x00, 0x00, 0x50, 0x50, 0x00, 0xAD, 0xA8, 0x03,
  0x00, 0x00, 0x00, 0x9C, 0x98, 0x03, 0xF7, 0xF1, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x48, 0x46, 0x00, 0x50, 0x50, 0x00, 0x3E, 0x3E, 0x00, 0x92, 0x8E, 0x03,
  0x9C, 0x98, 0x03, 0x82, 0x7E, 0x03, 0xF7, 0xF1, 0x00, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x9C, 0x98, 0x03, 0xAD, 0xA8, 0x03, 0x92, 0x8E, 0x03, 0xE5, 0xDF, 0x00,
  0xF7, 0xF1, 0x00, 0xF7, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xA6, 0xA1, 0x03, 0x00, 0x00, 0x00, 0x9C, 0x98, 0x03, 0xF7, 0xF1, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x8B, 0x87, 0x03, 0x9C, 0x98, 0x03, 0x82, 0x7E, 0x03, 0xF7, 0xF1, 0x00,
  0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xD9, 0x00, 0xF7, 0xF0, 0x00, 0xF7, 0xF1, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xF1, 0xEB, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xF2, 0xEB, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_12[768] = {
  0x21, 0x20, 0x00, 0x26, 0x24, 0x00, 0x1E, 0x1D, 0x00, 0x3E, 0x3C, 0x00,
  0x43, 0x40, 0x00, 0x39, 0x37, 0x00, 0x51, 0x51, 0x00, 0x59, 0x58, 0x00,
  0x47, 0x46, 0x00, 0x9B, 0x96, 0x03, 0xA4, 0xA0, 0x03, 0x8A, 0x86, 0x03,
  0xDD, 0xD7, 0x00, 0xEF, 0xE8, 0x00, 0xEF, 0xE9, 0x00, 0x00, 0x00, 0x00,
  0x26, 0x24, 0x00, 0x00, 0x00, 0x01, 0x22, 0x21, 0x00, 0x46, 0x43, 0x00,
  0x00, 0x00, 0x01, 0x40, 0x3E, 0x00, 0x5B, 0x5A, 0x00, 0x00, 0x00, 0x01,
  0x50, 0x50, 0x00, 0xAD, 0xA8, 0x03, 0x00, 0x00, 0x00, 0x9C, 0x98, 0x03,
  0xF7, 0xF0, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x1E, 0x1D, 0x00, 0x22, 0x21, 0x00, 0x1B, 0x1A, 0x00, 0x3C, 0x3A, 0x00,
  0x40, 0x3E, 0x00, 0x36, 0x34, 0x00, 0x49, 0x49, 0x00, 0x50, 0x50, 0x00,
  0x3E, 0x3E, 0x00, 0x92, 0x8E, 0x03, 0x9C, 0x98, 0x03, 0x82, 0x7E, 0x03,
  0xF7, 0xF1, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x3E, 0x3C, 0x00, 0x46, 0x43, 0x00, 0x3C, 0x3A, 0x00, 0x54, 0x53, 0x00,
  0x5B, 0x5A, 0x00, 0x49, 0x49, 0x00, 0xA3, 0x9E, 0x03, 0xAD, 0xA8, 0x03,
  0x92, 0x8E, 0x03, 0xE5, 0xDF, 0x00, 0xF7, 0xF0, 0x00, 0xF7, 0xF1, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x43, 0x40, 0x00, 0x00, 0x00, 0x01, 0x40, 0x3E, 0x00, 0x5B, 0x5A, 0x00,
  0x00, 0x00, 0x01, 0x50, 0x50, 0x00, 0xAD, 0xA8, 0x03, 0x00, 0x00, 0x00,
  0x9C, 0x98, 0x03, 0xF7, 0xF0, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x39, 0x37, 0x00, 0x40, 0x3E, 0x00, 0x36, 0x34, 0x00, 0x49, 0x49, 0x00,
  0x50, 0x50, 0x00, 0x3E, 0x3E, 0x00, 0x92, 0x8E, 0x03, 0x9C, 0x98, 0x03,
  0x82, 0x7E, 0x03, 0xF7, 0xF0, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x53, 0x51, 0x00, 0x5B, 0x5A, 0x00, 0x49, 0x49, 0x00, 0xA3, 0x9E, 0x03,
  0xAD, 0xA8, 0x03, 0x92, 0x8E, 0x03, 0xE5, 0xDF, 0x00, 0xF7, 0xF0, 0x00,
  0xF7, 0xF0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5A, 0x58, 0x00, 0x00, 0x00, 0x01, 0x50, 0x50, 0x00, 0xAD, 0xA8, 0x03,
  0x00, 0x00, 0x00, 0x9C, 0x98, 0x03, 0xF7, 0xF0, 0x00, 0x00, 0x00, 0x01,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x48, 0x46, 0x00, 0x50, 0x50, 0x00, 0x3E, 0x3E, 0x00, 0x92, 0x8E, 0x03,
  0x9C, 0x98, 0x03, 0x82, 0x7E, 0x03, 0xF7, 0xF1, 0x00, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x9C, 0x98, 0x03, 0xAD, 0xA8, 0x03, 0x92, 0x8E, 0x03, 0xE5, 0xDF, 0x00,
  0xF7, 0xF0, 0x00, 0xF7, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xA6, 0xA1, 0x03, 0x00, 0x00, 0x00, 0x9C, 0x98, 0x03, 0xF7, 0xF0, 0x00,
  0x00, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x8B, 0x87, 0x03, 0x9C, 0x98, 0x03, 0x82, 0x7E, 0x03, 0xF7, 0xF1, 0x00,
  0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xD9, 0x00, 0xF7, 0xF0, 0x00, 0xF7, 0xF1, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xF1, 0xEB, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xF2, 0xEB, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_13[768] = {
  0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x02, 0x24, 0x23, 0x00,
  0x24, 0x23, 0x00, 0x1D, 0x1C, 0x00, 0x3F, 0x3C, 0x00, 0x42, 0x40, 0x00,
  0x39, 0x37, 0x00, 0x51, 0x51, 0x00, 0x59, 0x58, 0x00, 0x47, 0x46, 0x00,
  0x9B, 0x96, 0x03, 0xA5, 0xA0, 0x03, 0x8A, 0x86, 0x03, 0xDD, 0xD7, 0x00,
  0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x02, 0x28, 0x27, 0x00,
  0x00, 0x00, 0x03, 0x21, 0x20, 0x00, 0x46, 0x43, 0x00, 0x00, 0x00, 0x03,
  0x40, 0x3E, 0x00, 0x5B, 0x5A, 0x00, 0x00, 0x00, 0x03, 0x50, 0x4F, 0x00,
  0xAD, 0xA8, 0x03, 0x00, 0x00, 0x00, 0x9C, 0x98, 0x03, 0xDD, 0xD7, 0x00,
  0x00, 0x00, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x02, 0x21, 0x20, 0x00,
  0x21, 0x20, 0x00, 0x1A, 0x19, 0x00, 0x3C, 0x3A, 0x00, 0x40, 0x3E, 0x00,
  0x36, 0x34, 0x00, 0x49, 0x49, 0x00, 0x50, 0x4F, 0x00, 0x3E, 0x3E, 0x00,
  0x92, 0x8E, 0x03, 0x9C, 0x98, 0x03, 0x82, 0x7E, 0x03, 0xF7, 0xF1, 0x00,
  0x24, 0x23, 0x00, 0x28, 0x27, 0x00, 0x21, 0x20, 0x00, 0x42, 0x40, 0x00,
  0x46, 0x43, 0x00, 0x3C, 0x3A, 0x00, 0x54, 0x53, 0x00, 0x5B, 0x5A, 0x00,
  0x49, 0x49, 0x00, 0xA3, 0x9E, 0x03, 0xAD, 0xA8, 0x03, 0x92, 0x8E, 0x03,
  0xE5, 0xDF, 0x00, 0xF7, 0xF0, 0x00, 0xF7, 0xF1, 0x00, 0x00, 0x00, 0x00,
  0x24, 0x23, 0x00, 0x00, 0x00, 0x03, 0x21, 0x20, 0x00, 0x46, 0x43, 0x00,
  0x00, 0x00, 0x03, 0x40, 0x3E, 0x00, 0x5B, 0x5A, 0x00, 0x00, 0x00, 0x03,
  0x50, 0x4F, 0x00, 0xAD, 0xA8, 0x03, 0x00, 0x00, 0x01, 0x9C, 0x98, 0x03,
  0xF7, 0xF0, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x1D, 0x1C, 0x00, 0x21, 0x20, 0x00, 0x1A, 0x19, 0x00, 0x3C, 0x3A, 0x00,
  0x40, 0x3E, 0x00, 0x36, 0x34, 0x00, 0x49, 0x49, 0x00, 0x50, 0x4F, 0x00,
  0x3E, 0x3E, 0x00, 0x92, 0x8E, 0x03, 0x9C, 0x98, 0x03, 0x82, 0x7E, 0x03,
  0xF7, 0xF1, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x3F, 0x3C, 0x00, 0x46, 0x43, 0x00, 0x3C, 0x3A, 0x00, 0x54, 0x53, 0x00,
  0x5B, 0x5A, 0x00, 0x49, 0x49, 0x00, 0xA3, 0x9E, 0x03, 0xAD, 0xA8, 0x03,
  0x92, 0x8E, 0x03, 0xE5, 0xDF, 0x00, 0xF7, 0xF0, 0x00, 0xF7, 0xF1, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x42, 0x40, 0x00, 0x00, 0x00, 0x03, 0x40, 0x3E, 0x00, 0x5B, 0x5A, 0x00,
  0x00, 0x00, 0x03, 0x50, 0x4F, 0x00, 0xAD, 0xA8, 0x03, 0x00, 0x00, 0x01,
  0x9C, 0x98, 0x03, 0xF7, 0xF0, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x39, 0x37, 0x00, 0x40, 0x3E, 0x00, 0x36, 0x34, 0x00, 0x49, 0x49, 0x00,
  0x50, 0x4F, 0x00, 0x3E, 0x3E, 0x00, 0x92, 0x8E, 0x03, 0x9C, 0x98, 0x03,
  0x82, 0x7E, 0x03, 0xF7, 0xF1, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x53, 0x51, 0x00, 0x5B, 0x5A, 0x00, 0x49, 0x49, 0x00, 0xA3, 0x9E, 0x03,
  0xAD, 0xA8, 0x03, 0x92, 0x8E, 0x03, 0xE5, 0xDF, 0x00, 0xF7, 0xF0, 0x00,
  0xF7, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5A, 0x58, 0x00, 0x00, 0x00, 0x03, 0x50, 0x4F, 0x00, 0xAD, 0xA8, 0x03,
  0x00, 0x00, 0x01, 0x9C, 0x98, 0x03, 0xF7, 0xF0, 0x00, 0x00, 0x00, 0x03,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x48, 0x46, 0x00, 0x50, 0x4F, 0x00, 0x3E, 0x3E, 0x00, 0x92, 0x8E, 0x03,
  0x9C, 0x98, 0x03, 0x82, 0x7E, 0x03, 0xF7, 0xF1, 0x00, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x9C, 0x98, 0x03, 0xAD, 0xA8, 0x03, 0x92, 0x8E, 0x03, 0xE5, 0xDF, 0x00,
  0xF7, 0xF0, 0x00, 0xF7, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xA5, 0xA1, 0x03, 0x00, 0x00, 0x01, 0x9C, 0x98, 0x03, 0xF7, 0xF0, 0x00,
  0x00, 0x00, 0x03, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x8B, 0x87, 0x03, 0x9C, 0x97, 0x03, 0x81, 0x7E, 0x04, 0xF8, 0xF1, 0x00,
  0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xE1, 0xDB, 0x00, 0xDF, 0xD9, 0x00, 0xFA, 0xF3, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_14[768] = {
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x26, 0x24, 0x00, 0x26, 0x24, 0x00,
  0x1E, 0x1D, 0x00, 0x3E, 0x3C, 0x00, 0x43, 0x40, 0x00, 0x39, 0x37, 0x00,
  0x51, 0x51, 0x00, 0x59, 0x58, 0x00, 0x47, 0x46, 0x00, 0x9B, 0x96, 0x03,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x2A, 0x28, 0x00, 0x00, 0x00, 0x01,
  0x22, 0x21, 0x00, 0x46, 0x43, 0x00, 0x00, 0x00, 0x01, 0x40, 0x3E, 0x00,
  0x5B, 0x5A, 0x00, 0x00, 0x00, 0x01, 0x50, 0x50, 0x00, 0x9B, 0x96, 0x03,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x22, 0x21, 0x00, 0x22, 0x21, 0x00,
  0x1B, 0x1A, 0x00, 0x3C, 0x3A, 0x00, 0x40, 0x3E, 0x00, 0x36, 0x34, 0x00,
  0x49, 0x49, 0x00, 0x50, 0x50, 0x00, 0x3E, 0x3E, 0x00, 0x92, 0x8E, 0x03,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x2A, 0x28, 0x00,
  0x2A, 0x28, 0x00, 0x22, 0x21, 0x00, 0x42, 0x3F, 0x00, 0x46, 0x43, 0x00,
  0x3C, 0x3A, 0x00, 0x54, 0x53, 0x00, 0x5B, 0x5A, 0x00, 0x49, 0x49, 0x00,
  0xA3, 0x9E, 0x03, 0xAD, 0xA8, 0x03, 0x92, 0x8E, 0x03, 0xE5, 0xDF, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x2A, 0x28, 0x00,
  0x00, 0x00, 0x01, 0x22, 0x21, 0x00, 0x46, 0x43, 0x00, 0x00, 0x00, 0x01,
  0x40, 0x3E, 0x00, 0x5B, 0x5A, 0x00, 0x00, 0x00, 0x01, 0x50, 0x50, 0x00,
  0xAD, 0xA8, 0x03, 0x00, 0x00, 0x00, 0x9C, 0x98, 0x03, 0xDD, 0xD7, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x22, 0x21, 0x00,
  0x22, 0x21, 0x00, 0x1B, 0x1A, 0x00, 0x3C, 0x3A, 0x00, 0x40, 0x3E, 0x00,
  0x36, 0x34, 0x00, 0x49, 0x49, 0x00, 0x50, 0x50, 0x00, 0x3E, 0x3E, 0x00,
  0x92, 0x8E, 0x03, 0x9C, 0x98, 0x03, 0x82, 0x7E, 0x03, 0xF7, 0xF0, 0x00,
  0x26, 0x24, 0x00, 0x2A, 0x28, 0x00, 0x22, 0x21, 0x00, 0x42, 0x3F, 0x00,
  0x46, 0x43, 0x00, 0x3C, 0x3A, 0x00, 0x54, 0x53, 0x00, 0x5B, 0x5A, 0x00,
  0x49, 0x49, 0x00, 0xA3, 0x9E, 0x03, 0xAD, 0xA8, 0x03, 0x92, 0x8E, 0x03,
  0xE5, 0xDF, 0x00, 0xF7, 0xF0, 0x00, 0xF7, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x26, 0x24, 0x00, 0x00, 0x00, 0x01, 0x22, 0x21, 0x00, 0x46, 0x43, 0x00,
  0x00, 0x00, 0x01, 0x40, 0x3E, 0x00, 0x5B, 0x5A, 0x00, 0x00, 0x00, 0x01,
  0x50, 0x50, 0x00, 0xAD, 0xA8, 0x03, 0x00, 0x00, 0x00, 0x9C, 0x98, 0x03,
  0xF7, 0xF0, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x1E, 0x1D, 0x00, 0x22, 0x21, 0x00, 0x1B, 0x1A, 0x00, 0x3C, 0x3A, 0x00,
  0x40, 0x3E, 0x00, 0x36, 0x34, 0x00, 0x49, 0x49, 0x00, 0x50, 0x50, 0x00,
  0x3E, 0x3E, 0x00, 0x92, 0x8E, 0x03, 0x9C, 0x98, 0x03, 0x82, 0x7E, 0x03,
  0xF7, 0xF0, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x3E, 0x3C, 0x00, 0x46, 0x43, 0x00, 0x3C, 0x3A, 0x00, 0x54, 0x53, 0x00,
  0x5B, 0x5A, 0x00, 0x49, 0x49, 0x00, 0xA3, 0x9E, 0x03, 0xAD, 0xA8, 0x03,
  0x92, 0x8E, 0x03, 0xE5, 0xDF, 0x00, 0xF7, 0xF0, 0x00, 0xF7, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x43, 0x40, 0x00, 0x00, 0x00, 0x01, 0x40, 0x3E, 0x00, 0x5B, 0x5A, 0x00,
  0x00, 0x00, 0x01, 0x50, 0x50, 0x00, 0xAD, 0xA8, 0x03, 0x00, 0x00, 0x00,
  0x9C, 0x98, 0x03, 0xF7, 0xF0, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x39, 0x37, 0x00, 0x40, 0x3E, 0x00, 0x36, 0x34, 0x00, 0x49, 0x49, 0x00,
  0x50, 0x50, 0x00, 0x3E, 0x3E, 0x00, 0x92, 0x8E, 0x03, 0x9C, 0x98, 0x03,
  0x82, 0x7E, 0x03, 0xF7, 0xF0, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x53, 0x51, 0x00, 0x5B, 0x5A, 0x00, 0x49, 0x49, 0x00, 0xA3, 0x9E, 0x03,
  0xAD, 0xA8, 0x03, 0x92, 0x8E, 0x03, 0xE5, 0xDF, 0x00, 0xF7, 0xF0, 0x00,
  0xF7, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5A, 0x58, 0x00, 0x00, 0x00, 0x01, 0x50, 0x50, 0x00, 0xAD, 0xA8, 0x03,
  0x00, 0x00, 0x00, 0x9C, 0x98, 0x03, 0xF7, 0xF0, 0x00, 0x00, 0x00, 0x01,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x48, 0x46, 0x00, 0x50, 0x4F, 0x00, 0x3E, 0x3E, 0x00, 0x92, 0x8E, 0x03,
  0x9C, 0x98, 0x03, 0x81, 0x7E, 0x03, 0xF7, 0xF1, 0x00, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x9D, 0x99, 0x03, 0x9C, 0x98, 0x03, 0x94, 0x90, 0x03, 0xE7, 0xE1, 0x00,
  0xDF, 0xD9, 0x00, 0xFA, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_15[768] = {
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x01, 0x24, 0x23, 0x00, 0x24, 0x23, 0x00, 0x1D, 0x1C, 0x00,
  0x3F, 0x3C, 0x00, 0x43, 0x40, 0x00, 0x39, 0x37, 0x00, 0x51, 0x51, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x01, 0x28, 0x27, 0x00, 0x00, 0x00, 0x01, 0x21, 0x20, 0x00,
  0x46, 0x43, 0x00, 0x00, 0x00, 0x01, 0x40, 0x3E, 0x00, 0x51, 0x51, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x01, 0x21, 0x20, 0x00, 0x21, 0x20, 0x00, 0x1A, 0x19, 0x00,
  0x3C, 0x3A, 0x00, 0x40, 0x3E, 0x00, 0x36, 0x34, 0x00, 0x49, 0x49, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x28, 0x27, 0x00, 0x28, 0x27, 0x00,
  0x21, 0x20, 0x00, 0x42, 0x40, 0x00, 0x46, 0x43, 0x00, 0x3C, 0x3A, 0x00,
  0x54, 0x53, 0x00, 0x5B, 0x5A, 0x00, 0x49, 0x49, 0x00, 0xA3, 0x9E, 0x03,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x28, 0x27, 0x00, 0x00, 0x00, 0x01,
  0x21, 0x20, 0x00, 0x46, 0x43, 0x00, 0x00, 0x00, 0x01, 0x40, 0x3E, 0x00,
  0x5B, 0x5A, 0x00, 0x00, 0x00, 0x01, 0x50, 0x50, 0x00, 0x9B, 0x96, 0x03,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x21, 0x20, 0x00, 0x21, 0x20, 0x00,
  0x1A, 0x19, 0x00, 0x3C, 0x3A, 0x00, 0x40, 0x3E, 0x00, 0x36, 0x34, 0x00,
  0x49, 0x49, 0x00, 0x50, 0x50, 0x00, 0x3E, 0x3E, 0x00, 0x92, 0x8E, 0x03,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x28, 0x27, 0x00,
  0x28, 0x27, 0x00, 0x21, 0x20, 0x00, 0x42, 0x40, 0x00, 0x46, 0x43, 0x00,
  0x3C, 0x3A, 0x00, 0x54, 0x53, 0x00, 0x5B, 0x5A, 0x00, 0x49, 0x49, 0x00,
  0xA3, 0x9E, 0x03, 0xAD, 0xA8, 0x03, 0x92, 0x8E, 0x03, 0xE5, 0xDF, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x28, 0x27, 0x00,
  0x00, 0x00, 0x01, 0x21, 0x20, 0x00, 0x46, 0x43, 0x00, 0x00, 0x00, 0x01,
  0x40, 0x3E, 0x00, 0x5B, 0x5A, 0x00, 0x00, 0x00, 0x01, 0x50, 0x50, 0x00,
  0xAD, 0xA8, 0x03, 0x00, 0x00, 0x00, 0x9C, 0x98, 0x03, 0xDD, 0xD7, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x21, 0x20, 0x00,
  0x21, 0x20, 0x00, 0x1A, 0x19, 0x00, 0x3C, 0x3A, 0x00, 0x40, 0x3E, 0x00,
  0x36, 0x34, 0x00, 0x49, 0x49, 0x00, 0x50, 0x50, 0x00, 0x3E, 0x3E, 0x00,
  0x92, 0x8E, 0x03, 0x9C, 0x98, 0x03, 0x82, 0x7E, 0x03, 0xF7, 0xF0, 0x00,
  0x24, 0x23, 0x00, 0x28, 0x27, 0x00, 0x21, 0x20, 0x00, 0x42, 0x40, 0x00,
  0x46, 0x43, 0x00, 0x3C, 0x3A, 0x00, 0x54, 0x53, 0x00, 0x5B, 0x5A, 0x00,
  0x49, 0x49, 0x00, 0xA3, 0x9E, 0x03, 0xAD, 0xA8, 0x03, 0x92, 0x8E, 0x03,
  0xE5, 0xDF, 0x00, 0xF7, 0xF0, 0x00, 0xF7, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x24, 0x23, 0x00, 0x00, 0x00, 0x01, 0x21, 0x20, 0x00, 0x46, 0x43, 0x00,
  0x00, 0x00, 0x01, 0x40, 0x3E, 0x00, 0x5B, 0x5A, 0x00, 0x00, 0x00, 0x01,
  0x50, 0x50, 0x00, 0xAD, 0xA8, 0x03, 0x00, 0x00, 0x00, 0x9C, 0x98, 0x03,
  0xF7, 0xF0, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x1D, 0x1C, 0x00, 0x21, 0x20, 0x00, 0x1A, 0x19, 0x00, 0x3C, 0x3A, 0x00,
  0x40, 0x3E, 0x00, 0x36, 0x34, 0x00, 0x49, 0x49, 0x00, 0x50, 0x50, 0x00,
  0x3E, 0x3E, 0x00, 0x92, 0x8E, 0x03, 0x9C, 0x98, 0x03, 0x82, 0x7E, 0x03,
  0xF7, 0xF0, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x3F, 0x3C, 0x00, 0x46, 0x43, 0x00, 0x3C, 0x3A, 0x00, 0x54, 0x53, 0x00,
  0x5B, 0x5A, 0x00, 0x49, 0x49, 0x00, 0xA3, 0x9E, 0x03, 0xAD, 0xA8, 0x03,
  0x92, 0x8E, 0x03, 0xE5, 0xDF, 0x00, 0xF7, 0xF0, 0x00, 0xF7, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x43, 0x40, 0x00, 0x00, 0x00, 0x01, 0x40, 0x3E, 0x00, 0x5B, 0x5A, 0x00,
  0x00, 0x00, 0x01, 0x50, 0x50, 0x00, 0xAD, 0xA8, 0x03, 0x00, 0x00, 0x00,
  0x9C, 0x98, 0x03, 0xF7, 0xF0, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x39, 0x37, 0x00, 0x40, 0x3E, 0x00, 0x36, 0x34, 0x00, 0x49, 0x48, 0x00,
  0x50, 0x4F, 0x00, 0x3E, 0x3E, 0x00, 0x92, 0x8E, 0x04, 0x9C, 0x98, 0x03,
  0x81, 0x7E, 0x04, 0xF7, 0xF1, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x53, 0x51, 0x00, 0x52, 0x51, 0x00, 0x4A, 0x49, 0x00, 0xA5, 0xA0, 0x03,
  0x9C, 0x98, 0x03, 0x94, 0x90, 0x03, 0xE7, 0xE1, 0x00, 0xDF, 0xD9, 0x00,
  0xFA, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_16[768] = {
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
  0x26, 0x24, 0x00, 0x26, 0x24, 0x00, 0x1E, 0x1D, 0x00, 0x3E, 0x3C, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
  0x2A, 0x28, 0x00, 0x00, 0x00, 0x01, 0x22, 0x21, 0x00, 0x3E, 0x3C, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
  0x22, 0x21, 0x00, 0x22, 0x21, 0x00, 0x1B, 0x1A, 0x00, 0x3C, 0x3A, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x01, 0x2A, 0x28, 0x00, 0x2A, 0x28, 0x00, 0x22, 0x21, 0x00,
  0x42, 0x3F, 0x00, 0x46, 0x43, 0x00, 0x3C, 0x3A, 0x00, 0x54, 0x53, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x01, 0x2A, 0x28, 0x00, 0x00, 0x00, 0x01, 0x22, 0x21, 0x00,
  0x46, 0x43, 0x00, 0x00, 0x00, 0x01, 0x40, 0x3E, 0x00, 0x51, 0x51, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x01, 0x22, 0x21, 0x00, 0x22, 0x21, 0x00, 0x1B, 0x1A, 0x00,
  0x3C, 0x3A, 0x00, 0x40, 0x3E, 0x00, 0x36, 0x34, 0x00, 0x49, 0x49, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x2A, 0x28, 0x00, 0x2A, 0x28, 0x00,
  0x22, 0x21, 0x00, 0x42, 0x3F, 0x00, 0x46, 0x43, 0x00, 0x3C, 0x3A, 0x00,
  0x54, 0x53, 0x00, 0x5B, 0x5A, 0x00, 0x49, 0x49, 0x00, 0xA3, 0x9E, 0x03,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x2A, 0x28, 0x00, 0x00, 0x00, 0x01,
  0x22, 0x21, 0x00, 0x46, 0x43, 0x00, 0x00, 0x00, 0x01, 0x40, 0x3E, 0x00,
  0x5B, 0x5A, 0x00, 0x00, 0x00, 0x01, 0x50, 0x50, 0x00, 0x9B, 0x96, 0x03,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x22, 0x21, 0x00, 0x22, 0x21, 0x00,
  0x1B, 0x1A, 0x00, 0x3C, 0x3A, 0x00, 0x40, 0x3E, 0x00, 0x36, 0x34, 0x00,
  0x49, 0x49, 0x00, 0x50, 0x50, 0x00, 0x3E, 0x3E, 0x00, 0x92, 0x8E, 0x03,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x2A, 0x28, 0x00,
  0x2A, 0x28, 0x00, 0x22, 0x21, 0x00, 0x42, 0x3F, 0x00, 0x46, 0x43, 0x00,
  0x3C, 0x3A, 0x00, 0x54, 0x53, 0x00, 0x5B, 0x5A, 0x00, 0x49, 0x49, 0x00,
  0xA3, 0x9E, 0x03, 0xAD, 0xA8, 0x03, 0x92, 0x8E, 0x03, 0xE5, 0xDF, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x2A, 0x28, 0x00,
  0x00, 0x00, 0x01, 0x22, 0x21, 0x00, 0x46, 0x43, 0x00, 0x00, 0x00, 0x01,
  0x40, 0x3E, 0x00, 0x5B, 0x5A, 0x00, 0x00, 0x00, 0x01, 0x50, 0x50, 0x00,
  0xAD, 0xA8, 0x03, 0x00, 0x00, 0x00, 0x9C, 0x98, 0x03, 0xDD, 0xD7, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x22, 0x21, 0x00,
  0x22, 0x21, 0x00, 0x1B, 0x1A, 0x00, 0x3C, 0x3A, 0x00, 0x40, 0x3E, 0x00,
  0x36, 0x34, 0x00, 0x49, 0x49, 0x00, 0x50, 0x50, 0x00, 0x3E, 0x3E, 0x00,
  0x92, 0x8E, 0x03, 0x9C, 0x98, 0x03, 0x82, 0x7E, 0x03, 0xF7, 0xF0, 0x00,
  0x26, 0x24, 0x00, 0x2A, 0x28, 0x00, 0x22, 0x21, 0x00, 0x42, 0x3F, 0x00,
  0x46, 0x43, 0x00, 0x3C, 0x3A, 0x00, 0x54, 0x53, 0x00, 0x5B, 0x5A, 0x00,
  0x49, 0x49, 0x00, 0xA3, 0x9E, 0x03, 0xAD, 0xA8, 0x03, 0x92, 0x8E, 0x03,
  0xE5, 0xDF, 0x00, 0xF7, 0xF0, 0x00, 0xF7, 0xF0, 0x00, 0x00, 0x00, 0x01,
  0x26, 0x24, 0x00, 0x00, 0x00, 0x01, 0x22, 0x21, 0x00, 0x46, 0x43, 0x00,
  0x00, 0x00, 0x01, 0x40, 0x3E, 0x00, 0x5B, 0x5A, 0x00, 0x00, 0x00, 0x01,
  0x50, 0x50, 0x00, 0xAD, 0xA8, 0x03, 0x00, 0x00, 0x00, 0x9C, 0x98, 0x03,
  0xF7, 0xF0, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x1E, 0x1D, 0x00, 0x22, 0x21, 0x00, 0x1B, 0x1A, 0x00, 0x3C, 0x3A, 0x00,
  0x40, 0x3E, 0x00, 0x36, 0x34, 0x00, 0x49, 0x48, 0x00, 0x50, 0x4F, 0x00,
  0x3E, 0x3E, 0x00, 0x92, 0x8E, 0x04, 0x9C, 0x98, 0x03, 0x81, 0x7E, 0x04,
  0xF7, 0xF1, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x3F, 0x3D, 0x00, 0x3F, 0x3D, 0x00, 0x3C, 0x3A, 0x00, 0x55, 0x54, 0x00,
  0x52, 0x51, 0x00, 0x4A, 0x49, 0x00, 0xA5, 0xA0, 0x03, 0x9C, 0x98, 0x03,
  0x94, 0x90, 0x03, 0xE7, 0xE1, 0x00, 0xDF, 0xD9, 0x00, 0xFA, 0xF3, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_17[768] = {
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x24, 0x23, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x24, 0x23, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x21, 0x20, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
  0x28, 0x27, 0x00, 0x28, 0x27, 0x00, 0x21, 0x20, 0x00, 0x42, 0x40, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
  0x28, 0x27, 0x00, 0x00, 0x00, 0x01, 0x21, 0x20, 0x00, 0x3F, 0x3C, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
  0x21, 0x20, 0x00, 0x21, 0x20, 0x00, 0x1A, 0x19, 0x00, 0x3C, 0x3A, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x01, 0x28, 0x27, 0x00, 0x28, 0x27, 0x00, 0x21, 0x20, 0x00,
  0x42, 0x40, 0x00, 0x46, 0x43, 0x00, 0x3C, 0x3A, 0x00, 0x54, 0x53, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x01, 0x28, 0x27, 0x00, 0x00, 0x00, 0x01, 0x21, 0x20, 0x00,
  0x46, 0x43, 0x00, 0x00, 0x00, 0x01, 0x40, 0x3E, 0x00, 0x51, 0x51, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x01, 0x21, 0x20, 0x00, 0x21, 0x20, 0x00, 0x1A, 0x19, 0x00,
  0x3C, 0x3A, 0x00, 0x40, 0x3E, 0x00, 0x36, 0x34, 0x00, 0x49, 0x49, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x28, 0x27, 0x00, 0x28, 0x27, 0x00,
  0x21, 0x20, 0x00, 0x42, 0x40, 0x00, 0x46, 0x43, 0x00, 0x3C, 0x3A, 0x00,
  0x54, 0x53, 0x00, 0x5B, 0x5A, 0x00, 0x49, 0x49, 0x00, 0xA3, 0x9E, 0x03,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x28, 0x27, 0x00, 0x00, 0x00, 0x01,
  0x21, 0x20, 0x00, 0x46, 0x43, 0x00, 0x00, 0x00, 0x01, 0x40, 0x3E, 0x00,
  0x5B, 0x5A, 0x00, 0x00, 0x00, 0x01, 0x50, 0x50, 0x00, 0x9B, 0x96, 0x03,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x21, 0x20, 0x00, 0x21, 0x20, 0x00,
  0x1A, 0x19, 0x00, 0x3C, 0x3A, 0x00, 0x40, 0x3E, 0x00, 0x36, 0x34, 0x00,
  0x49, 0x49, 0x00, 0x50, 0x50, 0x00, 0x3E, 0x3E, 0x00, 0x92, 0x8E, 0x03,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x28, 0x27, 0x00,
  0x28, 0x27, 0x00, 0x21, 0x20, 0x00, 0x42, 0x40, 0x00, 0x46, 0x43, 0x00,
  0x3C, 0x3A, 0x00, 0x54, 0x53, 0x00, 0x5B, 0x5A, 0x00, 0x49, 0x49, 0x00,
  0xA3, 0x9E, 0x03, 0xAD, 0xA8, 0x03, 0x92, 0x8E, 0x03, 0xE5, 0xDF, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x28, 0x27, 0x00,
  0x00, 0x00, 0x01, 0x21, 0x20, 0x00, 0x46, 0x43, 0x00, 0x00, 0x00, 0x01,
  0x40, 0x3E, 0x00, 0x5B, 0x5A, 0x00, 0x00, 0x00, 0x01, 0x50, 0x50, 0x00,
  0xAD, 0xA8, 0x03, 0x00, 0x00, 0x00, 0x9C, 0x98, 0x03, 0xDD, 0xD7, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x21, 0x20, 0x00,
  0x21, 0x20, 0x00, 0x1A, 0x19, 0x00, 0x3C, 0x3A, 0x00, 0x40, 0x3E, 0x00,
  0x36, 0x34, 0x00, 0x49, 0x48, 0x00, 0x50, 0x4F, 0x00, 0x3E, 0x3E, 0x00,
  0x92, 0x8E, 0x03, 0x9C, 0x98, 0x03, 0x81, 0x7E, 0x03, 0xF7, 0xF0, 0x00,
  0x24, 0x23, 0x00, 0x24, 0x23, 0x00, 0x21, 0x20, 0x00, 0x42, 0x40, 0x00,
  0x3F, 0x3D, 0x00, 0x3C, 0x3A, 0x00, 0x55, 0x54, 0x00, 0x52, 0x51, 0x00,
  0x4A, 0x49, 0x00, 0xA5, 0xA0, 0x03, 0x9C, 0x98, 0x03, 0x94, 0x90, 0x03,
  0xE7, 0xE1, 0x00, 0xDF, 0xD9, 0x00, 0xFA, 0xF3, 0x00, 0x00, 0x00, 0x01
};
const unsigned char ASCII_8X8_18[768] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x2A, 0x28, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x26, 0x24, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x22, 0x21, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
  0x2A, 0x28, 0x00, 0x2A, 0x28, 0x00, 0x22, 0x21, 0x00, 0x42, 0x3F, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
  0x2A, 0x28, 0x00, 0x00, 0x00, 0x01, 0x22, 0x21, 0x00, 0x3E, 0x3C, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
  0x22, 0x21, 0x00, 0x22, 0x21, 0x00, 0x1B, 0x1A, 0x00, 0x3C, 0x3A, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x01, 0x2A, 0x28, 0x00, 0x2A, 0x28, 0x00, 0x22, 0x21, 0x00,
  0x42, 0x3F, 0x00, 0x46, 0x43, 0x00, 0x3C, 0x3A, 0x00, 0x54, 0x53, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x01, 0x2A, 0x28, 0x00, 0x00, 0x00, 0x01, 0x22, 0x21, 0x00,
  0x46, 0x43, 0x00, 0x00, 0x00, 0x01, 0x40, 0x3E, 0x00, 0x51, 0x51, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x01, 0x22, 0x21, 0x00, 0x22, 0x21, 0x00, 0x1B, 0x1A, 0x00,
  0x3C, 0x3A, 0x00, 0x40, 0x3E, 0x00, 0x36, 0x34, 0x00, 0x49, 0x49, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x2A, 0x28, 0x00, 0x2A, 0x28, 0x00,
  0x22, 0x21, 0x00, 0x42, 0x3F, 0x00, 0x46, 0x43, 0x00, 0x3C, 0x3A, 0x00,
  0x54, 0x53, 0x00, 0x5B, 0x5A, 0x00, 0x49, 0x49, 0x00, 0xA3, 0x9E, 0x02,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x2A, 0x28, 0x00, 0x00, 0x00, 0x01,
  0x22, 0x21, 0x00, 0x46, 0x43, 0x00, 0x00, 0x00, 0x01, 0x40, 0x3E, 0x00,
  0x5B, 0x5A, 0x00, 0x00, 0x00, 0x01, 0x50, 0x50, 0x00, 0x9B, 0x96, 0x02,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x22, 0x21, 0x00, 0x22, 0x21, 0x00,
  0x1B, 0x1A, 0x00, 0x3C, 0x3A, 0x00, 0x40, 0x3E, 0x00, 0x36, 0x34, 0x00,
  0x49, 0x48, 0x00, 0x50, 0x4F, 0x00, 0x3E, 0x3E, 0x00, 0x92, 0x8E, 0x02,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x2A, 0x28, 0x00,
  0x26, 0x24, 0x00, 0x22, 0x21, 0x00, 0x42, 0x40, 0x00, 0x3F, 0x3D, 0x00,
  0x3C, 0x3A, 0x00, 0x55, 0x54, 0x00, 0x52, 0x51, 0x00, 0x4A, 0x49, 0x00,
  0xA5, 0xA0, 0x02, 0x9C, 0x98, 0x02, 0x94, 0x90, 0x02, 0xE6, 0xE0, 0x00
};
const unsigned char ASCII_8X8_19[768] = {
  0xD7, 0xD1, 0x00, 0xEF, 0xE8, 0x00, 0xEF, 0xE8, 0x00, 0x00, 0x00, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0xF1, 0xEB, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0xF2, 0xEB, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x2A, 0x28, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x26, 0x24, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x22, 0x21, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
  0x2A, 0x28, 0x00, 0x2A, 0x28, 0x00, 0x22, 0x21, 0x00, 0x42, 0x3F, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
  0x2A, 0x28, 0x00, 0x00, 0x00, 0x01, 0x22, 0x21, 0x00, 0x3E, 0x3C, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
  0x22, 0x21, 0x00, 0x22, 0x21, 0x00, 0x1B, 0x1A, 0x00, 0x3C, 0x3A, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x01, 0x2A, 0x28, 0x00, 0x2A, 0x28, 0x00, 0x22, 0x21, 0x00,
  0x42, 0x3F, 0x00, 0x46, 0x43, 0x00, 0x3C, 0x3A, 0x00, 0x54, 0x53, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x01, 0x2A, 0x28, 0x00, 0x00, 0x00, 0x01, 0x22, 0x21, 0x00,
  0x46, 0x43, 0x00, 0x00, 0x00, 0x01, 0x40, 0x3E, 0x00, 0x51, 0x51, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x01, 0x22, 0x21, 0x00, 0x22, 0x21, 0x00, 0x1B, 0x1A, 0x00,
  0x3C, 0x3A, 0x00, 0x40, 0x3E, 0x00, 0x36, 0x34, 0x00, 0x49, 0x48, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x2A, 0x28, 0x00, 0x26, 0x24, 0x00,
  0x22, 0x21, 0x00, 0x42, 0x40, 0x00, 0x3F, 0x3D, 0x00, 0x3C, 0x3A, 0x00,
  0x55, 0x54, 0x00, 0x52, 0x51, 0x00, 0x4A, 0x49, 0x00, 0xA5, 0xA0, 0x03
};
const unsigned char ASCII_8X8_20[768] = {
  0x93, 0x8F, 0x03, 0xA4, 0xA0, 0x03, 0x8A, 0x86, 0x03, 0xDD, 0xD7, 0x00,
  0xEF, 0xE8, 0x00, 0xEF, 0xE8, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0xA6, 0xA1, 0x03, 0x00, 0x00, 0x00, 0x9C, 0x98, 0x03, 0xF7, 0xF0, 0x00,
  0x00, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x8B, 0x87, 0x03, 0x9C, 0x98, 0x03, 0x82, 0x7E, 0x03, 0xF7, 0xF0, 0x00,
  0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0xDF, 0xD9, 0x00, 0xF7, 0xF0, 0x00, 0xF7, 0xF0, 0x00, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0xF1, 0xEB, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0xF2, 0xEB, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x2A, 0x28, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x26, 0x24, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x22, 0x21, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
  0x2A, 0x28, 0x00, 0x2A, 0x28, 0x00, 0x22, 0x21, 0x00, 0x42, 0x3F, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
  0x2A, 0x28, 0x00, 0x00, 0x00, 0x01, 0x22, 0x21, 0x00, 0x3E, 0x3C, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
  0x22, 0x21, 0x00, 0x22, 0x21, 0x00, 0x1B, 0x1A, 0x00, 0x3C, 0x3A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x2A, 0x28, 0x00, 0x26, 0x24, 0x00, 0x22, 0x21, 0x00,
  0x42, 0x40, 0x00, 0x3F, 0x3D, 0x00, 0x3C, 0x3A, 0x00, 0x55, 0x53, 0x00
};
const unsigned char ASCII_8X8_21[768] = {
  0x50, 0x4E, 0x00, 0x59, 0x58, 0x00, 0x47, 0x46, 0x00, 0x9B, 0x96, 0x03,
  0xA4, 0xA0, 0x03, 0x8A, 0x86, 0x03, 0xDD, 0xD7, 0x00, 0xEF, 0xE8, 0x00,
  0xEF, 0xE8, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x5A, 0x58, 0x00, 0x00, 0x00, 0x01, 0x50, 0x50, 0x00, 0xAD, 0xA8, 0x03,
  0x00, 0x00, 0x00, 0x9C, 0x98, 0x03, 0xF7, 0xF0, 0x00, 0x00, 0x00, 0x01,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x48, 0x46, 0x00, 0x50, 0x50, 0x00, 0x3E, 0x3E, 0x00, 0x92, 0x8E, 0x03,
  0x9C, 0x98, 0x03, 0x82, 0x7E, 0x03, 0xF7, 0xF0, 0x00, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x9C, 0x98, 0x03, 0xAD, 0xA8, 0x03, 0x92, 0x8E, 0x03, 0xE5, 0xDF, 0x00,
  0xF7, 0xF0, 0x00, 0xF7, 0xF0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0xA6, 0xA1, 0x03, 0x00, 0x00, 0x00, 0x9C, 0x98, 0x03, 0xF7, 0xF0, 0x00,
  0x00, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x8B, 0x87, 0x03, 0x9C, 0x98, 0x03, 0x82, 0x7E, 0x03, 0xF7, 0xF0, 0x00,
  0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0xDF, 0xD9, 0x00, 0xF7, 0xF0, 0x00, 0xF7, 0xF0, 0x00, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0xF1, 0xEB, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0xF2, 0xEB, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x2A, 0x28, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x26, 0x24, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x22, 0x21, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x2A, 0x28, 0x00, 0x26, 0x24, 0x00, 0x22, 0x21, 0x00, 0x42, 0x40, 0x00
};
const unsigned char ASCII_8X8_22[768] = {
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xB2, 0xB2, 0xFF, 0x29, 0x27, 0x2C, 0x34, 0x32, 0x3E,
  0x37, 0x37, 0x38, 0x29, 0x27, 0x2C, 0xE0, 0xEF, 0xC5, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xFB, 0xFF, 0xEA,
  0xE4, 0xF2, 0xD4, 0xD1, 0xDF, 0xB9, 0xDC, 0xEA, 0xCB, 0xE0, 0xEF, 0xC5,
  0xB2, 0xB2, 0xFF, 0xB6, 0xB7, 0xFF, 0xA7, 0xA7, 0xFE, 0xBE, 0xBF, 0xFF,
  0xD1, 0xD2, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xFB, 0xFF, 0xEA, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD1, 0xD2, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xE4, 0xF2, 0xD4, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0xBE, 0xBF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xE4, 0xF2, 0xD4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBE, 0xBF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xFB, 0xFF, 0xEA, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD1, 0xD2, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xFB, 0xFF, 0xEA,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xD1, 0xD2, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xBA, 0xBA, 0xFF, 0xE0, 0xEF, 0xC5,
  0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
  0xB2, 0xB2, 0xFF, 0xE8, 0xF7, 0xCE, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0xBE, 0xBF, 0xFF, 0xAE, 0xAF, 0xFF, 0x22, 0x1F, 0x29,
  0xF7, 0xFF, 0xDA, 0x00, 0x00, 0x00, 0x44, 0x42, 0x50, 0x3C, 0x3A, 0x47,
  0x3F, 0x3F, 0x41, 0x48, 0x48, 0x4A, 0x00, 0x00, 0x00, 0xC5, 0xC5, 0xFF,
  0x26, 0x25, 0x23, 0xD4, 0xE2, 0xC2, 0xE4, 0xF2, 0xD4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xB6, 0xB7, 0xFF, 0x3D, 0x3D, 0x38, 0x00, 0x00, 0x00,
  0xA4, 0xA2, 0xFF, 0xE8, 0xF7, 0xCE, 0xDC, 0xEA, 0xCB, 0xE0, 0xEF, 0xC5,
  0xB2, 0xB2, 0xFF, 0xB6, 0xB7, 0xFF, 0xBA, 0xBA, 0xFF, 0xD5, 0xE4, 0xB3,
  0x00, 0x00, 0x00, 0x35, 0x33, 0x44, 0xDC, 0xEA, 0xCB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBE, 0xBF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xD1, 0xD2, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFB, 0xFF, 0xEA,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE4, 0xF2, 0xD4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBE, 0xBF, 0xFF, 0xBE, 0xBF, 0xFF, 0xD1, 0xD2, 0xFF,
  0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
  0xFB, 0xFF, 0xEA, 0xE4, 0xF2, 0xD4, 0xE4, 0xF2, 0xD4, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const unsigned char ASCII_8X8_23[768] = {
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0xBE, 0xBF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE3, 0xF1, 0xD3, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xB2, 0xB2, 0xFF, 0x31, 0x30, 0x35, 0x3C, 0x3A, 0x47,
  0x3F, 0x3F, 0x41, 0x31, 0x30, 0x35, 0xDF, 0xEE, 0xC4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xFA, 0xFF, 0xE8,
  0xE3, 0xF1, 0xD3, 0xD0, 0xDE, 0xB8, 0xDB, 0xE9, 0xCA, 0xDF, 0xEE, 0xC4,
  0xB2, 0xB2, 0xFF, 0xB6, 0xB7, 0xFF, 0xA7, 0xA7, 0xFE, 0xBE, 0xBF, 0xFF,
  0xD1, 0xD2, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xFA, 0xFF, 0xE8, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD1, 0xD2, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xE3, 0xF1, 0xD3, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0xBE, 0xBF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xE3, 0xF1, 0xD3, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBE, 0xBF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xFA, 0xFF, 0xE8, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD1, 0xD2, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xFA, 0xFF, 0xE8,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xD1, 0xD2, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xBA, 0xBA, 0xFF, 0xDF, 0xEE, 0xC4,
  0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
  0xB2, 0xB2, 0xFF, 0xE7, 0xF6, 0xCD, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0xBE, 0xBF, 0xFF, 0xB6, 0xB7, 0xFF, 0x23, 0x20, 0x29,
  0xF5, 0xFF, 0xD9, 0x00, 0x00, 0x00, 0x44, 0x43, 0x50, 0x3C, 0x3A, 0x47,
  0x3F, 0x3F, 0x41, 0x48, 0x48, 0x4A, 0x00, 0x00, 0x00, 0xC5, 0xC5, 0xFF,
  0x26, 0x25, 0x23, 0xDB, 0xE9, 0xCA, 0xE3, 0xF1, 0xD3, 0x00, 0x00, 0x00,
  0xBF, 0xC1, 0xFF, 0xAB, 0xAC, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xA4, 0xA2, 0xFF, 0xE7, 0xF6, 0xCD, 0xDB, 0xE9, 0xCA, 0xDF, 0xEE, 0xC4,
  0xB2, 0xB2, 0xFF, 0xB6, 0xB7, 0xFF, 0xBA, 0xBA, 0xFF, 0xD4, 0xE3, 0xB1,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCD, 0xD9, 0xBE, 0xE3, 0xF1, 0xD3,
  0x00, 0x00, 0x00, 0xBE, 0xBF, 0xFF, 0xBE, 0xBF, 0xFF, 0xBE, 0xBF, 0xFF,
  0xBE, 0xBF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE3, 0xF1, 0xD3,
  0xE3, 0xF1, 0xD3, 0xE3, 0xF1, 0xD3, 0xE3, 0xF1, 0xD3, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_24[768] = {
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xE4, 0xF2, 0xD4,
  0xCE, 0xDA, 0xBF, 0xCE, 0xDA, 0xBF, 0xCE, 0xDA, 0xBF, 0xD1, 0xDF, 0xB9,
  0xA9, 0xA7, 0xFE, 0xAC, 0xAC, 0xF8, 0xAC, 0xAC, 0xF8, 0xAC, 0xAC, 0xF8,
  0xBF, 0xBF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xFB, 0xFF, 0xEA, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xCF, 0xCD, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xE4, 0xF2, 0xD4, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFB, 0xFF, 0xEA, 0xBE, 0xCC, 0x9E, 0xFB, 0xFF, 0xEA, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xE8, 0xF7, 0xCE, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBC, 0xBA, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0xD2, 0xD2, 0xFF, 0xBC, 0xBA, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD2, 0xD2, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFB, 0xFF, 0xEA,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xD2, 0xD2, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0xBF, 0xBF, 0xFF, 0xA9, 0xA7, 0xFE, 0xE0, 0xEF, 0xC5,
  0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
  0xB3, 0xB2, 0xFF, 0xE8, 0xF7, 0xCE, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0xAC, 0xAC, 0xF8, 0xAF, 0xAF, 0xFF, 0x0F, 0x0C, 0x0D,
  0xF7, 0xFF, 0xDA, 0x00, 0x00, 0x00, 0x44, 0x42, 0x50, 0x3C, 0x3A, 0x47,
  0x3F, 0x3F, 0x41, 0x48, 0x48, 0x4A, 0x00, 0x00, 0x00, 0xC6, 0xC5, 0xFF,
  0x0F, 0x0C, 0x0D, 0xD4, 0xE2, 0xC2, 0xE4, 0xF2, 0xD4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xB7, 0xB7, 0xFF, 0x2A, 0x2A, 0x1C, 0xAF, 0xAF, 0xFF,
  0xA5, 0xA2, 0xFF, 0xE8, 0xF7, 0xCE, 0xDC, 0xEA, 0xCB, 0xE0, 0xEF, 0xC5,
  0xB3, 0xB2, 0xFF, 0xB7, 0xB7, 0xFF, 0xBC, 0xBA, 0xFF, 0xD5, 0xE4, 0xB3,
  0xD4, 0xE2, 0xC2, 0x1E, 0x1A, 0x2F, 0xDC, 0xEA, 0xCB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0xBF, 0xFF, 0x00, 0x00, 0x00, 0xD2, 0xD2, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFB, 0xFF, 0xEA, 0x00, 0x00, 0x00, 0xE4, 0xF2, 0xD4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0xBF, 0xFF, 0xD2, 0xD2, 0xFF, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0xFB, 0xFF, 0xEA, 0xE4, 0xF2, 0xD4, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_25[768] = {
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xB2, 0xB2, 0xFF, 0x29, 0x27, 0x2C, 0x34, 0x32, 0x3E,
  0x37, 0x37, 0x38, 0x29, 0x27, 0x2C, 0xDF, 0xEE, 0xC5, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xFA, 0xFF, 0xEA,
  0xE3, 0xF1, 0xD4, 0xD0, 0xDE, 0xB9, 0xDB, 0xE9, 0xCB, 0xDF, 0xEE, 0xC5,
  0xB2, 0xB2, 0xFF, 0xB6, 0xB7, 0xFF, 0xA7, 0xA7, 0xFE, 0xBE, 0xBF, 0xFF,
  0xD1, 0xD2, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xFA, 0xFF, 0xEA, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD1, 0xD2, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xE3, 0xF1, 0xD4, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0xBA, 0xBA, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xE3, 0xF1, 0xD4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0xFA, 0xFF, 0xEA, 0xD4, 0xE3, 0xB3, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xE7, 0xF6, 0xCE, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xB7, 0xB5, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xA4, 0xA2, 0xFF, 0xE7, 0xF6, 0xCE,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xBA, 0xBA, 0xFF, 0xD4, 0xE3, 0xB3, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xB2, 0xB2, 0xFF, 0xDF, 0xEE, 0xC5,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
  0xB2, 0xB2, 0xFF, 0xDF, 0xEE, 0xC5, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0xC9, 0xCA, 0xFF, 0x35, 0x34, 0x2F, 0x31, 0x30, 0x35,
  0xB6, 0xB7, 0xFF, 0xA7, 0xA7, 0xFE, 0xB2, 0xB2, 0xFF, 0x31, 0x30, 0x35,
  0x3F, 0x3F, 0x41, 0x48, 0x48, 0x4A, 0x00, 0x00, 0x00, 0xC5, 0xC5, 0xFF,
  0x35, 0x34, 0x2F, 0x2D, 0x2B, 0x3B, 0xF2, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBE, 0xBF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xA7, 0xA7, 0xFE, 0xD4, 0xE3, 0xB3, 0xD0, 0xDE, 0xB9, 0xDF, 0xEE, 0xC5,
  0xB2, 0xB2, 0xFF, 0xB6, 0xB7, 0xFF, 0xBA, 0xBA, 0xFF, 0xD4, 0xE3, 0xB3,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE3, 0xF1, 0xD4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBE, 0xBF, 0xFF, 0xBE, 0xBF, 0xFF, 0xBE, 0xBF, 0xFF,
  0xBE, 0xBF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE3, 0xF1, 0xD4,
  0xE3, 0xF1, 0xD4, 0xE3, 0xF1, 0xD4, 0xE3, 0xF1, 0xD4, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_26[768] = {
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xB2, 0xB2, 0xFF, 0x29, 0x27, 0x2C, 0x34, 0x32, 0x3E,
  0x37, 0x37, 0x38, 0x29, 0x27, 0x2C, 0xE0, 0xEF, 0xC5, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xFB, 0xFF, 0xEA,
  0xE4, 0xF2, 0xD4, 0xD1, 0xDF, 0xB9, 0xDC, 0xEA, 0xCB, 0xE0, 0xEF, 0xC5,
  0xB2, 0xB2, 0xFF, 0xB6, 0xB7, 0xFF, 0xA7, 0xA7, 0xFE, 0xBE, 0xBF, 0xFF,
  0xD1, 0xD2, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xFB, 0xFF, 0xEA, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD1, 0xD2, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE4, 0xF2, 0xD4, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0xBE, 0xBF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0xBF, 0xC1, 0xFF, 0xBA, 0xBA, 0xFF, 0xD1, 0xDF, 0xB9, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBE, 0xBF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFB, 0xFF, 0xEA, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBA, 0xBA, 0xFF, 0xFF, 0xFF, 0xE3, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xFB, 0xFF, 0xEA,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xD1, 0xD2, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xBA, 0xBA, 0xFF, 0xE0, 0xEF, 0xC5,
  0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
  0xB2, 0xB2, 0xFF, 0xE8, 0xF7, 0xCE, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0xBE, 0xBF, 0xFF, 0xAE, 0xAF, 0xFF, 0x22, 0x1F, 0x29,
  0xF7, 0xFF, 0xDA, 0x00, 0x00, 0x00, 0x44, 0x42, 0x50, 0x3C, 0x3A, 0x47,
  0x3F, 0x3F, 0x41, 0x48, 0x48, 0x4A, 0x00, 0x00, 0x00, 0xC5, 0xC5, 0xFF,
  0x26, 0x25, 0x22, 0xD4, 0xE2, 0xC2, 0xE4, 0xF2, 0xD4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xB6, 0xB7, 0xFF, 0x3D, 0x3D, 0x38, 0x00, 0x00, 0x00,
  0xA4, 0xA2, 0xFF, 0xE8, 0xF7, 0xCE, 0xDC, 0xEA, 0xCB, 0xE0, 0xEF, 0xC5,
  0xB2, 0xB2, 0xFF, 0xB6, 0xB7, 0xFF, 0xBA, 0xBA, 0xFF, 0xD5, 0xE4, 0xB3,
  0x00, 0x00, 0x00, 0x35, 0x33, 0x44, 0xDC, 0xEA, 0xCB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBE, 0xBF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xD1, 0xD2, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFB, 0xFF, 0xEA,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE4, 0xF2, 0xD4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBE, 0xBF, 0xFF, 0xBE, 0xBF, 0xFF, 0xD1, 0xD2, 0xFF,
  0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
  0xFB, 0xFF, 0xEA, 0xE4, 0xF2, 0xD4, 0xE4, 0xF2, 0xD4, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_27[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_28[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF
};
const unsigned char ASCII_8X8_29[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00
};

const unsigned char ASCII_8X8_30[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_31[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xFF, 0x00, 0x68, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_32[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x68, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x68, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x68, 0xFF, 0x00, 0x68, 0xFF, 0x00, 0x68, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_33[768] = {
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x67, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x67, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x67, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_34[768] = {
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xFF,
  0x00, 0x68, 0xFF, 0x00, 0x68, 0xFF, 0x00, 0x68, 0xFF, 0x00, 0x68, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_35[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xFF, 0x00, 0x68, 0xFF,
  0x00, 0x68, 0xFF, 0x00, 0x68, 0xFF, 0x00, 0x68, 0xFF, 0x00, 0x68, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const unsigned char ASCII_8X8_36[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x67, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x67, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x67, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x67, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x67, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x67, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF,
  0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_37[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x68, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x68, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x68, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x68, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x68, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x68, 0xF9, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x68, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x68, 0xFF, 0x00, 0x68, 0xFF, 0x00, 0x68, 0xFF, 0x00, 0x68, 0xFF,
  0x00, 0x68, 0xFF, 0x00, 0x68, 0xFF, 0x00, 0x68, 0xFF, 0x00, 0x68, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_38[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x66, 0xF9,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xFF,
  0x00, 0x66, 0xFF, 0x00, 0x66, 0xFF, 0x00, 0x66, 0xFF, 0x00, 0x66, 0xFF,
  0x00, 0x66, 0xFF, 0x00, 0x66, 0xFF, 0x00, 0x66, 0xFF, 0x00, 0x66, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const unsigned char ASCII_8X8_39[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF,
  0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF,
  0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD3
};
const unsigned char ASCII_8X8_40[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x67, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x71, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x71, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x67, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x67, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x52, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x52, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x67, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF,
  0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF,
  0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x01,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD2, 0x00, 0x00, 0x00
};

const unsigned char ASCII_8X8_41[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x71, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xF9, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x71, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x67, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x67, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x67, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x67, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x52, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x3D, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01,
  0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x3D, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x52, 0xFF, 0x00, 0x67, 0xFF,
  0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF,
  0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_42[768] = {
  0x00, 0x00, 0xFB, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x67, 0xF9,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x67, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0xFF,
  0x00, 0x67, 0xFF, 0x00, 0x52, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x52, 0xFF,
  0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x71, 0xFF,
  0xFF, 0x00, 0xB1, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_43[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x69, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x69, 0x00, 0xFF, 0x69, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x01,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3D, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0xFA, 0x01,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xFF, 0x00, 0x66, 0xFF,
  0x00, 0x66, 0xFF, 0x00, 0x66, 0xFF, 0x00, 0x51, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x51, 0xFF, 0x00, 0x66, 0xFF, 0x00, 0x71, 0xFF, 0xFF, 0x00, 0x91,
  0x00, 0x71, 0xFF, 0x00, 0x66, 0xFF, 0x00, 0x66, 0xFF, 0x00, 0x66, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD2,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_44[768] = {
  0x00, 0x00, 0x00, 0x00, 0x66, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x66, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x66, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x66, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x66, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x66, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x51, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x51, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x66, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x52, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0xFF, 0x00, 0xD0,
  0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00,
  0xFF, 0xFA, 0x01, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xD0, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x52, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x66, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF,
  0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x51, 0xFF,
  0xFF, 0xFF, 0x00, 0x00, 0x5C, 0xFF, 0xFF, 0x00, 0x91, 0x00, 0x71, 0xFF,
  0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF, 0x00, 0x67, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD2, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_45[768] = {
  0x00, 0x5E, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x67, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x5E, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x67, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x5E, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x67, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x5E, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x67, 0x00, 0xFF, 0x67, 0x00, 0xFF, 0x67, 0x00, 0xFF, 0x67, 0x00, 0xFF,
  0x00, 0x5E, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x4A, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x4A, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x5E, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x5E, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD0, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0,
  0xFF, 0x00, 0xD0, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0,
  0x00, 0x5E, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x4A, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0xFF, 0x00, 0xD0, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x4A, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x5E, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x55, 0xFE, 0x00, 0x5E, 0xFF, 0x00, 0x5E, 0xFF, 0x00, 0x5E, 0xFF,
  0x00, 0x5E, 0xFF, 0x00, 0x5E, 0xFF, 0x00, 0x5E, 0xFF, 0x00, 0x5E, 0xFF,
  0x00, 0x68, 0xFF, 0xFF, 0x00, 0x93, 0x00, 0x68, 0xFF, 0x00, 0x5E, 0xFF,
  0x00, 0x5E, 0xFF, 0x00, 0x5E, 0xFF, 0x00, 0x5E, 0xFF, 0x00, 0x5E, 0xFF
};

const unsigned char ASCII_8X8_46[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0, 0xF9, 0x00, 0xCF, 0xFF, 0x01, 0xD0,
  0xFF, 0x01, 0xD0, 0xFF, 0x00, 0xD0, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00,
  0xFF, 0x00, 0xD0, 0x00, 0xFF, 0x00, 0xFF, 0xFA, 0x01, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD2, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_47[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x00, 0x29, 0x00, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x29, 0x00, 0xFF,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0, 0xF9, 0x00, 0xD0,
  0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0, 0xFF, 0x00, 0xD0, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xD0,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0xFA, 0x01,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD2,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_48[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01,
  0xFF, 0xFF, 0x00, 0x29, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x01,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0,
  0xFF, 0x01, 0xC5, 0x49, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x29, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xD2, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xFC, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFC, 0x00
};
const unsigned char ASCII_8X8_49[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x00,
  0x29, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xC5,
  0x29, 0x00, 0xFF, 0xFF, 0x01, 0xC5, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0,
  0xFF, 0x01, 0xD0, 0xF9, 0x00, 0xD0, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x68, 0x00, 0xFF, 0x29, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_50[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x00, 0x29, 0x00, 0xFF,
  0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xC5, 0x29, 0x00, 0xFF,
  0xFF, 0x01, 0xC5, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0,
  0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0, 0xF9, 0x00, 0xD0, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x29, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_51[768] = {
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x00, 0x29, 0x00, 0xFF, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x01, 0xF9, 0xF9, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xC5, 0x29, 0x00, 0xFF, 0xFF, 0x01, 0xC5,
  0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0,
  0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0, 0xFF, 0x01, 0xD0, 0xF9, 0x00, 0xCF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x29, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD2,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x01
};
const unsigned char ASCII_8X8_52[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0xFF, 0x01, 0xD1,
  0xFF, 0x01, 0xC7, 0x29, 0x00, 0xFF, 0xFF, 0x01, 0xC7, 0xFF, 0x01, 0xD1,
  0xFF, 0x01, 0xD1, 0xFF, 0x01, 0xD1, 0xFF, 0x01, 0xD1, 0xFF, 0x01, 0xD1,
  0xFF, 0x01, 0xD1, 0xFF, 0x01, 0xD1, 0xFF, 0x01, 0xD1, 0xFF, 0x01, 0xD1,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xD3, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_53[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0xFF, 0x01, 0xD1, 0xFF, 0x01, 0xC7,
  0x29, 0x00, 0xFF, 0xFF, 0x01, 0xC7, 0xFF, 0x01, 0xD1, 0xFF, 0x01, 0xD1,
  0xFF, 0x01, 0xD1, 0xFF, 0x01, 0xD1, 0xFF, 0x01, 0xD1, 0xFF, 0x01, 0xD1,
  0xFF, 0x01, 0xD1, 0xFF, 0x01, 0xD1, 0xFF, 0x01, 0xD1, 0xFF, 0x01, 0xD1,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x01, 0xD3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_54[768] = {
  0xFC, 0x01, 0xA8, 0xFF, 0x01, 0xBC, 0xFF, 0x01, 0xB2, 0x29, 0x00, 0xFF,
  0xFF, 0x01, 0xB2, 0xFF, 0x01, 0xBC, 0xFF, 0x01, 0xBC, 0xFF, 0x01, 0xBC,
  0xFF, 0x01, 0xBC, 0xFF, 0x01, 0xBC, 0xFF, 0x01, 0xBC, 0xFF, 0x01, 0xBC,
  0xFF, 0x01, 0xBC, 0xFF, 0x01, 0xBC, 0xFF, 0x01, 0xBC, 0xFF, 0x01, 0xBC,
  0xFF, 0x01, 0xBD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xBD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xBD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xBD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xBD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xBD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xBD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xBD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xBD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xBD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xBD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xBD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0xFF, 0x01, 0xBD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xBD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x01, 0xBF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_55[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_56[768] = {
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0x68, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_57[768] = {
  0x5E, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5E, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5E, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5E, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5E, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5E, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5E, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5E, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5E, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5E, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5E, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5E, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5E, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5E, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5E, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x55, 0x00, 0xFE, 0x5E, 0x00, 0xFF, 0x5E, 0x00, 0xFF, 0x5E, 0x00, 0xFF,
  0x5E, 0x00, 0xFF, 0x5E, 0x00, 0xFF, 0x5E, 0x00, 0xFF, 0x5E, 0x00, 0xFF,
  0x5E, 0x00, 0xFF, 0x5E, 0x00, 0xFF, 0x5E, 0x00, 0xFF, 0x5E, 0x00, 0xFF,
  0x5E, 0x00, 0xFF, 0x5E, 0x00, 0xFF, 0x5E, 0x00, 0xFF, 0x5E, 0x00, 0xFF
};
const unsigned char ASCII_8X8_58[768] = {
  0x00, 0x00, 0x00, 0x00, 0x7C, 0xFF, 0x00, 0x00, 0x00, 0x10, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x76, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xC1,
  0x00, 0x00, 0x00, 0xE1, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB0, 0x37, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xC1, 0x3D, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xC1, 0x3D, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xC1, 0x3D, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xC1, 0x3D, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xC1, 0x3D, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xC1, 0x3D, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xC1, 0x3D, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xE4, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xEC, 0x00, 0x00, 0x00, 0xCA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0xFF, 0x8A, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xA7, 0x00, 0xFF, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_59[768] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xE3, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xEA, 0x00, 0x00, 0x00, 0xC8, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0xFF, 0x8A, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x96, 0x00, 0xFF,
  0xC3, 0x3C, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xA5, 0x00, 0xFF,
  0xC3, 0x3C, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xA5, 0x00, 0xFF,
  0xC3, 0x3C, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xA5, 0x00, 0xFF,
  0xC3, 0x3C, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xA5, 0x00, 0xFF,
  0xC3, 0x3C, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xA5, 0x00, 0xFF,
  0xC3, 0x3C, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xA5, 0x00, 0xFF,
  0xC3, 0x3C, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xA5, 0x00, 0xFF,
  0xB2, 0x38, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x7D, 0xFF, 0x00, 0x00, 0x00,
  0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x76, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xC3, 0x00, 0x00, 0x00, 0xE4, 0x00, 0xFF, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_60[768] = {
  0x00, 0x00, 0x00, 0xC1, 0x3D, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xFF,
  0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x75, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xC0, 0x00, 0x00, 0x00, 0xCD, 0x00, 0xFF,
  0xA8, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00,
  0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xE1, 0x00, 0xFF,
  0xA8, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00,
  0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xE1, 0x00, 0xFF,
  0xA8, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00,
  0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xE1, 0x00, 0xFF,
  0xA8, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00,
  0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xE1, 0x00, 0xFF,
  0xA8, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00,
  0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xE1, 0x00, 0xFF,
  0xA8, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00,
  0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xE1, 0x00, 0xFF,
  0xA8, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00,
  0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD1, 0x00, 0x00, 0x00, 0xE1, 0x00, 0xFF,
  0x98, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xE5, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xEC, 0x00, 0x00, 0x00,
  0xCA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00,
  0xFF, 0x8A, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_61[768] = {
  0x00, 0x00, 0x00, 0xA5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xE2, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xEB,
  0x00, 0x00, 0x00, 0xC7, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x13,
  0x00, 0x00, 0x00, 0xFF, 0x89, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0xE4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF7, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0xE4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF7, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0xE4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF7, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0xE4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF7, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0xE4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF7, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0xE4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF7, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0xE4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF7, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0xD1, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xC1, 0x3D, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x7D, 0xFF, 0x00, 0x00, 0x00, 0x10, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x77, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x17, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xC4, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_62[768] = {
  0x00, 0x00, 0x00, 0xE2, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xC0, 0x3D, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x7C, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x76, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xAF,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x02, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF6, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x95, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xC1,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x02, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF6, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x95, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xC1,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x02, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF6, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x95, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xC1,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x02, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF6, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x95, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xC1,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x02, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF6, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x95, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xC1,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x02, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF6, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x95, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xC1,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x02, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF6, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x95, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xC1,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xA6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x01, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xE4, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xEB, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0xFF, 0x89, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_63[768] = {
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xA7, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xE2, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xEA, 0x00, 0x00, 0x00, 0xC6, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0xFF, 0x7D, 0x00,
  0xFF, 0x00, 0xC3, 0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x12, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x82, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF7, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xD8, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x89, 0x00,
  0xFF, 0x00, 0xC3, 0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x12, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x82, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF7, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xD8, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x89, 0x00,
  0xFF, 0x00, 0xC3, 0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x12, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x82, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF7, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xD8, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x89, 0x00,
  0xFF, 0x00, 0xC3, 0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x12, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x82, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF7, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xD8, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x89, 0x00,
  0xFF, 0x00, 0xC3, 0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x12, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x82, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF7, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xD8, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x89, 0x00,
  0xFF, 0x00, 0xC3, 0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x12, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x82, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF7, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xD8, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x89, 0x00,
  0xFF, 0x00, 0xC3, 0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x12, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x82, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF7, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xD8, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x89, 0x00,
  0xFF, 0x00, 0xB2, 0x00, 0x00, 0x00, 0xE4, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xC3, 0x3D, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x7D, 0xFF, 0x00, 0x00, 0x00,
  0x10, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x77, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_64[768] = {
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xC1, 0x00, 0x00, 0x00, 0xE2, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xC1, 0x3D, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xFF,
  0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x75, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0xFF, 0x8A, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB2, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF6, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFE, 0x00, 0x00, 0x00,
  0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17,
  0xFF, 0x8A, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB2, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF6, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFE, 0x00, 0x00, 0x00,
  0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17,
  0xFF, 0x8A, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB2, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF6, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFE, 0x00, 0x00, 0x00,
  0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17,
  0xFF, 0x8A, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB2, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF6, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFE, 0x00, 0x00, 0x00,
  0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17,
  0xFF, 0x8A, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB2, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF6, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFE, 0x00, 0x00, 0x00,
  0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17,
  0xFF, 0x8A, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB2, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF6, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFE, 0x00, 0x00, 0x00,
  0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17,
  0xFF, 0x8A, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB2, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF6, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFE, 0x00, 0x00, 0x00,
  0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17,
  0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xA4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xE4, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xEB, 0x00, 0x00, 0x00,
  0xCA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_65[768] = {
  0x00, 0x00, 0x00, 0xFF, 0x88, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xA4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xE3, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xE8,
  0x00, 0x00, 0x00, 0xC8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x11,
  0xFF, 0xFF, 0x17, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x12, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x80, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x95, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFD,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x13,
  0xFF, 0xFF, 0x17, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x12, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x80, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x95, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFD,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x13,
  0xFF, 0xFF, 0x17, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x12, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x80, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x95, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFD,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x13,
  0xFF, 0xFF, 0x17, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x12, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x80, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x95, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFD,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x13,
  0xFF, 0xFF, 0x17, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x12, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x80, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x95, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFD,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x13,
  0xFF, 0xFF, 0x17, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x12, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x80, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x95, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFD,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x13,
  0xFF, 0xFF, 0x17, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x12, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x80, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x95, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFD,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x13,
  0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xC3, 0x00, 0x00, 0x00,
  0xE4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xC3, 0x3D, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x7D, 0xFF, 0x00, 0x00, 0x00, 0x10, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x76, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_66[768] = {
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xC1,
  0x00, 0x00, 0x00, 0xE1, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xC1, 0x3D, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x7C, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x75, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x12, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x12, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x12, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x12, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x12, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x12, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x12, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x11, 0x00, 0x00, 0x00, 0xFF, 0x8A, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xA6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xE5, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xEC, 0x00, 0x00, 0x00, 0xCA, 0xFF, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_67[768] = {
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0xFF, 0x8A, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xA7, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xE3, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xEA, 0x00, 0x00, 0x00, 0xB6, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xC8, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xC8, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xC8, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xC8, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xC8, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xC8, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xC8, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xC3, 0x00, 0x00, 0x00, 0xE4, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xC3, 0x3D, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x7D, 0xFF, 0x00, 0x00, 0x00,
  0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x76, 0xFF, 0x00, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_68[768] = {
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xC1, 0x00, 0x00, 0x00, 0xE2, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xC1, 0x3D, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xFF,
  0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x6A, 0xFF, 0x01,
  0xC9, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x75, 0xFF, 0x02,
  0xC9, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x75, 0xFF, 0x02,
  0xC9, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x75, 0xFF, 0x02,
  0xC9, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x75, 0xFF, 0x02,
  0xC9, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x75, 0xFF, 0x02,
  0xC9, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x75, 0xFF, 0x02,
  0xC9, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x75, 0xFF, 0x02,
  0xB8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00,
  0xFF, 0x8A, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xA6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xE5, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xEC, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_69[768] = {
  0x00, 0x00, 0x00, 0xC6, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x13,
  0x00, 0x00, 0x00, 0xFF, 0x89, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xA5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xE3, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xD5,
  0x78, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xEA,
  0x78, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xEA,
  0x78, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xEA,
  0x78, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xEA,
  0x78, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xEA,
  0x78, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xEA,
  0x78, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xEA,
  0x6C, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x17, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xC3, 0x00, 0x00, 0x00,
  0xE4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xC3, 0x3D, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x7D, 0xFF, 0x00, 0x00, 0x00, 0x10, 0xFF, 0xFF, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_70[768] = {
  0x00, 0x00, 0x00, 0x75, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xC1,
  0x00, 0x00, 0x00, 0xE0, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xC1, 0x3B, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x7C, 0xFF, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF,
  0x00, 0xFF, 0xEB, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x40, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x10, 0xFF, 0xFF,
  0x00, 0xFF, 0xEB, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x40, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x10, 0xFF, 0xFF,
  0x00, 0xFF, 0xEB, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x40, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x10, 0xFF, 0xFF,
  0x00, 0xFF, 0xEB, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x40, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x10, 0xFF, 0xFF,
  0x00, 0xFF, 0xEB, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x40, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x10, 0xFF, 0xFF,
  0x00, 0xFF, 0xEB, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x40, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x10, 0xFF, 0xFF,
  0x00, 0xFF, 0xEB, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3,
  0x00, 0x00, 0x00, 0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD3, 0x40, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00, 0x10, 0xFF, 0xFF,
  0x00, 0xFF, 0xD8, 0x00, 0x00, 0x00, 0xCA, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0xFF, 0x8A, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xA7, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xE5, 0xFF, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_71[768] = {
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xEB, 0x00, 0x00, 0x00, 0xC8, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00, 0xFF, 0x89, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xA5, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xCE, 0xFF,
  0x10, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x02, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xE2, 0xFF,
  0x10, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x02, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xE2, 0xFF,
  0x10, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x02, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xE2, 0xFF,
  0x10, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x02, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xE2, 0xFF,
  0x10, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x02, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xE2, 0xFF,
  0x10, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x02, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xE2, 0xFF,
  0x10, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xD3, 0x43, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x14, 0x00, 0x00, 0x00, 0xFF, 0x96, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xB4, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x02, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xE2, 0xFF,
  0x0E, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x76, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xC3, 0x00, 0x00, 0x00, 0xE4, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xC3, 0x3D, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x7D, 0xFF, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_72[768] = {
  0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x73, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x17,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xC1, 0x00, 0x00, 0x00, 0xE2, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xC0, 0x3D, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x70, 0xFF,
  0x00, 0xE4, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0xD9, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0xFF, 0x98, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7E, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xFF,
  0x00, 0xE4, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0xD9, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0xFF, 0x98, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7E, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xFF,
  0x00, 0xE4, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0xD9, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0xFF, 0x98, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7E, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xFF,
  0x00, 0xE4, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0xD9, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0xFF, 0x98, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7E, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xFF,
  0x00, 0xE4, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0xD9, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0xFF, 0x98, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7E, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xFF,
  0x00, 0xE4, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0xD9, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0xFF, 0x98, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7E, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xFF,
  0x00, 0xE4, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0xD9, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15, 0x00, 0x00, 0x00,
  0xFF, 0x98, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xB3, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7E, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x19,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00, 0xF6, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xFF,
  0x00, 0xD1, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xEC, 0x00, 0x00, 0x00,
  0xC8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x13, 0x00, 0x00, 0x00,
  0xFF, 0x8C, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xA6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_73[768] = {
  0x00, 0x00, 0x00, 0x00, 0xE3, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xEA,
  0x00, 0x00, 0x00, 0xC8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x13,
  0x00, 0x00, 0x00, 0xFF, 0x89, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xA7, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x7D, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x7E, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x7D, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x7E, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x7D, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x7E, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x7D, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x7E, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x7D, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x7E, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x7D, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x7E, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x7D, 0xFF, 0x00, 0x00, 0x00, 0x13, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x7E, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x19, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xD3, 0x00, 0x00, 0x00,
  0xF5, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xD1, 0x42, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xDA, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x15,
  0x00, 0x00, 0x00, 0xFF, 0x96, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xB6, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x72, 0xFF, 0x00, 0x00, 0x00, 0x11, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x74, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x17, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xC3, 0x00, 0x00, 0x00,
  0xE4, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xC1, 0x3D, 0xFF, 0x00, 0x00, 0x00
};
const unsigned char ASCII_8X8_74[768] = {
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xEC, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF
};
const unsigned char ASCII_8X8_75[768] = {
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xA5, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF
};
const unsigned char ASCII_8X8_76[768] = {
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xEC, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB
};
const unsigned char ASCII_8X8_77[768] = {
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFF,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xEC,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77
};
const unsigned char ASCII_8X8_78[768] = {
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xEC, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40
};
const unsigned char ASCII_8X8_79[768] = {
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xEC, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00
};
const unsigned char ASCII_8X8_80[768] = {
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xEC, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00
};
const unsigned char ASCII_8X8_81[768] = {
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFF,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xEC,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00
};
const unsigned char ASCII_8X8_82[768] = {
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xEC, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00
};
const unsigned char ASCII_8X8_83[768] = {
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xEC, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55
};
const unsigned char ASCII_8X8_84[768] = {
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xEC, 0x00, 0xFF, 0xAE
};
const unsigned char ASCII_8X8_85[768] = {
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFF,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xEC
};
const unsigned char ASCII_8X8_86[768] = {
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00,
  0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40,
  0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF
};
const unsigned char ASCII_8X8_87[768] = {
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF,
  0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55,
  0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00,
  0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF,
  0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF
};
const unsigned char ASCII_8X8_88[768] = {
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF,
  0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xAE,
  0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x66, 0x00,
  0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77, 0xFF, 0x00, 0xBB,
  0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x55, 0xFF
};
const unsigned char ASCII_8X8_89[768] = {
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x55, 0xFF, 0x00, 0x84, 0xFF, 0x00, 0x9D, 0xFF, 0x00, 0xFF, 0xFB,
  0x00, 0xFF, 0xAE, 0x00, 0xFF, 0x55, 0xBB, 0xFF, 0x00, 0xFF, 0xAE, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x08, 0x00, 0xFF, 0x00, 0x40, 0xFF, 0x00, 0x77,
  0xFF, 0x00, 0xBB, 0xFB, 0x00, 0xFF, 0x55, 0x00, 0xFF, 0x00, 0x00, 0xFF
};
const unsigned char ASCII_8X8_90[768] = {
  0xFC, 0x00, 0x90, 0xF9, 0x00, 0x22, 0xF9, 0x00, 0x38, 0xF9, 0x00, 0x38,
  0xF9, 0x00, 0x38, 0xF9, 0x00, 0x38, 0xF9, 0x00, 0x38, 0xFF, 0x00, 0x3F,
  0xBC, 0x2F, 0x00, 0xFF, 0x86, 0x00, 0xF9, 0x7D, 0x00, 0xF9, 0x7D, 0x00,
  0xF9, 0x7D, 0x00, 0xF9, 0x7D, 0x00, 0xF9, 0x6E, 0x00, 0xF9, 0xB7, 0x00,
  0xFB, 0x00, 0xFF, 0xF9, 0x00, 0x8D, 0xF9, 0x00, 0x22, 0xF9, 0x00, 0x38,
  0xF9, 0x00, 0x38, 0xF9, 0x00, 0x38, 0xF9, 0x00, 0x38, 0xFF, 0x00, 0x3F,
  0xBC, 0x2F, 0x00, 0xFF, 0x86, 0x00, 0xF9, 0x7D, 0x00, 0xF9, 0x7D, 0x00,
  0xF9, 0x7D, 0x00, 0xF9, 0x6E, 0x00, 0xF9, 0xB6, 0x00, 0xF9, 0xFF, 0x00,
  0xFB, 0x00, 0xFB, 0xF9, 0x00, 0xFF, 0xFA, 0x00, 0x8E, 0xF9, 0x00, 0x22,
  0xF9, 0x00, 0x38, 0xF9, 0x00, 0x38, 0xF9, 0x00, 0x38, 0xFF, 0x00, 0x3F,
  0xBC, 0x2F, 0x00, 0xFF, 0x86, 0x00, 0xF9, 0x7D, 0x00, 0xF9, 0x7D, 0x00,
  0xF9, 0x6E, 0x00, 0xF9, 0xB6, 0x00, 0xF9, 0xFF, 0x00, 0xF9, 0xF9, 0x00,
  0xFB, 0x00, 0xFB, 0xF9, 0x00, 0xF9, 0xF9, 0x00, 0xFF, 0xFA, 0x00, 0x8E,
  0xF9, 0x00, 0x22, 0xF9, 0x00, 0x38, 0xF9, 0x00, 0x38, 0xFF, 0x00, 0x3F,
  0xBC, 0x2F, 0x00, 0xFF, 0x86, 0x00, 0xF9, 0x7D, 0x00, 0xF9, 0x6E, 0x00,
  0xF9, 0xB6, 0x00, 0xF9, 0xFF, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00,
  0xFB, 0x00, 0xFB, 0xF9, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00, 0xFF,
  0xFA, 0x00, 0x8E, 0xF9, 0x00, 0x22, 0xF9, 0x00, 0x38, 0xFF, 0x00, 0x3F,
  0xBC, 0x2F, 0x00, 0xFF, 0x86, 0x00, 0xF9, 0x6E, 0x00, 0xF9, 0xB6, 0x00,
  0xF9, 0xFF, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00,
  0xFB, 0x00, 0xFB, 0xF9, 0x00, 0xF9, 0xFF, 0x00, 0xFF, 0xF9, 0x00, 0xF9,
  0xFF, 0x00, 0xFF, 0xFA, 0x00, 0x8E, 0xFF, 0x00, 0x1E, 0xFF, 0x00, 0x3F,
  0xBC, 0x1D, 0x00, 0xFF, 0x77, 0x00, 0xFC, 0xB9, 0x00, 0xF9, 0xFF, 0x00,
  0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00,
  0xFF, 0x00, 0xFB, 0xFF, 0x00, 0xFF, 0x48, 0xB3, 0x40, 0xFF, 0x00, 0xFF,
  0x6D, 0xD8, 0x65, 0xFF, 0x00, 0xFF, 0x91, 0xFC, 0xB9, 0xFF, 0x00, 0x0C,
  0xB4, 0xF6, 0xFF, 0xFF, 0xB0, 0x00, 0xD5, 0xE5, 0xFF, 0xFC, 0xFC, 0x00,
  0xF8, 0xF8, 0xFF, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00,
  0xC7, 0x5D, 0xFC, 0xC6, 0x5D, 0xF9, 0xD5, 0x4D, 0xFF, 0xC6, 0x5D, 0xFA,
  0xD2, 0x4A, 0xFF, 0xC6, 0x5D, 0xFA, 0xC7, 0x50, 0xFF, 0xFF, 0x00, 0x95,
  0xFF, 0xBD, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFD, 0x00, 0xFF, 0xFA, 0x00,
  0xFF, 0xFA, 0x00, 0xFF, 0xFA, 0x00, 0xFF, 0xFA, 0x00, 0xFF, 0xFA, 0x00,
  0x00, 0x00, 0xFB, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9,
  0x00, 0x00, 0xF9, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xF9, 0x00, 0x2E, 0xFF,
  0x00, 0xFF, 0x96, 0x9A, 0xFD, 0x00, 0x9A, 0xF8, 0x00, 0x8A, 0xFF, 0x00,
  0x9A, 0xF8, 0x00, 0x8D, 0xFF, 0x00, 0x9A, 0xF8, 0x00, 0x9A, 0xF8, 0x00,
  0x00, 0x00, 0xFB, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0xFF, 0xFF, 0xF8,
  0x00, 0x00, 0xFC, 0xFF, 0xFF, 0xD5, 0x00, 0x20, 0xFF, 0xFF, 0xE0, 0xAE,
  0x00, 0xFF, 0xFF, 0xEF, 0x8D, 0xC4, 0x00, 0xEA, 0x00, 0xC6, 0x6E, 0xD9,
  0x00, 0xF4, 0x00, 0xA1, 0x49, 0xB4, 0x00, 0xEA, 0x0D, 0x07, 0xDE, 0x19,
  0x00, 0x00, 0xFB, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9,
  0x00, 0x00, 0xF9, 0x00, 0x29, 0xFD, 0x00, 0x8C, 0xF9, 0x00, 0xD8, 0xFF,
  0x00, 0xFA, 0xF9, 0x00, 0xFE, 0xFF, 0x00, 0xFF, 0x90, 0x0C, 0xE4, 0x00,
  0x17, 0xE1, 0x17, 0x0A, 0xED, 0x0A, 0x17, 0xE1, 0x17, 0x17, 0xE1, 0x17,
  0x00, 0x00, 0xFB, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9,
  0x00, 0x45, 0xFA, 0x00, 0x96, 0xF9, 0x00, 0x7C, 0xF9, 0x00, 0xD7, 0xF9,
  0x00, 0xFA, 0xF9, 0x00, 0xF5, 0xF9, 0x00, 0xF4, 0xFF, 0x00, 0xFF, 0x90,
  0x1C, 0xDA, 0x00, 0x17, 0xE1, 0x17, 0x17, 0xE1, 0x17, 0x17, 0xE1, 0x17,
  0x00, 0x00, 0xFB, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x45, 0xFA,
  0x00, 0x96, 0xF9, 0x00, 0x86, 0xF9, 0x00, 0x7C, 0xF9, 0x00, 0xD7, 0xF9,
  0x00, 0xFA, 0xF9, 0x00, 0xF5, 0xF9, 0x00, 0xF5, 0xF9, 0x00, 0xF4, 0xFF,
  0x00, 0xFF, 0x90, 0x1C, 0xDA, 0x00, 0x17, 0xE1, 0x17, 0x17, 0xE1, 0x17,
  0x00, 0x00, 0xFB, 0x00, 0x00, 0xF9, 0x00, 0x45, 0xFA, 0x00, 0x96, 0xF9,
  0x00, 0x86, 0xF9, 0x00, 0x86, 0xF9, 0x00, 0x7C, 0xF9, 0x00, 0xD7, 0xF9,
  0x00, 0xFA, 0xF9, 0x00, 0xF5, 0xF9, 0x00, 0xF5, 0xF9, 0x00, 0xF5, 0xF9,
  0x00, 0xF4, 0xFF, 0x00, 0xFF, 0x90, 0x1C, 0xDA, 0x00, 0x17, 0xE1, 0x17,
  0x00, 0x00, 0xFB, 0x00, 0x45, 0xF9, 0x00, 0x96, 0xF9, 0x00, 0x85, 0xF9,
  0x00, 0x85, 0xF9, 0x00, 0x85, 0xF9, 0x00, 0x7C, 0xF9, 0x00, 0xD7, 0xF9,
  0x00, 0xF9, 0xF9, 0x00, 0xF5, 0xF9, 0x00, 0xF5, 0xF9, 0x00, 0xF5, 0xF9,
  0x00, 0xF5, 0xF9, 0x00, 0xF4, 0xFF, 0x00, 0xFF, 0x90, 0x1C, 0xDA, 0x00,
  0x00, 0x45, 0xFE, 0x00, 0x97, 0xFB, 0x00, 0x87, 0xFC, 0x00, 0x87, 0xFC,
  0x00, 0x87, 0xFC, 0x00, 0x87, 0xFC, 0x00, 0x7D, 0xFC, 0x00, 0xD9, 0xFC,
  0x00, 0xFC, 0xFC, 0x00, 0xF8, 0xFC, 0x00, 0xF8, 0xFC, 0x00, 0xF8, 0xFC,
  0x00, 0xF8, 0xFC, 0x00, 0xF8, 0xFC, 0x00, 0xF7, 0xFF, 0x00, 0xFF, 0x90
};
const unsigned char ASCII_8X8_91[768] = {
  0xFC, 0x00, 0x62, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x0C, 0xF9, 0x00, 0x0C,
  0xF9, 0x00, 0x0C, 0xF9, 0x00, 0x0C, 0xF9, 0x00, 0x0C, 0xFF, 0x00, 0x0D,
  0xBC, 0x54, 0x00, 0xFF, 0xB0, 0x00, 0xF9, 0xA6, 0x00, 0xF9, 0xA6, 0x00,
  0xF9, 0xA6, 0x00, 0xF9, 0xA6, 0x00, 0xF9, 0x96, 0x00, 0xFE, 0xEA, 0x00,
  0xFB, 0x00, 0xED, 0xFA, 0x00, 0x5E, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x0C,
  0xF9, 0x00, 0x0C, 0xF9, 0x00, 0x0C, 0xF9, 0x00, 0x0C, 0xFF, 0x00, 0x0D,
  0xBC, 0x54, 0x00, 0xFF, 0xB0, 0x00, 0xF9, 0xA6, 0x00, 0xF9, 0xA6, 0x00,
  0xF9, 0xA6, 0x00, 0xF9, 0x96, 0x00, 0xFF, 0xEF, 0x00, 0xC5, 0xFE, 0x00,
  0xFB, 0x00, 0xD2, 0xF9, 0x00, 0xEA, 0xFA, 0x00, 0x5E, 0xF9, 0x00, 0x00,
  0xF9, 0x00, 0x0C, 0xF9, 0x00, 0x0C, 0xF9, 0x00, 0x0C, 0xFF, 0x00, 0x0D,
  0xBC, 0x54, 0x00, 0xFF, 0xB0, 0x00, 0xF9, 0xA6, 0x00, 0xF9, 0xA6, 0x00,
  0xF9, 0x96, 0x00, 0xFF, 0xEF, 0x00, 0xC5, 0xFE, 0x00, 0xD0, 0xF9, 0x00,
  0xFB, 0x00, 0xD2, 0xF9, 0x00, 0xCF, 0xF9, 0x00, 0xEB, 0xFA, 0x00, 0x5E,
  0xF9, 0x00, 0x00, 0xF9, 0x00, 0x0C, 0xF9, 0x00, 0x0C, 0xFF, 0x00, 0x0D,
  0xBC, 0x54, 0x00, 0xFF, 0xB0, 0x00, 0xF9, 0xA6, 0x00, 0xF9, 0x96, 0x00,
  0xFF, 0xEF, 0x00, 0xC5, 0xFE, 0x00, 0xD0, 0xF9, 0x00, 0xD0, 0xF9, 0x00,
  0xFB, 0x00, 0xD2, 0xF9, 0x00, 0xCF, 0xF9, 0x00, 0xD0, 0xF9, 0x00, 0xEB,
  0xFA, 0x00, 0x5E, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x0C, 0xFF, 0x00, 0x0D,
  0xBC, 0x54, 0x00, 0xFF, 0xB0, 0x00, 0xF9, 0x96, 0x00, 0xFF, 0xEF, 0x00,
  0xC0, 0xFE, 0x00, 0xD0, 0xF9, 0x00, 0xD0, 0xF9, 0x00, 0xD0, 0xF9, 0x00,
  0xFB, 0x00, 0xD2, 0xF9, 0x00, 0xCF, 0xFF, 0x00, 0xDA, 0xF9, 0x00, 0xD0,
  0xFF, 0x00, 0xF2, 0xFA, 0x00, 0x5E, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x0D,
  0xBC, 0x46, 0x00, 0xFF, 0xA1, 0x00, 0xFF, 0xF2, 0x00, 0xC0, 0xFE, 0x00,
  0xFF, 0xF9, 0xFF, 0xCA, 0xF9, 0x00, 0xD0, 0xF9, 0x00, 0xD0, 0xF9, 0x00,
  0xFF, 0x00, 0xCD, 0xFF, 0x00, 0xD4, 0x44, 0xB7, 0x4F, 0xFF, 0x00, 0xDC,
  0x68, 0xD7, 0x73, 0xFF, 0x00, 0xE3, 0x90, 0xFF, 0xCC, 0xFF, 0x00, 0x00,
  0xB7, 0xEA, 0xFF, 0xFF, 0xEE, 0x00, 0xE0, 0xDB, 0xFF, 0xCD, 0xFC, 0x00,
  0xCA, 0xF9, 0x00, 0xD0, 0xF9, 0x00, 0xD0, 0xF9, 0x00, 0xD0, 0xF9, 0x00,
  0xE5, 0x58, 0xFF, 0xE3, 0x58, 0xFE, 0xF2, 0x48, 0xFF, 0xE3, 0x58, 0xFE,
  0xEF, 0x45, 0xFF, 0xE3, 0x58, 0xFE, 0xE7, 0x4B, 0xFF, 0xFF, 0x00, 0x55,
  0xFF, 0xFF, 0x00, 0xD2, 0xFF, 0x00, 0xDA, 0xFD, 0x00, 0xDC, 0xFA, 0x00,
  0xDC, 0xFA, 0x00, 0xDC, 0xFA, 0x00, 0xDC, 0xFA, 0x00, 0xDC, 0xFA, 0x00,
  0x14, 0x00, 0xFB, 0x14, 0x00, 0xF9, 0x14, 0x00, 0xF9, 0x14, 0x00, 0xF9,
  0x14, 0x00, 0xF9, 0x00, 0x00, 0xFC, 0x1E, 0x00, 0xF9, 0x00, 0x00, 0xFF,
  0x00, 0xFF, 0xD6, 0x64, 0xFA, 0x00, 0x69, 0xF5, 0x00, 0x5A, 0xFE, 0x00,
  0x69, 0xF5, 0x00, 0x5D, 0xFF, 0x00, 0x69, 0xF5, 0x00, 0x69, 0xF5, 0x00,
  0x29, 0x00, 0xFB, 0x29, 0x00, 0xF9, 0x29, 0x00, 0xF9, 0x0F, 0x00, 0xF9,
  0x12, 0x00, 0xFC, 0xFF, 0xFF, 0xD6, 0x00, 0x00, 0xFF, 0xFF, 0xFA, 0xAF,
  0x00, 0xC4, 0xFF, 0xF8, 0x9C, 0xC3, 0x00, 0xE5, 0x15, 0xCA, 0x6F, 0xCB,
  0x00, 0xEE, 0x2B, 0xA6, 0x4E, 0xA7, 0x00, 0xE5, 0x37, 0x0C, 0xDA, 0x3F,
  0x29, 0x00, 0xFB, 0x29, 0x00, 0xF9, 0x0F, 0x00, 0xF9, 0xFF, 0xFF, 0xF9,
  0x1A, 0x00, 0xF9, 0x00, 0x00, 0xFD, 0x00, 0x62, 0xF9, 0x00, 0xA8, 0xFF,
  0x00, 0xCC, 0xF9, 0x00, 0xC4, 0xFF, 0x00, 0xFF, 0xC8, 0x0C, 0xDE, 0x0D,
  0x17, 0xDD, 0x38, 0x0A, 0xE8, 0x30, 0x17, 0xDD, 0x38, 0x17, 0xDD, 0x38,
  0x29, 0x00, 0xFB, 0x29, 0x00, 0xF9, 0x29, 0x00, 0xF9, 0x1A, 0x00, 0xF9,
  0x00, 0x0E, 0xFA, 0x00, 0x6C, 0xF9, 0x00, 0x51, 0xF9, 0x00, 0xAC, 0xF9,
  0x00, 0xCC, 0xF9, 0x00, 0xC8, 0xF9, 0x00, 0xBB, 0xFF, 0x00, 0xFF, 0xC8,
  0x1C, 0xD5, 0x18, 0x17, 0xDD, 0x38, 0x17, 0xDD, 0x38, 0x17, 0xDD, 0x38,
  0x29, 0x00, 0xFB, 0x29, 0x00, 0xF9, 0x34, 0x00, 0xF9, 0x00, 0x0E, 0xFA,
  0x00, 0x6C, 0xF9, 0x00, 0x5B, 0xF9, 0x00, 0x51, 0xF9, 0x00, 0xAC, 0xF9,
  0x00, 0xCC, 0xF9, 0x00, 0xC8, 0xF9, 0x00, 0xC8, 0xF9, 0x00, 0xBB, 0xFF,
  0x00, 0xFF, 0xC8, 0x1C, 0xD5, 0x18, 0x17, 0xDD, 0x38, 0x17, 0xDD, 0x38,
  0x29, 0x00, 0xFB, 0x34, 0x00, 0xF9, 0x00, 0x0E, 0xFA, 0x00, 0x6C, 0xF9,
  0x00, 0x5B, 0xF9, 0x00, 0x5B, 0xF9, 0x00, 0x51, 0xF9, 0x00, 0xAC, 0xF9,
  0x00, 0xCC, 0xF9, 0x00, 0xC8, 0xF9, 0x00, 0xC8, 0xF9, 0x00, 0xC8, 0xF9,
  0x00, 0xBB, 0xFF, 0x00, 0xFF, 0xC8, 0x1C, 0xD5, 0x18, 0x17, 0xDD, 0x38,
  0x34, 0x00, 0xFB, 0x00, 0x0E, 0xF9, 0x00, 0x6B, 0xF9, 0x00, 0x5B, 0xF9,
  0x00, 0x5B, 0xF9, 0x00, 0x5B, 0xF9, 0x00, 0x51, 0xF9, 0x00, 0xAC, 0xF9,
  0x00, 0xCC, 0xF9, 0x00, 0xC7, 0xF9, 0x00, 0xC7, 0xF9, 0x00, 0xC7, 0xF9,
  0x00, 0xC7, 0xF9, 0x00, 0xBB, 0xFF, 0x00, 0xFF, 0xC8, 0x1C, 0xD5, 0x18,
  0x00, 0x13, 0xFE, 0x00, 0x6C, 0xFB, 0x00, 0x5C, 0xFC, 0x00, 0x5C, 0xFC,
  0x00, 0x5C, 0xFC, 0x00, 0x5C, 0xFC, 0x00, 0x52, 0xFC, 0x00, 0xAE, 0xFC,
  0x00, 0xCE, 0xFC, 0x00, 0xCA, 0xFC, 0x00, 0xCA, 0xFC, 0x00, 0xCA, 0xFC,
  0x00, 0xCA, 0xFC, 0x00, 0xCA, 0xFC, 0x00, 0xBD, 0xFF, 0x00, 0xFF, 0xC1
};
const unsigned char ASCII_8X8_92[768] = {
  0xFC, 0x00, 0x2F, 0xF9, 0x29, 0x00, 0xF9, 0x20, 0x00, 0xF9, 0x20, 0x00,
  0xF9, 0x20, 0x00, 0xF9, 0x20, 0x00, 0xF9, 0x20, 0x00, 0xFF, 0x16, 0x00,
  0xBC, 0x77, 0x00, 0xFF, 0xDF, 0x00, 0xF9, 0xD4, 0x00, 0xF9, 0xD4, 0x00,
  0xF9, 0xD4, 0x00, 0xF9, 0xD4, 0x00, 0xFF, 0xCA, 0x00, 0xE5, 0xFE, 0x00,
  0xFB, 0x00, 0xBD, 0xFA, 0x00, 0x29, 0xF9, 0x29, 0x00, 0xF9, 0x20, 0x00,
  0xF9, 0x20, 0x00, 0xF9, 0x20, 0x00, 0xF9, 0x20, 0x00, 0xFF, 0x16, 0x00,
  0xBC, 0x77, 0x00, 0xFF, 0xDF, 0x00, 0xF9, 0xD4, 0x00, 0xF9, 0xD4, 0x00,
  0xF9, 0xD4, 0x00, 0xFF, 0xCA, 0x00, 0xEA, 0xFF, 0x00, 0x93, 0xF9, 0x00,
  0xFB, 0x00, 0xA2, 0xF9, 0x00, 0xBC, 0xFA, 0x00, 0x29, 0xF9, 0x29, 0x00,
  0xF9, 0x20, 0x00, 0xF9, 0x20, 0x00, 0xF9, 0x20, 0x00, 0xFF, 0x16, 0x00,
  0xBC, 0x77, 0x00, 0xFF, 0xDF, 0x00, 0xF9, 0xD4, 0x00, 0xF9, 0xD4, 0x00,
  0xFF, 0xCA, 0x00, 0xEA, 0xFF, 0x00, 0x93, 0xF9, 0x00, 0xA2, 0xF9, 0x00,
  0xFB, 0x00, 0xA2, 0xF9, 0x00, 0xA1, 0xF9, 0x00, 0xBC, 0xFA, 0x00, 0x29,
  0xF9, 0x29, 0x00, 0xF9, 0x20, 0x00, 0xF9, 0x20, 0x00, 0xFF, 0x16, 0x00,
  0xBC, 0x77, 0x00, 0xFF, 0xDF, 0x00, 0xF9, 0xD4, 0x00, 0xFF, 0xCA, 0x00,
  0xDF, 0xFF, 0x00, 0x93, 0xF9, 0x00, 0xA2, 0xF9, 0x00, 0xA2, 0xF9, 0x00,
  0xFB, 0x00, 0xA2, 0xF9, 0x00, 0xA1, 0xF9, 0x00, 0xA1, 0xF9, 0x00, 0xBC,
  0xFA, 0x00, 0x29, 0xF9, 0x29, 0x00, 0xF9, 0x20, 0x00, 0xFF, 0x16, 0x00,
  0xBC, 0x77, 0x00, 0xFF, 0xDF, 0x00, 0xFF, 0xCD, 0x00, 0xDF, 0xFF, 0x00,
  0xFF, 0xF9, 0xFF, 0x97, 0xF9, 0x00, 0xA2, 0xF9, 0x00, 0xA2, 0xF9, 0x00,
  0xFB, 0x00, 0xA2, 0xF9, 0x00, 0xA1, 0xFF, 0x00, 0xA6, 0xF9, 0x00, 0xA1,
  0xFF, 0x00, 0xBD, 0xFA, 0x00, 0x29, 0xFF, 0x12, 0x00, 0xFF, 0x16, 0x00,
  0xBC, 0x6D, 0x00, 0xFF, 0xD9, 0x00, 0xEB, 0xDF, 0xFF, 0x92, 0xFC, 0x00,
  0x97, 0xF9, 0x00, 0xA2, 0xF9, 0x00, 0xA2, 0xF9, 0x00, 0xA2, 0xF9, 0x00,
  0xFC, 0x00, 0x97, 0xFF, 0x00, 0x9A, 0x41, 0xB7, 0x61, 0xFF, 0x00, 0x9C,
  0x64, 0xD8, 0x84, 0xFF, 0x00, 0xA3, 0x8E, 0xF9, 0xD6, 0xFF, 0x00, 0x00,
  0xBC, 0xDB, 0xFF, 0xF0, 0xFF, 0x00, 0x92, 0xFC, 0x00, 0xA2, 0xF9, 0x00,
  0xA2, 0xF9, 0x00, 0xA2, 0xF9, 0x00, 0xA2, 0xF9, 0x00, 0xA2, 0xF9, 0x00,
  0xFF, 0x58, 0xFF, 0xFF, 0x56, 0xFF, 0xFF, 0x46, 0xFF, 0xFF, 0x56, 0xFF,
  0xFF, 0x43, 0xFF, 0xFF, 0x56, 0xFF, 0xFF, 0x49, 0xFF, 0xFF, 0x00, 0x13,
  0xFF, 0xFF, 0x00, 0x9F, 0xFA, 0x00, 0xAF, 0xFA, 0x00, 0xAF, 0xFA, 0x00,
  0xAF, 0xFA, 0x00, 0xAF, 0xFA, 0x00, 0xAF, 0xFA, 0x00, 0xAF, 0xFA, 0x00,
  0x43, 0x00, 0xFB, 0x42, 0x00, 0xF9, 0x42, 0x00, 0xF9, 0x42, 0x00, 0xF9,
  0x42, 0x00, 0xF9, 0x42, 0x00, 0xF9, 0x53, 0x00, 0xF9, 0x00, 0x00, 0xFF,
  0x00, 0xFF, 0xFF, 0x2A, 0xFA, 0x00, 0x35, 0xF6, 0x00, 0x26, 0xFF, 0x00,
  0x35, 0xF6, 0x00, 0x29, 0xFF, 0x00, 0x35, 0xF6, 0x00, 0x35, 0xF6, 0x00,
  0x57, 0x00, 0xFB, 0x56, 0x00, 0xF9, 0x56, 0x00, 0xF9, 0x56, 0x00, 0xF9,
  0x56, 0x00, 0xF9, 0x4D, 0x00, 0xFC, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xB0,
  0x00, 0x86, 0xFF, 0xFF, 0xA9, 0xC0, 0x00, 0xE4, 0x43, 0xD0, 0x6F, 0xBE,
  0x00, 0xEE, 0x5B, 0xAD, 0x4E, 0x9B, 0x05, 0xE5, 0x62, 0x12, 0xDA, 0x66,
  0x57, 0x00, 0xFB, 0x56, 0x00, 0xF9, 0x56, 0x00, 0xF9, 0x42, 0x00, 0xF9,
  0x4D, 0x00, 0xFC, 0xFF, 0xFF, 0xD5, 0x00, 0x13, 0xFC, 0x00, 0x73, 0xFF,
  0x00, 0x9E, 0xF9, 0x00, 0x8B, 0xFF, 0x00, 0xFF, 0xFF, 0x0C, 0xDE, 0x31,
  0x17, 0xDD, 0x5B, 0x0A, 0xE8, 0x57, 0x17, 0xDD, 0x5B, 0x17, 0xDD, 0x5B,
  0x57, 0x00, 0xFB, 0x56, 0x00, 0xF9, 0x42, 0x00, 0xF9, 0xFF, 0xFF, 0xF9,
  0x00, 0x00, 0xFA, 0x00, 0x1C, 0xFC, 0x00, 0x24, 0xF9, 0x00, 0x7D, 0xF9,
  0x00, 0x9E, 0xF9, 0x00, 0x9A, 0xF9, 0x00, 0x82, 0xFF, 0x00, 0xFF, 0xFF,
  0x1C, 0xD5, 0x39, 0x17, 0xDD, 0x5B, 0x17, 0xDD, 0x5B, 0x17, 0xDD, 0x5B,
  0x57, 0x00, 0xFB, 0x56, 0x00, 0xF9, 0x66, 0x00, 0xF9, 0x00, 0x00, 0xFA,
  0x00, 0x39, 0xF9, 0x00, 0x2D, 0xF9, 0x00, 0x24, 0xF9, 0x00, 0x7D, 0xF9,
  0x00, 0x9E, 0xF9, 0x00, 0x9A, 0xF9, 0x00, 0x9A, 0xF9, 0x00, 0x82, 0xFF,
  0x00, 0xFF, 0xFF, 0x1C, 0xD5, 0x39, 0x17, 0xDD, 0x5B, 0x17, 0xDD, 0x5B,
  0x57, 0x00, 0xFB, 0x66, 0x00, 0xF9, 0x09, 0x00, 0xFA, 0x00, 0x39, 0xF9,
  0x00, 0x2D, 0xF9, 0x00, 0x2D, 0xF9, 0x00, 0x24, 0xF9, 0x00, 0x7D, 0xF9,
  0x00, 0x9E, 0xF9, 0x00, 0x9A, 0xF9, 0x00, 0x9A, 0xF9, 0x00, 0x9A, 0xF9,
  0x00, 0x82, 0xFF, 0x00, 0xFF, 0xFF, 0x1C, 0xD5, 0x39, 0x17, 0xDD, 0x5B,
  0x68, 0x00, 0xFB, 0x09, 0x00, 0xF9, 0x00, 0x39, 0xF9, 0x00, 0x2D, 0xF9,
  0x00, 0x2D, 0xF9, 0x00, 0x2D, 0xF9, 0x00, 0x24, 0xF9, 0x00, 0x7D, 0xF9,
  0x00, 0x9E, 0xF9, 0x00, 0x9A, 0xF9, 0x00, 0x9A, 0xF9, 0x00, 0x9A, 0xF9,
  0x00, 0x9A, 0xF9, 0x00, 0x82, 0xFE, 0x00, 0xFF, 0xFF, 0x1C, 0xD5, 0x38,
  0x0F, 0x00, 0xFE, 0x00, 0x39, 0xFB, 0x00, 0x2E, 0xFC, 0x00, 0x2E, 0xFC,
  0x00, 0x2E, 0xFC, 0x00, 0x2E, 0xFC, 0x00, 0x24, 0xFC, 0x00, 0x7E, 0xFC,
  0x00, 0xA0, 0xFC, 0x00, 0x9C, 0xFC, 0x00, 0x9C, 0xFC, 0x00, 0x9C, 0xFC,
  0x00, 0x9C, 0xFC, 0x00, 0x9C, 0xFC, 0x00, 0x84, 0xFF, 0x00, 0xFF, 0xF5
};
const unsigned char ASCII_8X8_93[768] = {
  0xFC, 0x00, 0x05, 0xF9, 0x59, 0x00, 0xF9, 0x47, 0x00, 0xF9, 0x47, 0x00,
  0xF9, 0x47, 0x00, 0xF9, 0x47, 0x00, 0xF9, 0x47, 0x00, 0xFF, 0x3D, 0x00,
  0xBC, 0x93, 0x00, 0xFF, 0xFF, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00,
  0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00, 0xFF, 0xF9, 0x00, 0xBB, 0xF9, 0x00,
  0xFB, 0x00, 0x99, 0xF9, 0x00, 0x00, 0xF9, 0x59, 0x00, 0xF9, 0x47, 0x00,
  0xF9, 0x47, 0x00, 0xF9, 0x47, 0x00, 0xF9, 0x47, 0x00, 0xFF, 0x3D, 0x00,
  0xBC, 0x93, 0x00, 0xFF, 0xFF, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00,
  0xF9, 0xF9, 0x00, 0xFF, 0xF9, 0x00, 0xBB, 0xF9, 0x00, 0x6D, 0xF9, 0x00,
  0xFB, 0x00, 0x7E, 0xF9, 0x00, 0x97, 0xFA, 0x00, 0x00, 0xF9, 0x59, 0x00,
  0xF9, 0x47, 0x00, 0xF9, 0x47, 0x00, 0xF9, 0x47, 0x00, 0xFF, 0x3D, 0x00,
  0xBC, 0x93, 0x00, 0xFF, 0xFF, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00,
  0xFF, 0xF9, 0x00, 0xBB, 0xF9, 0x00, 0x6D, 0xF9, 0x00, 0x7D, 0xF9, 0x00,
  0xFB, 0x00, 0x7E, 0xF9, 0x00, 0x7C, 0xF9, 0x00, 0x97, 0xFA, 0x00, 0x00,
  0xF9, 0x59, 0x00, 0xF9, 0x47, 0x00, 0xF9, 0x47, 0x00, 0xFF, 0x3D, 0x00,
  0xBC, 0x93, 0x00, 0xFF, 0xFF, 0x00, 0xFC, 0xFC, 0x00, 0xFF, 0xF9, 0x00,
  0xFF, 0xF9, 0xFF, 0x65, 0xF9, 0x00, 0x7D, 0xF9, 0x00, 0x7D, 0xF9, 0x00,
  0xFB, 0x00, 0x7E, 0xF9, 0x00, 0x7C, 0xF9, 0x00, 0x7D, 0xF9, 0x00, 0x97,
  0xFA, 0x00, 0x00, 0xF9, 0x59, 0x00, 0xF9, 0x47, 0x00, 0xFF, 0x3D, 0x00,
  0xBC, 0x8C, 0x00, 0xFF, 0xFF, 0x00, 0xE5, 0xD5, 0xFF, 0xBE, 0xFC, 0x00,
  0x65, 0xF9, 0x00, 0x7D, 0xF9, 0x00, 0x7D, 0xF9, 0x00, 0x7D, 0xF9, 0x00,
  0xFB, 0x00, 0x7E, 0xF9, 0x00, 0x7C, 0xFF, 0x00, 0x7C, 0xF9, 0x00, 0x7D,
  0xFF, 0x00, 0x94, 0xFA, 0x00, 0x00, 0xFF, 0x43, 0x00, 0xFF, 0x37, 0x00,
  0xBC, 0xDD, 0xFF, 0xFF, 0xFF, 0x00, 0xBE, 0xFC, 0x00, 0x6D, 0xF9, 0x00,
  0x7D, 0xF9, 0x00, 0x7D, 0xF9, 0x00, 0x7D, 0xF9, 0x00, 0x7D, 0xF9, 0x00,
  0xFB, 0x00, 0x71, 0xFF, 0x00, 0x6F, 0x42, 0xB6, 0x74, 0xFF, 0x00, 0x6C,
  0x65, 0xD7, 0x96, 0xFF, 0x00, 0x74, 0x8A, 0xEC, 0xDA, 0xFF, 0x39, 0x00,
  0xC6, 0x80, 0x00, 0xC1, 0xFF, 0x00, 0x6D, 0xF9, 0x00, 0x7D, 0xF9, 0x00,
  0x7D, 0xF9, 0x00, 0x7D, 0xF9, 0x00, 0x7D, 0xF9, 0x00, 0x7D, 0xF9, 0x00,
  0xFF, 0x58, 0xF1, 0xFF, 0x56, 0xED, 0xFF, 0x46, 0xED, 0xFF, 0x56, 0xED,
  0xFF, 0x44, 0xEA, 0xFF, 0x56, 0xED, 0xFF, 0x49, 0xFF, 0xFF, 0x00, 0x00,
  0xD0, 0xFF, 0x00, 0x7A, 0xFA, 0x00, 0x89, 0xFA, 0x00, 0x89, 0xFA, 0x00,
  0x89, 0xFA, 0x00, 0x89, 0xFA, 0x00, 0x89, 0xFA, 0x00, 0x89, 0xFA, 0x00,
  0x6E, 0x00, 0xFE, 0x6D, 0x00, 0xFC, 0x6D, 0x00, 0xFC, 0x6D, 0x00, 0xFC,
  0x6D, 0x00, 0xFC, 0x6D, 0x00, 0xFC, 0x7E, 0x00, 0xFC, 0x28, 0x00, 0xFF,
  0x00, 0xFF, 0xFF, 0x00, 0xFD, 0x00, 0x0B, 0xF6, 0x00, 0x00, 0xFF, 0x00,
  0x0B, 0xF6, 0x00, 0x00, 0xFF, 0x00, 0x0B, 0xF6, 0x00, 0x0B, 0xF6, 0x00,
  0x7E, 0x00, 0xFB, 0x7C, 0x00, 0xF9, 0x7D, 0x00, 0xF9, 0x7D, 0x00, 0xF9,
  0x7D, 0x00, 0xF9, 0x8D, 0x00, 0xF9, 0x38, 0x00, 0xFA, 0x00, 0x57, 0xFF,
  0x00, 0x63, 0xFF, 0xFF, 0xAF, 0xB9, 0x00, 0xE7, 0x6E, 0xD6, 0x6F, 0xB4,
  0x00, 0xEE, 0x84, 0xB4, 0x4E, 0x91, 0x08, 0xE5, 0x88, 0x15, 0xDA, 0x89,
  0x7E, 0x00, 0xFB, 0x7C, 0x00, 0xF9, 0x7D, 0x00, 0xF9, 0x7D, 0x00, 0xF9,
  0x8D, 0x00, 0xF9, 0x1C, 0x00, 0xFD, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xAF,
  0x00, 0x6A, 0xFF, 0x00, 0x5F, 0xFF, 0x00, 0xFF, 0xFF, 0x0B, 0xE2, 0x55,
  0x16, 0xDD, 0x7A, 0x08, 0xE8, 0x79, 0x16, 0xDD, 0x7A, 0x16, 0xDD, 0x7A,
  0x7E, 0x00, 0xFB, 0x7C, 0x00, 0xF9, 0x7D, 0x00, 0xF9, 0x75, 0x00, 0xF9,
  0x1C, 0x00, 0xFD, 0xFF, 0xFF, 0xD5, 0x00, 0x00, 0xFC, 0x00, 0x4B, 0xFF,
  0x00, 0x79, 0xF9, 0x00, 0x75, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0xFF, 0xFF,
  0x1B, 0xDA, 0x59, 0x16, 0xDD, 0x7A, 0x16, 0xDD, 0x7A, 0x16, 0xDD, 0x7A,
  0x7E, 0x00, 0xFB, 0x7C, 0x00, 0xF9, 0x75, 0x00, 0xF9, 0xFF, 0xFF, 0xF9,
  0x00, 0x00, 0xF9, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xF9, 0x00, 0x5A, 0xF9,
  0x00, 0x79, 0xF9, 0x00, 0x75, 0xF9, 0x00, 0x75, 0xF9, 0x00, 0x57, 0xF9,
  0x00, 0xFF, 0xFF, 0x1B, 0xDA, 0x59, 0x16, 0xDD, 0x7A, 0x16, 0xDD, 0x7A,
  0x7E, 0x00, 0xFB, 0x8D, 0x00, 0xF9, 0x38, 0x00, 0xFA, 0x00, 0x00, 0xF9,
  0x00, 0x08, 0xF9, 0x00, 0x08, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x5A, 0xF9,
  0x00, 0x79, 0xF9, 0x00, 0x75, 0xF9, 0x00, 0x75, 0xF9, 0x00, 0x75, 0xF9,
  0x00, 0x57, 0xF9, 0x00, 0xFF, 0xFF, 0x1B, 0xDA, 0x59, 0x16, 0xDD, 0x7A,
  0x8E, 0x00, 0xFB, 0x38, 0x00, 0xF9, 0x00, 0x0A, 0xF9, 0x00, 0x08, 0xF9,
  0x00, 0x08, 0xF9, 0x00, 0x08, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x59, 0xF9,
  0x00, 0x78, 0xF9, 0x00, 0x74, 0xF9, 0x00, 0x74, 0xF9, 0x00, 0x74, 0xF9,
  0x00, 0x74, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0xFF, 0xFF, 0x1B, 0xD9, 0x59,
  0x39, 0x00, 0xFE, 0x00, 0x09, 0xFB, 0x00, 0x07, 0xFC, 0x00, 0x07, 0xFC,
  0x00, 0x07, 0xFC, 0x00, 0x07, 0xFC, 0x00, 0x00, 0xFC, 0x00, 0x5A, 0xFC,
  0x00, 0x7A, 0xFC, 0x00, 0x76, 0xFC, 0x00, 0x76, 0xFC, 0x00, 0x76, 0xFC,
  0x00, 0x76, 0xFC, 0x00, 0x76, 0xFC, 0x00, 0x58, 0xFB, 0x00, 0xFB, 0xFF
};
const unsigned char ASCII_8X8_94[768] = {
  0xFC, 0x0C, 0x00, 0xF9, 0x80, 0x00, 0xF9, 0x6B, 0x00, 0xF9, 0x6B, 0x00,
  0xF9, 0x6B, 0x00, 0xF9, 0x6B, 0x00, 0xF9, 0x6B, 0x00, 0xFF, 0x61, 0x00,
  0xC0, 0xB5, 0x00, 0xD4, 0xFF, 0x00, 0xD3, 0xF9, 0x00, 0xD3, 0xF9, 0x00,
  0xD3, 0xF9, 0x00, 0xD3, 0xF9, 0x00, 0xE2, 0xF9, 0x00, 0x96, 0xF9, 0x00,
  0xFB, 0x00, 0x6E, 0xFA, 0x04, 0x00, 0xF9, 0x80, 0x00, 0xF9, 0x6B, 0x00,
  0xF9, 0x6B, 0x00, 0xF9, 0x6B, 0x00, 0xF9, 0x6B, 0x00, 0xFF, 0x61, 0x00,
  0xC0, 0xB5, 0x00, 0xD4, 0xFF, 0x00, 0xD3, 0xF9, 0x00, 0xD3, 0xF9, 0x00,
  0xCE, 0xF9, 0x00, 0xE2, 0xF9, 0x00, 0x97, 0xF9, 0x00, 0x47, 0xF9, 0x00,
  0xFB, 0x00, 0x58, 0xF9, 0x00, 0x6D, 0xFA, 0x04, 0x00, 0xF9, 0x80, 0x00,
  0xF9, 0x6B, 0x00, 0xF9, 0x6B, 0x00, 0xF9, 0x6B, 0x00, 0xFF, 0x61, 0x00,
  0xC0, 0xB5, 0x00, 0xD4, 0xFF, 0x00, 0xD1, 0xFC, 0x00, 0xCE, 0xF9, 0x00,
  0xFF, 0xF9, 0xFF, 0x92, 0xF9, 0x00, 0x47, 0xF9, 0x00, 0x57, 0xF9, 0x00,
  0xFB, 0x00, 0x58, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x6D, 0xFA, 0x04, 0x00,
  0xF9, 0x80, 0x00, 0xF9, 0x6B, 0x00, 0xF9, 0x6B, 0x00, 0xFF, 0x61, 0x00,
  0xC0, 0xB3, 0x00, 0xD2, 0xFF, 0x00, 0xE8, 0xD5, 0xFF, 0xE0, 0xFC, 0x00,
  0x92, 0xF9, 0x00, 0x47, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00,
  0xFB, 0x00, 0x58, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x6D,
  0xFA, 0x04, 0x00, 0xF9, 0x80, 0x00, 0xFF, 0x62, 0x00, 0xFF, 0x5F, 0x00,
  0xC1, 0xD3, 0xFF, 0xD4, 0xFF, 0x00, 0xE0, 0xFC, 0x00, 0x97, 0xF9, 0x00,
  0x47, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00,
  0xFB, 0x00, 0x58, 0xF9, 0x00, 0x57, 0xFF, 0x00, 0x52, 0xF9, 0x00, 0x57,
  0xFF, 0x00, 0x65, 0xFF, 0x00, 0x00, 0x8B, 0xE8, 0xFF, 0xFF, 0x59, 0x00,
  0xC0, 0xB3, 0x00, 0xE3, 0xFF, 0x00, 0x97, 0xF9, 0x00, 0x47, 0xF9, 0x00,
  0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00,
  0xFB, 0x00, 0x49, 0xFF, 0x00, 0x43, 0x44, 0xB6, 0x86, 0xFF, 0x00, 0x3B,
  0x65, 0xD9, 0xA7, 0xFF, 0x00, 0x56, 0xFF, 0x00, 0x00, 0xFF, 0x77, 0x00,
  0xCE, 0xAD, 0x00, 0x98, 0xFF, 0x00, 0x47, 0xF9, 0x00, 0x57, 0xF9, 0x00,
  0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00,
  0xFF, 0x57, 0xD6, 0xFF, 0x56, 0xD4, 0xFF, 0x46, 0xCF, 0xFF, 0x56, 0xD4,
  0xFF, 0x44, 0xCC, 0xFF, 0x56, 0xD4, 0xFF, 0x5A, 0xF9, 0xFF, 0x00, 0x00,
  0x9E, 0xFF, 0x00, 0x52, 0xFA, 0x00, 0x62, 0xFA, 0x00, 0x62, 0xFA, 0x00,
  0x62, 0xFA, 0x00, 0x62, 0xFA, 0x00, 0x62, 0xFA, 0x00, 0x62, 0xFA, 0x00,
  0x98, 0x00, 0xFF, 0x97, 0x00, 0xFF, 0x97, 0x00, 0xFF, 0x97, 0x00, 0xFF,
  0x97, 0x00, 0xFF, 0x97, 0x00, 0xFF, 0xA8, 0x00, 0xFF, 0x5D, 0x00, 0xFF,
  0x00, 0xDD, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0xF6, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xF6, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xF6, 0x00, 0x00, 0xF6, 0x00,
  0xA3, 0x00, 0xFB, 0xA2, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0xA2, 0x00, 0xF9,
  0xA2, 0x00, 0xF9, 0xB3, 0x00, 0xF9, 0x64, 0x00, 0xF9, 0x00, 0x34, 0xF9,
  0x00, 0x35, 0xF9, 0x00, 0xCB, 0xFF, 0x0F, 0xE9, 0x90, 0xD9, 0x70, 0xA7,
  0x00, 0xEE, 0xAC, 0xB8, 0x4D, 0x86, 0x0C, 0xE5, 0xAC, 0x19, 0xDA, 0xA9,
  0xA3, 0x00, 0xFB, 0xA2, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0xA2, 0x00, 0xF9,
  0xB3, 0x00, 0xF9, 0x61, 0x00, 0xF9, 0x0F, 0x00, 0xF9, 0x00, 0x1B, 0xFF,
  0x00, 0x46, 0xFF, 0xFF, 0xC4, 0x8B, 0x00, 0xCD, 0xFF, 0x0C, 0xEC, 0x7F,
  0x17, 0xDD, 0x97, 0x09, 0xE8, 0x9A, 0x17, 0xDD, 0x97, 0x17, 0xDD, 0x97,
  0xA3, 0x00, 0xFB, 0xA2, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0xB3, 0x00, 0xF9,
  0x61, 0x00, 0xF9, 0x00, 0x00, 0xFC, 0x07, 0x00, 0xFF, 0xFF, 0xFF, 0xB0,
  0x00, 0x3F, 0xFF, 0x00, 0x42, 0xFF, 0x00, 0x31, 0xF9, 0x00, 0xDA, 0xFF,
  0x1C, 0xE3, 0x7F, 0x17, 0xDD, 0x97, 0x17, 0xDD, 0x97, 0x17, 0xDD, 0x97,
  0xA3, 0x00, 0xFB, 0xA2, 0x00, 0xF9, 0xB3, 0x00, 0xF9, 0x45, 0x00, 0xF9,
  0x00, 0x00, 0xFC, 0xFF, 0xFF, 0xD5, 0x07, 0x00, 0xFC, 0x00, 0x1B, 0xFF,
  0x00, 0x52, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x31, 0xF9,
  0x00, 0xDA, 0xFF, 0x1C, 0xE3, 0x7F, 0x17, 0xDD, 0x97, 0x17, 0xDD, 0x97,
  0xA3, 0x00, 0xFB, 0xB2, 0x00, 0xF9, 0x45, 0x00, 0xF9, 0xFF, 0xFF, 0xF9,
  0x01, 0x00, 0xF9, 0x04, 0x00, 0xFC, 0x20, 0x00, 0xF9, 0x00, 0x2F, 0xF9,
  0x00, 0x52, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x4E, 0xF9,
  0x00, 0x31, 0xF9, 0x00, 0xDA, 0xFF, 0x1C, 0xE3, 0x7F, 0x17, 0xDD, 0x97,
  0xB4, 0x00, 0xFB, 0x61, 0x00, 0xF9, 0x0C, 0x00, 0xF9, 0x01, 0x00, 0xF9,
  0x1C, 0x00, 0xF9, 0x1C, 0x00, 0xF9, 0x20, 0x00, 0xF9, 0x00, 0x2F, 0xF9,
  0x00, 0x52, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x4E, 0xF9,
  0x00, 0x4E, 0xF9, 0x00, 0x31, 0xF9, 0x00, 0xDA, 0xFF, 0x1C, 0xE3, 0x7F,
  0x61, 0x00, 0xFE, 0x0C, 0x00, 0xFC, 0x1D, 0x00, 0xFC, 0x1D, 0x00, 0xFC,
  0x1D, 0x00, 0xFC, 0x1D, 0x00, 0xFC, 0x20, 0x00, 0xFC, 0x00, 0x2F, 0xFC,
  0x00, 0x53, 0xFC, 0x00, 0x4F, 0xFC, 0x00, 0x4F, 0xFC, 0x00, 0x4F, 0xFC,
  0x00, 0x4F, 0xFC, 0x00, 0x4F, 0xFC, 0x00, 0x31, 0xFC, 0x00, 0xD0, 0xFF
};
const unsigned char ASCII_8X8_95[768] = {
  0xFC, 0x36, 0x00, 0xF9, 0xA7, 0x00, 0xF9, 0x91, 0x00, 0xF9, 0x91, 0x00,
  0xF9, 0x91, 0x00, 0xF9, 0x91, 0x00, 0xF9, 0x91, 0x00, 0xFF, 0x8A, 0x00,
  0xB6, 0xCB, 0x00, 0xAC, 0xFF, 0x00, 0xAE, 0xF9, 0x00, 0xAE, 0xF9, 0x00,
  0xAE, 0xF9, 0x00, 0xAE, 0xF9, 0x00, 0xBE, 0xF9, 0x00, 0x70, 0xFA, 0x00,
  0xFB, 0x00, 0x3E, 0xF9, 0x33, 0x00, 0xF9, 0xA7, 0x00, 0xF9, 0x91, 0x00,
  0xF9, 0x91, 0x00, 0xF9, 0x91, 0x00, 0xF9, 0x91, 0x00, 0xFF, 0x8A, 0x00,
  0xB6, 0xCB, 0x00, 0xAC, 0xFF, 0x00, 0xA8, 0xFC, 0x00, 0xAE, 0xF9, 0x00,
  0xA5, 0xF9, 0x00, 0xBE, 0xF9, 0x00, 0x6F, 0xFA, 0x00, 0x23, 0xF9, 0x00,
  0xFB, 0x00, 0x31, 0xF9, 0x00, 0x3E, 0xF9, 0x33, 0x00, 0xF9, 0xA7, 0x00,
  0xF9, 0x91, 0x00, 0xF9, 0x91, 0x00, 0xF9, 0x91, 0x00, 0xFF, 0x8A, 0x00,
  0xB4, 0xCC, 0x00, 0xA6, 0xFF, 0x00, 0xFB, 0xD6, 0xFF, 0x9E, 0xFC, 0x00,
  0xFF, 0xF9, 0xFF, 0x66, 0xFA, 0x00, 0x23, 0xF9, 0x00, 0x32, 0xF9, 0x00,
  0xFB, 0x00, 0x31, 0xF9, 0x00, 0x31, 0xF9, 0x00, 0x3E, 0xF9, 0x33, 0x00,
  0xF9, 0xA7, 0x00, 0xF9, 0x91, 0x00, 0xFF, 0x8E, 0x00, 0xFF, 0x8A, 0x00,
  0xC8, 0xC8, 0xFF, 0xAB, 0xFF, 0x00, 0xA8, 0xFC, 0x00, 0xBE, 0xF9, 0x00,
  0x66, 0xFA, 0x00, 0x23, 0xF9, 0x00, 0x32, 0xF9, 0x00, 0x32, 0xF9, 0x00,
  0xFB, 0x00, 0x31, 0xF9, 0x00, 0x31, 0xF9, 0x00, 0x31, 0xF9, 0x00, 0x3E,
  0xFF, 0x20, 0x00, 0xFF, 0xA3, 0x00, 0x8A, 0xBE, 0xFF, 0xFF, 0x86, 0x00,
  0xB4, 0xCC, 0x00, 0xAC, 0xFF, 0x00, 0xBE, 0xF9, 0x00, 0x6F, 0xFA, 0x00,
  0x23, 0xF9, 0x00, 0x32, 0xF9, 0x00, 0x32, 0xF9, 0x00, 0x32, 0xF9, 0x00,
  0xFB, 0x00, 0x31, 0xF9, 0x00, 0x31, 0xFF, 0x00, 0x28, 0xFF, 0x00, 0x25,
  0x65, 0xD3, 0xD5, 0xFF, 0x20, 0x00, 0xFF, 0xA3, 0x00, 0xFF, 0x8A, 0x00,
  0xB6, 0xCB, 0x00, 0xBC, 0xFF, 0x00, 0x6F, 0xFA, 0x00, 0x23, 0xF9, 0x00,
  0x32, 0xF9, 0x00, 0x32, 0xF9, 0x00, 0x32, 0xF9, 0x00, 0x32, 0xF9, 0x00,
  0xFB, 0x00, 0x21, 0xFF, 0x00, 0x18, 0x3F, 0xB6, 0x95, 0xFF, 0x00, 0x18,
  0xFF, 0x00, 0x15, 0xF9, 0x00, 0x2E, 0xF9, 0x2A, 0x00, 0xFF, 0xA0, 0x00,
  0xC7, 0xC5, 0x00, 0x6E, 0xFF, 0x00, 0x23, 0xF9, 0x00, 0x32, 0xF9, 0x00,
  0x32, 0xF9, 0x00, 0x32, 0xF9, 0x00, 0x32, 0xF9, 0x00, 0x32, 0xF9, 0x00,
  0xFF, 0x56, 0xB7, 0xFF, 0x56, 0xB4, 0xFF, 0x46, 0xAB, 0xFF, 0x56, 0xB4,
  0xFF, 0x56, 0xB4, 0xFF, 0x56, 0xB4, 0xFF, 0x50, 0xD0, 0xFF, 0x1D, 0x00,
  0x6B, 0xFF, 0x00, 0x29, 0xFA, 0x00, 0x39, 0xFA, 0x00, 0x39, 0xFA, 0x00,
  0x39, 0xFA, 0x00, 0x39, 0xFA, 0x00, 0x39, 0xFA, 0x00, 0x39, 0xFA, 0x00,
  0xC3, 0x00, 0xFF, 0xC0, 0x00, 0xFF, 0xC0, 0x00, 0xFF, 0xC0, 0x00, 0xFF,
  0xC0, 0x00, 0xFF, 0xC0, 0x00, 0xFF, 0xD1, 0x00, 0xFF, 0x8F, 0x00, 0xFF,
  0x00, 0xA9, 0xFF, 0x00, 0xFF, 0x02, 0x00, 0xF6, 0x24, 0x00, 0xF6, 0x24,
  0x00, 0xF6, 0x24, 0x00, 0xFF, 0x2B, 0x00, 0xF6, 0x24, 0x00, 0xF6, 0x24,
  0xC9, 0x00, 0xFB, 0xC6, 0x00, 0xF9, 0xC7, 0x00, 0xF9, 0xC7, 0x00, 0xF9,
  0xC7, 0x00, 0xF9, 0xD7, 0x00, 0xF9, 0x8D, 0x00, 0xFA, 0x00, 0x06, 0xF9,
  0x00, 0x10, 0xF9, 0x00, 0xA8, 0xFF, 0x1F, 0xEB, 0xB5, 0x09, 0xE4, 0xCA,
  0x0D, 0xE7, 0xCD, 0xB3, 0x4D, 0x73, 0x0D, 0xE7, 0xCD, 0x19, 0xDB, 0xC6,
  0xC9, 0x00, 0xFB, 0xC6, 0x00, 0xF9, 0xC7, 0x00, 0xF9, 0xC7, 0x00, 0xF9,
  0xD7, 0x00, 0xF9, 0x84, 0x00, 0xFA, 0x3A, 0x00, 0xF9, 0x00, 0x05, 0xF9,
  0x00, 0x2D, 0xF9, 0x00, 0x00, 0xFF, 0x00, 0xB3, 0xFF, 0xDC, 0x83, 0x76,
  0x07, 0xE6, 0xB9, 0x0A, 0xE9, 0xBC, 0x17, 0xDE, 0xB5, 0x17, 0xDE, 0xB5,
  0xC9, 0x00, 0xFB, 0xC6, 0x00, 0xF9, 0xC7, 0x00, 0xF9, 0xD7, 0x00, 0xF9,
  0x84, 0x00, 0xFA, 0x31, 0x00, 0xF9, 0x4A, 0x00, 0xF9, 0x00, 0x00, 0xFF,
  0x00, 0x1D, 0xFF, 0xFF, 0xF2, 0x8A, 0x00, 0x00, 0xFF, 0x00, 0xB3, 0xFF,
  0x1C, 0xEE, 0xA4, 0x17, 0xDE, 0xB5, 0x17, 0xDE, 0xB5, 0x17, 0xDE, 0xB5,
  0xC9, 0x00, 0xFB, 0xC6, 0x00, 0xF9, 0xD7, 0x00, 0xF9, 0x6E, 0x00, 0xFA,
  0x31, 0x00, 0xF9, 0x2E, 0x00, 0xFC, 0x31, 0x00, 0xFF, 0xFF, 0xFF, 0xAF,
  0x00, 0x15, 0xFF, 0x00, 0x19, 0xFF, 0x00, 0x29, 0xF9, 0x00, 0x0C, 0xF9,
  0x00, 0xAB, 0xFF, 0x1C, 0xEE, 0xA4, 0x17, 0xDE, 0xB5, 0x17, 0xDE, 0xB5,
  0xC9, 0x00, 0xFB, 0xD7, 0x00, 0xF9, 0x6E, 0x00, 0xFA, 0xFF, 0xFF, 0xF9,
  0x17, 0x00, 0xFC, 0xFF, 0xFF, 0xD6, 0x36, 0x00, 0xFC, 0x00, 0x00, 0xFF,
  0x00, 0x2D, 0xF9, 0x00, 0x29, 0xF9, 0x00, 0x29, 0xF9, 0x00, 0x29, 0xF9,
  0x00, 0x0C, 0xF9, 0x00, 0xAB, 0xFF, 0x1C, 0xEE, 0xA4, 0x17, 0xDE, 0xB5,
  0xD9, 0x00, 0xFB, 0x84, 0x00, 0xF9, 0x31, 0x00, 0xF9, 0x2B, 0x00, 0xF9,
  0x42, 0x00, 0xF9, 0x2E, 0x00, 0xFC, 0x4A, 0x00, 0xF9, 0x00, 0x05, 0xF9,
  0x00, 0x2D, 0xF9, 0x00, 0x29, 0xF9, 0x00, 0x29, 0xF9, 0x00, 0x29, 0xF9,
  0x00, 0x29, 0xF9, 0x00, 0x0C, 0xF9, 0x00, 0xAB, 0xFF, 0x1C, 0xED, 0xA4,
  0x87, 0x00, 0xFE, 0x32, 0x00, 0xFB, 0x43, 0x00, 0xFC, 0x43, 0x00, 0xFC,
  0x43, 0x00, 0xFC, 0x43, 0x00, 0xFC, 0x4B, 0x00, 0xFC, 0x00, 0x04, 0xFC,
  0x00, 0x2E, 0xFC, 0x00, 0x2A, 0xFC, 0x00, 0x2A, 0xFC, 0x00, 0x2A, 0xFC,
  0x00, 0x2A, 0xFC, 0x00, 0x2A, 0xFC, 0x00, 0x0C, 0xFC, 0x00, 0xA5, 0xFF
};
const unsigned char ASCII_8X8_96[768] = {
  0xFC, 0x70, 0x00, 0xF9, 0xD7, 0x00, 0xF9, 0xC2, 0x00, 0xF9, 0xC2, 0x00,
  0xF9, 0xC2, 0x00, 0xF9, 0xC2, 0x00, 0xF9, 0xC2, 0x00, 0xFF, 0xC1, 0x00,
  0x8D, 0xC3, 0x00, 0x78, 0xFF, 0x00, 0x7C, 0xF9, 0x00, 0x7C, 0xF9, 0x00,
  0x7C, 0xF9, 0x00, 0x7C, 0xF9, 0x00, 0x8B, 0xF9, 0x00, 0x3E, 0xFA, 0x00,
  0xFB, 0x00, 0x00, 0xF9, 0x71, 0x00, 0xF9, 0xD8, 0x00, 0xF9, 0xC2, 0x00,
  0xF9, 0xC2, 0x00, 0xF9, 0xC2, 0x00, 0xF9, 0xC2, 0x00, 0xFF, 0xC1, 0x00,
  0x87, 0xC3, 0x00, 0x78, 0xFF, 0x00, 0x6F, 0xFC, 0x00, 0x7C, 0xF9, 0x00,
  0x7C, 0xF9, 0x00, 0x8B, 0xF9, 0x00, 0x3E, 0xFA, 0x00, 0x00, 0xF9, 0x00,
  0xFB, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x71, 0x00, 0xF9, 0xD8, 0x00,
  0xF9, 0xC2, 0x00, 0xF9, 0xC2, 0x00, 0xFF, 0xC4, 0x00, 0xFF, 0xC1, 0x00,
  0xD7, 0xC2, 0xFF, 0x65, 0xFF, 0x00, 0xFF, 0xD5, 0xFF, 0x6F, 0xFC, 0x00,
  0x74, 0xF9, 0x00, 0x3E, 0xFA, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00,
  0xFB, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x71, 0x00,
  0xFF, 0xD2, 0x00, 0xFF, 0xC4, 0x00, 0x8C, 0xA7, 0xFF, 0xFF, 0xC3, 0x00,
  0x87, 0xC3, 0x00, 0x78, 0xFF, 0x00, 0x6F, 0xFC, 0x00, 0x74, 0xF9, 0x00,
  0xFF, 0xF9, 0xFF, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00,
  0xFB, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x66, 0xB2, 0xE3, 0xFF, 0xD2, 0x00, 0xFF, 0xC4, 0x00, 0xFF, 0xC1, 0x00,
  0x8D, 0xC3, 0x00, 0x78, 0xFF, 0x00, 0x8B, 0xF9, 0x00, 0x3E, 0xFA, 0x00,
  0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00,
  0xFB, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x40, 0xBB, 0xBE, 0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0xF9, 0x71, 0x00, 0xF9, 0xD8, 0x00, 0xFF, 0xC1, 0x00,
  0x8D, 0xC3, 0x00, 0x88, 0xFF, 0x00, 0x3E, 0xFA, 0x00, 0x00, 0xF9, 0x00,
  0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00,
  0xFB, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xF9, 0x00, 0x00,
  0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x68, 0x00, 0xFF, 0xD7, 0x00,
  0xA0, 0xBD, 0x00, 0x3B, 0xFF, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00,
  0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00,
  0xFC, 0x58, 0x8F, 0xF9, 0x58, 0x8E, 0xFA, 0x58, 0x8E, 0xFA, 0x58, 0x8E,
  0xFA, 0x58, 0x8E, 0xFA, 0x58, 0x8E, 0xFA, 0x46, 0xA0, 0xFF, 0x61, 0x00,
  0x2B, 0xFF, 0x00, 0x00, 0xFA, 0x00, 0x00, 0xFA, 0x00, 0x00, 0xFA, 0x00,
  0x00, 0xFA, 0x00, 0x00, 0xFA, 0x00, 0x00, 0xFA, 0x00, 0x00, 0xFA, 0x00,
  0xFB, 0x00, 0xFF, 0xF9, 0x00, 0xFF, 0xF9, 0x00, 0xFF, 0xF9, 0x00, 0xFF,
  0xF9, 0x00, 0xFF, 0xF9, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xCE, 0x00, 0xFF,
  0x00, 0x64, 0xFF, 0x00, 0xFF, 0x46, 0x00, 0xF6, 0x5D, 0x00, 0xF6, 0x5D,
  0x00, 0xF6, 0x5D, 0x00, 0xF6, 0x5D, 0x00, 0xF6, 0x5D, 0x00, 0xF6, 0x5D,
  0xFB, 0x00, 0xFB, 0xF9, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00, 0xF9,
  0xF9, 0x00, 0xF9, 0xFF, 0x00, 0xF9, 0xBF, 0x00, 0xF9, 0x0A, 0x00, 0xF9,
  0x06, 0x00, 0xF9, 0x00, 0x68, 0xFF, 0x1E, 0xF6, 0xE6, 0x18, 0xDA, 0xED,
  0x18, 0xDA, 0xED, 0x0B, 0xE6, 0xF9, 0x18, 0xDA, 0xED, 0x18, 0xDA, 0xED,
  0xFB, 0x00, 0xFB, 0xF9, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00, 0xF9,
  0xFF, 0x00, 0xF9, 0xB6, 0x00, 0xF9, 0x6E, 0x00, 0xF9, 0x24, 0x00, 0xF9,
  0x04, 0x00, 0xF9, 0x0A, 0x00, 0xF9, 0x00, 0x6B, 0xFF, 0x08, 0xF3, 0xE3,
  0x08, 0xE9, 0xE9, 0xB2, 0x4D, 0x4F, 0x08, 0xE9, 0xE9, 0x16, 0xDD, 0xDE,
  0xFB, 0x00, 0xFB, 0xF9, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xFF, 0x00, 0xF9,
  0xB6, 0x00, 0xF9, 0x64, 0x00, 0xF9, 0x7E, 0x00, 0xF9, 0x24, 0x00, 0xF9,
  0x04, 0x00, 0xF9, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0xDB, 0xAC, 0x6D,
  0x08, 0xF3, 0xE3, 0x08, 0xE9, 0xE9, 0x16, 0xDD, 0xDE, 0x16, 0xDD, 0xDE,
  0xFB, 0x00, 0xFB, 0xF9, 0x00, 0xF9, 0xFF, 0x00, 0xF9, 0xFF, 0xFF, 0xF9,
  0x5C, 0x00, 0xF9, 0x67, 0x00, 0xFC, 0x7E, 0x00, 0xF9, 0x10, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x8C, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0x00, 0x6B, 0xFF, 0x1B, 0xF9, 0xD7, 0x16, 0xDD, 0xDE, 0x16, 0xDD, 0xDE,
  0xFB, 0x00, 0xFB, 0xFF, 0x00, 0xF9, 0xB6, 0x00, 0xF9, 0x5C, 0x00, 0xF9,
  0x67, 0x00, 0xFC, 0xFF, 0xFF, 0xD5, 0x5D, 0x00, 0xFF, 0xFF, 0xFF, 0xAF,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x08, 0x00, 0xF9, 0x08, 0x00, 0xF9,
  0x0A, 0x00, 0xF9, 0x00, 0x6B, 0xFF, 0x1B, 0xF9, 0xD7, 0x16, 0xDD, 0xDE,
  0xFF, 0x00, 0xFB, 0xB5, 0x00, 0xF9, 0x64, 0x00, 0xF9, 0x75, 0x00, 0xF9,
  0x75, 0x00, 0xF9, 0x67, 0x00, 0xFC, 0x7E, 0x00, 0xF9, 0x10, 0x00, 0xFF,
  0x04, 0x00, 0xF9, 0x08, 0x00, 0xF9, 0x08, 0x00, 0xF9, 0x08, 0x00, 0xF9,
  0x08, 0x00, 0xF9, 0x0A, 0x00, 0xF9, 0x00, 0x6B, 0xFF, 0x1B, 0xF9, 0xD6,
  0xBB, 0x00, 0xFE, 0x65, 0x00, 0xFC, 0x76, 0x00, 0xFC, 0x76, 0x00, 0xFC,
  0x76, 0x00, 0xFC, 0x76, 0x00, 0xFC, 0x7F, 0x00, 0xFC, 0x24, 0x00, 0xFC,
  0x03, 0x00, 0xFC, 0x07, 0x00, 0xFC, 0x07, 0x00, 0xFC, 0x07, 0x00, 0xFC,
  0x07, 0x00, 0xFC, 0x07, 0x00, 0xFC, 0x09, 0x00, 0xFC, 0x00, 0x6C, 0xFF
};
const unsigned char ASCII_8X8_97[768] = {
  0xFC, 0x9A, 0x00, 0xF9, 0xFF, 0x00, 0xF9, 0xEC, 0x00, 0xF9, 0xEC, 0x00,
  0xF9, 0xEC, 0x00, 0xF9, 0xEC, 0x00, 0xF9, 0xEC, 0x00, 0xFF, 0xF1, 0x00,
  0x68, 0xBF, 0x00, 0x4E, 0xFF, 0x00, 0x52, 0xF9, 0x00, 0x52, 0xF9, 0x00,
  0x52, 0xF9, 0x00, 0x52, 0xF9, 0x00, 0x61, 0xF9, 0x00, 0x0F, 0xFA, 0x00,
  0xFB, 0x0E, 0x00, 0xF9, 0x9C, 0x00, 0xF9, 0xFF, 0x00, 0xF9, 0xEC, 0x00,
  0xF9, 0xEC, 0x00, 0xF9, 0xEC, 0x00, 0xFF, 0xF4, 0x00, 0xFF, 0xF1, 0x00,
  0x5E, 0xBF, 0x00, 0x4E, 0xFF, 0x00, 0x52, 0xF9, 0x00, 0x52, 0xF9, 0x00,
  0x52, 0xF9, 0x00, 0x61, 0xF9, 0x00, 0x0A, 0xFA, 0x00, 0x00, 0xF9, 0x33,
  0xFB, 0x29, 0x00, 0xF9, 0x0E, 0x00, 0xFA, 0x9C, 0x00, 0xF9, 0xFF, 0x00,
  0xFF, 0xF7, 0x00, 0xFF, 0xF4, 0x00, 0x8B, 0x92, 0xFF, 0xFF, 0xF8, 0x00,
  0xE7, 0xBE, 0xFF, 0x43, 0xFF, 0x00, 0x40, 0xFC, 0x00, 0x52, 0xF9, 0x00,
  0x61, 0xF9, 0x00, 0x0A, 0xFA, 0x00, 0x00, 0xF9, 0x33, 0x00, 0xF9, 0x28,
  0xFB, 0x29, 0x00, 0xF9, 0x29, 0x00, 0xFF, 0x03, 0x00, 0xFF, 0xA7, 0x00,
  0x65, 0x81, 0xE1, 0xFF, 0xF7, 0x00, 0xFF, 0xF4, 0x00, 0xFF, 0xF1, 0x00,
  0x5E, 0xBF, 0x00, 0x3C, 0xFF, 0x00, 0xFF, 0xD2, 0xFF, 0x50, 0xFC, 0x00,
  0x00, 0xFA, 0x00, 0x00, 0xF9, 0x33, 0x00, 0xF9, 0x28, 0x00, 0xF9, 0x28,
  0xFB, 0x29, 0x00, 0xFF, 0x1F, 0x00, 0x40, 0xAB, 0xBD, 0xFF, 0x03, 0x00,
  0xFF, 0xA7, 0x00, 0xF9, 0xFF, 0x00, 0xF9, 0xEC, 0x00, 0xFF, 0xF1, 0x00,
  0x68, 0xBF, 0x00, 0x4E, 0xFF, 0x00, 0x50, 0xFC, 0x00, 0x00, 0xFA, 0x00,
  0xFF, 0xF8, 0xFF, 0x00, 0xF9, 0x0E, 0x00, 0xF9, 0x28, 0x00, 0xF9, 0x28,
  0xFB, 0x29, 0x00, 0xF9, 0x29, 0x00, 0xFF, 0x1F, 0x00, 0xF9, 0x29, 0x00,
  0xF9, 0x0E, 0x00, 0xFA, 0x9C, 0x00, 0xF9, 0xFF, 0x00, 0xFF, 0xF1, 0x00,
  0x68, 0xBF, 0x00, 0x5D, 0xFF, 0x00, 0x0A, 0xFA, 0x00, 0x00, 0xF9, 0x33,
  0x00, 0xF9, 0x0E, 0x00, 0xF9, 0x28, 0x00, 0xF9, 0x28, 0x00, 0xF9, 0x28,
  0xFB, 0x26, 0x00, 0xF9, 0x26, 0x00, 0xF9, 0x26, 0x00, 0xF9, 0x26, 0x00,
  0xF9, 0x26, 0x00, 0xF9, 0x0B, 0x00, 0xFA, 0x98, 0x00, 0xFF, 0xFF, 0x00,
  0x7C, 0xB8, 0x00, 0x06, 0xFF, 0x00, 0x00, 0xF9, 0x33, 0x00, 0xF9, 0x28,
  0x00, 0xF9, 0x28, 0x00, 0xF9, 0x28, 0x00, 0xF9, 0x28, 0x00, 0xF9, 0x28,
  0xFC, 0x51, 0x6F, 0xF9, 0x51, 0x6E, 0xF9, 0x51, 0x6E, 0xF9, 0x51, 0x6E,
  0xF9, 0x51, 0x6E, 0xF9, 0x51, 0x6E, 0xF9, 0x39, 0x7C, 0xFF, 0x9C, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFA, 0x26, 0x00, 0xFA, 0x1C, 0x00, 0xFA, 0x1C,
  0x00, 0xFA, 0x1C, 0x00, 0xFA, 0x1C, 0x00, 0xFA, 0x1C, 0x00, 0xFA, 0x1C,
  0xFB, 0x00, 0xDE, 0xF9, 0x00, 0xDC, 0xF9, 0x00, 0xDC, 0xF9, 0x00, 0xDC,
  0xF9, 0x00, 0xDC, 0xF9, 0x00, 0xDC, 0xFF, 0x00, 0xD2, 0xFF, 0x00, 0xFF,
  0x00, 0x27, 0xFF, 0x00, 0xFF, 0x7B, 0x00, 0xFA, 0x8C, 0x00, 0xFA, 0x8C,
  0x00, 0xFA, 0x8C, 0x00, 0xFA, 0x8C, 0x00, 0xFA, 0x8C, 0x00, 0xFA, 0x8C,
  0xFB, 0x00, 0xD2, 0xF9, 0x00, 0xCF, 0xF9, 0x00, 0xD0, 0xF9, 0x00, 0xD0,
  0xF9, 0x00, 0xD0, 0xFF, 0x00, 0xC6, 0xF3, 0x00, 0xFF, 0x33, 0x00, 0xF9,
  0x3B, 0x00, 0xF9, 0x00, 0x2F, 0xFF, 0x1F, 0xD2, 0xE0, 0x19, 0xB4, 0xE7,
  0x19, 0xB4, 0xE7, 0x19, 0xB4, 0xE7, 0x19, 0xB4, 0xE7, 0x19, 0xB4, 0xE7,
  0xFB, 0x00, 0xD2, 0xF9, 0x00, 0xCF, 0xF9, 0x00, 0xD0, 0xF9, 0x00, 0xCB,
  0xFF, 0x00, 0xC6, 0xEA, 0x00, 0xFF, 0x97, 0x00, 0xFA, 0x4D, 0x00, 0xF9,
  0x2E, 0x00, 0xF9, 0x3F, 0x00, 0xF9, 0x00, 0x36, 0xFF, 0x1C, 0xD9, 0xD5,
  0x17, 0xBB, 0xDD, 0x0A, 0xC2, 0xE8, 0x17, 0xBB, 0xDD, 0x17, 0xBB, 0xDD,
  0xFB, 0x00, 0xD2, 0xF9, 0x00, 0xCF, 0xF9, 0x00, 0xCB, 0xFE, 0xFF, 0xFF,
  0xEA, 0x00, 0xFD, 0x86, 0x00, 0xFD, 0xA8, 0x00, 0xF9, 0x4D, 0x00, 0xF9,
  0x2E, 0x00, 0xF9, 0x32, 0x00, 0xF9, 0x3F, 0x00, 0xF9, 0x00, 0x23, 0xFF,
  0x0F, 0xE0, 0xE1, 0xB2, 0x62, 0x4E, 0x0A, 0xC2, 0xE8, 0x17, 0xBB, 0xDD,
  0xFB, 0x00, 0xD2, 0xF9, 0x00, 0xCF, 0xFF, 0x00, 0xC6, 0xEA, 0x00, 0xFD,
  0x86, 0x00, 0xFD, 0xFF, 0xFF, 0xD2, 0x9F, 0x00, 0xFD, 0x3F, 0x00, 0xFF,
  0x2E, 0x00, 0xF9, 0x23, 0x00, 0xFF, 0x26, 0x00, 0xFF, 0xD5, 0xD1, 0x65,
  0x00, 0x23, 0xFF, 0x0F, 0xE0, 0xE1, 0x17, 0xBB, 0xDD, 0x17, 0xBB, 0xDD,
  0xFB, 0x00, 0xD2, 0xFF, 0x00, 0xC5, 0xEA, 0x00, 0xFF, 0x8E, 0x00, 0xFA,
  0x9E, 0x00, 0xF9, 0x96, 0x00, 0xFD, 0x99, 0x00, 0xFF, 0xFF, 0xFF, 0xB1,
  0x10, 0x00, 0xFF, 0xEF, 0xFF, 0x8B, 0x23, 0x00, 0xFF, 0x26, 0x00, 0xFF,
  0x3F, 0x00, 0xF9, 0x00, 0x36, 0xFF, 0x1C, 0xD9, 0xD5, 0x17, 0xBB, 0xDD,
  0xFF, 0x00, 0xC7, 0xEA, 0x00, 0xFF, 0x8E, 0x00, 0xF9, 0x9E, 0x00, 0xF9,
  0x9E, 0x00, 0xF9, 0x9E, 0x00, 0xF9, 0xA7, 0x00, 0xF9, 0x3E, 0x00, 0xFF,
  0x2E, 0x00, 0xF9, 0x22, 0x00, 0xFF, 0x32, 0x00, 0xF9, 0x32, 0x00, 0xF9,
  0x32, 0x00, 0xF9, 0x3F, 0x00, 0xF9, 0x00, 0x36, 0xFF, 0x1C, 0xD9, 0xD5,
  0xE9, 0x00, 0xFF, 0x8F, 0x00, 0xFC, 0xA0, 0x00, 0xFC, 0xA0, 0x00, 0xFC,
  0xA0, 0x00, 0xFC, 0xA0, 0x00, 0xFC, 0xA9, 0x00, 0xFC, 0x4E, 0x00, 0xFC,
  0x2E, 0x00, 0xFC, 0x33, 0x00, 0xFC, 0x33, 0x00, 0xFC, 0x33, 0x00, 0xFC,
  0x33, 0x00, 0xFC, 0x33, 0x00, 0xFC, 0x3F, 0x00, 0xFC, 0x00, 0x3D, 0xFF
};
const unsigned char ASCII_8X8_98[768] = {
  0xFF, 0xC2, 0x00, 0xD9, 0xFF, 0x00, 0xE0, 0xF9, 0x00, 0xE0, 0xF9, 0x00,
  0xE0, 0xF9, 0x00, 0xE0, 0xF9, 0x00, 0xE0, 0xF9, 0x00, 0xF1, 0xFF, 0x00,
  0x4A, 0xBE, 0x00, 0x28, 0xFF, 0x00, 0x2D, 0xF9, 0x00, 0x2D, 0xF9, 0x00,
  0x2D, 0xF9, 0x00, 0x2D, 0xF9, 0x00, 0x39, 0xF9, 0x00, 0x00, 0xF9, 0x0B,
  0xFB, 0x34, 0x00, 0xFF, 0xC7, 0x00, 0xD9, 0xFF, 0x00, 0xE0, 0xF9, 0x00,
  0xE9, 0xFF, 0x00, 0xE0, 0xF9, 0x00, 0xE6, 0xFF, 0x00, 0xF1, 0xFF, 0x00,
  0x4A, 0xBE, 0x00, 0x28, 0xFF, 0x00, 0x2D, 0xF9, 0x00, 0x2D, 0xF9, 0x00,
  0x2D, 0xF9, 0x00, 0x39, 0xF9, 0x00, 0x00, 0xF9, 0x06, 0x00, 0xF9, 0x5D,
  0xFB, 0x4F, 0x00, 0xF9, 0x33, 0x00, 0xFF, 0xC1, 0x00, 0xE3, 0xFF, 0x00,
  0x70, 0x63, 0xE0, 0xEF, 0xFF, 0x00, 0x97, 0x8A, 0xFF, 0xF7, 0xFF, 0x00,
  0x3C, 0xBE, 0x00, 0x28, 0xFF, 0x00, 0x2D, 0xF9, 0x00, 0x2D, 0xF9, 0x00,
  0x39, 0xF9, 0x00, 0x00, 0xF9, 0x06, 0x00, 0xF9, 0x5D, 0x00, 0xF9, 0x4E,
  0xFB, 0x4F, 0x00, 0xFF, 0x48, 0x00, 0x40, 0x7E, 0xBF, 0xFF, 0xC1, 0x00,
  0xE3, 0xFF, 0x00, 0xE0, 0xF9, 0x00, 0xE6, 0xFF, 0x00, 0xE3, 0xFF, 0x00,
  0xF4, 0xBB, 0xFF, 0x1A, 0xFF, 0x00, 0x17, 0xFC, 0x00, 0x39, 0xF9, 0x00,
  0x00, 0xF9, 0x06, 0x00, 0xF9, 0x5D, 0x00, 0xF9, 0x4E, 0x00, 0xF9, 0x4E,
  0xFB, 0x4F, 0x00, 0xF9, 0x4E, 0x00, 0xFF, 0x48, 0x00, 0xF9, 0x33, 0x00,
  0xFF, 0xC7, 0x00, 0xD9, 0xFF, 0x00, 0xE0, 0xF9, 0x00, 0xF1, 0xFF, 0x00,
  0x3C, 0xBE, 0x00, 0x12, 0xFF, 0x00, 0xFF, 0xD5, 0xFF, 0x00, 0xFC, 0x00,
  0x00, 0xF9, 0x48, 0x00, 0xF9, 0x4E, 0x00, 0xF9, 0x4E, 0x00, 0xF9, 0x4E,
  0xFB, 0x4F, 0x00, 0xF9, 0x4E, 0x00, 0xF9, 0x4E, 0x00, 0xF9, 0x4E, 0x00,
  0xF9, 0x33, 0x00, 0xFF, 0xC7, 0x00, 0xD9, 0xFF, 0x00, 0xF1, 0xFF, 0x00,
  0x4A, 0xBE, 0x00, 0x33, 0xFF, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xF9, 0x48,
  0xFF, 0xF9, 0xFF, 0x00, 0xF9, 0x39, 0x00, 0xF9, 0x4E, 0x00, 0xF9, 0x4E,
  0xFB, 0x50, 0x00, 0xF9, 0x4F, 0x00, 0xF9, 0x4F, 0x00, 0xF9, 0x4F, 0x00,
  0xF9, 0x4F, 0x00, 0xF9, 0x34, 0x00, 0xFF, 0xC8, 0x00, 0xEA, 0xFF, 0x00,
  0x5A, 0xB8, 0x00, 0x00, 0xFF, 0x06, 0x00, 0xF9, 0x5D, 0x00, 0xF9, 0x4E,
  0x00, 0xF9, 0x39, 0x00, 0xF9, 0x4E, 0x00, 0xF9, 0x4E, 0x00, 0xF9, 0x4E,
  0xFB, 0x4D, 0x51, 0xF9, 0x4D, 0x4F, 0xF9, 0x4D, 0x50, 0xF9, 0x4D, 0x50,
  0xF9, 0x4D, 0x50, 0xF9, 0x4D, 0x50, 0xF9, 0x30, 0x5A, 0xFF, 0xD2, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFA, 0x51, 0x00, 0xFA, 0x42, 0x00, 0xFA, 0x42,
  0x00, 0xFA, 0x42, 0x00, 0xFA, 0x42, 0x00, 0xFA, 0x42, 0x00, 0xFA, 0x42,
  0xFB, 0x00, 0xB7, 0xF9, 0x00, 0xB6, 0xF9, 0x00, 0xB6, 0xF9, 0x00, 0xB6,
  0xF9, 0x00, 0xB6, 0xF9, 0x00, 0xB6, 0xFA, 0x00, 0xA6, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0xFF, 0xA9, 0x00, 0xFF, 0xB6, 0x00, 0xFF, 0xB6,
  0x00, 0xFF, 0xB6, 0x00, 0xFF, 0xB6, 0x00, 0xFF, 0xB6, 0x00, 0xFF, 0xB6,
  0xFB, 0x00, 0xAC, 0xF9, 0x00, 0xAB, 0xF9, 0x00, 0xAB, 0xF9, 0x00, 0xA1,
  0xF9, 0x00, 0xAB, 0xFA, 0x00, 0x9A, 0xFF, 0x00, 0xFB, 0x5D, 0x00, 0xFC,
  0x68, 0x00, 0xF9, 0x00, 0x00, 0xFF, 0x1F, 0xB5, 0xDC, 0x19, 0x94, 0xE3,
  0x19, 0x94, 0xE3, 0x19, 0x94, 0xE3, 0x19, 0x94, 0xE3, 0x19, 0x94, 0xE3,
  0xFB, 0x00, 0xAC, 0xF9, 0x00, 0xAB, 0xF9, 0x00, 0xA1, 0xF9, 0xFF, 0xFF,
  0xFA, 0x00, 0x91, 0xFF, 0x00, 0xFE, 0xBF, 0x00, 0xFC, 0x73, 0x00, 0xF9,
  0x53, 0x00, 0xF9, 0x6D, 0x00, 0xF9, 0x00, 0x03, 0xFF, 0x1C, 0xC0, 0xD7,
  0x17, 0x9F, 0xDE, 0x17, 0x9F, 0xDE, 0x17, 0x9F, 0xDE, 0x17, 0x9F, 0xDE,
  0xFB, 0x00, 0xAC, 0xF9, 0x00, 0xAB, 0xF9, 0x00, 0xAB, 0xFA, 0x00, 0x91,
  0xFF, 0x00, 0xFE, 0xE3, 0xFF, 0xD8, 0xC8, 0x00, 0xFC, 0x69, 0x00, 0xFF,
  0x53, 0x00, 0xF9, 0x57, 0x00, 0xF9, 0x6D, 0x00, 0xF9, 0x00, 0x03, 0xFF,
  0x1C, 0xC0, 0xD7, 0x0A, 0xA3, 0xE9, 0x17, 0x9F, 0xDE, 0x17, 0x9F, 0xDE,
  0xFB, 0x00, 0xAC, 0xF9, 0x00, 0xAB, 0xFA, 0x00, 0x9A, 0xFF, 0x00, 0xFB,
  0xB6, 0x00, 0xFC, 0xBF, 0x00, 0xFC, 0xC2, 0x00, 0xFF, 0xEA, 0xFF, 0xAF,
  0x49, 0x00, 0xFF, 0x4C, 0x00, 0xFF, 0x57, 0x00, 0xF9, 0x65, 0x00, 0xFF,
  0x00, 0x07, 0xFF, 0xB7, 0x91, 0x49, 0x0A, 0xA3, 0xE9, 0x17, 0x9F, 0xDE,
  0xFB, 0x00, 0xAC, 0xF9, 0x00, 0x9A, 0xFF, 0x00, 0xFB, 0xB6, 0x00, 0xFC,
  0xC3, 0x00, 0xF9, 0xC3, 0x00, 0xF9, 0xCC, 0x00, 0xF9, 0x69, 0x00, 0xFF,
  0x48, 0x00, 0xFF, 0xDB, 0xFF, 0x8A, 0x44, 0x00, 0xFF, 0xB5, 0xE0, 0x63,
  0x65, 0x00, 0xFF, 0x00, 0x07, 0xFF, 0x1C, 0xC0, 0xD7, 0x17, 0x9F, 0xDE,
  0xFB, 0x00, 0x9B, 0xFF, 0x00, 0xFB, 0xB5, 0x00, 0xFC, 0xC3, 0x00, 0xF9,
  0xC3, 0x00, 0xF9, 0xC3, 0x00, 0xF9, 0xCC, 0x00, 0xF9, 0x73, 0x00, 0xF9,
  0x53, 0x00, 0xF9, 0x4C, 0x00, 0xFF, 0x57, 0x00, 0xF9, 0x4F, 0x00, 0xFF,
  0x57, 0x00, 0xF9, 0x6D, 0x00, 0xF9, 0x00, 0x03, 0xFF, 0x1C, 0xC0, 0xD6,
  0xFF, 0x00, 0xF9, 0xB7, 0x00, 0xFE, 0xC5, 0x00, 0xFC, 0xC5, 0x00, 0xFC,
  0xC5, 0x00, 0xFC, 0xC5, 0x00, 0xFC, 0xCE, 0x00, 0xFC, 0x75, 0x00, 0xFC,
  0x53, 0x00, 0xFC, 0x58, 0x00, 0xFC, 0x58, 0x00, 0xFC, 0x58, 0x00, 0xFC,
  0x58, 0x00, 0xFC, 0x58, 0x00, 0xFC, 0x6D, 0x00, 0xFC, 0x00, 0x10, 0xFF
};
const unsigned char ASCII_8X8_99[768] = {
  0xFF, 0xF1, 0x00, 0xA6, 0xFE, 0x00, 0xB7, 0xF9, 0x00, 0xB7, 0xF9, 0x00,
  0xB7, 0xF9, 0x00, 0xB7, 0xF9, 0x00, 0xB7, 0xF9, 0x00, 0xC7, 0xFF, 0x00,
  0x28, 0xBD, 0x00, 0x00, 0xFF, 0x00, 0x04, 0xF9, 0x00, 0x04, 0xF9, 0x00,
  0x04, 0xF9, 0x00, 0x04, 0xF9, 0x00, 0x05, 0xF9, 0x00, 0x00, 0xF9, 0x39,
  0xFC, 0x5F, 0x00, 0xFF, 0xF9, 0x00, 0xB6, 0xFF, 0x00, 0xB7, 0xF9, 0x00,
  0xBB, 0xFF, 0x00, 0xB7, 0xF9, 0x00, 0xB7, 0xF9, 0x00, 0xC7, 0xFF, 0x00,
  0x28, 0xBD, 0x00, 0x00, 0xFF, 0x00, 0x04, 0xF9, 0x00, 0x04, 0xF9, 0x00,
  0x04, 0xF9, 0x00, 0x05, 0xF9, 0x00, 0x00, 0xF9, 0x38, 0x00, 0xF9, 0x88,
  0xFB, 0x7A, 0x00, 0xFF, 0x6A, 0x00, 0x53, 0x62, 0xBF, 0xBA, 0xFF, 0x00,
  0x86, 0x65, 0xE2, 0xBB, 0xFF, 0x00, 0xB8, 0xFF, 0x00, 0xC7, 0xFF, 0x00,
  0x28, 0xBD, 0x00, 0x00, 0xFF, 0x00, 0x04, 0xF9, 0x00, 0x04, 0xF9, 0x00,
  0x05, 0xF9, 0x00, 0x00, 0xF9, 0x38, 0x00, 0xF9, 0x88, 0x00, 0xF9, 0x79,
  0xFB, 0x7A, 0x00, 0xF9, 0x78, 0x00, 0xFF, 0x6A, 0x00, 0xFF, 0xF9, 0x00,
  0xAB, 0xFF, 0x00, 0xB8, 0xFF, 0x00, 0xAD, 0x8B, 0xFF, 0xC8, 0xFF, 0x00,
  0x16, 0xBD, 0x00, 0x00, 0xFF, 0x00, 0x04, 0xF9, 0x00, 0x05, 0xF9, 0x00,
  0x00, 0xF9, 0x38, 0x00, 0xF9, 0x88, 0x00, 0xF9, 0x79, 0x00, 0xF9, 0x79,
  0xFB, 0x7A, 0x00, 0xF9, 0x78, 0x00, 0xF9, 0x79, 0x00, 0xFA, 0x5E, 0x00,
  0xFF, 0xF9, 0x00, 0xA7, 0xFF, 0x00, 0xB8, 0xFF, 0x00, 0xB5, 0xFF, 0x00,
  0xFF, 0xBB, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xF9, 0x38,
  0x00, 0xF9, 0x88, 0x00, 0xF9, 0x79, 0x00, 0xF9, 0x79, 0x00, 0xF9, 0x79,
  0xFB, 0x7A, 0x00, 0xF9, 0x78, 0x00, 0xF9, 0x79, 0x00, 0xF9, 0x79, 0x00,
  0xFA, 0x5E, 0x00, 0xFF, 0xF9, 0x00, 0xA7, 0xFF, 0x00, 0xC7, 0xFF, 0x00,
  0x16, 0xBD, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0xD5, 0xFF, 0x00, 0xFC, 0x73,
  0x00, 0xF9, 0x68, 0x00, 0xF9, 0x79, 0x00, 0xF9, 0x79, 0x00, 0xF9, 0x79,
  0xFB, 0x7E, 0x00, 0xF9, 0x7D, 0x00, 0xF9, 0x7D, 0x00, 0xF9, 0x7D, 0x00,
  0xF9, 0x7D, 0x00, 0xFA, 0x62, 0x00, 0xFF, 0xFD, 0x00, 0xB7, 0xFF, 0x00,
  0x2F, 0xB7, 0x00, 0x00, 0xFF, 0x38, 0x00, 0xFC, 0x73, 0x00, 0xF9, 0x68,
  0xFF, 0xF9, 0xFF, 0x00, 0xF9, 0x68, 0x00, 0xF9, 0x79, 0x00, 0xF9, 0x79,
  0xFC, 0x5E, 0x47, 0xF9, 0x5E, 0x48, 0xFA, 0x5E, 0x48, 0xFA, 0x5E, 0x48,
  0xFA, 0x5E, 0x48, 0xFA, 0x5E, 0x48, 0xFA, 0x3F, 0x50, 0xFF, 0xFF, 0x00,
  0x00, 0xFF, 0x28, 0x00, 0xFA, 0x7D, 0x00, 0xFA, 0x6D, 0x00, 0xFA, 0x6D,
  0x00, 0xFA, 0x5D, 0x00, 0xFA, 0x6D, 0x00, 0xFA, 0x6D, 0x00, 0xFA, 0x6D,
  0xFB, 0x00, 0x89, 0xF9, 0x00, 0x88, 0xF9, 0x00, 0x88, 0xF9, 0x00, 0x79,
  0xF9, 0x00, 0x88, 0xF9, 0x00, 0x88, 0xF9, 0x00, 0x77, 0xFF, 0x00, 0xD6,
  0x00, 0x00, 0xFF, 0x00, 0xFF, 0xDA, 0x00, 0xFF, 0xE2, 0x00, 0xFF, 0xE2,
  0x00, 0xFF, 0xE2, 0x00, 0xFF, 0xE2, 0x00, 0xFF, 0xE2, 0x00, 0xFF, 0xE2,
  0xFB, 0x00, 0x82, 0xF9, 0x00, 0x80, 0xF9, 0x00, 0x71, 0xF9, 0xFF, 0xFF,
  0xF9, 0x00, 0x71, 0xFC, 0x00, 0x6C, 0xFF, 0x00, 0xC6, 0x8D, 0x00, 0xFF,
  0x9A, 0x00, 0xF9, 0x00, 0x00, 0xFF, 0x1B, 0x8E, 0xD6, 0x18, 0x6F, 0xDD,
  0x18, 0x6F, 0xDD, 0x18, 0x6F, 0xDD, 0x18, 0x6F, 0xDD, 0x18, 0x6F, 0xDD,
  0xFB, 0x00, 0x82, 0xF9, 0x00, 0x80, 0xF9, 0x00, 0x80, 0xF9, 0x00, 0x71,
  0xFC, 0x00, 0x6C, 0xD8, 0xFF, 0xF4, 0xF7, 0x00, 0xFF, 0x95, 0x00, 0xFF,
  0x7D, 0x00, 0xF9, 0x9E, 0x00, 0xF9, 0x00, 0x00, 0xFF, 0x18, 0x9D, 0xD5,
  0x16, 0x7E, 0xDD, 0x16, 0x7E, 0xDD, 0x16, 0x7E, 0xDD, 0x16, 0x7E, 0xDD,
  0xFB, 0x00, 0x82, 0xF9, 0x00, 0x80, 0xF9, 0x00, 0x80, 0xF9, 0x00, 0x70,
  0xFC, 0x00, 0xC6, 0xED, 0x00, 0xFF, 0xF2, 0x00, 0xFF, 0xD6, 0xFF, 0xAF,
  0x78, 0x00, 0xFF, 0x7B, 0x00, 0xFF, 0x9E, 0x00, 0xF9, 0x00, 0x00, 0xFF,
  0x18, 0x9D, 0xD5, 0x16, 0x7E, 0xDD, 0x16, 0x7E, 0xDD, 0x16, 0x7E, 0xDD,
  0xFB, 0x00, 0x82, 0xF9, 0x00, 0x80, 0xF9, 0x00, 0x70, 0xFC, 0x00, 0xC6,
  0xEA, 0x00, 0xFF, 0xED, 0x00, 0xF9, 0xF7, 0x00, 0xF9, 0x95, 0x00, 0xFF,
  0x77, 0x00, 0xFF, 0xC8, 0xFF, 0x8B, 0x7B, 0x00, 0xFF, 0x9B, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x0A, 0x8D, 0xE5, 0x16, 0x7E, 0xDD, 0x16, 0x7E, 0xDD,
  0xFB, 0x00, 0x82, 0xF9, 0x00, 0x70, 0xFC, 0x00, 0xC6, 0xEA, 0x00, 0xFF,
  0xED, 0x00, 0xF9, 0xED, 0x00, 0xF9, 0xF7, 0x00, 0xF9, 0x9A, 0x00, 0xF9,
  0x7D, 0x00, 0xF9, 0x7B, 0x00, 0xFF, 0x7E, 0x00, 0xFF, 0xA1, 0xE1, 0x65,
  0x8D, 0x00, 0xFF, 0x99, 0x9F, 0x4A, 0x0A, 0x8D, 0xE5, 0x16, 0x7E, 0xDD,
  0xFB, 0x00, 0x71, 0xFC, 0x00, 0xC6, 0xEA, 0x00, 0xFF, 0xED, 0x00, 0xF9,
  0xED, 0x00, 0xF9, 0xED, 0x00, 0xF9, 0xF7, 0x00, 0xF9, 0x9A, 0x00, 0xF9,
  0x7C, 0x00, 0xF9, 0x80, 0x00, 0xF9, 0x80, 0x00, 0xF9, 0x7E, 0x00, 0xFF,
  0x80, 0x00, 0xF9, 0x8F, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x18, 0x9D, 0xD5,
  0xFF, 0x00, 0xC7, 0xED, 0x00, 0xFF, 0xF0, 0x00, 0xFC, 0xF0, 0x00, 0xFC,
  0xF0, 0x00, 0xFC, 0xF0, 0x00, 0xFC, 0xFA, 0x00, 0xFC, 0x9C, 0x00, 0xFC,
  0x7E, 0x00, 0xFC, 0x82, 0x00, 0xFC, 0x82, 0x00, 0xFC, 0x82, 0x00, 0xFC,
  0x82, 0x00, 0xFC, 0x82, 0x00, 0xFC, 0x9F, 0x00, 0xFC, 0x00, 0x00, 0xFF
};
const unsigned char ASCII_8X8_100[768] = {
  0xE6, 0xFF, 0x00, 0x6F, 0xF9, 0x00, 0x85, 0xF9, 0x00, 0x85, 0xF9, 0x00,
  0x85, 0xF9, 0x00, 0x85, 0xF9, 0x00, 0x85, 0xF9, 0x00, 0x95, 0xFF, 0x00,
  0x00, 0xBD, 0x00, 0x00, 0xFF, 0x33, 0x00, 0xF9, 0x2D, 0x00, 0xF9, 0x2D,
  0x00, 0xF9, 0x2D, 0x00, 0xF9, 0x2D, 0x00, 0xF9, 0x1E, 0x00, 0xFA, 0x6C,
  0xFF, 0x99, 0x00, 0xEB, 0xFF, 0x00, 0x7B, 0xFF, 0x00, 0x85, 0xF9, 0x00,
  0x85, 0xF9, 0x00, 0x85, 0xF9, 0x00, 0x85, 0xF9, 0x00, 0x95, 0xFF, 0x00,
  0x00, 0xBD, 0x00, 0x00, 0xFF, 0x33, 0x00, 0xF9, 0x2D, 0x00, 0xF9, 0x2D,
  0x00, 0xF9, 0x2D, 0x00, 0xF9, 0x1E, 0x00, 0xFA, 0x6B, 0x00, 0xF9, 0xBB,
  0xFB, 0xAC, 0x00, 0xFF, 0xA7, 0x00, 0x5E, 0x55, 0xBE, 0x7B, 0xFF, 0x00,
  0x83, 0xFF, 0x00, 0x85, 0xF9, 0x00, 0x85, 0xF9, 0x00, 0x95, 0xFF, 0x00,
  0x00, 0xBD, 0x00, 0x00, 0xFF, 0x33, 0x00, 0xF9, 0x2D, 0x00, 0xF9, 0x2D,
  0x00, 0xF9, 0x1E, 0x00, 0xFA, 0x6B, 0x00, 0xF9, 0xBB, 0x00, 0xF9, 0xAB,
  0xFB, 0xAC, 0x00, 0xF9, 0xAB, 0x00, 0xFF, 0xA7, 0x00, 0xE9, 0xFF, 0x00,
  0x89, 0x65, 0xE1, 0x83, 0xFF, 0x00, 0x80, 0xFF, 0x00, 0x95, 0xFF, 0x00,
  0x00, 0xBD, 0x00, 0x00, 0xFF, 0x33, 0x00, 0xF9, 0x2D, 0x00, 0xF9, 0x1E,
  0x00, 0xFA, 0x6B, 0x00, 0xF9, 0xBB, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB,
  0xFB, 0xAC, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB, 0x00, 0xFF, 0x98, 0x00,
  0xE9, 0xFF, 0x00, 0x6A, 0xFF, 0x00, 0xC5, 0x8B, 0xFF, 0x8F, 0xFF, 0x00,
  0x00, 0xBD, 0x00, 0x00, 0xFF, 0x33, 0x00, 0xF9, 0x1E, 0x00, 0xFA, 0x6B,
  0x00, 0xF9, 0xBB, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB,
  0xFB, 0xAC, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB, 0x00,
  0xFF, 0x98, 0x00, 0xEB, 0xFF, 0x00, 0x6A, 0xFF, 0x00, 0x7D, 0xFF, 0x00,
  0xFF, 0xBB, 0xFF, 0x00, 0xFF, 0x0A, 0x00, 0xFD, 0x65, 0x00, 0xF9, 0xBB,
  0x00, 0xF9, 0xA1, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB,
  0xFB, 0xB2, 0x00, 0xF9, 0xB1, 0x00, 0xF9, 0xB1, 0x00, 0xF9, 0xB1, 0x00,
  0xF9, 0xB1, 0x00, 0xFF, 0x9E, 0x00, 0xEB, 0xFF, 0x00, 0x7F, 0xFF, 0x00,
  0x00, 0xB7, 0x00, 0x00, 0xFF, 0x6A, 0xFF, 0xD5, 0xFF, 0x00, 0xFC, 0x9A,
  0xFF, 0xF9, 0xFF, 0x00, 0xF9, 0xA1, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB,
  0xFC, 0x86, 0x4D, 0xF9, 0x85, 0x4D, 0xF9, 0x85, 0x4D, 0xF9, 0x85, 0x4D,
  0xF9, 0x85, 0x4D, 0xF9, 0x85, 0x4D, 0xFF, 0x6C, 0x55, 0xFC, 0xFF, 0x00,
  0x00, 0xFF, 0x6D, 0x00, 0xFC, 0xB2, 0x00, 0xFF, 0x9B, 0x00, 0xFC, 0xA2,
  0x00, 0xFC, 0x98, 0x00, 0xFC, 0xA2, 0x00, 0xFC, 0xA2, 0x00, 0xFC, 0xA2,
  0xFB, 0x00, 0x50, 0xF9, 0x00, 0x4F, 0xF9, 0x00, 0x4F, 0xF9, 0x00, 0x3A,
  0xF9, 0x00, 0x4F, 0xFC, 0x00, 0x3D, 0xF9, 0x00, 0x3E, 0xFF, 0x00, 0x92,
  0x28, 0x00, 0xFF, 0x00, 0xFF, 0xF9, 0x00, 0xF2, 0xFD, 0x00, 0xF2, 0xFD,
  0x00, 0xF2, 0xFD, 0x00, 0xF2, 0xFD, 0x00, 0xF2, 0xFD, 0x00, 0xF2, 0xFD,
  0xFB, 0x00, 0x4F, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x39, 0xF9, 0xFF, 0xFF,
  0xFC, 0x00, 0x26, 0xD6, 0xFF, 0xFF, 0xFF, 0x00, 0x7B, 0xD0, 0x00, 0xFF,
  0xCB, 0x00, 0xF9, 0x2E, 0x00, 0xFE, 0x0E, 0x59, 0xD3, 0x18, 0x43, 0xDA,
  0x18, 0x43, 0xDA, 0x18, 0x43, 0xDA, 0x18, 0x43, 0xDA, 0x18, 0x43, 0xDA,
  0xFB, 0x00, 0x4F, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x39,
  0xF9, 0x00, 0x3D, 0xFC, 0x00, 0x80, 0xFF, 0x00, 0xE5, 0xC1, 0xFF, 0xB3,
  0xAF, 0x00, 0xFF, 0xCF, 0x00, 0xFF, 0x2B, 0x00, 0xFF, 0x0B, 0x6A, 0xD5,
  0x16, 0x55, 0xDD, 0x16, 0x55, 0xDD, 0x16, 0x55, 0xDD, 0x16, 0x55, 0xDD,
  0xFB, 0x00, 0x4F, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x3D,
  0xF9, 0x00, 0x92, 0xF9, 0x00, 0xE4, 0xFE, 0x00, 0xCF, 0xD4, 0x00, 0xFF,
  0xAE, 0x00, 0xFF, 0xAF, 0xFF, 0x8B, 0xCF, 0x00, 0xFF, 0x2F, 0x00, 0xFF,
  0x0B, 0x6A, 0xD5, 0x16, 0x55, 0xDD, 0x16, 0x55, 0xDD, 0x16, 0x55, 0xDD,
  0xFB, 0x00, 0x4F, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x3D, 0xF9, 0x00, 0x92,
  0xF9, 0x00, 0xE4, 0xF9, 0x00, 0xD4, 0xFE, 0x00, 0xCF, 0xD3, 0x00, 0xFE,
  0xAE, 0x00, 0xF9, 0xB2, 0x00, 0xFF, 0xB5, 0x00, 0xFF, 0xA5, 0xE1, 0x65,
  0x2F, 0x00, 0xFF, 0x03, 0x5A, 0xE5, 0x16, 0x55, 0xDD, 0x16, 0x55, 0xDD,
  0xFB, 0x00, 0x4F, 0xF9, 0x00, 0x3D, 0xF9, 0x00, 0x92, 0xF9, 0x00, 0xE4,
  0xF9, 0x00, 0xD4, 0xF9, 0x00, 0xD4, 0xFE, 0x00, 0xCF, 0xD3, 0x00, 0xFE,
  0xAE, 0x00, 0xF9, 0xB2, 0x00, 0xF9, 0xB2, 0x00, 0xF9, 0xB5, 0x00, 0xFF,
  0xC7, 0x00, 0xFF, 0x8C, 0xA8, 0x48, 0x03, 0x5A, 0xE5, 0x16, 0x55, 0xDD,
  0xFB, 0x00, 0x3E, 0xF9, 0x00, 0x92, 0xF9, 0x00, 0xE4, 0xF9, 0x00, 0xD3,
  0xF9, 0x00, 0xD3, 0xF9, 0x00, 0xD3, 0xFE, 0x00, 0xCF, 0xD3, 0x00, 0xFE,
  0xAE, 0x00, 0xF9, 0xB2, 0x00, 0xF9, 0xB2, 0x00, 0xF9, 0xB2, 0x00, 0xF9,
  0xB2, 0x00, 0xF9, 0xC7, 0x00, 0xFF, 0x2B, 0x00, 0xFF, 0x0B, 0x6A, 0xD5,
  0xFE, 0x00, 0x94, 0xFC, 0x00, 0xE6, 0xFC, 0x00, 0xD6, 0xFC, 0x00, 0xD6,
  0xFC, 0x00, 0xD6, 0xFC, 0x00, 0xD6, 0xFF, 0x00, 0xD1, 0xD5, 0x00, 0xFF,
  0xAF, 0x00, 0xFC, 0xB4, 0x00, 0xFC, 0xB4, 0x00, 0xFC, 0xB4, 0x00, 0xFC,
  0xB4, 0x00, 0xFC, 0xB4, 0x00, 0xFC, 0xD1, 0x00, 0xFC, 0x35, 0x00, 0xFF
};
const unsigned char ASCII_8X8_101[768] = {
  0xB6, 0xFF, 0x00, 0x44, 0xF9, 0x00, 0x5A, 0xF9, 0x00, 0x5A, 0xF9, 0x00,
  0x5A, 0xF9, 0x00, 0x5A, 0xF9, 0x00, 0x5A, 0xF9, 0x00, 0x65, 0xFF, 0x00,
  0x00, 0xBC, 0x0E, 0x00, 0xFF, 0x5F, 0x00, 0xF9, 0x57, 0x00, 0xF9, 0x57,
  0x00, 0xF9, 0x57, 0x00, 0xF9, 0x57, 0x00, 0xF9, 0x47, 0x00, 0xF9, 0x96,
  0xFF, 0xCB, 0x00, 0xB6, 0xFF, 0x00, 0x44, 0xF9, 0x00, 0x5A, 0xF9, 0x00,
  0x5A, 0xF9, 0x00, 0x5A, 0xF9, 0x00, 0x5A, 0xF9, 0x00, 0x65, 0xFF, 0x00,
  0x00, 0xBC, 0x0E, 0x00, 0xFF, 0x5F, 0x00, 0xF9, 0x57, 0x00, 0xF9, 0x57,
  0x00, 0xF9, 0x57, 0x00, 0xF9, 0x47, 0x00, 0xF9, 0x96, 0x00, 0xF9, 0xE3,
  0xFB, 0xD5, 0x00, 0xFF, 0xC9, 0x00, 0xC5, 0xFF, 0x00, 0x44, 0xF9, 0x00,
  0x5A, 0xF9, 0x00, 0x5A, 0xF9, 0x00, 0x5A, 0xF9, 0x00, 0x65, 0xFF, 0x00,
  0x00, 0xBC, 0x0E, 0x00, 0xFF, 0x5F, 0x00, 0xF9, 0x57, 0x00, 0xF9, 0x57,
  0x00, 0xF9, 0x47, 0x00, 0xF9, 0x96, 0x00, 0xF9, 0xE3, 0x00, 0xF9, 0xD4,
  0xFB, 0xD5, 0x00, 0xFF, 0xDD, 0x00, 0x54, 0x4A, 0xBD, 0xC5, 0xFF, 0x00,
  0x47, 0xFF, 0x00, 0x5A, 0xF9, 0x00, 0x5A, 0xF9, 0x00, 0x65, 0xFF, 0x00,
  0x00, 0xBC, 0x0E, 0x00, 0xFF, 0x5F, 0x00, 0xF9, 0x57, 0x00, 0xF9, 0x47,
  0x00, 0xF9, 0x96, 0x00, 0xF9, 0xE3, 0x00, 0xF9, 0xD4, 0x00, 0xF9, 0xD4,
  0xFB, 0xD5, 0x00, 0xF9, 0xD2, 0x00, 0xFF, 0xDD, 0x00, 0xFF, 0xD5, 0x00,
  0x8E, 0x70, 0xE3, 0x47, 0xFF, 0x00, 0x4F, 0xFF, 0x00, 0x65, 0xFF, 0x00,
  0x00, 0xBC, 0x0E, 0x00, 0xFF, 0x5F, 0x00, 0xF9, 0x47, 0x00, 0xF9, 0x96,
  0x00, 0xF9, 0xE3, 0x00, 0xF9, 0xD4, 0x00, 0xF9, 0xD4, 0x00, 0xF9, 0xD4,
  0xFB, 0xD5, 0x00, 0xF9, 0xD2, 0x00, 0xF9, 0xD3, 0x00, 0xF9, 0xD3, 0x00,
  0xFF, 0xD5, 0x00, 0xAB, 0xFF, 0x00, 0xC5, 0x8B, 0xFF, 0x5A, 0xFF, 0x00,
  0x00, 0xBC, 0x00, 0x00, 0xFF, 0x50, 0x00, 0xFC, 0x95, 0x00, 0xF9, 0xE3,
  0x00, 0xF9, 0xCF, 0x00, 0xF9, 0xD4, 0x00, 0xF9, 0xD4, 0x00, 0xF9, 0xD4,
  0xFB, 0xDC, 0x00, 0xF9, 0xD9, 0x00, 0xF9, 0xDA, 0x00, 0xF9, 0xDA, 0x00,
  0xF9, 0xDA, 0x00, 0xFF, 0xD0, 0x00, 0xAB, 0xFF, 0x00, 0x36, 0xFF, 0x00,
  0xFF, 0xB5, 0xFF, 0x00, 0xFF, 0x87, 0xFF, 0xD6, 0xF8, 0x00, 0xFC, 0xCD,
  0xFF, 0xF9, 0xFF, 0x00, 0xF9, 0xCF, 0x00, 0xF9, 0xD4, 0x00, 0xF9, 0xD4,
  0xFC, 0xA8, 0x52, 0xFA, 0xA6, 0x52, 0xFA, 0xA7, 0x52, 0xFA, 0xA7, 0x52,
  0xFA, 0xA7, 0x52, 0xFA, 0xA7, 0x52, 0xFF, 0x96, 0x5B, 0xC1, 0xFF, 0x00,
  0x00, 0xFF, 0x8E, 0x00, 0xFF, 0xDF, 0x00, 0xFF, 0xCE, 0x00, 0xFF, 0xD0,
  0x00, 0xFF, 0xCB, 0x00, 0xFF, 0xD0, 0x00, 0xFF, 0xD0, 0x00, 0xFF, 0xD0,
  0xFB, 0x00, 0x21, 0xF9, 0x00, 0x21, 0xF9, 0x00, 0x21, 0xF9, 0x00, 0x07,
  0xF9, 0x00, 0x21, 0xFC, 0x00, 0x0A, 0xF9, 0x00, 0x11, 0xFF, 0x00, 0x61,
  0x61, 0x00, 0xFF, 0x00, 0xDE, 0xF6, 0x00, 0xC0, 0xFA, 0x00, 0xC0, 0xFA,
  0x00, 0xC0, 0xFA, 0x00, 0xC0, 0xFA, 0x00, 0xC0, 0xFA, 0x00, 0xC0, 0xFA,
  0xFB, 0x00, 0x25, 0xF9, 0x00, 0x25, 0xF9, 0x00, 0x0B, 0xF9, 0xFF, 0xFF,
  0xFC, 0x00, 0x00, 0xD6, 0xFF, 0xFF, 0xFF, 0x00, 0x4E, 0xB3, 0xFF, 0xD4,
  0xFC, 0x00, 0xFF, 0x67, 0x00, 0xFF, 0x05, 0x31, 0xD3, 0x19, 0x24, 0xDA,
  0x19, 0x24, 0xDA, 0x19, 0x24, 0xDA, 0x19, 0x24, 0xDA, 0x19, 0x24, 0xDA,
  0xFB, 0x00, 0x25, 0xF9, 0x00, 0x25, 0xF9, 0x00, 0x25, 0xF9, 0x00, 0x0B,
  0xF9, 0x00, 0x15, 0xFC, 0x00, 0x52, 0xF9, 0x00, 0xB1, 0xFF, 0x00, 0xFF,
  0xDE, 0x00, 0xFF, 0xB7, 0xFF, 0x8C, 0x64, 0x00, 0xFF, 0x00, 0x2E, 0xE2,
  0x17, 0x34, 0xDD, 0x17, 0x34, 0xDD, 0x17, 0x34, 0xDD, 0x17, 0x34, 0xDD,
  0xFB, 0x00, 0x25, 0xF9, 0x00, 0x25, 0xF9, 0x00, 0x25, 0xF9, 0x00, 0x15,
  0xF9, 0x00, 0x6A, 0xF9, 0x00, 0xBA, 0xF9, 0x00, 0xA1, 0xFD, 0x00, 0xFE,
  0xD9, 0x00, 0xFA, 0xE2, 0x00, 0xFF, 0xF4, 0x00, 0xFF, 0xA6, 0xD6, 0x6D,
  0x00, 0x2E, 0xE2, 0x09, 0x2B, 0xE8, 0x17, 0x34, 0xDD, 0x17, 0x34, 0xDD,
  0xFB, 0x00, 0x25, 0xF9, 0x00, 0x25, 0xF9, 0x00, 0x15, 0xF9, 0x00, 0x6A,
  0xF9, 0x00, 0xBA, 0xF9, 0x00, 0xAA, 0xF9, 0x00, 0xA1, 0xFD, 0x00, 0xFE,
  0xD9, 0x00, 0xFA, 0xDC, 0x00, 0xF9, 0xDC, 0x00, 0xF9, 0xF4, 0x00, 0xFF,
  0x51, 0x00, 0xFF, 0x9F, 0xB0, 0x47, 0x09, 0x2B, 0xE8, 0x17, 0x34, 0xDD,
  0xFB, 0x00, 0x25, 0xF9, 0x00, 0x15, 0xF9, 0x00, 0x6A, 0xF9, 0x00, 0xBA,
  0xF9, 0x00, 0xAA, 0xF9, 0x00, 0xAA, 0xF9, 0x00, 0xA1, 0xFD, 0x00, 0xFE,
  0xD9, 0x00, 0xFA, 0xDC, 0x00, 0xF9, 0xDC, 0x00, 0xF9, 0xDC, 0x00, 0xF9,
  0xFA, 0x00, 0xF9, 0x51, 0x00, 0xFF, 0x02, 0x41, 0xD5, 0x17, 0x34, 0xDD,
  0xFB, 0x00, 0x14, 0xF9, 0x00, 0x69, 0xF9, 0x00, 0xBA, 0xF9, 0x00, 0xAA,
  0xF9, 0x00, 0xAA, 0xF9, 0x00, 0xAA, 0xF9, 0x00, 0xA0, 0xFC, 0x00, 0xFE,
  0xD9, 0x00, 0xF9, 0xDC, 0x00, 0xF9, 0xDC, 0x00, 0xF9, 0xDC, 0x00, 0xF9,
  0xDC, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0x5E, 0x00, 0xFF, 0x02, 0x41, 0xD5,
  0xFE, 0x00, 0x6A, 0xFC, 0x00, 0xBC, 0xFC, 0x00, 0xAC, 0xFC, 0x00, 0xAC,
  0xFC, 0x00, 0xAC, 0xFC, 0x00, 0xAC, 0xFC, 0x00, 0xA2, 0xFF, 0x00, 0xFF,
  0xDB, 0x00, 0xFC, 0xDF, 0x00, 0xFC, 0xDF, 0x00, 0xFC, 0xDF, 0x00, 0xFC,
  0xDF, 0x00, 0xFC, 0xDF, 0x00, 0xFC, 0xFC, 0x00, 0xFC, 0x64, 0x00, 0xFF
};
const unsigned char ASCII_8X8_102[768] = {
  0x88, 0xFC, 0x00, 0x1C, 0xF9, 0x00, 0x32, 0xF9, 0x00, 0x32, 0xF9, 0x00,
  0x32, 0xF9, 0x00, 0x32, 0xF9, 0x00, 0x32, 0xF9, 0x00, 0x39, 0xFF, 0x00,
  0x00, 0xBC, 0x33, 0x00, 0xFF, 0x8A, 0x00, 0xF9, 0x81, 0x00, 0xF9, 0x81,
  0x00, 0xF9, 0x81, 0x00, 0xF9, 0x81, 0x00, 0xF9, 0x71, 0x00, 0xFA, 0xBF,
  0xFF, 0xFB, 0x00, 0x84, 0xFA, 0x00, 0x1C, 0xF9, 0x00, 0x32, 0xF9, 0x00,
  0x32, 0xF9, 0x00, 0x32, 0xF9, 0x00, 0x32, 0xF9, 0x00, 0x39, 0xFF, 0x00,
  0x00, 0xBC, 0x33, 0x00, 0xFF, 0x8A, 0x00, 0xF9, 0x81, 0x00, 0xF9, 0x81,
  0x00, 0xF9, 0x81, 0x00, 0xF9, 0x71, 0x00, 0xFA, 0xC0, 0x00, 0xF4, 0xFF,
  0xF7, 0xFB, 0x00, 0xFF, 0xF9, 0x00, 0x84, 0xFA, 0x00, 0x1C, 0xF9, 0x00,
  0x32, 0xF9, 0x00, 0x32, 0xF9, 0x00, 0x32, 0xF9, 0x00, 0x39, 0xFF, 0x00,
  0x00, 0xBC, 0x33, 0x00, 0xFF, 0x8A, 0x00, 0xF9, 0x81, 0x00, 0xF9, 0x81,
  0x00, 0xF9, 0x71, 0x00, 0xFA, 0xC0, 0x00, 0xF4, 0xFF, 0x00, 0xF5, 0xF9,
  0xF7, 0xFB, 0x00, 0xF5, 0xF9, 0x00, 0xFF, 0xFF, 0x00, 0x84, 0xFA, 0x00,
  0x1C, 0xF9, 0x00, 0x32, 0xF9, 0x00, 0x32, 0xF9, 0x00, 0x39, 0xFF, 0x00,
  0x00, 0xBC, 0x33, 0x00, 0xFF, 0x8A, 0x00, 0xF9, 0x81, 0x00, 0xF9, 0x71,
  0x00, 0xFA, 0xC0, 0x00, 0xF4, 0xFF, 0x00, 0xF5, 0xF9, 0x00, 0xF5, 0xF9,
  0xF7, 0xFB, 0x00, 0xFF, 0xFF, 0x00, 0x46, 0x44, 0xC0, 0xFF, 0xFF, 0x00,
  0x90, 0xFF, 0x00, 0x1C, 0xF9, 0x00, 0x32, 0xF9, 0x00, 0x39, 0xFF, 0x00,
  0x00, 0xBC, 0x33, 0x00, 0xFF, 0x8A, 0x00, 0xF9, 0x71, 0x00, 0xFA, 0xC0,
  0x00, 0xF4, 0xFF, 0x00, 0xF5, 0xF9, 0x00, 0xF5, 0xF9, 0x00, 0xF5, 0xF9,
  0xF7, 0xFB, 0x00, 0xF5, 0xF9, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00,
  0x83, 0x66, 0xE3, 0x90, 0xFF, 0x00, 0x18, 0xFF, 0x00, 0x39, 0xFF, 0x00,
  0x00, 0xBC, 0x20, 0x00, 0xFF, 0x7A, 0x00, 0xFD, 0xC3, 0x00, 0xF4, 0xFF,
  0x00, 0xF5, 0xF9, 0x00, 0xF5, 0xF9, 0x00, 0xF5, 0xF9, 0x00, 0xF5, 0xF9,
  0xF7, 0xFF, 0x00, 0xF4, 0xFF, 0x00, 0xF5, 0xFF, 0x00, 0xF5, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xBC, 0x92, 0xFE, 0x05, 0xFF, 0x00,
  0xFF, 0xB5, 0xF5, 0x00, 0xFF, 0xBA, 0xFF, 0xD7, 0xE4, 0x00, 0xF7, 0xFC,
  0xFF, 0xFB, 0xF9, 0x00, 0xF5, 0xF9, 0x00, 0xF5, 0xF9, 0x00, 0xF5, 0xF9,
  0xFD, 0xC8, 0x57, 0xFA, 0xC7, 0x57, 0xFB, 0xC7, 0x57, 0xFB, 0xC7, 0x57,
  0xFB, 0xC7, 0x57, 0xFB, 0xC7, 0x57, 0xFF, 0xC8, 0x4A, 0x8A, 0xFF, 0x00,
  0x00, 0xFF, 0xC7, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFD, 0x00, 0xFF, 0xFA,
  0x00, 0xFF, 0xFA, 0x00, 0xFF, 0xFA, 0x00, 0xFF, 0xFA, 0x00, 0xFF, 0xFA,
  0xFB, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00,
  0xF9, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xFF, 0x00, 0x23,
  0x9C, 0x00, 0xFF, 0x00, 0x8F, 0xFB, 0x00, 0x90, 0xF6, 0x00, 0x90, 0xF6,
  0x00, 0x90, 0xF6, 0x00, 0x90, 0xF6, 0x00, 0x90, 0xF6, 0x00, 0x90, 0xF6,
  0xFB, 0x04, 0x00, 0xF9, 0x04, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0xFF, 0xFF,
  0xFC, 0x00, 0x00, 0xD5, 0xFF, 0xFF, 0xFF, 0x00, 0x16, 0xAF, 0xFF, 0xE5,
  0xFF, 0x00, 0xF8, 0xC5, 0xF2, 0x91, 0x00, 0x00, 0xDC, 0x0E, 0x00, 0xE2,
  0x1E, 0x08, 0xDA, 0x1E, 0x08, 0xDA, 0x1E, 0x08, 0xDA, 0x1E, 0x08, 0xDA,
  0xFB, 0x04, 0x00, 0xF9, 0x04, 0x00, 0xF9, 0x04, 0x00, 0xF9, 0x00, 0x00,
  0xF9, 0x05, 0x00, 0xFD, 0x00, 0x1F, 0xF9, 0x00, 0x87, 0xFF, 0x00, 0xD3,
  0xF9, 0x00, 0xF1, 0xFF, 0x00, 0xF3, 0x86, 0x00, 0xFF, 0xB8, 0xDD, 0x6D,
  0x0B, 0x06, 0xE5, 0x0E, 0x09, 0xE8, 0x1B, 0x17, 0xDD, 0x1B, 0x17, 0xDD,
  0xFB, 0x04, 0x00, 0xF9, 0x04, 0x00, 0xF9, 0x04, 0x00, 0xF9, 0x05, 0x00,
  0xFA, 0x00, 0x3C, 0xF9, 0x00, 0x90, 0xF9, 0x00, 0x76, 0xF9, 0x00, 0xD3,
  0xF9, 0x00, 0xF1, 0xF9, 0x00, 0xED, 0xFF, 0x00, 0xEA, 0x86, 0x00, 0xFF,
  0x00, 0x0F, 0xE1, 0xB3, 0xB5, 0x52, 0x0E, 0x09, 0xE8, 0x1B, 0x17, 0xDD,
  0xFB, 0x04, 0x00, 0xF9, 0x04, 0x00, 0xF9, 0x05, 0x00, 0xFA, 0x00, 0x3C,
  0xF9, 0x00, 0x90, 0xF9, 0x00, 0x80, 0xF9, 0x00, 0x76, 0xF9, 0x00, 0xD3,
  0xF9, 0x00, 0xF1, 0xF9, 0x00, 0xED, 0xF9, 0x00, 0xED, 0xFF, 0x00, 0xEA,
  0x95, 0x00, 0xFF, 0x00, 0x0F, 0xE1, 0x1B, 0x17, 0xDD, 0x1B, 0x17, 0xDD,
  0xFB, 0x04, 0x00, 0xF9, 0x05, 0x00, 0xFA, 0x00, 0x3C, 0xF9, 0x00, 0x90,
  0xF9, 0x00, 0x80, 0xF9, 0x00, 0x80, 0xF9, 0x00, 0x76, 0xF9, 0x00, 0xD3,
  0xF9, 0x00, 0xF1, 0xF9, 0x00, 0xED, 0xF9, 0x00, 0xED, 0xF9, 0x00, 0xED,
  0xFF, 0x00, 0xEA, 0x95, 0x00, 0xFF, 0x00, 0x1C, 0xD5, 0x1B, 0x17, 0xDD,
  0xFB, 0x05, 0x00, 0xF9, 0x00, 0x3B, 0xF9, 0x00, 0x90, 0xF9, 0x00, 0x7F,
  0xF9, 0x00, 0x7F, 0xF9, 0x00, 0x7F, 0xF9, 0x00, 0x76, 0xF9, 0x00, 0xD2,
  0xF9, 0x00, 0xF1, 0xF9, 0x00, 0xED, 0xF9, 0x00, 0xED, 0xF9, 0x00, 0xED,
  0xF9, 0x00, 0xED, 0xFF, 0x00, 0xEA, 0x95, 0x00, 0xFF, 0x00, 0x1C, 0xD5,
  0xFE, 0x00, 0x3E, 0xFB, 0x00, 0x91, 0xFC, 0x00, 0x81, 0xFC, 0x00, 0x81,
  0xFC, 0x00, 0x81, 0xFC, 0x00, 0x81, 0xFC, 0x00, 0x77, 0xFC, 0x00, 0xD4,
  0xFC, 0x00, 0xF4, 0xFC, 0x00, 0xF0, 0xFC, 0x00, 0xF0, 0xFC, 0x00, 0xF0,
  0xFC, 0x00, 0xF0, 0xFC, 0x00, 0xF0, 0xFF, 0x00, 0xED, 0x94, 0x00, 0xFF
};
const unsigned char ASCII_8X8_103[768] = {
  0x5D, 0xFC, 0x00, 0x00, 0xF9, 0x00, 0x08, 0xF9, 0x00, 0x08, 0xF9, 0x00,
  0x08, 0xF9, 0x00, 0x08, 0xF9, 0x00, 0x08, 0xF9, 0x00, 0x09, 0xFF, 0x00,
  0x00, 0xBC, 0x56, 0x00, 0xFF, 0xB6, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB,
  0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0x9C, 0x00, 0xFF, 0xEE,
  0xE9, 0xFB, 0x00, 0x59, 0xFA, 0x00, 0x00, 0xF9, 0x00, 0x08, 0xF9, 0x00,
  0x08, 0xF9, 0x00, 0x08, 0xF9, 0x00, 0x08, 0xF9, 0x00, 0x09, 0xFF, 0x00,
  0x00, 0xBC, 0x56, 0x00, 0xFF, 0xB6, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB,
  0x00, 0xF9, 0xAB, 0x00, 0xF9, 0x9C, 0x00, 0xFF, 0xF4, 0x00, 0xBF, 0xFE,
  0xCE, 0xFB, 0x00, 0xE7, 0xF9, 0x00, 0x5A, 0xFA, 0x00, 0x00, 0xF9, 0x00,
  0x08, 0xF9, 0x00, 0x08, 0xF9, 0x00, 0x08, 0xF9, 0x00, 0x09, 0xFF, 0x00,
  0x00, 0xBC, 0x56, 0x00, 0xFF, 0xB6, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB,
  0x00, 0xF9, 0x9C, 0x00, 0xFF, 0xF4, 0x00, 0xBF, 0xFE, 0x00, 0xCB, 0xF9,
  0xCE, 0xFB, 0x00, 0xCB, 0xF9, 0x00, 0xE7, 0xF9, 0x00, 0x5A, 0xFA, 0x00,
  0x00, 0xF9, 0x00, 0x08, 0xF9, 0x00, 0x08, 0xF9, 0x00, 0x09, 0xFF, 0x00,
  0x00, 0xBC, 0x56, 0x00, 0xFF, 0xB6, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0x9C,
  0x00, 0xFF, 0xF4, 0x00, 0xBF, 0xFE, 0x00, 0xCB, 0xF9, 0x00, 0xCB, 0xF9,
  0xCE, 0xFB, 0x00, 0xCB, 0xF9, 0x00, 0xD5, 0xFF, 0x00, 0xE7, 0xF9, 0x00,
  0x5A, 0xFA, 0x00, 0x00, 0xF9, 0x00, 0x08, 0xF9, 0x00, 0x09, 0xFF, 0x00,
  0x00, 0xBC, 0x56, 0x00, 0xFF, 0xB6, 0x00, 0xF9, 0x9C, 0x00, 0xFF, 0xF4,
  0x00, 0xBF, 0xFE, 0x00, 0xCB, 0xF9, 0x00, 0xCB, 0xF9, 0x00, 0xCB, 0xF9,
  0xCE, 0xFB, 0x00, 0xD5, 0xFF, 0x00, 0x57, 0x44, 0xC1, 0xD5, 0xFF, 0x00,
  0xEE, 0xFF, 0x00, 0x5A, 0xFA, 0x00, 0x00, 0xFF, 0x00, 0x09, 0xFF, 0x00,
  0x00, 0xBC, 0x48, 0x00, 0xFF, 0xA6, 0x00, 0xFF, 0xF7, 0x00, 0xBF, 0xFE,
  0x00, 0xC5, 0xF9, 0x00, 0xCB, 0xF9, 0x00, 0xCB, 0xF9, 0x00, 0xCB, 0xF9,
  0xC8, 0xFF, 0x00, 0xC6, 0xFD, 0x00, 0xD0, 0xFF, 0x00, 0xCD, 0xFF, 0x00,
  0x74, 0x68, 0xD7, 0xDE, 0xFF, 0x00, 0xCD, 0x90, 0xFF, 0x00, 0xFF, 0x00,
  0xFF, 0xB5, 0xE7, 0x00, 0xFF, 0xF3, 0xFF, 0xE1, 0xDA, 0x00, 0xC2, 0xFC,
  0xFF, 0xFF, 0xF9, 0x00, 0xC5, 0xF9, 0x00, 0xCB, 0xF9, 0x00, 0xCB, 0xF9,
  0xFF, 0xE9, 0x56, 0xFF, 0xE7, 0x56, 0xFF, 0xE7, 0x56, 0xFF, 0xE7, 0x56,
  0xFF, 0xF4, 0x44, 0xFF, 0xE7, 0x56, 0xFF, 0xEC, 0x49, 0x4F, 0xFF, 0x00,
  0x00, 0xFF, 0xFF, 0x00, 0xCC, 0xFE, 0x00, 0xD5, 0xFD, 0x00, 0xD7, 0xFA,
  0x00, 0xD2, 0xFA, 0x00, 0xD7, 0xFA, 0x00, 0xD7, 0xFA, 0x00, 0xD7, 0xFA,
  0xFB, 0x17, 0x00, 0xF9, 0x17, 0x00, 0xF9, 0x17, 0x00, 0xF9, 0x00, 0x00,
  0xF9, 0x17, 0x00, 0xFC, 0x00, 0x00, 0xF9, 0x22, 0x00, 0xFF, 0x00, 0x00,
  0xDC, 0x00, 0xFF, 0x00, 0x5D, 0xFB, 0x00, 0x63, 0xF6, 0x00, 0x53, 0xFF,
  0x00, 0x63, 0xF6, 0x00, 0x63, 0xF6, 0x00, 0x63, 0xF6, 0x00, 0x63, 0xF6,
  0xFB, 0x2C, 0x00, 0xF9, 0x2C, 0x00, 0xF9, 0x13, 0x00, 0xF8, 0xFF, 0xFF,
  0xFC, 0x00, 0x00, 0xD6, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xAF, 0xFF, 0xFA,
  0xFF, 0x00, 0xBE, 0xC3, 0xF9, 0x9D, 0x17, 0x00, 0xE4, 0xCA, 0xCB, 0x6F,
  0x36, 0x00, 0xE3, 0x39, 0x00, 0xE5, 0x42, 0x0D, 0xDA, 0x42, 0x0D, 0xDA,
  0xFB, 0x2C, 0x00, 0xF9, 0x2C, 0x00, 0xF9, 0x2C, 0x00, 0xF9, 0x13, 0x00,
  0xF9, 0x37, 0x00, 0xFC, 0x00, 0x00, 0xF9, 0x00, 0x5E, 0xFF, 0x00, 0xA3,
  0xF9, 0x00, 0xC7, 0xFF, 0x00, 0xBE, 0xCE, 0x00, 0xFF, 0x0E, 0x0C, 0xDE,
  0x32, 0x09, 0xE8, 0xA0, 0xB5, 0x52, 0x32, 0x09, 0xE8, 0x3A, 0x17, 0xDD,
  0xFB, 0x2C, 0x00, 0xF9, 0x2C, 0x00, 0xF9, 0x2C, 0x00, 0xF9, 0x37, 0x00,
  0xF9, 0x00, 0x09, 0xF9, 0x00, 0x68, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0xA7,
  0xF9, 0x00, 0xC7, 0xF9, 0x00, 0xC3, 0xFF, 0x00, 0xB5, 0xCE, 0x00, 0xFF,
  0x1A, 0x1C, 0xD5, 0x32, 0x09, 0xE8, 0x3A, 0x17, 0xDD, 0x3A, 0x17, 0xDD,
  0xFB, 0x2C, 0x00, 0xF9, 0x2C, 0x00, 0xF9, 0x37, 0x00, 0xF9, 0x00, 0x09,
  0xF9, 0x00, 0x68, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0xA7,
  0xF9, 0x00, 0xC7, 0xF9, 0x00, 0xC3, 0xF9, 0x00, 0xC3, 0xFF, 0x00, 0xB5,
  0xCE, 0x00, 0xFF, 0x1A, 0x1C, 0xD5, 0x3A, 0x17, 0xDD, 0x3A, 0x17, 0xDD,
  0xFB, 0x2C, 0x00, 0xF9, 0x37, 0x00, 0xF9, 0x00, 0x09, 0xF9, 0x00, 0x68,
  0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0xA7,
  0xF9, 0x00, 0xC7, 0xF9, 0x00, 0xC3, 0xF9, 0x00, 0xC3, 0xF9, 0x00, 0xC3,
  0xFF, 0x00, 0xB5, 0xCE, 0x00, 0xFF, 0x1A, 0x1C, 0xD5, 0x3A, 0x17, 0xDD,
  0xFB, 0x38, 0x00, 0xF9, 0x00, 0x09, 0xF9, 0x00, 0x68, 0xF9, 0x00, 0x57,
  0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0xA7,
  0xF9, 0x00, 0xC7, 0xF9, 0x00, 0xC3, 0xF9, 0x00, 0xC3, 0xF9, 0x00, 0xC3,
  0xF9, 0x00, 0xC3, 0xFF, 0x00, 0xB5, 0xCE, 0x00, 0xFF, 0x1A, 0x1C, 0xD5,
  0xFE, 0x00, 0x0F, 0xFC, 0x00, 0x68, 0xFC, 0x00, 0x58, 0xFC, 0x00, 0x58,
  0xFC, 0x00, 0x58, 0xFC, 0x00, 0x58, 0xFC, 0x00, 0x4E, 0xFC, 0x00, 0xA9,
  0xFC, 0x00, 0xC9, 0xFC, 0x00, 0xC5, 0xFC, 0x00, 0xC5, 0xFC, 0x00, 0xC5,
  0xFC, 0x00, 0xC5, 0xFC, 0x00, 0xC5, 0xFF, 0x00, 0xB7, 0xC6, 0x00, 0xFF
};
const unsigned char ASCII_8X8_104[768] = {
  0x3E, 0xFC, 0x00, 0x00, 0xF9, 0x1A, 0x00, 0xF9, 0x15, 0x00, 0xF9, 0x15,
  0x00, 0xF9, 0x15, 0x00, 0xF9, 0x15, 0x00, 0xF9, 0x15, 0x00, 0xFF, 0x0A,
  0x00, 0xBC, 0x6D, 0x00, 0xFF, 0xD2, 0x00, 0xF9, 0xC7, 0x00, 0xF9, 0xC7,
  0x00, 0xF9, 0xC7, 0x00, 0xF9, 0xC7, 0x00, 0xFC, 0xBA, 0x00, 0xF4, 0xFF,
  0xCB, 0xFB, 0x00, 0x39, 0xFA, 0x00, 0x00, 0xF9, 0x1A, 0x00, 0xF9, 0x15,
  0x00, 0xF9, 0x15, 0x00, 0xF9, 0x15, 0x00, 0xF9, 0x15, 0x00, 0xFF, 0x0A,
  0x00, 0xBC, 0x6D, 0x00, 0xFF, 0xD2, 0x00, 0xF9, 0xC7, 0x00, 0xF9, 0xC7,
  0x00, 0xF9, 0xC7, 0x00, 0xFC, 0xBA, 0x00, 0xFA, 0xFF, 0x00, 0x9E, 0xF9,
  0xB0, 0xFB, 0x00, 0xC9, 0xF9, 0x00, 0x39, 0xFA, 0x00, 0x00, 0xF9, 0x1A,
  0x00, 0xF9, 0x15, 0x00, 0xF9, 0x15, 0x00, 0xF9, 0x15, 0x00, 0xFF, 0x0A,
  0x00, 0xBC, 0x6D, 0x00, 0xFF, 0xD2, 0x00, 0xF9, 0xC7, 0x00, 0xF9, 0xC7,
  0x00, 0xFC, 0xBA, 0x00, 0xFA, 0xFF, 0x00, 0x9E, 0xF9, 0x00, 0xAE, 0xF9,
  0xB0, 0xFB, 0x00, 0xAE, 0xF9, 0x00, 0xC9, 0xF9, 0x00, 0x39, 0xFA, 0x00,
  0x00, 0xF9, 0x1A, 0x00, 0xF9, 0x15, 0x00, 0xF9, 0x15, 0x00, 0xFF, 0x0A,
  0x00, 0xBC, 0x6D, 0x00, 0xFF, 0xD2, 0x00, 0xF9, 0xC7, 0x00, 0xFC, 0xBA,
  0x00, 0xFA, 0xFF, 0x00, 0x9E, 0xF9, 0x00, 0xAE, 0xF9, 0x00, 0xAE, 0xF9,
  0xB0, 0xFB, 0x00, 0xAE, 0xF9, 0x00, 0xAE, 0xF9, 0x00, 0xC9, 0xF9, 0x00,
  0x39, 0xFA, 0x00, 0x00, 0xF9, 0x1A, 0x00, 0xF9, 0x15, 0x00, 0xFF, 0x0A,
  0x00, 0xBC, 0x6D, 0x00, 0xFF, 0xD2, 0x00, 0xFC, 0xBA, 0x00, 0xFA, 0xFF,
  0x00, 0x9E, 0xF9, 0x00, 0xAE, 0xF9, 0x00, 0xAE, 0xF9, 0x00, 0xAE, 0xF9,
  0xB0, 0xFB, 0x00, 0xAE, 0xF9, 0x00, 0xB4, 0xFF, 0x00, 0xAE, 0xF9, 0x00,
  0xCC, 0xFF, 0x00, 0x39, 0xFA, 0x00, 0x00, 0xFF, 0x04, 0x00, 0xFF, 0x0A,
  0x00, 0xBC, 0x61, 0x00, 0xFF, 0xC5, 0x00, 0xF4, 0xFF, 0x00, 0x9E, 0xF9,
  0x00, 0xA5, 0xF9, 0x00, 0xAE, 0xF9, 0x00, 0xAE, 0xF9, 0x00, 0xAE, 0xF9,
  0xA7, 0xFD, 0x00, 0xAA, 0xFF, 0x00, 0x5C, 0x44, 0xB7, 0xAE, 0xFF, 0x00,
  0x7F, 0x65, 0xD7, 0xB5, 0xFF, 0x00, 0xD2, 0x8C, 0xF9, 0x00, 0xFF, 0x00,
  0xFF, 0xB8, 0xDC, 0x00, 0xFA, 0xFF, 0xFF, 0xEB, 0xD5, 0x00, 0x9E, 0xFC,
  0xFF, 0xFF, 0xF9, 0x00, 0xA5, 0xF9, 0x00, 0xAE, 0xF9, 0x00, 0xAE, 0xF9,
  0xFF, 0xFF, 0x58, 0xFF, 0xFD, 0x58, 0xFF, 0xFF, 0x48, 0xFF, 0xFD, 0x58,
  0xFF, 0xFF, 0x45, 0xFF, 0xFD, 0x58, 0xFF, 0xFF, 0x4B, 0x26, 0xFF, 0x00,
  0x00, 0xFF, 0xFF, 0x00, 0xAB, 0xFA, 0x00, 0xB4, 0xFD, 0x00, 0xBB, 0xFA,
  0x00, 0xB1, 0xFA, 0x00, 0xBB, 0xFA, 0x00, 0xBB, 0xFA, 0x00, 0xBB, 0xFA,
  0xFB, 0x37, 0x00, 0xF9, 0x37, 0x00, 0xF9, 0x37, 0x00, 0xF9, 0x21, 0x00,
  0xF9, 0x37, 0x00, 0xFC, 0x24, 0x00, 0xF9, 0x48, 0x00, 0xFF, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x39, 0xFB, 0x00, 0x43, 0xF6, 0x00, 0x33, 0xFF,
  0x00, 0x43, 0xF6, 0x00, 0x36, 0xFF, 0x00, 0x43, 0xF6, 0x00, 0x43, 0xF6,
  0xFB, 0x4B, 0x00, 0xF9, 0x4B, 0x00, 0xF9, 0x35, 0x00, 0xF9, 0xFF, 0xFF,
  0xFC, 0x22, 0x00, 0xD5, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xAF, 0xFF, 0xFF,
  0xFF, 0x00, 0x98, 0xBE, 0xFB, 0xA3, 0x37, 0x00, 0xE5, 0xC1, 0xCE, 0x6F,
  0x4E, 0x00, 0xEE, 0x9E, 0xAD, 0x4E, 0x57, 0x03, 0xE5, 0x5C, 0x10, 0xDA,
  0xFB, 0x4B, 0x00, 0xF9, 0x4B, 0x00, 0xF9, 0x4B, 0x00, 0xF9, 0x35, 0x00,
  0xF9, 0x5C, 0x00, 0xFC, 0x00, 0x00, 0xF9, 0x00, 0x3F, 0xFF, 0x00, 0x81,
  0xF9, 0x00, 0xAB, 0xFF, 0x00, 0x9C, 0xF2, 0x00, 0xFF, 0x28, 0x0C, 0xDE,
  0x52, 0x17, 0xDD, 0x4D, 0x09, 0xE8, 0x52, 0x17, 0xDD, 0x52, 0x17, 0xDD,
  0xFB, 0x4B, 0x00, 0xF9, 0x4B, 0x00, 0xF9, 0x4B, 0x00, 0xF9, 0x5C, 0x00,
  0xF9, 0x00, 0x00, 0xF9, 0x00, 0x49, 0xF9, 0x00, 0x31, 0xF9, 0x00, 0x89,
  0xF9, 0x00, 0xAB, 0xF9, 0x00, 0xA7, 0xFF, 0x00, 0x92, 0xF2, 0x00, 0xFF,
  0x30, 0x1C, 0xD5, 0x52, 0x17, 0xDD, 0x52, 0x17, 0xDD, 0x52, 0x17, 0xDD,
  0xFB, 0x4B, 0x00, 0xF9, 0x4B, 0x00, 0xF9, 0x5C, 0x00, 0xF9, 0x00, 0x00,
  0xF9, 0x00, 0x49, 0xF9, 0x00, 0x3A, 0xF9, 0x00, 0x31, 0xF9, 0x00, 0x89,
  0xF9, 0x00, 0xAB, 0xF9, 0x00, 0xA7, 0xF9, 0x00, 0xA7, 0xFF, 0x00, 0x92,
  0xF2, 0x00, 0xFF, 0x30, 0x1C, 0xD5, 0x52, 0x17, 0xDD, 0x52, 0x17, 0xDD,
  0xFB, 0x4B, 0x00, 0xF9, 0x5C, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x49,
  0xF9, 0x00, 0x3A, 0xF9, 0x00, 0x3A, 0xF9, 0x00, 0x31, 0xF9, 0x00, 0x89,
  0xF9, 0x00, 0xAB, 0xF9, 0x00, 0xA7, 0xF9, 0x00, 0xA7, 0xF9, 0x00, 0xA7,
  0xFF, 0x00, 0x92, 0xF2, 0x00, 0xFF, 0x30, 0x1C, 0xD5, 0x52, 0x17, 0xDD,
  0xFB, 0x5C, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x48, 0xF9, 0x00, 0x3A,
  0xF9, 0x00, 0x3A, 0xF9, 0x00, 0x3A, 0xF9, 0x00, 0x31, 0xF9, 0x00, 0x89,
  0xF9, 0x00, 0xAB, 0xF9, 0x00, 0xA7, 0xF9, 0x00, 0xA7, 0xF9, 0x00, 0xA7,
  0xF9, 0x00, 0xA7, 0xFF, 0x00, 0x92, 0xF2, 0x00, 0xFF, 0x30, 0x1C, 0xD5,
  0xFE, 0x00, 0x00, 0xFC, 0x00, 0x49, 0xFC, 0x00, 0x3B, 0xFC, 0x00, 0x3B,
  0xFC, 0x00, 0x3B, 0xFC, 0x00, 0x3B, 0xFC, 0x00, 0x31, 0xFC, 0x00, 0x8B,
  0xFC, 0x00, 0xAD, 0xFC, 0x00, 0xA9, 0xFC, 0x00, 0xA9, 0xFC, 0x00, 0xA9,
  0xFC, 0x00, 0xA9, 0xFC, 0x00, 0xA9, 0xFF, 0x00, 0x94, 0xE7, 0x00, 0xFF
};
const unsigned char ASCII_8X8_105[768] = {
  0x09, 0xFC, 0x00, 0x00, 0xF9, 0x52, 0x00, 0xF9, 0x41, 0x00, 0xF9, 0x41,
  0x00, 0xF9, 0x41, 0x00, 0xF9, 0x41, 0x00, 0xF9, 0x41, 0x00, 0xFF, 0x37,
  0x00, 0xBD, 0x90, 0x00, 0xFF, 0xFF, 0x00, 0xF9, 0xF5, 0x00, 0xF9, 0xF5,
  0x00, 0xF9, 0xF5, 0x00, 0xF9, 0xF5, 0x00, 0xFF, 0xF4, 0x00, 0xBF, 0xFA,
  0x9D, 0xFB, 0x00, 0x00, 0xFA, 0x00, 0x00, 0xF9, 0x52, 0x00, 0xF9, 0x41,
  0x00, 0xF9, 0x41, 0x00, 0xF9, 0x41, 0x00, 0xF9, 0x41, 0x00, 0xFF, 0x37,
  0x00, 0xBD, 0x90, 0x00, 0xFF, 0xFF, 0x00, 0xF9, 0xF5, 0x00, 0xF9, 0xF5,
  0x00, 0xF9, 0xF5, 0x00, 0xFF, 0xF4, 0x00, 0xC0, 0xFA, 0x00, 0x71, 0xF9,
  0x82, 0xFB, 0x00, 0x9B, 0xF9, 0x00, 0x00, 0xFA, 0x00, 0x00, 0xF9, 0x52,
  0x00, 0xF9, 0x41, 0x00, 0xF9, 0x41, 0x00, 0xF9, 0x41, 0x00, 0xFF, 0x37,
  0x00, 0xBD, 0x90, 0x00, 0xFF, 0xFF, 0x00, 0xF9, 0xF5, 0x00, 0xF9, 0xF5,
  0x00, 0xFF, 0xF4, 0x00, 0xC0, 0xFA, 0x00, 0x71, 0xF9, 0x00, 0x81, 0xF9,
  0x82, 0xFB, 0x00, 0x80, 0xF9, 0x00, 0x9B, 0xF9, 0x00, 0x00, 0xFA, 0x00,
  0x00, 0xF9, 0x52, 0x00, 0xF9, 0x41, 0x00, 0xF9, 0x41, 0x00, 0xFF, 0x37,
  0x00, 0xBD, 0x90, 0x00, 0xFF, 0xFF, 0x00, 0xF9, 0xF5, 0x00, 0xFF, 0xF4,
  0x00, 0xC0, 0xFA, 0x00, 0x71, 0xF9, 0x00, 0x81, 0xF9, 0x00, 0x81, 0xF9,
  0x82, 0xFB, 0x00, 0x80, 0xF9, 0x00, 0x80, 0xF9, 0x00, 0x9B, 0xF9, 0x00,
  0x00, 0xFA, 0x00, 0x00, 0xF9, 0x52, 0x00, 0xF9, 0x41, 0x00, 0xFF, 0x37,
  0x00, 0xBD, 0x90, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xF4, 0x00, 0xC0, 0xFA,
  0x00, 0x62, 0xF9, 0x00, 0x81, 0xF9, 0x00, 0x81, 0xF9, 0x00, 0x81, 0xF9,
  0x82, 0xFB, 0x00, 0x80, 0xF9, 0x00, 0x81, 0xFF, 0x00, 0x80, 0xF9, 0x00,
  0x99, 0xFF, 0x00, 0x00, 0xFA, 0x00, 0x00, 0xFF, 0x3B, 0x00, 0xFF, 0x37,
  0x00, 0xBD, 0x8A, 0x00, 0xFF, 0xFF, 0x00, 0xB4, 0xFD, 0x00, 0x62, 0xF9,
  0xFF, 0xFF, 0xF6, 0x00, 0x71, 0xF9, 0x00, 0x81, 0xF9, 0x00, 0x81, 0xF9,
  0x75, 0xFB, 0x00, 0x74, 0xFF, 0x00, 0x72, 0x42, 0xB6, 0x71, 0xFF, 0x00,
  0x93, 0x63, 0xD7, 0x79, 0xFF, 0x00, 0xDB, 0x8B, 0xEF, 0x00, 0xFF, 0x2B,
  0xFF, 0xC2, 0xD1, 0x00, 0xBA, 0xFF, 0xFF, 0xFF, 0xD6, 0x00, 0x74, 0xFC,
  0x00, 0x71, 0xF9, 0x00, 0x81, 0xF9, 0x00, 0x81, 0xF9, 0x00, 0x81, 0xF9,
  0xF4, 0xFF, 0x58, 0xF2, 0xFF, 0x58, 0xF2, 0xFF, 0x48, 0xF2, 0xFF, 0x58,
  0xEF, 0xFF, 0x45, 0xF2, 0xFF, 0x58, 0xFF, 0xFF, 0x4B, 0x00, 0xFF, 0x00,
  0x00, 0xD6, 0xFF, 0x00, 0x7E, 0xFA, 0x00, 0x81, 0xFD, 0x00, 0x8D, 0xFA,
  0x00, 0x8D, 0xFA, 0x00, 0x8D, 0xFA, 0x00, 0x8D, 0xFA, 0x00, 0x8D, 0xFA,
  0xFE, 0x68, 0x00, 0xFB, 0x67, 0x00, 0xFC, 0x67, 0x00, 0xFC, 0x67, 0x00,
  0xFC, 0x67, 0x00, 0xFF, 0x5A, 0x00, 0xFC, 0x78, 0x00, 0xFF, 0x0A, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x01, 0xFC, 0x00, 0x11, 0xF6, 0x00, 0x01, 0xFF,
  0x00, 0x11, 0xF6, 0x00, 0x04, 0xFF, 0x00, 0x11, 0xF6, 0x00, 0x11, 0xF6,
  0xFB, 0x79, 0x00, 0xF9, 0x78, 0x00, 0xF9, 0x78, 0x00, 0xF9, 0x67, 0x00,
  0xFC, 0x6A, 0x00, 0xD6, 0xFF, 0xFF, 0xFF, 0x0D, 0x00, 0xAD, 0xFF, 0xFF,
  0xFF, 0x00, 0x58, 0xBB, 0xFF, 0xB0, 0x69, 0x00, 0xE6, 0xB4, 0xD4, 0x6F,
  0x7F, 0x00, 0xEE, 0x93, 0xB3, 0x4E, 0x83, 0x09, 0xE5, 0x84, 0x16, 0xDA,
  0xFB, 0x79, 0x00, 0xF9, 0x78, 0x00, 0xF9, 0x67, 0x00, 0xF9, 0xFF, 0xFF,
  0xF9, 0x78, 0x00, 0xFC, 0x26, 0x00, 0xF9, 0x00, 0x05, 0xFF, 0x00, 0x50,
  0xF9, 0x00, 0x7B, 0xFF, 0x00, 0x62, 0xFF, 0x00, 0xFF, 0x51, 0x0C, 0xE2,
  0x76, 0x17, 0xDD, 0x74, 0x09, 0xE8, 0x76, 0x17, 0xDD, 0x76, 0x17, 0xDD,
  0xFB, 0x79, 0x00, 0xF9, 0x78, 0x00, 0xF9, 0x78, 0x00, 0xF9, 0x78, 0x00,
  0xFA, 0x33, 0x00, 0xF9, 0x00, 0x0F, 0xF9, 0x00, 0x02, 0xF9, 0x00, 0x5E,
  0xF9, 0x00, 0x7B, 0xF9, 0x00, 0x78, 0xFA, 0x00, 0x5A, 0xFF, 0x00, 0xFF,
  0x55, 0x1C, 0xD9, 0x76, 0x17, 0xDD, 0x76, 0x17, 0xDD, 0x76, 0x17, 0xDD,
  0xFB, 0x79, 0x00, 0xF9, 0x78, 0x00, 0xF9, 0x88, 0x00, 0xFA, 0x33, 0x00,
  0xF9, 0x00, 0x0F, 0xF9, 0x00, 0x0C, 0xF9, 0x00, 0x02, 0xF9, 0x00, 0x5E,
  0xF9, 0x00, 0x7B, 0xF9, 0x00, 0x78, 0xF9, 0x00, 0x78, 0xFA, 0x00, 0x5A,
  0xFF, 0x00, 0xFF, 0x55, 0x1C, 0xD9, 0x76, 0x17, 0xDD, 0x76, 0x17, 0xDD,
  0xFB, 0x79, 0x00, 0xF9, 0x88, 0x00, 0xFA, 0x33, 0x00, 0xF9, 0x00, 0x0F,
  0xF9, 0x00, 0x0C, 0xF9, 0x00, 0x0C, 0xF9, 0x00, 0x02, 0xF9, 0x00, 0x5E,
  0xF9, 0x00, 0x7B, 0xF9, 0x00, 0x78, 0xF9, 0x00, 0x78, 0xF9, 0x00, 0x78,
  0xFA, 0x00, 0x5A, 0xFF, 0x00, 0xFF, 0x55, 0x1C, 0xD9, 0x76, 0x17, 0xDD,
  0xFB, 0x89, 0x00, 0xF9, 0x33, 0x00, 0xF9, 0x00, 0x0F, 0xF9, 0x00, 0x0C,
  0xF9, 0x00, 0x0C, 0xF9, 0x00, 0x0C, 0xF9, 0x00, 0x02, 0xF9, 0x00, 0x5E,
  0xF9, 0x00, 0x7B, 0xF9, 0x00, 0x77, 0xF9, 0x00, 0x77, 0xF9, 0x00, 0x77,
  0xF9, 0x00, 0x77, 0xF9, 0x00, 0x5A, 0xFF, 0x00, 0xFF, 0x55, 0x1C, 0xD8,
  0xFE, 0x35, 0x00, 0xFC, 0x00, 0x0E, 0xFC, 0x00, 0x0B, 0xFC, 0x00, 0x0B,
  0xFC, 0x00, 0x0B, 0xFC, 0x00, 0x0B, 0xFC, 0x00, 0x02, 0xFC, 0x00, 0x5E,
  0xFC, 0x00, 0x7D, 0xFC, 0x00, 0x79, 0xFC, 0x00, 0x79, 0xFC, 0x00, 0x79,
  0xFC, 0x00, 0x79, 0xFC, 0x00, 0x79, 0xFC, 0x00, 0x5B, 0xFF, 0x00, 0xFF
};
const unsigned char ASCII_8X8_106[768] = {
  0x00, 0xFC, 0x0C, 0x00, 0xF9, 0x80, 0x00, 0xF9, 0x6B, 0x00, 0xF9, 0x6B,
  0x00, 0xF9, 0x6B, 0x00, 0xF9, 0x6B, 0x00, 0xF9, 0x6B, 0x00, 0xFF, 0x62,
  0x01, 0xBF, 0xB5, 0x00, 0xD4, 0xFF, 0x00, 0xD3, 0xF9, 0x00, 0xD3, 0xF9,
  0x00, 0xD3, 0xF9, 0x00, 0xD3, 0xF9, 0x00, 0xE2, 0xF9, 0x00, 0x96, 0xF9,
  0x6E, 0xFB, 0x00, 0x00, 0xFC, 0x04, 0x00, 0xF9, 0x80, 0x00, 0xF9, 0x6B,
  0x00, 0xF9, 0x6B, 0x00, 0xF9, 0x6B, 0x00, 0xF9, 0x6B, 0x00, 0xFF, 0x62,
  0x01, 0xBF, 0xB5, 0x00, 0xD4, 0xFF, 0x00, 0xD3, 0xF9, 0x00, 0xD3, 0xF9,
  0x00, 0xD3, 0xF9, 0x00, 0xE2, 0xF9, 0x00, 0x97, 0xF9, 0x00, 0x47, 0xF9,
  0x58, 0xFB, 0x00, 0x6D, 0xF9, 0x00, 0x00, 0xFC, 0x04, 0x00, 0xF9, 0x80,
  0x00, 0xF9, 0x6B, 0x00, 0xF9, 0x6B, 0x00, 0xF9, 0x6B, 0x00, 0xFF, 0x62,
  0x01, 0xBF, 0xB5, 0x00, 0xD4, 0xFF, 0x00, 0xD3, 0xF9, 0x00, 0xD3, 0xF9,
  0x00, 0xE2, 0xF9, 0x00, 0x97, 0xF9, 0x00, 0x47, 0xF9, 0x00, 0x57, 0xF9,
  0x58, 0xFB, 0x00, 0x57, 0xF9, 0x00, 0x6D, 0xF9, 0x00, 0x00, 0xFC, 0x04,
  0x00, 0xF9, 0x80, 0x00, 0xF9, 0x6B, 0x00, 0xF9, 0x6B, 0x00, 0xFF, 0x62,
  0x01, 0xBF, 0xB5, 0x00, 0xD4, 0xFF, 0x00, 0xD3, 0xF9, 0x00, 0xE2, 0xF9,
  0x00, 0x83, 0xF9, 0x00, 0x47, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9,
  0x58, 0xFB, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x6D, 0xF9, 0x00,
  0x00, 0xFC, 0x04, 0x00, 0xF9, 0x80, 0x00, 0xF9, 0x6B, 0x00, 0xFF, 0x62,
  0x01, 0xBF, 0xB5, 0x00, 0xD4, 0xFF, 0x00, 0xE2, 0xF9, 0x00, 0x83, 0xF9,
  0xFF, 0xFF, 0xF8, 0x00, 0x43, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9,
  0x58, 0xFB, 0x00, 0x57, 0xF9, 0x00, 0x52, 0xFF, 0x00, 0x57, 0xF9, 0x00,
  0x65, 0xFF, 0x00, 0x00, 0xFC, 0x04, 0x00, 0xFF, 0x6D, 0x00, 0xFF, 0x62,
  0x00, 0xBF, 0xB2, 0x00, 0xE3, 0xFF, 0x00, 0x85, 0xFC, 0x00, 0x47, 0xF9,
  0x00, 0x43, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9,
  0x4A, 0xFB, 0x00, 0x44, 0xFF, 0x00, 0x80, 0x41, 0xB4, 0x3C, 0xFF, 0x00,
  0xA7, 0x64, 0xD9, 0x40, 0xFF, 0x00, 0xE4, 0x8B, 0xE3, 0x00, 0xFF, 0x61,
  0xFF, 0xD0, 0xCB, 0x00, 0x87, 0xFF, 0xFF, 0xFF, 0xD7, 0x00, 0x46, 0xFC,
  0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9,
  0xD5, 0xFF, 0x56, 0xD4, 0xFF, 0x56, 0xCF, 0xFF, 0x47, 0xD4, 0xFF, 0x56,
  0xCC, 0xFF, 0x44, 0xD4, 0xFF, 0x56, 0xE2, 0xFF, 0x46, 0x00, 0xFF, 0x00,
  0x00, 0x9E, 0xFF, 0x00, 0x52, 0xFA, 0x00, 0x50, 0xFD, 0x00, 0x62, 0xFA,
  0x00, 0x62, 0xFA, 0x00, 0x62, 0xFA, 0x00, 0x62, 0xFA, 0x00, 0x62, 0xFA,
  0xFF, 0x98, 0x00, 0xFF, 0x97, 0x00, 0xFF, 0x97, 0x00, 0xFF, 0x97, 0x00,
  0xFF, 0x97, 0x00, 0xFF, 0x8F, 0x00, 0xFF, 0xA7, 0x00, 0xFF, 0x44, 0x00,
  0xFF, 0x00, 0xDC, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xF6, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0xF6, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xF6, 0x00, 0x00, 0xF6,
  0xFB, 0xA3, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0xA2, 0x00,
  0xFC, 0x9A, 0x00, 0xD7, 0xFF, 0xFF, 0xFF, 0x43, 0x00, 0xB1, 0xFF, 0xFF,
  0xFF, 0x00, 0x24, 0xB5, 0xFF, 0xB9, 0x99, 0x00, 0xEC, 0xA7, 0xD9, 0x70,
  0xAC, 0x00, 0xEE, 0x80, 0xB5, 0x4B, 0xAC, 0x0C, 0xE6, 0xA9, 0x19, 0xDA,
  0xFB, 0xA3, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0x97, 0x00,
  0xF9, 0xB3, 0x00, 0xFC, 0x59, 0x00, 0xF9, 0x0F, 0x00, 0xFF, 0x00, 0x1C,
  0xF9, 0x00, 0x52, 0xFF, 0x00, 0x33, 0xFF, 0x00, 0xD8, 0x7F, 0x0C, 0xEC,
  0x97, 0x17, 0xDD, 0x9B, 0x09, 0xE8, 0x97, 0x17, 0xDD, 0x97, 0x17, 0xDD,
  0xFB, 0xA3, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0x97, 0x00, 0xF8, 0xFF, 0xFF,
  0xF9, 0x56, 0x00, 0xF9, 0x0C, 0x00, 0xF9, 0x20, 0x00, 0xF9, 0x00, 0x2F,
  0xF9, 0x00, 0x52, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x31, 0xFF, 0x00, 0xD8,
  0x7F, 0x1C, 0xE3, 0x97, 0x17, 0xDD, 0x97, 0x17, 0xDD, 0x97, 0x17, 0xDD,
  0xFB, 0xA3, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0xB3, 0x00, 0xF9, 0x56, 0x00,
  0xF9, 0x0C, 0x00, 0xF9, 0x1C, 0x00, 0xF9, 0x20, 0x00, 0xF9, 0x00, 0x2F,
  0xF9, 0x00, 0x52, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x31,
  0xFF, 0x00, 0xD8, 0x7F, 0x1C, 0xE3, 0x97, 0x17, 0xDD, 0x97, 0x17, 0xDD,
  0xFB, 0xA3, 0x00, 0xF9, 0xB2, 0x00, 0xF9, 0x61, 0x00, 0xF9, 0x0C, 0x00,
  0xF9, 0x1C, 0x00, 0xF9, 0x1C, 0x00, 0xF9, 0x20, 0x00, 0xF9, 0x00, 0x2F,
  0xF9, 0x00, 0x52, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x4E,
  0xF9, 0x00, 0x31, 0xFF, 0x00, 0xD8, 0x7F, 0x1C, 0xE3, 0x97, 0x17, 0xDD,
  0xFB, 0xB4, 0x00, 0xF9, 0x61, 0x00, 0xF9, 0x0C, 0x00, 0xF9, 0x1C, 0x00,
  0xF9, 0x1C, 0x00, 0xF9, 0x1C, 0x00, 0xF9, 0x20, 0x00, 0xF9, 0x00, 0x2F,
  0xF9, 0x00, 0x52, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x4E,
  0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x31, 0xFF, 0x00, 0xD8, 0x7E, 0x1C, 0xE3,
  0xFE, 0x61, 0x00, 0xFC, 0x0C, 0x00, 0xFC, 0x1D, 0x00, 0xFC, 0x1D, 0x00,
  0xFC, 0x1D, 0x00, 0xFC, 0x1D, 0x00, 0xFC, 0x20, 0x00, 0xFC, 0x00, 0x2F,
  0xFC, 0x00, 0x53, 0xFC, 0x00, 0x4F, 0xFC, 0x00, 0x4F, 0xFC, 0x00, 0x4F,
  0xFC, 0x00, 0x4F, 0xFC, 0x00, 0x4F, 0xFC, 0x00, 0x31, 0xFF, 0x00, 0xCF
};
const unsigned char ASCII_8X8_107[768] = {
  0x00, 0xFC, 0x49, 0x00, 0xF9, 0xB7, 0x00, 0xF9, 0xA1, 0x00, 0xF9, 0xA1,
  0x00, 0xF9, 0xA1, 0x00, 0xF9, 0xA1, 0x00, 0xF9, 0xA1, 0x00, 0xFF, 0x9C,
  0x00, 0xA8, 0xC8, 0x00, 0x9C, 0xFF, 0x00, 0x9E, 0xF9, 0x00, 0x9E, 0xF9,
  0x00, 0x9E, 0xF9, 0x00, 0x9E, 0xF9, 0x00, 0xAE, 0xF9, 0x00, 0x5F, 0xFA,
  0x2A, 0xFB, 0x00, 0x00, 0xF9, 0x47, 0x00, 0xF9, 0xB7, 0x00, 0xF9, 0xA1,
  0x00, 0xF9, 0xA1, 0x00, 0xF9, 0xA1, 0x00, 0xF9, 0xA1, 0x00, 0xFF, 0x9C,
  0x00, 0xA8, 0xC8, 0x00, 0x9C, 0xFF, 0x00, 0x9E, 0xF9, 0x00, 0x9E, 0xF9,
  0x00, 0x9E, 0xF9, 0x00, 0xAE, 0xF9, 0x00, 0x5F, 0xFA, 0x00, 0x11, 0xF9,
  0x21, 0xFB, 0x00, 0x2A, 0xF9, 0x00, 0x00, 0xFA, 0x47, 0x00, 0xF9, 0xB7,
  0x00, 0xF9, 0xA1, 0x00, 0xF9, 0xA1, 0x00, 0xF9, 0xA1, 0x00, 0xFF, 0x9C,
  0x00, 0xA8, 0xC8, 0x00, 0x9C, 0xFF, 0x00, 0x9E, 0xF9, 0x00, 0x9E, 0xF9,
  0x00, 0x9B, 0xF9, 0x00, 0x5F, 0xFA, 0x00, 0x11, 0xF9, 0x00, 0x21, 0xF9,
  0x21, 0xFB, 0x00, 0x21, 0xF9, 0x00, 0x2A, 0xF9, 0x00, 0x00, 0xFA, 0x47,
  0x00, 0xF9, 0xB7, 0x00, 0xF9, 0xA1, 0x00, 0xF9, 0xA1, 0x00, 0xFF, 0x9C,
  0x00, 0xA8, 0xC8, 0x00, 0x9C, 0xFF, 0x00, 0x9E, 0xF9, 0x00, 0x9B, 0xF9,
  0xFF, 0xFF, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x21, 0xF9, 0x00, 0x21, 0xF9,
  0x21, 0xFB, 0x00, 0x21, 0xF9, 0x00, 0x21, 0xF9, 0x00, 0x2A, 0xF9, 0x00,
  0x00, 0xFA, 0x47, 0x00, 0xF9, 0xB7, 0x00, 0xF9, 0xA1, 0x00, 0xFF, 0x9C,
  0x00, 0xA8, 0xC8, 0x00, 0x9C, 0xFF, 0x00, 0x9E, 0xFC, 0x00, 0x5F, 0xFA,
  0x00, 0x00, 0xF9, 0x00, 0x21, 0xF9, 0x00, 0x21, 0xF9, 0x00, 0x21, 0xF9,
  0x21, 0xFB, 0x00, 0x21, 0xF9, 0x00, 0x16, 0xFF, 0x00, 0x21, 0xF9, 0x00,
  0x1B, 0xFF, 0x00, 0x00, 0xFA, 0x47, 0x00, 0xFF, 0xAA, 0x00, 0xFF, 0x9C,
  0x00, 0xA5, 0xC8, 0x00, 0x9C, 0xFF, 0xFF, 0xFF, 0xD7, 0x00, 0x00, 0xFC,
  0x00, 0x21, 0xF9, 0x00, 0x21, 0xF9, 0x00, 0x21, 0xF9, 0x00, 0x21, 0xF9,
  0x11, 0xFB, 0x00, 0x05, 0xFF, 0x00, 0x9E, 0x42, 0xB4, 0x00, 0xFF, 0x00,
  0xC0, 0x65, 0xD9, 0x00, 0xFF, 0x00, 0xF0, 0x8B, 0xD7, 0x00, 0xFF, 0xA5,
  0xFF, 0xDF, 0xC0, 0x00, 0x59, 0xFF, 0x00, 0x00, 0xFC, 0x00, 0x21, 0xF9,
  0x00, 0x21, 0xF9, 0x00, 0x21, 0xF9, 0x00, 0x21, 0xF9, 0x00, 0x21, 0xF9,
  0xAA, 0xFF, 0x57, 0xA9, 0xFF, 0x57, 0x9D, 0xFF, 0x47, 0xA9, 0xFF, 0x57,
  0x9B, 0xFF, 0x44, 0xA9, 0xFF, 0x57, 0xAC, 0xFF, 0x40, 0x00, 0xFF, 0x33,
  0x00, 0x52, 0xFF, 0x00, 0x15, 0xFA, 0x00, 0x25, 0xFA, 0x00, 0x25, 0xFA,
  0x00, 0x25, 0xFA, 0x00, 0x25, 0xFA, 0x00, 0x25, 0xFA, 0x00, 0x25, 0xFA,
  0xFF, 0xD7, 0x00, 0xFF, 0xD4, 0x00, 0xFF, 0xD4, 0x00, 0xFF, 0xD4, 0x00,
  0xFF, 0xD4, 0x00, 0xFF, 0xD4, 0x00, 0xFF, 0xE5, 0x00, 0xFF, 0x8E, 0x00,
  0xFF, 0x00, 0x91, 0x22, 0x00, 0xFF, 0x37, 0x00, 0xF6, 0x3D, 0x00, 0xFF,
  0x37, 0x00, 0xF6, 0x40, 0x00, 0xFF, 0x37, 0x00, 0xF6, 0x37, 0x00, 0xF6,
  0xFB, 0xDB, 0x00, 0xF9, 0xD8, 0x00, 0xF9, 0xD8, 0x00, 0xF9, 0xD8, 0x00,
  0xF9, 0xD8, 0x00, 0xFC, 0xDF, 0x00, 0xFF, 0x88, 0x00, 0xAF, 0xFF, 0xFF,
  0xFF, 0x00, 0x00, 0xAA, 0xFF, 0xC8, 0xD3, 0x00, 0xF2, 0x91, 0xD9, 0x70,
  0xE0, 0x00, 0xEE, 0x6E, 0xB7, 0x4C, 0xDA, 0x0C, 0xE6, 0xD2, 0x19, 0xDA,
  0xFB, 0xDB, 0x00, 0xF9, 0xD8, 0x00, 0xF9, 0xD8, 0x00, 0xF9, 0xD8, 0x00,
  0xFC, 0xDF, 0x00, 0xD7, 0xFF, 0xFF, 0xFC, 0x42, 0x00, 0xFF, 0x00, 0x00,
  0xF9, 0x00, 0x1C, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x95, 0xB9, 0x0C, 0xFA,
  0xC2, 0x17, 0xDD, 0xCA, 0x09, 0xE8, 0xC2, 0x17, 0xDD, 0xC2, 0x17, 0xDD,
  0xFB, 0xDB, 0x00, 0xF9, 0xD8, 0x00, 0xF9, 0xD8, 0x00, 0xF9, 0xDD, 0x00,
  0xF9, 0x97, 0x00, 0xFC, 0x39, 0x00, 0xF9, 0x5C, 0x00, 0xF9, 0x00, 0x00,
  0xF9, 0x00, 0x1C, 0xF9, 0x00, 0x19, 0xF9, 0x00, 0x00, 0xFF, 0x00, 0x95,
  0xB4, 0x1C, 0xF1, 0xC2, 0x17, 0xDD, 0xC2, 0x17, 0xDD, 0xC2, 0x17, 0xDD,
  0xFB, 0xDB, 0x00, 0xF9, 0xD8, 0x00, 0xF9, 0xDD, 0x00, 0xF9, 0xFF, 0xFF,
  0xF9, 0x36, 0x00, 0xF9, 0x53, 0x00, 0xF9, 0x5C, 0x00, 0xF9, 0x00, 0x00,
  0xF9, 0x00, 0x1C, 0xF9, 0x00, 0x19, 0xF9, 0x00, 0x19, 0xF9, 0x00, 0x00,
  0xFF, 0x00, 0x95, 0xB4, 0x1C, 0xF1, 0xC2, 0x17, 0xDD, 0xC2, 0x17, 0xDD,
  0xFB, 0xDB, 0x00, 0xF9, 0xE9, 0x00, 0xF9, 0x97, 0x00, 0xF9, 0x36, 0x00,
  0xF9, 0x53, 0x00, 0xF9, 0x53, 0x00, 0xF9, 0x5C, 0x00, 0xF9, 0x00, 0x00,
  0xF9, 0x00, 0x1C, 0xF9, 0x00, 0x19, 0xF9, 0x00, 0x19, 0xF9, 0x00, 0x19,
  0xF9, 0x00, 0x00, 0xFF, 0x00, 0x95, 0xB4, 0x1C, 0xF1, 0xC2, 0x17, 0xDD,
  0xFB, 0xEB, 0x00, 0xF9, 0x96, 0x00, 0xF9, 0x42, 0x00, 0xF9, 0x53, 0x00,
  0xF9, 0x53, 0x00, 0xF9, 0x53, 0x00, 0xF9, 0x5C, 0x00, 0xF9, 0x00, 0x00,
  0xF9, 0x00, 0x1C, 0xF9, 0x00, 0x19, 0xF9, 0x00, 0x19, 0xF9, 0x00, 0x19,
  0xF9, 0x00, 0x19, 0xF9, 0x00, 0x00, 0xFF, 0x00, 0x95, 0xB4, 0x1C, 0xF1,
  0xFE, 0x99, 0x00, 0xFC, 0x43, 0x00, 0xFC, 0x54, 0x00, 0xFC, 0x54, 0x00,
  0xFC, 0x54, 0x00, 0xFC, 0x54, 0x00, 0xFC, 0x5D, 0x00, 0xFC, 0x00, 0x00,
  0xFC, 0x00, 0x1C, 0xFC, 0x00, 0x18, 0xFC, 0x00, 0x18, 0xFC, 0x00, 0x18,
  0xFC, 0x00, 0x18, 0xFC, 0x00, 0x18, 0xFC, 0x00, 0x00, 0xFF, 0x00, 0x92
};
const unsigned char ASCII_8X8_108[768] = {
  0x00, 0xFC, 0x6F, 0x00, 0xF9, 0xD9, 0x00, 0xF9, 0xC3, 0x00, 0xF9, 0xC3,
  0x00, 0xF9, 0xC3, 0x00, 0xF9, 0xC3, 0x00, 0xF9, 0xC3, 0x00, 0xFF, 0xC2,
  0x01, 0x8D, 0xC1, 0x00, 0x79, 0xFF, 0x00, 0x7D, 0xF9, 0x00, 0x7D, 0xF9,
  0x00, 0x7D, 0xF9, 0x00, 0x7D, 0xF9, 0x00, 0x8C, 0xF9, 0x00, 0x3D, 0xF9,
  0x00, 0xFB, 0x00, 0x00, 0xF9, 0x70, 0x00, 0xF9, 0xD9, 0x00, 0xF9, 0xC3,
  0x00, 0xF9, 0xC3, 0x00, 0xF9, 0xC3, 0x00, 0xF9, 0xC3, 0x00, 0xFF, 0xC2,
  0x01, 0x8D, 0xC1, 0x00, 0x79, 0xFF, 0x00, 0x7D, 0xF9, 0x00, 0x7D, 0xF9,
  0x00, 0x6D, 0xF9, 0x00, 0x8C, 0xF9, 0x00, 0x3C, 0xF9, 0x00, 0x00, 0xF9,
  0x00, 0xFB, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xFA, 0x70, 0x00, 0xF9, 0xD9,
  0x00, 0xF9, 0xC3, 0x00, 0xF9, 0xC3, 0x00, 0xF9, 0xC3, 0x00, 0xFF, 0xC2,
  0x01, 0x8D, 0xC1, 0x00, 0x79, 0xFF, 0x00, 0x7D, 0xF9, 0x00, 0x6D, 0xF9,
  0xFF, 0xFF, 0xF9, 0x00, 0x2D, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9,
  0x00, 0xFB, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xFA, 0x70,
  0x00, 0xF9, 0xD9, 0x00, 0xF9, 0xC3, 0x00, 0xF9, 0xC3, 0x00, 0xFF, 0xC2,
  0x01, 0x8D, 0xC1, 0x00, 0x79, 0xFF, 0x00, 0x70, 0xFC, 0x00, 0x8C, 0xF9,
  0x00, 0x2D, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9,
  0x00, 0xFB, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00,
  0x00, 0xFA, 0x70, 0x00, 0xF9, 0xD9, 0x00, 0xF9, 0xC3, 0x00, 0xFF, 0xC2,
  0x01, 0x8D, 0xC1, 0x00, 0x6D, 0xFF, 0xFF, 0xFF, 0xD5, 0x00, 0x30, 0xFC,
  0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9,
  0x00, 0xFB, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xF9, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFA, 0x70, 0x00, 0xFF, 0xD0, 0x00, 0xFF, 0xC2,
  0x00, 0x87, 0xC1, 0x00, 0x89, 0xFF, 0x00, 0x30, 0xFC, 0x00, 0x00, 0xF9,
  0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9,
  0x00, 0xFB, 0x00, 0x00, 0xFF, 0x00, 0xAD, 0x42, 0xB6, 0x00, 0xFF, 0x00,
  0xD0, 0x65, 0xD9, 0x00, 0xFF, 0x00, 0xF5, 0x8A, 0xCD, 0x00, 0xFF, 0xD0,
  0xFF, 0xEB, 0xBC, 0x00, 0x33, 0xFF, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9,
  0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9,
  0x8F, 0xFC, 0x56, 0x8E, 0xF9, 0x56, 0x7E, 0xFF, 0x46, 0x8E, 0xFA, 0x56,
  0x7B, 0xFF, 0x44, 0x8E, 0xFA, 0x56, 0x89, 0xFF, 0x3C, 0x00, 0xFF, 0x61,
  0x00, 0x23, 0xFF, 0x00, 0x00, 0xFA, 0x00, 0x00, 0xFA, 0x00, 0x00, 0xFA,
  0x00, 0x00, 0xFA, 0x00, 0x00, 0xFA, 0x00, 0x00, 0xFA, 0x00, 0x00, 0xFA,
  0xFF, 0xFB, 0x00, 0xFF, 0xF9, 0x00, 0xFF, 0xF9, 0x00, 0xFF, 0xF9, 0x00,
  0xFF, 0xF9, 0x00, 0xFF, 0xF9, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xBB, 0x00,
  0xFF, 0x00, 0x64, 0x50, 0x00, 0xFF, 0x5D, 0x00, 0xF6, 0x66, 0x00, 0xFF,
  0x5D, 0x00, 0xF6, 0x69, 0x00, 0xFF, 0x5D, 0x00, 0xF6, 0x5D, 0x00, 0xF6,
  0xFB, 0xFB, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00,
  0xF9, 0xF9, 0x00, 0xF9, 0xFF, 0x00, 0xFF, 0xAC, 0x00, 0xAF, 0xF8, 0xFF,
  0xFF, 0x00, 0x00, 0xA1, 0xFF, 0xCD, 0xF7, 0x00, 0xF6, 0x83, 0xD9, 0x70,
  0xFF, 0x00, 0xEE, 0x60, 0xB6, 0x4E, 0xF8, 0x0C, 0xE5, 0xEC, 0x19, 0xDA,
  0xFB, 0xFB, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00,
  0xF9, 0xFF, 0x00, 0xFD, 0xA9, 0x00, 0xF9, 0x6D, 0x00, 0xFF, 0x10, 0x00,
  0xF9, 0x03, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x6B, 0xDE, 0x0C, 0xFF,
  0xDD, 0x17, 0xDD, 0xE8, 0x09, 0xE8, 0xDD, 0x17, 0xDD, 0xDD, 0x17, 0xDD,
  0xFB, 0xFB, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xFF, 0x00,
  0xFD, 0xA9, 0x00, 0xD5, 0xFF, 0xFF, 0xFC, 0x70, 0x00, 0xF9, 0x24, 0x00,
  0xF9, 0x03, 0x00, 0xF9, 0x08, 0x00, 0xF9, 0x0A, 0x00, 0xFF, 0x00, 0x6B,
  0xD5, 0x1C, 0xF9, 0xDD, 0x17, 0xDD, 0xDD, 0x17, 0xDD, 0xDD, 0x17, 0xDD,
  0xFB, 0xFB, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xFF, 0x00, 0xFA, 0xA6, 0x00,
  0xF9, 0x64, 0x00, 0xFC, 0x67, 0x00, 0xF9, 0x7E, 0x00, 0xF9, 0x24, 0x00,
  0xF9, 0x03, 0x00, 0xF9, 0x08, 0x00, 0xF9, 0x08, 0x00, 0xF9, 0x0A, 0x00,
  0xFF, 0x00, 0x6B, 0xD5, 0x1C, 0xF9, 0xDD, 0x17, 0xDD, 0xDD, 0x17, 0xDD,
  0xFB, 0xFB, 0x00, 0xF9, 0xFF, 0x00, 0xFA, 0xA6, 0x00, 0xF9, 0xFF, 0xFF,
  0xF9, 0x64, 0x00, 0xF9, 0x75, 0x00, 0xF9, 0x7E, 0x00, 0xF9, 0x24, 0x00,
  0xF9, 0x03, 0x00, 0xF9, 0x08, 0x00, 0xF9, 0x08, 0x00, 0xF9, 0x08, 0x00,
  0xF9, 0x0A, 0x00, 0xFF, 0x00, 0x6B, 0xD5, 0x1C, 0xF9, 0xDD, 0x17, 0xDD,
  0xFB, 0xFF, 0x00, 0xF9, 0xB6, 0x00, 0xF9, 0x64, 0x00, 0xF9, 0x64, 0x00,
  0xF9, 0x74, 0x00, 0xF9, 0x74, 0x00, 0xF9, 0x7E, 0x00, 0xF9, 0x24, 0x00,
  0xF9, 0x03, 0x00, 0xF9, 0x08, 0x00, 0xF9, 0x08, 0x00, 0xF9, 0x08, 0x00,
  0xF9, 0x08, 0x00, 0xF9, 0x0A, 0x00, 0xFF, 0x00, 0x6B, 0xD5, 0x1C, 0xF9,
  0xFE, 0xBB, 0x00, 0xFB, 0x65, 0x00, 0xFC, 0x76, 0x00, 0xFC, 0x76, 0x00,
  0xFC, 0x76, 0x00, 0xFC, 0x76, 0x00, 0xFC, 0x7F, 0x00, 0xFC, 0x24, 0x00,
  0xFC, 0x03, 0x00, 0xFC, 0x07, 0x00, 0xFC, 0x07, 0x00, 0xFC, 0x07, 0x00,
  0xFC, 0x07, 0x00, 0xFC, 0x07, 0x00, 0xFB, 0x09, 0x00, 0xFF, 0x00, 0x6C
};
const unsigned char ASCII_8X8_109[768] = {
  0x00, 0xFD, 0x99, 0x00, 0xF9, 0xFF, 0x00, 0xF9, 0xED, 0x00, 0xF9, 0xED,
  0x00, 0xF9, 0xED, 0x00, 0xF9, 0xED, 0x00, 0xF9, 0xED, 0x00, 0xFF, 0xF2,
  0x00, 0x67, 0xBD, 0x00, 0x4E, 0xFF, 0x00, 0x52, 0xF9, 0x00, 0x52, 0xF9,
  0x00, 0x3D, 0xF9, 0x00, 0x52, 0xF9, 0x00, 0x61, 0xF9, 0x00, 0x0F, 0xF9,
  0x00, 0xFB, 0x0E, 0x00, 0xFC, 0x9A, 0x00, 0xF9, 0xFF, 0x00, 0xF9, 0xED,
  0x00, 0xF9, 0xED, 0x00, 0xF9, 0xED, 0x00, 0xF9, 0xED, 0x00, 0xFF, 0xF2,
  0x00, 0x67, 0xBD, 0x00, 0x4E, 0xFF, 0x00, 0x52, 0xF9, 0x00, 0x3D, 0xF9,
  0xFF, 0xFF, 0xF9, 0x00, 0x4D, 0xF9, 0x00, 0x0A, 0xF9, 0x34, 0x00, 0xF9,
  0x00, 0xFB, 0x29, 0x00, 0xF9, 0x0E, 0x00, 0xFC, 0x9A, 0x00, 0xF9, 0xFF,
  0x00, 0xF9, 0xED, 0x00, 0xF9, 0xED, 0x00, 0xF9, 0xED, 0x00, 0xFF, 0xF2,
  0x00, 0x67, 0xBD, 0x00, 0x4E, 0xFF, 0x00, 0x40, 0xFC, 0x00, 0x52, 0xF9,
  0x00, 0x4D, 0xF9, 0x00, 0x0A, 0xF9, 0x34, 0x00, 0xF9, 0x29, 0x00, 0xF9,
  0x00, 0xFB, 0x29, 0x00, 0xF9, 0x29, 0x00, 0xF9, 0x0E, 0x00, 0xFC, 0x9A,
  0x00, 0xF9, 0xFF, 0x00, 0xF9, 0xED, 0x00, 0xF9, 0xED, 0x00, 0xFF, 0xF2,
  0x00, 0x67, 0xBD, 0x00, 0x3C, 0xFF, 0xFF, 0xFF, 0xD6, 0x00, 0x50, 0xFC,
  0x00, 0x0A, 0xF9, 0x34, 0x00, 0xF9, 0x29, 0x00, 0xF9, 0x29, 0x00, 0xF9,
  0x00, 0xFB, 0x29, 0x00, 0xF9, 0x29, 0x00, 0xF9, 0x29, 0x00, 0xF9, 0x0E,
  0x00, 0xFC, 0x9A, 0x00, 0xF9, 0xFF, 0x00, 0xF9, 0xED, 0x00, 0xFF, 0xF2,
  0x00, 0x5C, 0xBD, 0x00, 0x4E, 0xFF, 0x00, 0x50, 0xFC, 0x00, 0x0A, 0xF9,
  0x34, 0x00, 0xF9, 0x29, 0x00, 0xF9, 0x29, 0x00, 0xF9, 0x29, 0x00, 0xF9,
  0x00, 0xFB, 0x29, 0x00, 0xF9, 0x29, 0x00, 0xFF, 0x1F, 0x00, 0xF9, 0x29,
  0x00, 0xFF, 0x01, 0x00, 0xFC, 0x9A, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xF2,
  0xFF, 0xE5, 0xBD, 0x00, 0x53, 0xFF, 0x00, 0x0A, 0xF9, 0x34, 0x00, 0xF9,
  0x29, 0x00, 0xF9, 0x29, 0x00, 0xF9, 0x29, 0x00, 0xF9, 0x29, 0x00, 0xF9,
  0x00, 0xFB, 0x26, 0x00, 0xFF, 0x1B, 0xB0, 0x41, 0xA5, 0x00, 0xFF, 0x0E,
  0xD4, 0x65, 0xC9, 0x00, 0xFF, 0x00, 0xFB, 0x8B, 0xBF, 0x00, 0xFF, 0xFF,
  0x00, 0x70, 0xB7, 0x00, 0x06, 0xFF, 0x34, 0x00, 0xF9, 0x29, 0x00, 0xF9,
  0x29, 0x00, 0xF9, 0x29, 0x00, 0xF9, 0x29, 0x00, 0xF9, 0x29, 0x00, 0xF9,
  0x6F, 0xFC, 0x51, 0x6E, 0xF9, 0x51, 0x5E, 0xFF, 0x47, 0x6E, 0xF9, 0x51,
  0x5B, 0xFF, 0x44, 0x6E, 0xF9, 0x51, 0x65, 0xFF, 0x36, 0x00, 0xFF, 0x9B,
  0x00, 0x00, 0xFF, 0x28, 0x00, 0xFA, 0x1D, 0x00, 0xFA, 0x1D, 0x00, 0xFA,
  0x1D, 0x00, 0xFA, 0x1D, 0x00, 0xFA, 0x1D, 0x00, 0xFA, 0x1D, 0x00, 0xFA,
  0xDE, 0xFB, 0x00, 0xDC, 0xF9, 0x00, 0xDC, 0xF9, 0x00, 0xDC, 0xF9, 0x00,
  0xDC, 0xF9, 0x00, 0xDC, 0xF9, 0x00, 0xD2, 0xFF, 0x00, 0xFF, 0xFF, 0x00,
  0xFF, 0x00, 0x26, 0x84, 0x00, 0xFF, 0x8C, 0x00, 0xFA, 0x95, 0x00, 0xFF,
  0x8C, 0x00, 0xFA, 0x98, 0x00, 0xFF, 0x8C, 0x00, 0xFA, 0x8C, 0x00, 0xFA,
  0xD2, 0xFB, 0x00, 0xCF, 0xF9, 0x00, 0xD0, 0xF9, 0x00, 0xD0, 0xF9, 0x00,
  0xD0, 0xF9, 0x00, 0xC5, 0xFF, 0x00, 0xFF, 0xF4, 0x00, 0xFF, 0x25, 0x00,
  0xFF, 0x23, 0x00, 0x9D, 0xF9, 0xD2, 0xF2, 0x00, 0xC9, 0x7D, 0xD9, 0x7D,
  0xFB, 0x00, 0xC0, 0x59, 0xB5, 0x59, 0xF3, 0x0C, 0xBB, 0xE7, 0x19, 0xB4,
  0xD2, 0xFB, 0x00, 0xCF, 0xF9, 0x00, 0xD0, 0xF9, 0x00, 0xD0, 0xF9, 0x00,
  0xC5, 0xFF, 0x00, 0xFF, 0xEB, 0x00, 0xFF, 0x88, 0x00, 0xAF, 0xFD, 0xFF,
  0xFF, 0x1E, 0x00, 0xFF, 0x28, 0x00, 0xFF, 0x00, 0x35, 0xDE, 0x0C, 0xDE,
  0xDD, 0x17, 0xBB, 0xE8, 0x0A, 0xC3, 0xDD, 0x17, 0xBB, 0xDD, 0x17, 0xBB,
  0xD2, 0xFB, 0x00, 0xCF, 0xF9, 0x00, 0xD0, 0xF9, 0x00, 0xC5, 0xFF, 0x00,
  0xFF, 0xEB, 0x00, 0xFC, 0x85, 0x00, 0xF9, 0xA8, 0x00, 0xFF, 0x3F, 0x00,
  0xF9, 0x2D, 0x00, 0xF9, 0x31, 0x00, 0xF9, 0x3E, 0x00, 0xFF, 0x00, 0x35,
  0xD5, 0x1C, 0xD9, 0xDD, 0x17, 0xBB, 0xDD, 0x17, 0xBB, 0xDD, 0x17, 0xBB,
  0xD2, 0xFB, 0x00, 0xCF, 0xF9, 0x00, 0xC5, 0xFF, 0x00, 0xFF, 0xEB, 0x00,
  0xFC, 0x85, 0x00, 0xD5, 0xFF, 0xFF, 0xFC, 0x9F, 0x00, 0xF9, 0x4D, 0x00,
  0xF9, 0x2D, 0x00, 0xF9, 0x31, 0x00, 0xF9, 0x31, 0x00, 0xF9, 0x3E, 0x00,
  0xFF, 0x00, 0x35, 0xD5, 0x1C, 0xD9, 0xDD, 0x17, 0xBB, 0xDD, 0x17, 0xBB,
  0xD2, 0xFB, 0x00, 0xC5, 0xFF, 0x00, 0xFF, 0xEB, 0x00, 0xF9, 0x82, 0x00,
  0xF9, 0x9E, 0x00, 0xFC, 0x96, 0x00, 0xF9, 0xA8, 0x00, 0xF9, 0x4D, 0x00,
  0xF9, 0x2D, 0x00, 0xF9, 0x31, 0x00, 0xF9, 0x31, 0x00, 0xF9, 0x31, 0x00,
  0xF9, 0x3E, 0x00, 0xFF, 0x00, 0x35, 0xD5, 0x1C, 0xD9, 0xDD, 0x17, 0xBB,
  0xC7, 0xFF, 0x00, 0xFF, 0xEA, 0x00, 0xF9, 0x82, 0x00, 0xF9, 0xFF, 0xFF,
  0xF9, 0x93, 0x00, 0xF9, 0x9E, 0x00, 0xF9, 0xA7, 0x00, 0xF9, 0x4D, 0x00,
  0xF9, 0x2D, 0x00, 0xF9, 0x31, 0x00, 0xF9, 0x31, 0x00, 0xF9, 0x31, 0x00,
  0xF9, 0x31, 0x00, 0xF9, 0x3E, 0x00, 0xFF, 0x00, 0x35, 0xD5, 0x1C, 0xD9,
  0xFF, 0xEA, 0x00, 0xFC, 0x8F, 0x00, 0xFC, 0xA0, 0x00, 0xFC, 0x94, 0x00,
  0xFC, 0xA0, 0x00, 0xFC, 0xA0, 0x00, 0xFC, 0xA9, 0x00, 0xFC, 0x4E, 0x00,
  0xFC, 0x2D, 0x00, 0xFC, 0x32, 0x00, 0xFC, 0x32, 0x00, 0xFC, 0x32, 0x00,
  0xFC, 0x32, 0x00, 0xFC, 0x32, 0x00, 0xFC, 0x3E, 0x00, 0xFF, 0x00, 0x3C
};
const unsigned char ASCII_8X8_110[768] = {
  0x00, 0xFF, 0xCB, 0x00, 0xD0, 0xFF, 0x00, 0xD9, 0xF9, 0x00, 0xD9, 0xF9,
  0x00, 0xD9, 0xF9, 0x00, 0xD9, 0xF9, 0x00, 0xD9, 0xF9, 0x00, 0xEA, 0xFF,
  0x00, 0x43, 0xBD, 0x00, 0x20, 0xFF, 0x00, 0x25, 0xF9, 0x00, 0x25, 0xF9,
  0x00, 0x0B, 0xF9, 0x00, 0x25, 0xF9, 0x00, 0x2F, 0xF9, 0x14, 0x00, 0xF9,
  0x00, 0xFB, 0x3C, 0x00, 0xFF, 0xCF, 0x00, 0xD0, 0xFF, 0x00, 0xD9, 0xF9,
  0x00, 0xD9, 0xF9, 0x00, 0xD9, 0xF9, 0x00, 0xD9, 0xF9, 0x00, 0xEA, 0xFF,
  0x00, 0x43, 0xBD, 0x00, 0x20, 0xFF, 0x00, 0x0E, 0xFC, 0x00, 0x0B, 0xF9,
  0xFF, 0xFF, 0xF9, 0x00, 0x14, 0xF9, 0x0F, 0x00, 0xF9, 0x66, 0x00, 0xF9,
  0x00, 0xFB, 0x57, 0x00, 0xF9, 0x3B, 0x00, 0xFF, 0xCF, 0x00, 0xD0, 0xFF,
  0x00, 0xD9, 0xF9, 0x00, 0xD9, 0xF9, 0x00, 0xD9, 0xF9, 0x00, 0xEA, 0xFF,
  0x00, 0x43, 0xBD, 0x00, 0x09, 0xFF, 0xFF, 0xFF, 0xD6, 0x00, 0x0E, 0xFC,
  0x00, 0x14, 0xF9, 0x0F, 0x00, 0xF9, 0x66, 0x00, 0xF9, 0x57, 0x00, 0xF9,
  0x00, 0xFB, 0x57, 0x00, 0xF9, 0x56, 0x00, 0xF9, 0x3B, 0x00, 0xFF, 0xCF,
  0x00, 0xD0, 0xFF, 0x00, 0xD9, 0xF9, 0x00, 0xD9, 0xF9, 0x00, 0xEA, 0xFF,
  0x00, 0x34, 0xBD, 0x00, 0x20, 0xFF, 0x00, 0x0E, 0xFC, 0x00, 0x2F, 0xF9,
  0x0F, 0x00, 0xF9, 0x66, 0x00, 0xF9, 0x57, 0x00, 0xF9, 0x57, 0x00, 0xF9,
  0x00, 0xFB, 0x57, 0x00, 0xF9, 0x56, 0x00, 0xF9, 0x56, 0x00, 0xF9, 0x3B,
  0x00, 0xFF, 0xCF, 0x00, 0xD0, 0xFF, 0x00, 0xD9, 0xF9, 0x00, 0xDB, 0xFF,
  0xFF, 0xF8, 0xBB, 0x00, 0x11, 0xFF, 0x00, 0x2F, 0xF9, 0x0F, 0x00, 0xF9,
  0x66, 0x00, 0xF9, 0x57, 0x00, 0xF9, 0x57, 0x00, 0xF9, 0x57, 0x00, 0xF9,
  0x00, 0xFB, 0x57, 0x00, 0xF9, 0x56, 0x00, 0xFF, 0x51, 0x00, 0xF9, 0x56,
  0x00, 0xFF, 0x33, 0x00, 0xFF, 0xCF, 0x00, 0xDA, 0xFF, 0x00, 0xEA, 0xFF,
  0x00, 0x34, 0xBD, 0x00, 0x2A, 0xFF, 0x0F, 0x00, 0xF9, 0x66, 0x00, 0xF9,
  0x57, 0x00, 0xF9, 0x57, 0x00, 0xF9, 0x57, 0x00, 0xF9, 0x57, 0x00, 0xF9,
  0x00, 0xFB, 0x59, 0x00, 0xFF, 0x53, 0xB7, 0x43, 0x97, 0x00, 0xFF, 0x4B,
  0xDA, 0x66, 0xBA, 0x00, 0xFF, 0x37, 0xFF, 0x94, 0xB6, 0x00, 0xEB, 0xFF,
  0x00, 0x52, 0xB7, 0x0F, 0x00, 0xFF, 0x66, 0x00, 0xF9, 0x57, 0x00, 0xF9,
  0x57, 0x00, 0xF9, 0x57, 0x00, 0xF9, 0x57, 0x00, 0xF9, 0x57, 0x00, 0xF9,
  0x4A, 0xFC, 0x4C, 0x49, 0xFA, 0x4C, 0x39, 0xFF, 0x47, 0x49, 0xFA, 0x4C,
  0x36, 0xFF, 0x44, 0x49, 0xFA, 0x4C, 0x3C, 0xFF, 0x31, 0x00, 0xFF, 0xDC,
  0x00, 0x00, 0xFF, 0x5A, 0x00, 0xFA, 0x4B, 0x00, 0xFA, 0x4B, 0x00, 0xFA,
  0x4B, 0x00, 0xFA, 0x4B, 0x00, 0xFA, 0x4B, 0x00, 0xFA, 0x4B, 0x00, 0xFA,
  0xAE, 0xFB, 0x00, 0xAD, 0xF9, 0x00, 0xAD, 0xF9, 0x00, 0xAD, 0xF9, 0x00,
  0xAD, 0xF9, 0x00, 0xAD, 0xF9, 0x00, 0x9C, 0xFA, 0x00, 0xFF, 0xFF, 0x00,
  0xFF, 0x00, 0x00, 0xBC, 0x00, 0xFF, 0xBE, 0x00, 0xFF, 0xC7, 0x00, 0xFF,
  0xBE, 0x00, 0xFF, 0xCA, 0x00, 0xFF, 0xBE, 0x00, 0xFF, 0xBE, 0x00, 0xFF,
  0xA3, 0xFB, 0x00, 0xA2, 0xF9, 0x00, 0xA2, 0xF9, 0x00, 0xA2, 0xF9, 0x00,
  0xA2, 0xF9, 0x00, 0x92, 0xFA, 0x00, 0xF0, 0xFF, 0x00, 0xFF, 0x67, 0x00,
  0xFF, 0x5C, 0x00, 0x97, 0xEE, 0xD7, 0xEC, 0x00, 0x99, 0x79, 0xDA, 0x8C,
  0xF5, 0x00, 0x8E, 0x57, 0xB8, 0x69, 0xED, 0x0C, 0x8E, 0xE1, 0x19, 0x8C,
  0xA3, 0xFB, 0x00, 0xA2, 0xF9, 0x00, 0xA2, 0xF9, 0x00, 0xA2, 0xF9, 0x00,
  0x92, 0xFA, 0x00, 0xF0, 0xFF, 0x00, 0xFE, 0xCA, 0x00, 0xFF, 0x72, 0x00,
  0xF9, 0x5B, 0x00, 0xFF, 0x61, 0x00, 0xFF, 0x00, 0x00, 0xDE, 0x0C, 0xB7,
  0xDC, 0x17, 0x97, 0xE8, 0x09, 0x9A, 0xDC, 0x17, 0x97, 0xDC, 0x17, 0x97,
  0xA3, 0xFB, 0x00, 0xA2, 0xF9, 0x00, 0xA2, 0xF9, 0x00, 0x92, 0xFA, 0x00,
  0xF0, 0xFF, 0x00, 0xFE, 0xC1, 0x00, 0xFF, 0xCC, 0x00, 0xAF, 0xE6, 0xFF,
  0xFF, 0x52, 0x00, 0xF9, 0x5F, 0x00, 0xFA, 0x77, 0x00, 0xFF, 0x00, 0x00,
  0xD6, 0x1C, 0xB7, 0xDC, 0x17, 0x97, 0xDC, 0x17, 0x97, 0xDC, 0x17, 0x97,
  0xA3, 0xFB, 0x00, 0xA2, 0xF9, 0x00, 0x92, 0xFA, 0x00, 0xF0, 0xFF, 0x00,
  0xFE, 0xC1, 0x00, 0xFC, 0xC9, 0x00, 0xF9, 0xD5, 0x00, 0xFF, 0x72, 0x00,
  0xF9, 0x5B, 0x00, 0xF9, 0x5F, 0x00, 0xF9, 0x5F, 0x00, 0xFA, 0x77, 0x00,
  0xFF, 0x00, 0x00, 0xD6, 0x1C, 0xB7, 0xDC, 0x17, 0x97, 0xDC, 0x17, 0x97,
  0xA3, 0xFB, 0x00, 0x91, 0xF9, 0x00, 0xF0, 0xFF, 0x00, 0xFE, 0xBB, 0x00,
  0xFC, 0xC9, 0x00, 0xD6, 0xEC, 0xFF, 0xFC, 0xD3, 0x00, 0xF9, 0x7B, 0x00,
  0xF9, 0x5B, 0x00, 0xF9, 0x5F, 0x00, 0xF9, 0x5F, 0x00, 0xF9, 0x5F, 0x00,
  0xFA, 0x77, 0x00, 0xFF, 0x00, 0x00, 0xD6, 0x1C, 0xB7, 0xDC, 0x17, 0x97,
  0x92, 0xFB, 0x00, 0xF0, 0xFF, 0x00, 0xFE, 0xBB, 0x00, 0xF9, 0xFF, 0xFF,
  0xF9, 0xC6, 0x00, 0xFC, 0xC9, 0x00, 0xF9, 0xD5, 0x00, 0xF9, 0x7B, 0x00,
  0xF9, 0x5B, 0x00, 0xF9, 0x5F, 0x00, 0xF9, 0x5F, 0x00, 0xF9, 0x5F, 0x00,
  0xF9, 0x5F, 0x00, 0xF9, 0x76, 0x00, 0xFE, 0x00, 0x00, 0xD5, 0x1C, 0xB7,
  0xEF, 0xFF, 0x00, 0xFF, 0xC2, 0x00, 0xFC, 0xCE, 0x00, 0xFC, 0xC8, 0x00,
  0xFC, 0xCE, 0x00, 0xFC, 0xCE, 0x00, 0xFC, 0xD7, 0x00, 0xFC, 0x7C, 0x00,
  0xFC, 0x5B, 0x00, 0xFC, 0x60, 0x00, 0xFC, 0x60, 0x00, 0xFC, 0x60, 0x00,
  0xFC, 0x60, 0x00, 0xFC, 0x60, 0x00, 0xFC, 0x77, 0x00, 0xFE, 0x00, 0x08
};
const unsigned char ASCII_8X8_111[768] = {
  0x00, 0xFF, 0xF5, 0x00, 0xA0, 0xFD, 0x00, 0xB2, 0xF9, 0x00, 0xB2, 0xF9,
  0x00, 0xB2, 0xF9, 0x00, 0xB2, 0xF9, 0x00, 0xB2, 0xF9, 0x00, 0xC2, 0xFF,
  0x00, 0x29, 0xBC, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xF9,
  0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x3D, 0x00, 0xF9,
  0x00, 0xFC, 0x63, 0x00, 0xFF, 0xFE, 0x00, 0xA1, 0xFE, 0x00, 0xB2, 0xF9,
  0x00, 0xB2, 0xF9, 0x00, 0xB2, 0xF9, 0x00, 0xB2, 0xF9, 0x00, 0xC2, 0xFF,
  0x00, 0x29, 0xBC, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xD6, 0x00, 0x00, 0xFC,
  0xFF, 0xFF, 0xF9, 0x00, 0x00, 0xF9, 0x3D, 0x00, 0xF9, 0x8C, 0x00, 0xF9,
  0x00, 0xFB, 0x7E, 0x00, 0xF9, 0x62, 0x00, 0xFF, 0xFE, 0x00, 0xA1, 0xFE,
  0x00, 0xB2, 0xF9, 0x00, 0xB2, 0xF9, 0x00, 0xB2, 0xF9, 0x00, 0xC2, 0xFF,
  0x00, 0x16, 0xBC, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xF9,
  0x00, 0x00, 0xF9, 0x3D, 0x00, 0xF9, 0x8C, 0x00, 0xF9, 0x7D, 0x00, 0xF9,
  0x00, 0xFB, 0x7E, 0x00, 0xF9, 0x7C, 0x00, 0xFA, 0x62, 0x00, 0xFF, 0xFE,
  0x00, 0xA1, 0xFE, 0x00, 0xB2, 0xF9, 0x00, 0xB2, 0xF9, 0x00, 0xAF, 0xFF,
  0xFF, 0xFF, 0xBA, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9,
  0x3D, 0x00, 0xF9, 0x8C, 0x00, 0xF9, 0x7D, 0x00, 0xF9, 0x7D, 0x00, 0xF9,
  0x00, 0xFB, 0x7E, 0x00, 0xF9, 0x7C, 0x00, 0xF9, 0x7C, 0x00, 0xFA, 0x62,
  0x00, 0xFF, 0xFE, 0x00, 0xA1, 0xFE, 0x00, 0xB2, 0xFF, 0x00, 0xC2, 0xFF,
  0x00, 0x16, 0xBC, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xF9, 0x3D, 0x00, 0xF9,
  0x8C, 0x00, 0xF9, 0x7D, 0x00, 0xF9, 0x7D, 0x00, 0xF9, 0x7D, 0x00, 0xF9,
  0x00, 0xFB, 0x7E, 0x00, 0xF9, 0x7C, 0x00, 0xFF, 0x7C, 0x00, 0xF9, 0x7C,
  0x00, 0xFF, 0x5F, 0x00, 0xFF, 0xFF, 0xFF, 0x9E, 0x90, 0x00, 0xC2, 0xFF,
  0x00, 0x29, 0xBC, 0x00, 0x00, 0xFF, 0x3D, 0x00, 0xF9, 0x8C, 0x00, 0xF9,
  0x7D, 0x00, 0xF9, 0x7D, 0x00, 0xF9, 0x7D, 0x00, 0xF9, 0x7D, 0x00, 0xF9,
  0x00, 0xFB, 0x82, 0x00, 0xFF, 0x80, 0xB8, 0x44, 0x85, 0x00, 0xFF, 0x7D,
  0xD8, 0x63, 0xA6, 0x00, 0xFF, 0x63, 0x00, 0xFF, 0xFF, 0x00, 0xB0, 0xFF,
  0x00, 0x2F, 0xB6, 0x3D, 0x00, 0xFF, 0x8C, 0x00, 0xF9, 0x7D, 0x00, 0xF9,
  0x7D, 0x00, 0xF9, 0x7D, 0x00, 0xF9, 0x7D, 0x00, 0xF9, 0x7D, 0x00, 0xF9,
  0x46, 0xFB, 0x61, 0x45, 0xF9, 0x61, 0x35, 0xFF, 0x61, 0x45, 0xF9, 0x61,
  0x32, 0xFF, 0x5E, 0x45, 0xF9, 0x61, 0x4D, 0xFA, 0x42, 0x00, 0xFF, 0xFF,
  0x2D, 0x00, 0xFF, 0x81, 0x00, 0xFA, 0x71, 0x00, 0xFA, 0x71, 0x00, 0xFA,
  0x71, 0x00, 0xFA, 0x71, 0x00, 0xFA, 0x71, 0x00, 0xFA, 0x71, 0x00, 0xFA,
  0x85, 0xFC, 0x00, 0x84, 0xF9, 0x00, 0x84, 0xF9, 0x00, 0x84, 0xF9, 0x00,
  0x84, 0xF9, 0x00, 0x84, 0xF9, 0x00, 0x73, 0xF9, 0x00, 0xCF, 0xFF, 0x00,
  0xFF, 0x00, 0x00, 0xDE, 0x00, 0xFF, 0xE6, 0x00, 0xFF, 0xEF, 0x00, 0xFE,
  0xE6, 0x00, 0xFF, 0xF1, 0x00, 0xFF, 0xE6, 0x00, 0xFF, 0xE6, 0x00, 0xFF,
  0x7E, 0xFB, 0x00, 0x7C, 0xF9, 0x00, 0x7D, 0xF9, 0x00, 0x7D, 0xF9, 0x00,
  0x7D, 0xF9, 0x00, 0x6C, 0xF9, 0x00, 0xC0, 0xFF, 0x00, 0xFF, 0x94, 0x00,
  0xF9, 0x9D, 0x00, 0xFF, 0x00, 0x00, 0xDF, 0x0A, 0x85, 0x72, 0xD8, 0x94,
  0xF1, 0x00, 0x66, 0x52, 0xB8, 0x73, 0xE8, 0x0B, 0x6A, 0xDD, 0x18, 0x6A,
  0x7E, 0xFB, 0x00, 0x7C, 0xF9, 0x00, 0x7D, 0xF9, 0x00, 0x7D, 0xF9, 0x00,
  0x6C, 0xF9, 0x00, 0xC0, 0xFB, 0x00, 0xFF, 0xF9, 0x00, 0xF9, 0x9F, 0x00,
  0xFF, 0x7B, 0x00, 0x8B, 0xE3, 0xFF, 0xFF, 0x00, 0x00, 0xDE, 0x07, 0x94,
  0xDD, 0x16, 0x7A, 0xE8, 0x08, 0x79, 0xDD, 0x16, 0x7A, 0xDD, 0x16, 0x7A,
  0x7E, 0xFB, 0x00, 0x7C, 0xF9, 0x00, 0x7D, 0xF9, 0x00, 0x6C, 0xF9, 0x00,
  0xC0, 0xFB, 0x00, 0xFF, 0xEF, 0x00, 0xF9, 0xFB, 0x00, 0xFF, 0x9B, 0x00,
  0xF9, 0x80, 0x00, 0xFF, 0x7F, 0x00, 0xF9, 0xA1, 0x00, 0xFF, 0x00, 0x00,
  0xD5, 0x17, 0x98, 0xDD, 0x16, 0x7A, 0xDD, 0x16, 0x7A, 0xDD, 0x16, 0x7A,
  0x7E, 0xFB, 0x00, 0x7C, 0xF9, 0x00, 0x6C, 0xF9, 0x00, 0xC0, 0xFB, 0x00,
  0xFF, 0xEF, 0x00, 0xF9, 0xF1, 0x00, 0xFF, 0xF7, 0x00, 0xAD, 0xD2, 0xFF,
  0xFF, 0x7C, 0x00, 0xF9, 0x84, 0x00, 0xF9, 0x84, 0x00, 0xF9, 0xA1, 0x00,
  0xFF, 0x00, 0x00, 0xD5, 0x17, 0x98, 0xDD, 0x16, 0x7A, 0xDD, 0x16, 0x7A,
  0x7E, 0xFB, 0x00, 0x6C, 0xF9, 0x00, 0xC0, 0xFB, 0x00, 0xFF, 0xEE, 0x00,
  0xF9, 0xF1, 0x00, 0xFC, 0xF3, 0x00, 0xF9, 0xFB, 0x00, 0xFF, 0x9B, 0x00,
  0xF9, 0x80, 0x00, 0xF9, 0x84, 0x00, 0xF9, 0x84, 0x00, 0xF9, 0x84, 0x00,
  0xF9, 0xA1, 0x00, 0xFF, 0x00, 0x00, 0xD5, 0x17, 0x98, 0xDD, 0x16, 0x7A,
  0x6D, 0xFB, 0x00, 0xC0, 0xFB, 0x00, 0xFF, 0xEE, 0x00, 0xF9, 0xFD, 0xFF,
  0xFC, 0xF2, 0x00, 0xD6, 0xDA, 0xFF, 0xFC, 0xFD, 0x00, 0xF9, 0x9F, 0x00,
  0xF9, 0x80, 0x00, 0xF9, 0x84, 0x00, 0xF9, 0x84, 0x00, 0xF9, 0x84, 0x00,
  0xF9, 0x84, 0x00, 0xF9, 0xA1, 0x00, 0xFF, 0x00, 0x00, 0xD5, 0x17, 0x98,
  0xC4, 0xFF, 0x00, 0xFF, 0xF2, 0x00, 0xFC, 0xF4, 0x00, 0xFC, 0xF3, 0x00,
  0xFC, 0xF4, 0x00, 0xFF, 0xF6, 0x00, 0xFC, 0xFD, 0x00, 0xFC, 0xA1, 0x00,
  0xFC, 0x82, 0x00, 0xFC, 0x86, 0x00, 0xFC, 0x86, 0x00, 0xFC, 0x86, 0x00,
  0xFC, 0x86, 0x00, 0xFC, 0x86, 0x00, 0xFC, 0xA3, 0x00, 0xFF, 0x01, 0x00
};
const unsigned char ASCII_8X8_112[768] = {
  0x00, 0xE5, 0xFF, 0x00, 0x70, 0xF9, 0x00, 0x85, 0xF9, 0x00, 0x85, 0xF9,
  0x00, 0x85, 0xF9, 0x00, 0x85, 0xF9, 0x00, 0x85, 0xF9, 0x00, 0x95, 0xFF,
  0x00, 0x00, 0xBC, 0x33, 0x00, 0xFF, 0x17, 0x00, 0xFC, 0x2D, 0x00, 0xF9,
  0x2D, 0x00, 0xF9, 0x2D, 0x00, 0xF9, 0x1E, 0x00, 0xF9, 0x6A, 0x00, 0xF9,
  0x00, 0xFF, 0x97, 0x00, 0xEA, 0xFF, 0x00, 0x70, 0xF9, 0x00, 0x85, 0xF9,
  0x00, 0x85, 0xF9, 0x00, 0x85, 0xF9, 0x00, 0x85, 0xF9, 0x00, 0x95, 0xFF,
  0x00, 0x00, 0xBC, 0x1C, 0x00, 0xFF, 0xFF, 0xFF, 0xD6, 0x17, 0x00, 0xFC,
  0x14, 0x00, 0xF9, 0x1E, 0x00, 0xF9, 0x6A, 0x00, 0xF9, 0xBB, 0x00, 0xF9,
  0x00, 0xFB, 0xAB, 0x00, 0xFF, 0x96, 0x00, 0xEA, 0xFF, 0x00, 0x70, 0xF9,
  0x00, 0x85, 0xF9, 0x00, 0x85, 0xF9, 0x00, 0x85, 0xF9, 0x00, 0x7D, 0xFF,
  0xFF, 0xFF, 0xBB, 0x1A, 0x00, 0xFF, 0x17, 0x00, 0xFC, 0x14, 0x00, 0xF9,
  0xFF, 0xFF, 0xF9, 0x51, 0x00, 0xF9, 0xBB, 0x00, 0xF9, 0xAB, 0x00, 0xF9,
  0x00, 0xFB, 0xAB, 0x00, 0xF9, 0xAA, 0x00, 0xFF, 0x96, 0x00, 0xEA, 0xFF,
  0x00, 0x70, 0xF9, 0x00, 0x85, 0xF9, 0x00, 0x80, 0xFF, 0x00, 0x95, 0xFF,
  0x00, 0x00, 0xBC, 0x33, 0x00, 0xFF, 0x2D, 0x00, 0xF9, 0x1E, 0x00, 0xF9,
  0x51, 0x00, 0xF9, 0xBB, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB, 0x00, 0xF9,
  0x00, 0xFB, 0xAB, 0x00, 0xF9, 0xAA, 0x00, 0xF9, 0xAA, 0x00, 0xFF, 0x96,
  0x00, 0xEA, 0xFF, 0x00, 0x6B, 0xFF, 0xFF, 0xC5, 0x8B, 0x00, 0x8F, 0xFF,
  0x00, 0x00, 0xBC, 0x33, 0x00, 0xFF, 0x1E, 0x00, 0xF9, 0x6A, 0x00, 0xF9,
  0xBB, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB, 0x00, 0xF9,
  0x00, 0xFB, 0xAB, 0x00, 0xF9, 0xAA, 0x00, 0xFF, 0xB0, 0x00, 0xF9, 0xAA,
  0x00, 0xFF, 0x99, 0x00, 0xEA, 0xFF, 0x00, 0x6B, 0xFF, 0x00, 0x95, 0xFF,
  0x00, 0x00, 0xBC, 0x24, 0x00, 0xFF, 0x6A, 0x00, 0xF9, 0xBB, 0x00, 0xF9,
  0xAB, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB, 0x00, 0xF9,
  0x00, 0xFB, 0xB1, 0x00, 0xFF, 0xB5, 0xB6, 0x42, 0x6D, 0x00, 0xFF, 0xB8,
  0xDA, 0x66, 0x94, 0x00, 0xFF, 0x9F, 0x00, 0xEA, 0xFF, 0x00, 0x7F, 0xFF,
  0x00, 0x01, 0xB6, 0x70, 0x00, 0xFF, 0xBB, 0x00, 0xF9, 0xAB, 0x00, 0xF9,
  0xAB, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB, 0x00, 0xF9,
  0x4D, 0xFC, 0x86, 0x4D, 0xF9, 0x85, 0x3D, 0xFF, 0x8A, 0x4D, 0xF9, 0x85,
  0x3A, 0xFF, 0x87, 0x4D, 0xF9, 0x85, 0x55, 0xFF, 0x6B, 0x00, 0xFB, 0xFF,
  0x6C, 0x00, 0xFF, 0xB2, 0x00, 0xFC, 0xA2, 0x00, 0xFC, 0xA2, 0x00, 0xFC,
  0xA2, 0x00, 0xFC, 0xA2, 0x00, 0xFC, 0xA2, 0x00, 0xFC, 0xA2, 0x00, 0xFC,
  0x50, 0xFB, 0x00, 0x4F, 0xF9, 0x00, 0x4F, 0xF9, 0x00, 0x4F, 0xF9, 0x00,
  0x4F, 0xF9, 0x00, 0x4F, 0xF9, 0x00, 0x3E, 0xF9, 0x00, 0x93, 0xFF, 0x00,
  0xFF, 0x26, 0x00, 0xFB, 0x00, 0xFF, 0xFF, 0x00, 0xEE, 0xFF, 0x00, 0xE6,
  0xFF, 0x00, 0xEE, 0xFF, 0x00, 0xE9, 0xFF, 0x00, 0xEE, 0xFF, 0x00, 0xEE,
  0x4F, 0xFB, 0x00, 0x4E, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x4E, 0xF9, 0x00,
  0x4E, 0xF9, 0x00, 0x3D, 0xF9, 0x00, 0x8D, 0xFE, 0x00, 0xFF, 0xCB, 0x00,
  0xF9, 0xCD, 0x00, 0xFE, 0x2C, 0x00, 0xDD, 0x00, 0x50, 0x71, 0xDB, 0xA7,
  0xEF, 0x00, 0x36, 0x4D, 0xB7, 0x81, 0xE7, 0x0B, 0x3E, 0xDB, 0x18, 0x44,
  0x4F, 0xFB, 0x00, 0x4E, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x4E, 0xF9, 0x00,
  0x3D, 0xF9, 0x00, 0x92, 0xF9, 0x00, 0xDF, 0xFE, 0x00, 0xFE, 0xD0, 0x00,
  0xF9, 0xAF, 0x00, 0xFF, 0xD1, 0x00, 0xFF, 0x29, 0x00, 0xDF, 0x00, 0x62,
  0xDE, 0x16, 0x55, 0xE9, 0x08, 0x50, 0xDE, 0x16, 0x55, 0xDE, 0x16, 0x55,
  0x4F, 0xFB, 0x00, 0x4E, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x3D, 0xF9, 0x00,
  0x92, 0xF9, 0x00, 0xE4, 0xF9, 0x00, 0xCF, 0xFE, 0x00, 0xFE, 0xD0, 0x00,
  0xFF, 0xB0, 0x00, 0x8B, 0xAF, 0xFF, 0xFF, 0xD1, 0x00, 0xFF, 0x29, 0x00,
  0xD7, 0x0C, 0x6A, 0xDE, 0x16, 0x55, 0xDE, 0x16, 0x55, 0xDE, 0x16, 0x55,
  0x4F, 0xFB, 0x00, 0x4E, 0xF9, 0x00, 0x3D, 0xF9, 0x00, 0x8D, 0xF9, 0x00,
  0xE4, 0xF9, 0x00, 0xD3, 0xF9, 0x00, 0xCF, 0xFE, 0x00, 0xFF, 0xD2, 0x00,
  0xF9, 0xAF, 0x00, 0xFF, 0xB3, 0x00, 0xF9, 0xB3, 0x00, 0xF9, 0xD1, 0x00,
  0xFF, 0x29, 0x00, 0xD7, 0x0C, 0x6A, 0xDE, 0x16, 0x55, 0xDE, 0x16, 0x55,
  0x4F, 0xFB, 0x00, 0x3D, 0xF9, 0x00, 0x8D, 0xF9, 0x00, 0xFF, 0xF9, 0xFF,
  0xCF, 0xF9, 0x00, 0xD2, 0xFC, 0x00, 0xD5, 0xFF, 0x00, 0xB4, 0xC1, 0xFF,
  0xFF, 0xB0, 0x00, 0xF9, 0xB3, 0x00, 0xF9, 0xB3, 0x00, 0xF9, 0xB3, 0x00,
  0xF9, 0xD1, 0x00, 0xFF, 0x29, 0x00, 0xD7, 0x0C, 0x6A, 0xDE, 0x16, 0x55,
  0x3E, 0xFB, 0x00, 0x92, 0xF9, 0x00, 0xE4, 0xF9, 0x00, 0xCE, 0xF9, 0x00,
  0xD1, 0xFC, 0x00, 0xE8, 0xD5, 0xFF, 0xCD, 0xFF, 0x00, 0xFF, 0xD1, 0x00,
  0xF9, 0xAF, 0x00, 0xF9, 0xB3, 0x00, 0xF9, 0xB3, 0x00, 0xF9, 0xB3, 0x00,
  0xF9, 0xB3, 0x00, 0xF9, 0xD0, 0x00, 0xFF, 0x29, 0x00, 0xD6, 0x0C, 0x6A,
  0x94, 0xFE, 0x00, 0xE6, 0xFC, 0x00, 0xD6, 0xFC, 0x00, 0xD6, 0xFC, 0x00,
  0xD6, 0xFC, 0x00, 0xD4, 0xFF, 0x00, 0xD1, 0xFF, 0x00, 0xFF, 0xD4, 0x00,
  0xFC, 0xB1, 0x00, 0xFC, 0xB5, 0x00, 0xFC, 0xB5, 0x00, 0xFC, 0xB5, 0x00,
  0xFC, 0xB5, 0x00, 0xFC, 0xB5, 0x00, 0xFC, 0xD2, 0x00, 0xFF, 0x34, 0x00
};
const unsigned char ASCII_8X8_113[768] = {
  0x00, 0xB2, 0xFF, 0x00, 0x40, 0xF9, 0x00, 0x56, 0xF9, 0x00, 0x56, 0xF9,
  0x00, 0x56, 0xF9, 0x00, 0x56, 0xF9, 0x00, 0x56, 0xF9, 0x00, 0x61, 0xFF,
  0x00, 0x00, 0xBD, 0x63, 0x00, 0xFF, 0x4A, 0x00, 0xFC, 0x5B, 0x00, 0xF9,
  0x5B, 0x00, 0xF9, 0x5B, 0x00, 0xF9, 0x4B, 0x00, 0xF9, 0x99, 0x00, 0xF9,
  0x00, 0xFF, 0xD1, 0x00, 0xB2, 0xFF, 0x00, 0x40, 0xF9, 0x00, 0x56, 0xF9,
  0x00, 0x56, 0xF9, 0x00, 0x56, 0xF9, 0x00, 0x56, 0xF9, 0x00, 0x48, 0xFF,
  0xFF, 0xFF, 0xBC, 0x3C, 0x00, 0xFF, 0xFF, 0xFF, 0xD7, 0x4A, 0x00, 0xFC,
  0x5B, 0x00, 0xF9, 0x4B, 0x00, 0xF9, 0x99, 0x00, 0xF9, 0xE8, 0x00, 0xF9,
  0x00, 0xFB, 0xDA, 0x00, 0xFF, 0xCF, 0x00, 0xB3, 0xFF, 0x00, 0x40, 0xF9,
  0x00, 0x56, 0xF9, 0x00, 0x56, 0xF9, 0x00, 0x4B, 0xFF, 0x00, 0x61, 0xFF,
  0x00, 0x00, 0xBD, 0x63, 0x00, 0xFF, 0x4A, 0x00, 0xFC, 0x5B, 0x00, 0xF9,
  0x3F, 0x00, 0xF9, 0x99, 0x00, 0xF9, 0xE8, 0x00, 0xF9, 0xD9, 0x00, 0xF9,
  0x00, 0xFB, 0xDA, 0x00, 0xF9, 0xD7, 0x00, 0xFF, 0xCF, 0x00, 0xB3, 0xFF,
  0x00, 0x40, 0xF9, 0x00, 0x4B, 0xFF, 0xFF, 0xDB, 0x8A, 0x00, 0x56, 0xFF,
  0x11, 0x00, 0xBD, 0x63, 0x00, 0xFF, 0x5B, 0x00, 0xF9, 0x3F, 0x00, 0xF9,
  0xFF, 0xFF, 0xF9, 0xDC, 0x00, 0xF9, 0xD9, 0x00, 0xF9, 0xD9, 0x00, 0xF9,
  0x00, 0xFB, 0xDA, 0x00, 0xF9, 0xD7, 0x00, 0xF9, 0xD8, 0x00, 0xFF, 0xCF,
  0x00, 0xBF, 0xFF, 0x00, 0x40, 0xF9, 0x00, 0x4B, 0xFF, 0x00, 0x61, 0xFF,
  0x11, 0x00, 0xBD, 0x63, 0x00, 0xFF, 0x4B, 0x00, 0xF9, 0x99, 0x00, 0xF9,
  0xDC, 0x00, 0xF9, 0xD9, 0x00, 0xF9, 0xD9, 0x00, 0xF9, 0xD9, 0x00, 0xF9,
  0x00, 0xFB, 0xDA, 0x00, 0xF9, 0xD7, 0x00, 0xFF, 0xE3, 0x00, 0xFF, 0xE0,
  0xE2, 0x77, 0x6D, 0x00, 0xBF, 0xFF, 0x00, 0x40, 0xF9, 0x00, 0x61, 0xFF,
  0x11, 0x00, 0xBD, 0x54, 0x00, 0xFF, 0x99, 0x00, 0xF9, 0xE8, 0x00, 0xF9,
  0xD9, 0x00, 0xF9, 0xD9, 0x00, 0xF9, 0xD9, 0x00, 0xF9, 0xD9, 0x00, 0xF9,
  0x00, 0xFB, 0xE1, 0x00, 0xFF, 0xEA, 0xB7, 0x3F, 0x58, 0x00, 0xFF, 0xEA,
  0x00, 0xFF, 0xE7, 0x00, 0xFF, 0xD7, 0x00, 0xB3, 0xFF, 0x00, 0x4A, 0xFF,
  0x00, 0x00, 0xB6, 0xA2, 0x00, 0xFF, 0xE8, 0x00, 0xF9, 0xD9, 0x00, 0xF9,
  0xD9, 0x00, 0xF9, 0xD9, 0x00, 0xF9, 0xD9, 0x00, 0xF9, 0xD9, 0x00, 0xF9,
  0x52, 0xFC, 0xAA, 0x52, 0xF9, 0xA8, 0x42, 0xFF, 0xB4, 0x52, 0xFA, 0xA8,
  0x52, 0xFA, 0xA8, 0x52, 0xFA, 0xA8, 0x5B, 0xFF, 0x98, 0x00, 0xBD, 0xFF,
  0xA9, 0x00, 0xFF, 0xE5, 0x00, 0xFF, 0xD5, 0x00, 0xFF, 0xD5, 0x00, 0xFF,
  0xD5, 0x00, 0xFF, 0xD5, 0x00, 0xFF, 0xD5, 0x00, 0xFF, 0xD5, 0x00, 0xFF,
  0x1D, 0xFB, 0x00, 0x1D, 0xF9, 0x00, 0x1D, 0xF9, 0x00, 0x1D, 0xF9, 0x00,
  0x1D, 0xF9, 0x00, 0x1D, 0xF9, 0x00, 0x0D, 0xF9, 0x00, 0x51, 0xFF, 0x00,
  0xFF, 0x67, 0x00, 0xF5, 0x00, 0xD8, 0xFA, 0x00, 0xBC, 0xFA, 0x00, 0xBC,
  0xFA, 0x00, 0xBC, 0xFF, 0x00, 0xB2, 0xFA, 0x00, 0xBC, 0xFA, 0x00, 0xBC,
  0x22, 0xFB, 0x00, 0x22, 0xF9, 0x00, 0x22, 0xF9, 0x00, 0x22, 0xF9, 0x00,
  0x22, 0xF9, 0x00, 0x11, 0xF9, 0x00, 0x58, 0xF9, 0x00, 0xFF, 0xFB, 0x00,
  0xFA, 0xFB, 0x00, 0xFF, 0x67, 0x00, 0xD2, 0x04, 0x2C, 0xE3, 0x09, 0x13,
  0xE5, 0x0D, 0x16, 0x4E, 0xB4, 0x93, 0xE5, 0x0D, 0x16, 0xDA, 0x19, 0x20,
  0x22, 0xFB, 0x00, 0x22, 0xF9, 0x00, 0x22, 0xF9, 0x00, 0x22, 0xF9, 0x00,
  0x11, 0xF9, 0x00, 0x61, 0xF9, 0x00, 0xAE, 0xF9, 0x00, 0xFA, 0xFB, 0x00,
  0xFA, 0xDE, 0x00, 0xF9, 0xFE, 0x00, 0xFF, 0x54, 0x00, 0x6B, 0xC1, 0xD5,
  0xE5, 0x07, 0x24, 0xE8, 0x0A, 0x27, 0xDD, 0x17, 0x30, 0xDD, 0x17, 0x30,
  0x22, 0xFB, 0x00, 0x22, 0xF9, 0x00, 0x22, 0xF9, 0x00, 0x00, 0xF9, 0x00,
  0x61, 0xF9, 0x00, 0xB7, 0xF9, 0x00, 0x9D, 0xF9, 0x00, 0xFA, 0xFB, 0x00,
  0xFA, 0xDE, 0x00, 0xFF, 0xE7, 0x00, 0xF9, 0xFE, 0x00, 0xFF, 0x54, 0x00,
  0xD5, 0x01, 0x3C, 0xDD, 0x17, 0x30, 0xDD, 0x17, 0x30, 0xDD, 0x17, 0x30,
  0x22, 0xFB, 0x00, 0x22, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0xFF, 0xF9, 0xFF,
  0xA4, 0xF9, 0x00, 0xA6, 0xF9, 0x00, 0x9D, 0xF9, 0x00, 0xFA, 0xFB, 0x00,
  0xFF, 0xE4, 0x00, 0x8A, 0x96, 0xFF, 0xFF, 0xE7, 0x00, 0xF9, 0xFE, 0x00,
  0xFF, 0x64, 0x00, 0xD5, 0x01, 0x3C, 0xDD, 0x17, 0x30, 0xDD, 0x17, 0x30,
  0x22, 0xFB, 0x00, 0x11, 0xF9, 0x00, 0x61, 0xF9, 0x00, 0xA4, 0xF9, 0x00,
  0xA6, 0xF9, 0x00, 0x9F, 0xFC, 0x00, 0x9D, 0xF9, 0x00, 0xFF, 0xFF, 0x00,
  0xFA, 0xDE, 0x00, 0xFF, 0xE7, 0x00, 0xF9, 0xE1, 0x00, 0xF9, 0xE1, 0x00,
  0xF9, 0xFE, 0x00, 0xFF, 0x64, 0x00, 0xD5, 0x01, 0x3C, 0xDD, 0x17, 0x30,
  0x11, 0xFB, 0x00, 0x61, 0xF9, 0x00, 0xB7, 0xF9, 0x00, 0xA6, 0xF9, 0x00,
  0x9E, 0xFC, 0x00, 0xFF, 0xD7, 0xFF, 0x9A, 0xFF, 0x00, 0xBC, 0xB2, 0xFF,
  0xFF, 0xE3, 0x00, 0xF9, 0xE0, 0x00, 0xF9, 0xE0, 0x00, 0xF9, 0xE0, 0x00,
  0xF9, 0xE0, 0x00, 0xF8, 0xFD, 0x00, 0xFF, 0x64, 0x00, 0xD5, 0x01, 0x3C,
  0x66, 0xFE, 0x00, 0xB8, 0xFC, 0x00, 0xA8, 0xFC, 0x00, 0xA8, 0xFC, 0x00,
  0xA8, 0xFC, 0x00, 0xA0, 0xFF, 0x00, 0x9E, 0xFC, 0x00, 0xFF, 0xFF, 0x00,
  0xFD, 0xE0, 0x00, 0xFC, 0xE3, 0x00, 0xFC, 0xE3, 0x00, 0xFC, 0xE3, 0x00,
  0xFC, 0xE3, 0x00, 0xFC, 0xE3, 0x00, 0xFB, 0xFF, 0x00, 0xFF, 0x68, 0x00
};
const unsigned char ASCII_8X8_114[768] = {
  0x00, 0x9A, 0xFE, 0x00, 0x2D, 0xF9, 0x00, 0x43, 0xF9, 0x00, 0x43, 0xF9,
  0x00, 0x43, 0xF9, 0x00, 0x43, 0xF9, 0x00, 0x43, 0xF9, 0x00, 0x4C, 0xFF,
  0x0F, 0x00, 0xBD, 0x79, 0x00, 0xFF, 0x70, 0x00, 0xF9, 0x70, 0x00, 0xF9,
  0x70, 0x00, 0xF9, 0x70, 0x00, 0xF9, 0x60, 0x00, 0xF9, 0xAE, 0x00, 0xF9,
  0x00, 0xFF, 0xEB, 0x00, 0x98, 0xFD, 0x00, 0x2D, 0xF9, 0x00, 0x43, 0xF9,
  0x00, 0x43, 0xF9, 0x00, 0x43, 0xF9, 0x00, 0x36, 0xFF, 0x00, 0x33, 0xFF,
  0xFF, 0xFF, 0xBB, 0x65, 0x00, 0xFF, 0x61, 0x00, 0xFC, 0x70, 0x00, 0xF9,
  0x70, 0x00, 0xF9, 0x60, 0x00, 0xF9, 0xAE, 0x00, 0xF9, 0xFD, 0x00, 0xF9,
  0x00, 0xFB, 0xEF, 0x00, 0xFF, 0xE9, 0x00, 0x99, 0xFD, 0x00, 0x2D, 0xF9,
  0x00, 0x43, 0xF9, 0x00, 0x36, 0xFF, 0xFF, 0xE5, 0x8A, 0x00, 0x3E, 0xFF,
  0x0F, 0x00, 0xBD, 0x6A, 0x00, 0xFF, 0xFF, 0xFF, 0xD7, 0x61, 0x00, 0xFC,
  0x60, 0x00, 0xF9, 0xAE, 0x00, 0xF9, 0xFD, 0x00, 0xF9, 0xED, 0x00, 0xF9,
  0x00, 0xFB, 0xEF, 0x00, 0xF9, 0xEC, 0x00, 0xFF, 0xE9, 0x00, 0x99, 0xFD,
  0x00, 0x2E, 0xFF, 0x00, 0x43, 0xF9, 0x00, 0x36, 0xFF, 0x00, 0x4C, 0xFF,
  0x23, 0x00, 0xBD, 0x79, 0x00, 0xFF, 0x61, 0x00, 0xFC, 0x60, 0x00, 0xF9,
  0xAD, 0x00, 0xF9, 0xFD, 0x00, 0xF9, 0xED, 0x00, 0xF9, 0xED, 0x00, 0xF9,
  0x00, 0xFB, 0xEF, 0x00, 0xF9, 0xEC, 0x00, 0xF9, 0xEC, 0x00, 0xFF, 0xF5,
  0xE1, 0x92, 0x68, 0x00, 0x2E, 0xFF, 0x00, 0x43, 0xF9, 0x00, 0x4C, 0xFF,
  0x23, 0x00, 0xBD, 0x79, 0x00, 0xFF, 0x60, 0x00, 0xF9, 0xAD, 0x00, 0xF9,
  0xFF, 0xFF, 0xF9, 0xEC, 0x00, 0xF9, 0xED, 0x00, 0xF9, 0xED, 0x00, 0xF9,
  0x00, 0xFB, 0xEF, 0x00, 0xF9, 0xEC, 0x00, 0xFF, 0xFA, 0x00, 0xF9, 0xEC,
  0x00, 0xFF, 0xF5, 0x00, 0x99, 0xFD, 0x00, 0x2D, 0xF9, 0x00, 0x4C, 0xFF,
  0x23, 0x00, 0xBD, 0x69, 0x00, 0xFF, 0xAE, 0x00, 0xF9, 0xFD, 0x00, 0xF9,
  0xEC, 0x00, 0xF9, 0xED, 0x00, 0xF9, 0xED, 0x00, 0xF9, 0xED, 0x00, 0xF9,
  0x00, 0xFB, 0xF7, 0x00, 0xFF, 0xFF, 0xB2, 0x43, 0x4D, 0x00, 0xFF, 0xFF,
  0x00, 0xF9, 0xF4, 0x00, 0xFF, 0xF1, 0x00, 0x98, 0xFF, 0x00, 0x36, 0xFF,
  0x0B, 0x00, 0xB7, 0xB7, 0x00, 0xFF, 0xFD, 0x00, 0xF9, 0xED, 0x00, 0xF9,
  0xED, 0x00, 0xF9, 0xED, 0x00, 0xF9, 0xED, 0x00, 0xF9, 0xED, 0x00, 0xF9,
  0x55, 0xFD, 0xBB, 0x55, 0xFC, 0xBB, 0x46, 0xFF, 0xC9, 0x55, 0xFC, 0xBB,
  0x55, 0xFC, 0xBB, 0x55, 0xFC, 0xBB, 0x5E, 0xFF, 0xAF, 0x00, 0xA1, 0xFF,
  0xC4, 0x00, 0xFF, 0xFC, 0x00, 0xFF, 0xEC, 0x00, 0xFF, 0xEC, 0x00, 0xFF,
  0xEC, 0x00, 0xFF, 0xEC, 0x00, 0xFF, 0xEC, 0x00, 0xFF, 0xEC, 0x00, 0xFF,
  0x04, 0xFB, 0x00, 0x04, 0xF9, 0x00, 0x04, 0xF9, 0x00, 0x04, 0xF9, 0x00,
  0x04, 0xF9, 0x00, 0x04, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x3A, 0xFF, 0x00,
  0xFF, 0x83, 0x00, 0xF3, 0x00, 0xBC, 0xF7, 0x00, 0xA4, 0xF7, 0x00, 0xA4,
  0xF7, 0x00, 0xA4, 0xFF, 0x00, 0x98, 0xF7, 0x00, 0xA4, 0xF7, 0x00, 0xA4,
  0x0C, 0xFB, 0x00, 0x0C, 0xF9, 0x00, 0x0C, 0xF9, 0x00, 0x0C, 0xF9, 0x00,
  0x0C, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x46, 0xFA, 0x00, 0xFC, 0xFA, 0x00,
  0xFD, 0xFF, 0x00, 0xFE, 0x80, 0x00, 0xD3, 0x00, 0x19, 0xDA, 0x19, 0x11,
  0xE6, 0x0C, 0x05, 0x49, 0xB7, 0x9B, 0xE6, 0x0C, 0x05, 0xDA, 0x19, 0x11,
  0x0C, 0xFB, 0x00, 0x0C, 0xF9, 0x00, 0x0C, 0xF9, 0x00, 0x00, 0xF9, 0x00,
  0x00, 0xF9, 0x00, 0x4F, 0xFA, 0x00, 0x98, 0xF9, 0x00, 0xE2, 0xFA, 0x00,
  0xFD, 0xF5, 0x00, 0xF9, 0xFF, 0x00, 0xFF, 0x7D, 0x00, 0xE2, 0x00, 0x16,
  0xDD, 0x17, 0x20, 0xE9, 0x09, 0x15, 0xDD, 0x17, 0x20, 0xDD, 0x17, 0x20,
  0x0C, 0xFB, 0x00, 0x0C, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0xFF, 0xF9, 0xFF,
  0x32, 0xFA, 0x00, 0xA2, 0xF9, 0x00, 0x88, 0xF9, 0x00, 0xE2, 0xFA, 0x00,
  0xFD, 0xF5, 0x00, 0xF9, 0xF5, 0x00, 0xFF, 0xFF, 0x00, 0x6C, 0x9E, 0xD9,
  0xE2, 0x00, 0x16, 0xDD, 0x17, 0x20, 0xDD, 0x17, 0x20, 0xDD, 0x17, 0x20,
  0x0C, 0xFB, 0x00, 0x0C, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x32, 0xFA, 0x00,
  0xA2, 0xF9, 0x00, 0x87, 0xFC, 0x00, 0x88, 0xF9, 0x00, 0xE2, 0xFA, 0x00,
  0xFD, 0xF5, 0x00, 0xFF, 0xFE, 0x00, 0xF9, 0xF5, 0x00, 0xFF, 0xFF, 0x00,
  0xFF, 0x7D, 0x00, 0xD5, 0x00, 0x29, 0xDD, 0x17, 0x20, 0xDD, 0x17, 0x20,
  0x0C, 0xFB, 0x00, 0x00, 0xF9, 0x00, 0x4F, 0xFA, 0x00, 0xA2, 0xF9, 0x00,
  0x87, 0xFC, 0x00, 0xFF, 0xD7, 0xFF, 0x7E, 0xFC, 0x00, 0xE5, 0xFF, 0x00,
  0xFF, 0xFE, 0x00, 0x8A, 0x8C, 0xFF, 0xFF, 0xFE, 0x00, 0xF9, 0xF5, 0x00,
  0xF9, 0xFF, 0x00, 0xFF, 0x7D, 0x00, 0xD5, 0x00, 0x29, 0xDD, 0x17, 0x20,
  0x00, 0xFB, 0x00, 0x4F, 0xF9, 0x00, 0xA2, 0xF9, 0x00, 0x91, 0xF9, 0x00,
  0x91, 0xF9, 0x00, 0x87, 0xFC, 0x00, 0x8A, 0xFF, 0x00, 0xC3, 0xAF, 0xFF,
  0xFF, 0xFB, 0x00, 0xFF, 0xFE, 0x00, 0xF9, 0xF5, 0x00, 0xF9, 0xF5, 0x00,
  0xF9, 0xF5, 0x00, 0xF9, 0xFF, 0x00, 0xFF, 0x7D, 0x00, 0xD5, 0x00, 0x29,
  0x50, 0xFE, 0x00, 0xA3, 0xFB, 0x00, 0x93, 0xFC, 0x00, 0x93, 0xFC, 0x00,
  0x93, 0xFC, 0x00, 0x93, 0xFC, 0x00, 0x89, 0xFC, 0x00, 0xE7, 0xFF, 0x00,
  0xFF, 0xF7, 0x00, 0xFC, 0xF8, 0x00, 0xFC, 0xF8, 0x00, 0xFC, 0xF8, 0x00,
  0xFC, 0xF8, 0x00, 0xFC, 0xF8, 0x00, 0xFC, 0xFF, 0x00, 0xFF, 0x80, 0x00
};
const unsigned char ASCII_8X8_115[768] = {
  0x00, 0x6A, 0xFC, 0x00, 0x00, 0xF9, 0x00, 0x15, 0xF9, 0x00, 0x15, 0xF9,
  0x00, 0x15, 0xF9, 0x00, 0x15, 0xF9, 0x00, 0x01, 0xFF, 0x00, 0x17, 0xFF,
  0x3C, 0x00, 0xBC, 0xA8, 0x00, 0xFF, 0x9E, 0x00, 0xF9, 0x9E, 0x00, 0xF9,
  0x9E, 0x00, 0xF9, 0x9E, 0x00, 0xF9, 0x8F, 0x00, 0xF9, 0xE1, 0x00, 0xFD,
  0x00, 0xF6, 0xFB, 0x00, 0x66, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x15, 0xF9,
  0x00, 0x15, 0xF9, 0x00, 0x01, 0xFF, 0xFF, 0xFC, 0x8A, 0x00, 0x00, 0xFF,
  0xFF, 0xFF, 0xBA, 0x99, 0x00, 0xFF, 0x9E, 0x00, 0xF9, 0x9E, 0x00, 0xF9,
  0x9E, 0x00, 0xF9, 0x8F, 0x00, 0xF9, 0xE5, 0x00, 0xFF, 0xFF, 0x00, 0xD0,
  0x00, 0xDB, 0xFB, 0x00, 0xF4, 0xF9, 0x00, 0x66, 0xF9, 0x00, 0x00, 0xF9,
  0x00, 0x04, 0xFF, 0x00, 0x15, 0xF9, 0x00, 0x01, 0xFF, 0x00, 0x17, 0xFF,
  0x3C, 0x00, 0xBC, 0xA8, 0x00, 0xFF, 0x96, 0x00, 0xFC, 0x9E, 0x00, 0xF9,
  0x8F, 0x00, 0xF9, 0xE5, 0x00, 0xFF, 0xFF, 0x00, 0xD0, 0xF9, 0x00, 0xD9,
  0x00, 0xDB, 0xFB, 0x00, 0xD8, 0xF9, 0x00, 0xF4, 0xF9, 0x00, 0x56, 0xFF,
  0xE1, 0xC2, 0x65, 0x00, 0x04, 0xFF, 0x00, 0x15, 0xF9, 0x00, 0x17, 0xFF,
  0x4B, 0x00, 0xBC, 0xA0, 0x00, 0xFF, 0xFF, 0xFF, 0xD6, 0x86, 0x00, 0xFC,
  0xE5, 0x00, 0xFF, 0xFF, 0x00, 0xD0, 0xF9, 0x00, 0xD9, 0xF9, 0x00, 0xD9,
  0x00, 0xDB, 0xFB, 0x00, 0xD8, 0xF9, 0x00, 0xE3, 0xFF, 0x00, 0xF4, 0xF9,
  0x00, 0x56, 0xFF, 0x00, 0x00, 0xF9, 0x00, 0x15, 0xF9, 0x00, 0x17, 0xFF,
  0x4B, 0x00, 0xBC, 0xA8, 0x00, 0xFF, 0x86, 0x00, 0xFC, 0xE5, 0x00, 0xFF,
  0xFF, 0x00, 0xCC, 0xF9, 0x00, 0xD9, 0xF9, 0x00, 0xD9, 0xF9, 0x00, 0xD9,
  0x00, 0xDB, 0xFB, 0x00, 0xE3, 0xFF, 0xB9, 0x55, 0x3E, 0x00, 0xE3, 0xFF,
  0x00, 0xF4, 0xF9, 0x00, 0x66, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x17, 0xFF,
  0x4B, 0x00, 0xBC, 0x99, 0x00, 0xFF, 0xE5, 0x00, 0xFF, 0xFF, 0x00, 0xCC,
  0xF9, 0xFF, 0xFF, 0xF9, 0x00, 0xD5, 0xF9, 0x00, 0xD9, 0xF9, 0x00, 0xD9,
  0x00, 0xD7, 0xFF, 0x00, 0xD4, 0xFF, 0x00, 0xDF, 0xFF, 0x00, 0xD4, 0xFF,
  0x00, 0xD4, 0xFF, 0x00, 0xF0, 0xFF, 0x00, 0x62, 0xFF, 0x00, 0x01, 0xFF,
  0x31, 0x00, 0xB6, 0xEF, 0x00, 0xFF, 0xFF, 0x00, 0xD0, 0xF9, 0x00, 0xD9,
  0xF9, 0x00, 0xD5, 0xF9, 0x00, 0xD9, 0xF9, 0x00, 0xD9, 0xF9, 0x00, 0xD9,
  0x56, 0xFF, 0xDF, 0x57, 0xFF, 0xDE, 0x57, 0xFF, 0xDE, 0x57, 0xFF, 0xDE,
  0x57, 0xFF, 0xDE, 0x57, 0xFF, 0xDE, 0x5F, 0xFF, 0xD8, 0x00, 0x60, 0xFF,
  0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xDD, 0xFA, 0x00, 0xE6, 0xFA, 0x00, 0xE6,
  0xFA, 0x00, 0xE6, 0xFA, 0x00, 0xE6, 0xFA, 0x00, 0xE6, 0xFA, 0x00, 0xE6,
  0x00, 0xFB, 0x0A, 0x00, 0xF9, 0x0A, 0x00, 0xF9, 0x0A, 0x00, 0xF9, 0x0A,
  0x00, 0xF9, 0x0A, 0x00, 0xF9, 0x0A, 0x00, 0xF9, 0x11, 0x00, 0xFF, 0x00,
  0xFF, 0xC6, 0x00, 0xF2, 0x00, 0x80, 0xF6, 0x00, 0x6F, 0xF6, 0x00, 0x6F,
  0xF6, 0x00, 0x6F, 0xF6, 0x00, 0x6F, 0xF6, 0x00, 0x6F, 0xF6, 0x00, 0x6F,
  0x00, 0xFB, 0x1F, 0x00, 0xF9, 0x1F, 0x00, 0xF9, 0x1F, 0x00, 0xF9, 0x04,
  0x00, 0xF9, 0x1F, 0x00, 0xF9, 0x27, 0x0F, 0xF9, 0x00, 0xCD, 0xF9, 0x00,
  0xC9, 0xFF, 0x00, 0xFF, 0xC0, 0x00, 0xD4, 0x18, 0x10, 0xDB, 0x37, 0x0A,
  0xDB, 0x37, 0x0A, 0xE7, 0x2E, 0x00, 0xDB, 0x37, 0x0A, 0xDB, 0x37, 0x0A,
  0x00, 0xFB, 0x1F, 0x00, 0xF9, 0x1F, 0x00, 0xF9, 0x04, 0xFF, 0xF9, 0xFF,
  0x00, 0xF9, 0x0C, 0x19, 0xF9, 0x00, 0x6B, 0xF9, 0x00, 0xB3, 0xF9, 0x00,
  0xD4, 0xF9, 0x00, 0xC5, 0xFF, 0x00, 0xFF, 0xBA, 0x00, 0xD7, 0x12, 0x1B,
  0xEA, 0x27, 0x09, 0x4A, 0xA9, 0xB0, 0xEA, 0x27, 0x09, 0xDE, 0x31, 0x16,
  0x00, 0xFB, 0x1F, 0x00, 0xF9, 0x1F, 0x00, 0xF9, 0x1F, 0x00, 0xF9, 0x0C,
  0x19, 0xF9, 0x00, 0x65, 0xFC, 0x00, 0x5B, 0xF9, 0x00, 0xB3, 0xF9, 0x00,
  0xD4, 0xF9, 0x00, 0xD0, 0xF9, 0x00, 0xC5, 0xFF, 0x00, 0xFF, 0xC6, 0x00,
  0xD7, 0x12, 0x1B, 0xEA, 0x27, 0x09, 0xDE, 0x31, 0x16, 0xDE, 0x31, 0x16,
  0x00, 0xFB, 0x1F, 0x00, 0xF9, 0x1F, 0x00, 0xF9, 0x27, 0x19, 0xF9, 0x00,
  0x65, 0xFC, 0x00, 0xFF, 0xD6, 0xFF, 0x4B, 0xFC, 0x00, 0xB3, 0xF9, 0x00,
  0xD4, 0xF9, 0x00, 0xD0, 0xF9, 0x00, 0xD7, 0xFF, 0x00, 0x6F, 0x78, 0xE1,
  0xFF, 0xC6, 0x00, 0xD7, 0x12, 0x1B, 0xDE, 0x31, 0x16, 0xDE, 0x31, 0x16,
  0x00, 0xFB, 0x1F, 0x00, 0xF9, 0x27, 0x19, 0xF9, 0x00, 0x74, 0xF9, 0x00,
  0x64, 0xF9, 0x00, 0x54, 0xFC, 0x00, 0x5B, 0xF9, 0x00, 0xB0, 0xFF, 0x00,
  0xD4, 0xF9, 0x00, 0xD4, 0xFF, 0x00, 0xD0, 0xF9, 0x00, 0xD7, 0xFF, 0x00,
  0xC5, 0xFF, 0x00, 0xFF, 0xBA, 0x00, 0xD7, 0x12, 0x1B, 0xDE, 0x31, 0x16,
  0x00, 0xFB, 0x27, 0x19, 0xF9, 0x00, 0x74, 0xF9, 0x00, 0x64, 0xF9, 0x00,
  0x64, 0xF9, 0x00, 0x64, 0xF9, 0x00, 0x57, 0xFF, 0x00, 0xD8, 0xAD, 0xFF,
  0xD5, 0xFF, 0x00, 0x9F, 0x8A, 0xFF, 0xD3, 0xFF, 0x00, 0xCF, 0xF9, 0x00,
  0xCF, 0xF9, 0x00, 0xC5, 0xFF, 0x00, 0xFF, 0xB9, 0x00, 0xD6, 0x12, 0x1B,
  0x1D, 0xFE, 0x00, 0x75, 0xFC, 0x00, 0x65, 0xFC, 0x00, 0x65, 0xFC, 0x00,
  0x65, 0xFC, 0x00, 0x65, 0xFC, 0x00, 0x5B, 0xFC, 0x00, 0xB2, 0xFF, 0x00,
  0xD6, 0xFC, 0x00, 0xD6, 0xFF, 0x00, 0xD2, 0xFC, 0x00, 0xD2, 0xFC, 0x00,
  0xD2, 0xFC, 0x00, 0xD2, 0xFC, 0x00, 0xC7, 0xFF, 0x00, 0xFF, 0xB6, 0x00
};
const unsigned char ASCII_8X8_116[768] = {
  0x00, 0x3F, 0xFC, 0x1A, 0x00, 0xF9, 0x15, 0x00, 0xF9, 0x15, 0x00, 0xF9,
  0x15, 0x00, 0xF9, 0x15, 0x00, 0xF9, 0x01, 0x00, 0xFF, 0x09, 0x00, 0xFF,
  0x6E, 0x00, 0xBC, 0xD2, 0x00, 0xFF, 0xC7, 0x00, 0xF9, 0xC7, 0x00, 0xF9,
  0xC7, 0x00, 0xF9, 0xC7, 0x00, 0xF9, 0xBA, 0x00, 0xFC, 0xFF, 0x00, 0xF4,
  0x00, 0xCB, 0xFB, 0x00, 0x3A, 0xFA, 0x1A, 0x00, 0xF9, 0x15, 0x00, 0xF9,
  0x05, 0x00, 0xFF, 0x01, 0x00, 0xFF, 0xFE, 0xFF, 0x8C, 0x00, 0x00, 0xFF,
  0x62, 0x00, 0xBC, 0xD2, 0x00, 0xFF, 0xC7, 0x00, 0xF9, 0xC7, 0x00, 0xF9,
  0xC7, 0x00, 0xF9, 0xBA, 0x00, 0xFC, 0xFF, 0x00, 0xFA, 0xF9, 0x00, 0x9E,
  0x00, 0xB0, 0xFB, 0x00, 0xC8, 0xF9, 0x00, 0x3B, 0xFA, 0x0A, 0x00, 0xFF,
  0xD6, 0xE0, 0x65, 0x05, 0x00, 0xFF, 0x01, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0xF5, 0xFF, 0xBD, 0xC7, 0x00, 0xFF, 0xC7, 0x00, 0xF9, 0xC7, 0x00, 0xF9,
  0xBA, 0x00, 0xFC, 0xFF, 0x00, 0xFA, 0xF9, 0x00, 0x9E, 0xF9, 0x00, 0xAE,
  0x00, 0xB0, 0xFB, 0x00, 0xAE, 0xF9, 0x00, 0xCE, 0xFF, 0x00, 0x3B, 0xFA,
  0x0A, 0x00, 0xFF, 0x15, 0x00, 0xF9, 0x15, 0x00, 0xF9, 0x09, 0x00, 0xFF,
  0x62, 0x00, 0xBC, 0xD2, 0x00, 0xFF, 0xC3, 0x00, 0xFC, 0xBA, 0x00, 0xFC,
  0xFF, 0x00, 0xFA, 0xF9, 0x00, 0x9E, 0xF9, 0x00, 0xAE, 0xF9, 0x00, 0xAE,
  0x00, 0xB0, 0xFB, 0x00, 0xB4, 0xFF, 0xBB, 0x67, 0x3F, 0x00, 0xCE, 0xFF,
  0x00, 0x3B, 0xFA, 0x1A, 0x00, 0xF9, 0x15, 0x00, 0xF9, 0x09, 0x00, 0xFF,
  0x6E, 0x00, 0xBC, 0xCF, 0x00, 0xFF, 0xE2, 0xFF, 0xD8, 0xFF, 0x00, 0xFD,
  0xF9, 0x00, 0x9E, 0xF9, 0x00, 0xAE, 0xF9, 0x00, 0xAE, 0xF9, 0x00, 0xAE,
  0x00, 0xB0, 0xFB, 0x00, 0xAE, 0xF9, 0x00, 0xB4, 0xFF, 0x00, 0xAE, 0xF9,
  0x00, 0xC9, 0xF9, 0x00, 0x3B, 0xFA, 0x1A, 0x00, 0xF9, 0x09, 0x00, 0xFF,
  0x6E, 0x00, 0xBC, 0xC5, 0x00, 0xFF, 0xFF, 0x00, 0xFD, 0xF9, 0x00, 0x9E,
  0xF9, 0x00, 0xA5, 0xF9, 0x00, 0xAE, 0xF9, 0x00, 0xAE, 0xF9, 0x00, 0xAE,
  0x00, 0xA7, 0xFD, 0x00, 0xA4, 0xFB, 0x00, 0xA5, 0xFB, 0x00, 0xA5, 0xFB,
  0x00, 0xA5, 0xFB, 0x00, 0xBF, 0xFB, 0x00, 0x31, 0xFC, 0x0F, 0x00, 0xFF,
  0x56, 0x00, 0xB9, 0xFF, 0x00, 0xFF, 0xF9, 0x00, 0x9E, 0xF9, 0x00, 0xA5,
  0xF9, 0xFF, 0xFF, 0xF9, 0x00, 0xA5, 0xF9, 0x00, 0xAE, 0xF9, 0x00, 0xAE,
  0x58, 0xFF, 0xFE, 0x56, 0xFF, 0xFC, 0x56, 0xFF, 0xFC, 0x56, 0xFF, 0xFC,
  0x56, 0xFF, 0xFC, 0x56, 0xFF, 0xFC, 0x5F, 0xFF, 0xFA, 0x00, 0x28, 0xFF,
  0xFF, 0x00, 0xFF, 0xFA, 0x00, 0xAB, 0xFA, 0x00, 0xBB, 0xFA, 0x00, 0xBB,
  0xFA, 0x00, 0xB1, 0xFA, 0x00, 0xBB, 0xFA, 0x00, 0xBB, 0xFA, 0x00, 0xBB,
  0x00, 0xFB, 0x37, 0x00, 0xF9, 0x37, 0x00, 0xF9, 0x37, 0x00, 0xF9, 0x21,
  0x00, 0xF9, 0x37, 0x00, 0xF9, 0x37, 0x00, 0xF9, 0x48, 0x00, 0xFF, 0x00,
  0xFF, 0xFF, 0x00, 0xF3, 0x00, 0x4F, 0xF7, 0x00, 0x43, 0xF7, 0x00, 0x43,
  0xF7, 0x00, 0x43, 0xF7, 0x00, 0x43, 0xF7, 0x00, 0x43, 0xF7, 0x00, 0x43,
  0x00, 0xFB, 0x4B, 0x00, 0xF9, 0x4B, 0x00, 0xF9, 0x35, 0xFF, 0xF9, 0xFF,
  0x00, 0xF9, 0x35, 0x00, 0xF9, 0x5C, 0x00, 0xFA, 0x00, 0xA3, 0xF9, 0x00,
  0x97, 0xFF, 0x00, 0xFF, 0xFC, 0x00, 0xD2, 0x3B, 0x16, 0xDA, 0x5C, 0x10,
  0xDA, 0x5C, 0x10, 0xDA, 0x5C, 0x10, 0xDA, 0x5C, 0x10, 0xDA, 0x5C, 0x10,
  0x00, 0xFB, 0x4B, 0x00, 0xF9, 0x4B, 0x00, 0xF9, 0x4B, 0x00, 0xF9, 0x35,
  0x00, 0xF9, 0x5C, 0x00, 0xFD, 0x00, 0x3F, 0xF9, 0x00, 0x8B, 0xF9, 0x00,
  0xAB, 0xF9, 0x00, 0x92, 0xFF, 0x00, 0xFF, 0xF2, 0x00, 0xD5, 0x30, 0x1C,
  0xDD, 0x52, 0x17, 0xE9, 0x4C, 0x0A, 0xDD, 0x52, 0x17, 0xDD, 0x52, 0x17,
  0x00, 0xFB, 0x4B, 0x00, 0xF9, 0x4B, 0x00, 0xF9, 0x4B, 0x00, 0xF9, 0x5C,
  0x00, 0xFD, 0x00, 0xFF, 0xD5, 0xFF, 0x1C, 0xFC, 0x00, 0x8B, 0xF9, 0x00,
  0xAB, 0xF9, 0x00, 0xA7, 0xF9, 0x00, 0x92, 0xFF, 0x00, 0xFF, 0xF2, 0x00,
  0xE1, 0x2B, 0x0F, 0x4C, 0x95, 0xB0, 0xE9, 0x4C, 0x0A, 0xDD, 0x52, 0x17,
  0x00, 0xFB, 0x4B, 0x00, 0xF9, 0x4B, 0x00, 0xF9, 0x5C, 0x00, 0xFA, 0x00,
  0x49, 0xF9, 0x00, 0x25, 0xFC, 0x00, 0x31, 0xF9, 0x00, 0x82, 0xFF, 0x00,
  0xAB, 0xF9, 0x00, 0xA7, 0xF9, 0x00, 0xA7, 0xF9, 0x00, 0x95, 0xFF, 0x00,
  0xFF, 0xF2, 0x00, 0xE1, 0x2B, 0x0F, 0xDD, 0x52, 0x17, 0xDD, 0x52, 0x17,
  0x00, 0xFB, 0x4B, 0x00, 0xF9, 0x5C, 0x00, 0xFA, 0x00, 0x49, 0xF9, 0x00,
  0x3A, 0xF9, 0x00, 0x3A, 0xF9, 0x00, 0x28, 0xFF, 0x00, 0xEE, 0xB1, 0xFF,
  0xA3, 0xFF, 0x00, 0xA6, 0xFF, 0x00, 0xA9, 0xFF, 0x00, 0x8C, 0x63, 0xE1,
  0x95, 0xFF, 0x00, 0xFF, 0xF2, 0x00, 0xD5, 0x30, 0x1C, 0xDD, 0x52, 0x17,
  0x00, 0xFB, 0x5C, 0x00, 0xF9, 0x00, 0x49, 0xF9, 0x00, 0x3A, 0xF9, 0x00,
  0x3A, 0xF9, 0x00, 0x3A, 0xF9, 0x00, 0x31, 0xF9, 0x00, 0x82, 0xFF, 0x00,
  0xAA, 0xFF, 0x00, 0xB4, 0x8B, 0xFF, 0xA6, 0xFF, 0x00, 0xA9, 0xFF, 0x00,
  0xA7, 0xF9, 0x00, 0x92, 0xFF, 0x00, 0xFF, 0xF1, 0x00, 0xD5, 0x30, 0x1C,
  0x00, 0xFE, 0x00, 0x49, 0xFB, 0x00, 0x3B, 0xFC, 0x00, 0x3B, 0xFC, 0x00,
  0x3B, 0xFC, 0x00, 0x3B, 0xFC, 0x00, 0x31, 0xFC, 0x00, 0x8C, 0xFC, 0x00,
  0xAD, 0xFC, 0x00, 0xA8, 0xFF, 0x00, 0xA9, 0xFC, 0x00, 0xA9, 0xFC, 0x00,
  0xA9, 0xFC, 0x00, 0xA9, 0xFC, 0x00, 0x94, 0xFF, 0x00, 0xFF, 0xE7, 0x00
};
const unsigned char ASCII_8X8_117[768] = {
  0x00, 0x0A, 0xFC, 0x53, 0x00, 0xF9, 0x42, 0x00, 0xF9, 0x42, 0x00, 0xF9,
  0x38, 0x00, 0xFF, 0x42, 0x00, 0xF9, 0x34, 0x00, 0xFF, 0x38, 0x00, 0xFF,
  0x90, 0x00, 0xBD, 0xFF, 0x00, 0xFF, 0xF5, 0x00, 0xF9, 0xF5, 0x00, 0xF9,
  0xF5, 0x00, 0xF9, 0xF5, 0x00, 0xF9, 0xF4, 0x00, 0xFF, 0xFA, 0x00, 0xC1,
  0x00, 0x9C, 0xFB, 0x00, 0x00, 0xF9, 0x53, 0x00, 0xF9, 0x38, 0x00, 0xFF,
  0xC0, 0xE1, 0x65, 0x2A, 0x00, 0xFF, 0xE9, 0xFF, 0x8D, 0x2A, 0x00, 0xFF,
  0x90, 0x00, 0xBD, 0xFF, 0x00, 0xFF, 0xF5, 0x00, 0xF9, 0xF5, 0x00, 0xF9,
  0xF5, 0x00, 0xF9, 0xF4, 0x00, 0xFF, 0xFA, 0x00, 0xC2, 0xF9, 0x00, 0x70,
  0x00, 0x81, 0xFB, 0x00, 0x9A, 0xF9, 0x00, 0x00, 0xFF, 0x53, 0x00, 0xF9,
  0x38, 0x00, 0xFF, 0x42, 0x00, 0xF9, 0x34, 0x00, 0xFF, 0x38, 0x00, 0xFF,
  0x89, 0x00, 0xBD, 0xFF, 0x00, 0xFF, 0xF5, 0x00, 0xF9, 0xF5, 0x00, 0xF9,
  0xF4, 0x00, 0xFF, 0xFA, 0x00, 0xC2, 0xF9, 0x00, 0x70, 0xF9, 0x00, 0x80,
  0x00, 0x81, 0xFB, 0x00, 0x80, 0xFF, 0xBB, 0x98, 0x41, 0x00, 0x00, 0xFF,
  0x53, 0x00, 0xF9, 0x42, 0x00, 0xF9, 0x42, 0x00, 0xF9, 0x31, 0x00, 0xFF,
  0xE0, 0xFF, 0xBB, 0xFB, 0x00, 0xFF, 0xF5, 0x00, 0xF9, 0xF4, 0x00, 0xFF,
  0xFA, 0x00, 0xC2, 0xF9, 0x00, 0x70, 0xF9, 0x00, 0x80, 0xF9, 0x00, 0x80,
  0x00, 0x81, 0xFB, 0x00, 0x7F, 0xF9, 0x00, 0x80, 0xFF, 0x00, 0x9A, 0xF9,
  0x00, 0x00, 0xF9, 0x53, 0x00, 0xF9, 0x42, 0x00, 0xF9, 0x38, 0x00, 0xFF,
  0x89, 0x00, 0xBD, 0xFF, 0x00, 0xFF, 0xF7, 0x00, 0xFF, 0xFA, 0x00, 0xC2,
  0xF9, 0x00, 0x70, 0xF9, 0x00, 0x80, 0xF9, 0x00, 0x80, 0xF9, 0x00, 0x80,
  0x00, 0x81, 0xFB, 0x00, 0x7F, 0xF9, 0x00, 0x80, 0xF9, 0x00, 0x80, 0xF9,
  0x00, 0x9A, 0xF9, 0x00, 0x00, 0xF9, 0x53, 0x00, 0xF9, 0x38, 0x00, 0xFF,
  0x90, 0x00, 0xBD, 0xFF, 0x00, 0xFF, 0xD5, 0xFF, 0xF2, 0xFC, 0x00, 0x6C,
  0xF9, 0x00, 0x71, 0xF9, 0x00, 0x80, 0xF9, 0x00, 0x80, 0xF9, 0x00, 0x80,
  0x00, 0x73, 0xFB, 0x00, 0x72, 0xF9, 0x00, 0x73, 0xF9, 0x00, 0x73, 0xF9,
  0x00, 0x73, 0xF9, 0x00, 0x8D, 0xF9, 0x00, 0x00, 0xF9, 0x49, 0x00, 0xFF,
  0x83, 0x00, 0xC5, 0xFF, 0x00, 0xC8, 0xFC, 0x00, 0x6C, 0xF9, 0x00, 0x71,
  0xF9, 0xFF, 0xFF, 0xF9, 0x00, 0x71, 0xF9, 0x00, 0x80, 0xF9, 0x00, 0x80,
  0x58, 0xF5, 0xFF, 0x56, 0xF2, 0xFF, 0x56, 0xF2, 0xFF, 0x56, 0xF2, 0xFF,
  0x56, 0xF2, 0xFF, 0x56, 0xF2, 0xFF, 0x5F, 0xFF, 0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0xD8, 0xFA, 0x00, 0x7D, 0xFA, 0x00, 0x8D, 0xFA, 0x00, 0x8D,
  0xFA, 0x00, 0x7E, 0xFA, 0x00, 0x8D, 0xFA, 0x00, 0x8D, 0xFA, 0x00, 0x8D,
  0x00, 0xFE, 0x69, 0x00, 0xFB, 0x68, 0x00, 0xFC, 0x68, 0x00, 0xFC, 0x58,
  0x00, 0xFC, 0x68, 0x00, 0xFC, 0x68, 0x00, 0xFC, 0x79, 0x00, 0xFF, 0x24,
  0xFF, 0xFF, 0x00, 0xF7, 0x00, 0x17, 0xF8, 0x00, 0x11, 0xF8, 0x00, 0x11,
  0xF8, 0x00, 0x11, 0xF8, 0x00, 0x11, 0xF8, 0x00, 0x11, 0xF8, 0x00, 0x11,
  0x00, 0xFB, 0x7A, 0x00, 0xF9, 0x78, 0x00, 0xF9, 0x68, 0xFF, 0xF9, 0xFF,
  0x00, 0xF9, 0x68, 0x00, 0xFC, 0x74, 0x00, 0xF9, 0x34, 0x69, 0xF9, 0x00,
  0x60, 0xF9, 0x00, 0xFF, 0xFF, 0x00, 0xD7, 0x65, 0x1A, 0xDB, 0x85, 0x15,
  0xDB, 0x85, 0x15, 0xDB, 0x85, 0x15, 0xDB, 0x85, 0x15, 0xDB, 0x85, 0x15,
  0x00, 0xFB, 0x7A, 0x00, 0xF9, 0x78, 0x00, 0xF9, 0x79, 0x00, 0xF9, 0x68,
  0x00, 0xFC, 0x74, 0xFF, 0xD4, 0xFF, 0x00, 0xFC, 0x00, 0x5C, 0xF9, 0x00,
  0x7D, 0xF9, 0x00, 0x5B, 0xF9, 0x00, 0xFF, 0xFF, 0x00, 0xDA, 0x56, 0x1B,
  0xDE, 0x77, 0x16, 0xDE, 0x77, 0x16, 0xDE, 0x77, 0x16, 0xDE, 0x77, 0x16,
  0x00, 0xFB, 0x7A, 0x00, 0xF9, 0x78, 0x00, 0xF9, 0x79, 0x00, 0xF9, 0x89,
  0x00, 0xF9, 0x34, 0x00, 0xFC, 0x00, 0x02, 0xF9, 0x00, 0x4E, 0xFF, 0x00,
  0x7D, 0xF9, 0x00, 0x79, 0xF9, 0x00, 0x5B, 0xF9, 0x00, 0xFF, 0xFF, 0x00,
  0xDA, 0x56, 0x1B, 0xEA, 0x76, 0x08, 0xDE, 0x77, 0x16, 0xDE, 0x77, 0x16,
  0x00, 0xFB, 0x7A, 0x00, 0xF9, 0x78, 0x00, 0xF9, 0x89, 0x00, 0xF9, 0x34,
  0x0F, 0xF9, 0x00, 0x0C, 0xF9, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0xAF, 0xFF,
  0x6F, 0xFF, 0x00, 0x79, 0xF9, 0x00, 0x79, 0xF9, 0x00, 0x5B, 0xF9, 0x00,
  0xFF, 0xFF, 0x00, 0x49, 0x61, 0xB8, 0xEA, 0x76, 0x08, 0xDE, 0x77, 0x16,
  0x00, 0xFB, 0x7A, 0x00, 0xF9, 0x89, 0x00, 0xF9, 0x34, 0x0F, 0xF9, 0x00,
  0x0C, 0xF9, 0x00, 0x0C, 0xF9, 0x00, 0x02, 0xF9, 0x00, 0x4E, 0xFF, 0x00,
  0x7D, 0xF9, 0x00, 0x71, 0xFF, 0x00, 0x79, 0xF9, 0x00, 0x75, 0xFF, 0x00,
  0x5B, 0xF9, 0x00, 0xFF, 0xFF, 0x00, 0xDA, 0x56, 0x1B, 0xDE, 0x77, 0x16,
  0x00, 0xFB, 0x8A, 0x00, 0xF9, 0x34, 0x0F, 0xF9, 0x00, 0x0C, 0xF9, 0x00,
  0x0C, 0xF9, 0x00, 0x0C, 0xF9, 0x00, 0x02, 0xF9, 0x00, 0x5C, 0xF9, 0x00,
  0x76, 0xFF, 0x00, 0xCD, 0x8D, 0xFF, 0x6E, 0xFF, 0x00, 0xA5, 0x64, 0xE2,
  0x75, 0xFF, 0x00, 0x5B, 0xF9, 0x00, 0xFF, 0xFF, 0x00, 0xDA, 0x56, 0x1B,
  0x00, 0xFE, 0x35, 0x0E, 0xFC, 0x00, 0x0B, 0xFC, 0x00, 0x0B, 0xFC, 0x00,
  0x0B, 0xFC, 0x00, 0x0B, 0xFC, 0x00, 0x02, 0xFC, 0x00, 0x5D, 0xFC, 0x00,
  0x7E, 0xFC, 0x00, 0x73, 0xFF, 0x00, 0x7A, 0xFC, 0x00, 0x76, 0xFF, 0x00,
  0x7A, 0xFC, 0x00, 0x7A, 0xFC, 0x00, 0x5C, 0xFC, 0x00, 0xFF, 0xFF, 0x00
};
const unsigned char ASCII_8X8_118[768] = {
  0x0D, 0x00, 0xFC, 0x80, 0x00, 0xF9, 0x6B, 0x00, 0xF9, 0x6B, 0x00, 0xF9,
  0x65, 0x00, 0xFF, 0x6B, 0x00, 0xF9, 0x6B, 0x00, 0xF9, 0x61, 0x00, 0xFF,
  0xB7, 0x00, 0xC0, 0xFF, 0x00, 0xD4, 0xF9, 0x00, 0xD3, 0xF9, 0x00, 0xD3,
  0xF9, 0x00, 0xD3, 0xF9, 0x00, 0xD3, 0xF9, 0x00, 0xE2, 0xF9, 0x00, 0x96,
  0x00, 0x6E, 0xFB, 0x06, 0x00, 0xF9, 0x73, 0x00, 0xFF, 0x65, 0x00, 0xFF,
  0xAB, 0xE0, 0x63, 0x65, 0x00, 0xFF, 0x62, 0x00, 0xFF, 0x61, 0x00, 0xFF,
  0xB7, 0x00, 0xC0, 0xFF, 0x00, 0xD4, 0xF9, 0x00, 0xD3, 0xF9, 0x00, 0xD3,
  0xF9, 0x00, 0xD3, 0xF9, 0x00, 0xE2, 0xF9, 0x00, 0x97, 0xF9, 0x00, 0x47,
  0x00, 0x58, 0xFB, 0x00, 0x5D, 0xFF, 0xA4, 0xA9, 0x40, 0x73, 0x00, 0xFF,
  0x65, 0x00, 0xFF, 0x62, 0x00, 0xFF, 0xD3, 0xFF, 0x8B, 0x59, 0x00, 0xFF,
  0xB7, 0x00, 0xC0, 0xFF, 0x00, 0xD4, 0xF9, 0x00, 0xD3, 0xF9, 0x00, 0xD3,
  0xF9, 0x00, 0xE2, 0xF9, 0x00, 0x97, 0xF9, 0x00, 0x47, 0xF9, 0x00, 0x57,
  0x00, 0x58, 0xFB, 0x00, 0x57, 0xF9, 0x00, 0x5D, 0xFF, 0x06, 0x00, 0xFA,
  0x80, 0x00, 0xF9, 0x6B, 0x00, 0xF9, 0x62, 0x00, 0xFF, 0x61, 0x00, 0xFF,
  0xB5, 0x00, 0xC1, 0xFF, 0x00, 0xD4, 0xF9, 0x00, 0xD3, 0xF9, 0x00, 0xE2,
  0xF9, 0x00, 0x97, 0xF9, 0x00, 0x47, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57,
  0x00, 0x58, 0xFB, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x6D, 0xF9,
  0x06, 0x00, 0xFA, 0x80, 0x00, 0xF9, 0x6B, 0x00, 0xF9, 0x5F, 0x00, 0xFF,
  0xD1, 0xFF, 0xC0, 0xFF, 0x00, 0xD4, 0xF9, 0x00, 0xE2, 0xF9, 0x00, 0x97,
  0xF9, 0x00, 0x47, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57,
  0x00, 0x58, 0xFB, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9,
  0x00, 0x6D, 0xF9, 0x06, 0x00, 0xFA, 0x80, 0x00, 0xF9, 0x61, 0x00, 0xFF,
  0xB5, 0x00, 0xC1, 0xFF, 0x00, 0xE3, 0xFC, 0x00, 0x85, 0xF9, 0x00, 0x47,
  0xF9, 0x00, 0x43, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57,
  0x00, 0x4A, 0xFB, 0x00, 0x48, 0xF9, 0x00, 0x49, 0xF9, 0x00, 0x49, 0xF9,
  0x00, 0x49, 0xF9, 0x00, 0x5E, 0xF9, 0x00, 0x00, 0xF9, 0x76, 0x00, 0xFF,
  0xAE, 0x00, 0xCE, 0xFF, 0x00, 0x87, 0xD5, 0xFF, 0xFF, 0xFC, 0x00, 0x31,
  0xF9, 0xFF, 0xFF, 0xF9, 0x00, 0x43, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x57,
  0x56, 0xD5, 0xFF, 0x56, 0xD2, 0xFF, 0x56, 0xD2, 0xFF, 0x56, 0xD2, 0xFF,
  0x56, 0xD2, 0xFF, 0x56, 0xD2, 0xFF, 0x59, 0xF6, 0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x9E, 0xFA, 0x00, 0x52, 0xFD, 0x00, 0x51, 0xFA, 0x00, 0x62,
  0xFA, 0x00, 0x4E, 0xFA, 0x00, 0x62, 0xFA, 0x00, 0x62, 0xFA, 0x00, 0x62,
  0x00, 0xFF, 0x98, 0x00, 0xFF, 0x97, 0x00, 0xFF, 0x97, 0x00, 0xFF, 0x8C,
  0x00, 0xFF, 0x97, 0x00, 0xFF, 0x8F, 0x00, 0xFF, 0xA8, 0x00, 0xFF, 0x5D,
  0xDD, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0xF6, 0x00, 0x00, 0xF6, 0x00, 0x00,
  0xF6, 0x00, 0x00, 0xF6, 0x00, 0x00, 0xF6, 0x00, 0x00, 0xF6, 0x00, 0x00,
  0x00, 0xFB, 0xA3, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0x97, 0xFF, 0xF9, 0xFF,
  0x00, 0xFC, 0x8F, 0xFF, 0xD5, 0xFF, 0x00, 0xFC, 0x5C, 0x36, 0xF9, 0x00,
  0x35, 0xF9, 0x00, 0xD7, 0xFF, 0x00, 0xE0, 0x92, 0x1E, 0xDA, 0xAA, 0x18,
  0xDA, 0xAA, 0x18, 0xDA, 0xAA, 0x18, 0xDA, 0xAA, 0x18, 0xDA, 0xAA, 0x18,
  0x00, 0xFB, 0xA3, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0x97,
  0x00, 0xF9, 0xB3, 0x00, 0xFC, 0x58, 0x00, 0xF9, 0x0F, 0x1D, 0xFF, 0x00,
  0x52, 0xF9, 0x00, 0x31, 0xF9, 0x00, 0xDA, 0xFF, 0x00, 0xE3, 0x80, 0x1B,
  0xDD, 0x98, 0x16, 0xDD, 0x98, 0x16, 0xDD, 0x98, 0x16, 0xDD, 0x98, 0x16,
  0x00, 0xFB, 0xA3, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0xB3,
  0x00, 0xF9, 0x60, 0x00, 0xF9, 0x0C, 0x00, 0xFF, 0x07, 0xFF, 0xAE, 0xFF,
  0x3F, 0xFF, 0x00, 0x4E, 0xF9, 0x00, 0x31, 0xF9, 0x00, 0xDA, 0xFF, 0x00,
  0xE3, 0x80, 0x1B, 0xDD, 0x98, 0x16, 0xDD, 0x98, 0x16, 0xDD, 0x98, 0x16,
  0x00, 0xFB, 0xA3, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0xB3, 0x00, 0xF9, 0x60,
  0x00, 0xF9, 0x0C, 0x00, 0xF9, 0x1C, 0x00, 0xF9, 0x20, 0x1D, 0xFF, 0x00,
  0x52, 0xF9, 0x00, 0x42, 0xFF, 0x00, 0x4E, 0xF9, 0x00, 0x31, 0xF9, 0x00,
  0xDA, 0xFF, 0x00, 0xEB, 0x8F, 0x0B, 0xDD, 0x98, 0x16, 0xDD, 0x98, 0x16,
  0x00, 0xFB, 0xA3, 0x00, 0xF9, 0xB2, 0x00, 0xF9, 0x60, 0x00, 0xF9, 0x0C,
  0x00, 0xF9, 0x1C, 0x00, 0xF9, 0x1C, 0x00, 0xF9, 0x20, 0x30, 0xF9, 0x00,
  0x46, 0xFF, 0x00, 0xE1, 0x8B, 0xFF, 0x42, 0xFF, 0x00, 0x45, 0xFF, 0x00,
  0x39, 0xFF, 0x00, 0x74, 0x5A, 0xB8, 0xEB, 0x8F, 0x0B, 0xDD, 0x98, 0x16,
  0x00, 0xFB, 0xB4, 0x00, 0xF9, 0x60, 0x00, 0xF9, 0x0C, 0x00, 0xF9, 0x1C,
  0x00, 0xF9, 0x1C, 0x00, 0xF9, 0x1C, 0x00, 0xF9, 0x20, 0x30, 0xF9, 0x00,
  0x52, 0xF9, 0x00, 0x42, 0xFF, 0x00, 0x45, 0xFF, 0x00, 0xB9, 0x63, 0xE0,
  0x45, 0xFF, 0x00, 0x39, 0xFF, 0x00, 0xDA, 0xFF, 0x00, 0xE3, 0x80, 0x1B,
  0x00, 0xFE, 0x61, 0x00, 0xFC, 0x0C, 0x00, 0xFC, 0x1D, 0x00, 0xFC, 0x1D,
  0x00, 0xFC, 0x1D, 0x00, 0xFC, 0x1D, 0x00, 0xFC, 0x20, 0x2F, 0xFC, 0x00,
  0x53, 0xFC, 0x00, 0x4F, 0xFC, 0x00, 0x4F, 0xFC, 0x00, 0x46, 0xFF, 0x00,
  0x4F, 0xFC, 0x00, 0x4F, 0xFC, 0x00, 0x31, 0xFC, 0x00, 0xD0, 0xFF, 0x00
};
const unsigned char ASCII_8X8_119[768] = {
  0x45, 0x00, 0xFC, 0xB4, 0x00, 0xF9, 0xA2, 0x00, 0xFF, 0x9E, 0x00, 0xF9,
  0x9F, 0x00, 0xFF, 0x9E, 0x00, 0xF9, 0x9E, 0x00, 0xF9, 0x99, 0x00, 0xFF,
  0xC9, 0x00, 0xAB, 0xFF, 0x00, 0xA0, 0xF9, 0x00, 0xA2, 0xF9, 0x00, 0xA2,
  0xF9, 0x00, 0xA2, 0xF9, 0x00, 0xA2, 0xF9, 0x00, 0xB2, 0xF9, 0x00, 0x63,
  0x00, 0x2E, 0xFB, 0x45, 0x00, 0xFF, 0x83, 0xBF, 0x43, 0xA3, 0x00, 0xFF,
  0x92, 0xE2, 0x65, 0x9F, 0x00, 0xFF, 0x9E, 0x00, 0xF9, 0x99, 0x00, 0xFF,
  0xC9, 0x00, 0xAB, 0xFF, 0x00, 0xA0, 0xF9, 0x00, 0xA2, 0xF9, 0x00, 0xA2,
  0xF9, 0x00, 0xA2, 0xF9, 0x00, 0xB2, 0xF9, 0x00, 0x63, 0xF9, 0x00, 0x15,
  0x00, 0x24, 0xFB, 0x00, 0x2E, 0xF9, 0x45, 0x00, 0xFF, 0xB4, 0x00, 0xF9,
  0x9F, 0x00, 0xFF, 0x9E, 0x00, 0xF9, 0x9C, 0x00, 0xFF, 0x99, 0x00, 0xFF,
  0xC9, 0x00, 0xAB, 0xFF, 0x00, 0xA0, 0xF9, 0x00, 0xA2, 0xF9, 0x00, 0xA2,
  0xF9, 0x00, 0xB2, 0xF9, 0x00, 0x63, 0xF9, 0x00, 0x15, 0xF9, 0x00, 0x24,
  0x00, 0x24, 0xFB, 0x00, 0x24, 0xF9, 0x00, 0x2E, 0xF9, 0x41, 0x00, 0xFA,
  0xB4, 0x00, 0xF9, 0x9C, 0x00, 0xFF, 0xB7, 0xFF, 0x8A, 0x97, 0x00, 0xFF,
  0xC9, 0x00, 0xAB, 0xFF, 0x00, 0xA0, 0xF9, 0x00, 0xA2, 0xF9, 0x00, 0xB2,
  0xF9, 0x00, 0x63, 0xF9, 0x00, 0x15, 0xF9, 0x00, 0x24, 0xF9, 0x00, 0x24,
  0x00, 0x24, 0xFB, 0x00, 0x24, 0xF9, 0x00, 0x24, 0xF9, 0x00, 0x2E, 0xF9,
  0x41, 0x00, 0xFA, 0xB4, 0x00, 0xF9, 0x9C, 0x00, 0xFF, 0x99, 0x00, 0xFF,
  0xC9, 0x00, 0xA8, 0xFF, 0x00, 0xA0, 0xF9, 0x00, 0xB2, 0xF9, 0x00, 0x63,
  0xF9, 0x00, 0x15, 0xF9, 0x00, 0x24, 0xF9, 0x00, 0x24, 0xF9, 0x00, 0x24,
  0x00, 0x24, 0xFB, 0x00, 0x24, 0xF9, 0x00, 0x24, 0xF9, 0x00, 0x24, 0xF9,
  0x00, 0x2E, 0xF9, 0x41, 0x00, 0xFA, 0xB4, 0x00, 0xF9, 0x99, 0x00, 0xFF,
  0xC6, 0xFF, 0xCC, 0xFF, 0x00, 0xAD, 0xFC, 0x00, 0x4B, 0xF9, 0x00, 0x15,
  0xF9, 0x00, 0x0A, 0xF9, 0x00, 0x24, 0xF9, 0x00, 0x24, 0xF9, 0x00, 0x24,
  0x00, 0x14, 0xFB, 0x00, 0x14, 0xF9, 0x00, 0x14, 0xF9, 0x00, 0x14, 0xF9,
  0x00, 0x14, 0xF9, 0x00, 0x1D, 0xF9, 0x39, 0x00, 0xFA, 0xAF, 0x00, 0xFF,
  0xC3, 0x00, 0xBA, 0xFF, 0x00, 0x49, 0xD6, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
  0xF9, 0xFF, 0xFF, 0xF9, 0x00, 0x0A, 0xF9, 0x00, 0x24, 0xF9, 0x00, 0x24,
  0x57, 0xAD, 0xFF, 0x57, 0xAC, 0xFE, 0x57, 0xAC, 0xFE, 0x57, 0xAC, 0xFE,
  0x57, 0xAC, 0xFE, 0x57, 0xAC, 0xFE, 0x4E, 0xC5, 0xFE, 0x2D, 0x00, 0xFF,
  0xFF, 0x00, 0x5A, 0xFA, 0x00, 0x19, 0xFD, 0x00, 0x11, 0xFA, 0x00, 0x29,
  0xFA, 0x00, 0x0E, 0xFA, 0x00, 0x29, 0xFA, 0x00, 0x29, 0xFA, 0x00, 0x29,
  0x00, 0xFF, 0xD1, 0x00, 0xFF, 0xCF, 0x00, 0xFF, 0xCF, 0x00, 0xFF, 0xCA,
  0x00, 0xFF, 0xCF, 0x00, 0xFF, 0xCD, 0x00, 0xFF, 0xE0, 0x00, 0xFF, 0x9F,
  0x99, 0xFF, 0x00, 0xFF, 0x16, 0x00, 0xF6, 0x35, 0x00, 0xF6, 0x35, 0x00,
  0xF6, 0x35, 0x00, 0xF6, 0x35, 0x00, 0xF6, 0x35, 0x00, 0xF6, 0x35, 0x00,
  0x00, 0xFB, 0xD6, 0x00, 0xF9, 0xD3, 0x00, 0xF9, 0xCF, 0xFF, 0xF9, 0xFF,
  0x00, 0xFC, 0xCD, 0xFF, 0xD6, 0xF9, 0x00, 0xFC, 0x98, 0x00, 0xFF, 0x00,
  0x03, 0xF9, 0x00, 0x99, 0xFF, 0x00, 0xED, 0xC0, 0x1E, 0xDA, 0xCF, 0x18,
  0xDA, 0xCF, 0x18, 0xDA, 0xCF, 0x18, 0xDA, 0xCF, 0x18, 0xDA, 0xCF, 0x18,
  0x00, 0xFB, 0xD6, 0x00, 0xF9, 0xD3, 0x00, 0xF9, 0xD4, 0x00, 0xF9, 0xCF,
  0x00, 0xF9, 0xE4, 0x00, 0xFC, 0x8F, 0x00, 0xFF, 0x2E, 0xFF, 0xAF, 0xFF,
  0x07, 0xFF, 0x00, 0x00, 0xF9, 0x00, 0x9C, 0xFF, 0x00, 0xEF, 0xB0, 0x1B,
  0xDD, 0xBF, 0x16, 0xDD, 0xBF, 0x16, 0xDD, 0xBF, 0x16, 0xDD, 0xBF, 0x16,
  0x00, 0xFB, 0xD6, 0x00, 0xF9, 0xD3, 0x00, 0xF9, 0xD4, 0x00, 0xF9, 0xE4,
  0x00, 0xF9, 0x91, 0x00, 0xF9, 0x3D, 0x00, 0xF9, 0x57, 0x00, 0xFF, 0x00,
  0x20, 0xF9, 0x00, 0x0A, 0xFF, 0x00, 0x00, 0xF9, 0x00, 0x9C, 0xFF, 0x00,
  0xEF, 0xB0, 0x1B, 0xDD, 0xBF, 0x16, 0xDD, 0xBF, 0x16, 0xDD, 0xBF, 0x16,
  0x00, 0xFB, 0xD6, 0x00, 0xF9, 0xD3, 0x00, 0xF9, 0xE4, 0x00, 0xF9, 0x91,
  0x00, 0xF9, 0x3D, 0x00, 0xF9, 0x4E, 0x00, 0xF9, 0x57, 0x00, 0xF9, 0x00,
  0x0E, 0xFF, 0x00, 0xF8, 0x8A, 0xFF, 0x0A, 0xFF, 0x00, 0x00, 0xF9, 0x00,
  0x9C, 0xFF, 0x00, 0xEF, 0xB0, 0x1B, 0xDD, 0xBF, 0x16, 0xDD, 0xBF, 0x16,
  0x00, 0xFB, 0xD6, 0x00, 0xF9, 0xE4, 0x00, 0xF9, 0x91, 0x00, 0xF9, 0x3D,
  0x00, 0xF9, 0x4E, 0x00, 0xF9, 0x4E, 0x00, 0xF9, 0x57, 0x00, 0xF9, 0x00,
  0x20, 0xF9, 0x00, 0x0A, 0xFF, 0x00, 0x1C, 0xF9, 0x00, 0x0D, 0xFF, 0x00,
  0x00, 0xF9, 0x00, 0x8F, 0xFF, 0x00, 0xEF, 0xB0, 0x1B, 0xDD, 0xBF, 0x16,
  0x00, 0xFB, 0xE7, 0x00, 0xF9, 0x91, 0x00, 0xF9, 0x3D, 0x00, 0xF9, 0x4E,
  0x00, 0xF9, 0x4E, 0x00, 0xF9, 0x4E, 0x00, 0xF9, 0x57, 0x00, 0xF9, 0x00,
  0x20, 0xF9, 0x00, 0x1C, 0xF9, 0x00, 0x0D, 0xFF, 0x00, 0xD3, 0x65, 0xE2,
  0x01, 0xFF, 0x00, 0x91, 0x42, 0xBF, 0x8F, 0xFF, 0x00, 0xEF, 0xB0, 0x1B,
  0x00, 0xFE, 0x93, 0x00, 0xFC, 0x3E, 0x00, 0xFC, 0x4F, 0x00, 0xFC, 0x4F,
  0x00, 0xFC, 0x4F, 0x00, 0xFC, 0x4F, 0x00, 0xFC, 0x58, 0x00, 0xFC, 0x00,
  0x20, 0xFC, 0x00, 0x1D, 0xFC, 0x00, 0x1D, 0xFC, 0x00, 0x0D, 0xFF, 0x00,
  0x1D, 0xFC, 0x00, 0x10, 0xFF, 0x00, 0x00, 0xFC, 0x00, 0x98, 0xFF, 0x00
};
const unsigned char ASCII_8X8_120[768] = {
  0x70, 0x00, 0xFC, 0xD7, 0x00, 0xF9, 0xCB, 0x00, 0xFF, 0xC2, 0x00, 0xF9,
  0xC2, 0x00, 0xF9, 0xC2, 0x00, 0xF9, 0xC2, 0x00, 0xF9, 0xC1, 0x00, 0xFF,
  0xC3, 0x00, 0x8D, 0xFF, 0x00, 0x79, 0xF9, 0x00, 0x7D, 0xF9, 0x00, 0x7D,
  0xF9, 0x00, 0x7D, 0xF9, 0x00, 0x7D, 0xF9, 0x00, 0x8C, 0xF9, 0x00, 0x3E,
  0x00, 0x00, 0xFB, 0x7A, 0x00, 0xFF, 0x6F, 0xBB, 0x43, 0xCB, 0x00, 0xFF,
  0xC7, 0x00, 0xFF, 0xC2, 0x00, 0xF9, 0xC2, 0x00, 0xF9, 0xC1, 0x00, 0xFF,
  0xC3, 0x00, 0x8D, 0xFF, 0x00, 0x79, 0xF9, 0x00, 0x7D, 0xF9, 0x00, 0x7D,
  0xF9, 0x00, 0x7D, 0xF9, 0x00, 0x8C, 0xF9, 0x00, 0x3E, 0xF9, 0x00, 0x00,
  0x00, 0x00, 0xFB, 0x00, 0x00, 0xF9, 0x7A, 0x00, 0xFF, 0xDD, 0x00, 0xFF,
  0x80, 0xE1, 0x65, 0xC7, 0x00, 0xFF, 0xC2, 0x00, 0xF9, 0xC1, 0x00, 0xFF,
  0xC3, 0x00, 0x8D, 0xFF, 0x00, 0x79, 0xF9, 0x00, 0x7D, 0xF9, 0x00, 0x7D,
  0xF9, 0x00, 0x8C, 0xF9, 0x00, 0x3E, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00,
  0x00, 0x00, 0xFB, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x71, 0x00, 0xFA,
  0xDD, 0x00, 0xFF, 0xC2, 0x00, 0xF9, 0xC4, 0x00, 0xFF, 0xC1, 0x00, 0xFF,
  0xC3, 0x00, 0x8D, 0xFF, 0x00, 0x79, 0xF9, 0x00, 0x7D, 0xF9, 0x00, 0x8C,
  0xF9, 0x00, 0x3E, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00,
  0x00, 0x00, 0xFB, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9,
  0x71, 0x00, 0xFA, 0xDA, 0x00, 0xFF, 0xA4, 0xFF, 0x88, 0xC4, 0x00, 0xFF,
  0xC3, 0x00, 0x8D, 0xFF, 0x00, 0x79, 0xF9, 0x00, 0x8C, 0xF9, 0x00, 0x3E,
  0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00,
  0x00, 0x00, 0xFB, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9,
  0x00, 0x00, 0xF9, 0x71, 0x00, 0xFA, 0xDA, 0x00, 0xFF, 0xC1, 0x00, 0xFF,
  0xC3, 0x00, 0x86, 0xFF, 0x00, 0x89, 0xFC, 0x00, 0x22, 0xF9, 0x00, 0x00,
  0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00,
  0x00, 0x00, 0xFB, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9,
  0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x69, 0x00, 0xFA, 0xD7, 0x00, 0xFF,
  0xBE, 0xFF, 0xEC, 0xFF, 0x00, 0x18, 0xD6, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
  0xF9, 0xFF, 0xFF, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x00, 0x00,
  0x57, 0x8F, 0xFC, 0x57, 0x8E, 0xFB, 0x57, 0x8E, 0xFB, 0x57, 0x8E, 0xFB,
  0x57, 0x8E, 0xFB, 0x57, 0x8E, 0xFB, 0x44, 0xA0, 0xFC, 0x62, 0x00, 0xFF,
  0xFF, 0x00, 0x25, 0xFA, 0x00, 0x00, 0xFD, 0x00, 0x00, 0xFA, 0x00, 0x00,
  0xFA, 0x00, 0x00, 0xFA, 0x00, 0x00, 0xFA, 0x00, 0x00, 0xFA, 0x00, 0x00,
  0x00, 0xFF, 0xFB, 0x00, 0xFF, 0xF9, 0x00, 0xFF, 0xF9, 0x00, 0xFF, 0xF9,
  0x00, 0xFF, 0xF9, 0x00, 0xFF, 0xFC, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xBA,
  0x64, 0xFF, 0x00, 0xFF, 0x47, 0x00, 0xF6, 0x5E, 0x00, 0xF6, 0x5E, 0x00,
  0xF6, 0x5E, 0x00, 0xF6, 0x5E, 0x00, 0xF6, 0x5E, 0x00, 0xF6, 0x5E, 0x00,
  0x00, 0xFB, 0xFB, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0xFF, 0xF9, 0xF9,
  0x00, 0xFC, 0xFC, 0xFF, 0xD6, 0xE6, 0x00, 0xFF, 0xAF, 0xFF, 0xB1, 0xFA,
  0x00, 0xFF, 0x00, 0x68, 0xFF, 0x00, 0xF6, 0xE6, 0x1E, 0xDA, 0xED, 0x18,
  0xDA, 0xED, 0x18, 0xDA, 0xED, 0x18, 0xDA, 0xED, 0x18, 0xDA, 0xED, 0x18,
  0x00, 0xFB, 0xFB, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9,
  0x00, 0xF9, 0xFF, 0x00, 0xFC, 0xB9, 0x00, 0xF9, 0x6D, 0x00, 0xFF, 0x10,
  0x00, 0xF9, 0x04, 0x00, 0xFF, 0x00, 0x6A, 0xFF, 0x00, 0xF9, 0xD6, 0x1B,
  0xDD, 0xDD, 0x16, 0xDD, 0xDD, 0x16, 0xDD, 0xDD, 0x16, 0xDD, 0xDD, 0x16,
  0x00, 0xFB, 0xFB, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xFF,
  0x00, 0xF9, 0xB6, 0x00, 0xF9, 0x64, 0x00, 0xF9, 0x7E, 0x00, 0xF9, 0x24,
  0x00, 0xFF, 0x00, 0xFF, 0x88, 0xFF, 0x00, 0xFF, 0x00, 0x6A, 0xFF, 0x00,
  0xF9, 0xD6, 0x1B, 0xDD, 0xDD, 0x16, 0xDD, 0xDD, 0x16, 0xDD, 0xDD, 0x16,
  0x00, 0xFB, 0xFB, 0x00, 0xF9, 0xF9, 0x00, 0xF9, 0xFF, 0x00, 0xF9, 0xB6,
  0x00, 0xF9, 0x64, 0x00, 0xF9, 0x75, 0x00, 0xF9, 0x7E, 0x00, 0xF9, 0x24,
  0x00, 0xF9, 0x04, 0x00, 0xFF, 0x00, 0x00, 0xF9, 0x08, 0x00, 0xFF, 0x00,
  0x6A, 0xFF, 0x00, 0xF9, 0xD6, 0x1B, 0xDD, 0xDD, 0x16, 0xDD, 0xDD, 0x16,
  0x00, 0xFB, 0xFB, 0x00, 0xF9, 0xFF, 0x00, 0xF9, 0xB6, 0x00, 0xF9, 0x64,
  0x00, 0xF9, 0x75, 0x00, 0xF9, 0x75, 0x00, 0xF9, 0x7E, 0x00, 0xF9, 0x24,
  0x00, 0xF9, 0x04, 0x00, 0xF9, 0x08, 0x00, 0xFF, 0x00, 0xE1, 0x65, 0xDE,
  0x00, 0xFF, 0x00, 0x5B, 0xFF, 0x00, 0xF9, 0xD6, 0x1B, 0xDD, 0xDD, 0x16,
  0x00, 0xFB, 0xFF, 0x00, 0xF9, 0xB6, 0x00, 0xF9, 0x64, 0x00, 0xF9, 0x74,
  0x00, 0xF9, 0x74, 0x00, 0xF9, 0x74, 0x00, 0xF9, 0x7E, 0x00, 0xF9, 0x24,
  0x00, 0xF9, 0x04, 0x00, 0xF9, 0x08, 0x00, 0xF9, 0x08, 0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00, 0xA0, 0x3E, 0xBE, 0x5B, 0xFF, 0x00, 0xF9, 0xD6, 0x1B,
  0x00, 0xFE, 0xBB, 0x00, 0xFC, 0x65, 0x00, 0xFC, 0x76, 0x00, 0xFC, 0x76,
  0x00, 0xFC, 0x76, 0x00, 0xFC, 0x76, 0x00, 0xFC, 0x7F, 0x00, 0xFC, 0x24,
  0x00, 0xFC, 0x03, 0x00, 0xFC, 0x07, 0x00, 0xFC, 0x07, 0x00, 0xFC, 0x07,
  0x00, 0xFC, 0x07, 0x00, 0xFF, 0x00, 0x00, 0xFC, 0x09, 0x6C, 0xFF, 0x00
};
const unsigned char ASCII_8X8_121[768] = {
  0x90, 0x00, 0xFC, 0xF9, 0x00, 0xF9, 0xF0, 0x00, 0xFF, 0xE4, 0x00, 0xF9,
  0xE4, 0x00, 0xF9, 0xE4, 0x00, 0xF9, 0xE4, 0x00, 0xF9, 0xE7, 0x00, 0xFF,
  0xC0, 0x00, 0x6E, 0xFF, 0x00, 0x57, 0xF9, 0x00, 0x5B, 0xF9, 0x00, 0x5B,
  0xF9, 0x00, 0x5B, 0xF9, 0x00, 0x5B, 0xF9, 0x00, 0x6B, 0xF9, 0x00, 0x17,
  0x04, 0x00, 0xFB, 0x9E, 0x00, 0xFF, 0x63, 0xBD, 0x40, 0xF0, 0x00, 0xFF,
  0xE4, 0x00, 0xF9, 0xE4, 0x00, 0xF9, 0xE4, 0x00, 0xF9, 0xE7, 0x00, 0xFF,
  0xC0, 0x00, 0x6E, 0xFF, 0x00, 0x57, 0xF9, 0x00, 0x5B, 0xF9, 0x00, 0x5B,
  0xF9, 0x00, 0x5B, 0xF9, 0x00, 0x6B, 0xF9, 0x00, 0x13, 0xF9, 0x29, 0x00,
  0x20, 0x00, 0xFB, 0x04, 0x00, 0xF9, 0x9E, 0x00, 0xFF, 0xF9, 0x00, 0xF9,
  0xED, 0x00, 0xFF, 0xE4, 0x00, 0xF9, 0xE4, 0x00, 0xF9, 0xE7, 0x00, 0xFF,
  0xC0, 0x00, 0x6E, 0xFF, 0x00, 0x57, 0xF9, 0x00, 0x5B, 0xF9, 0x00, 0x5B,
  0xF9, 0x00, 0x6B, 0xF9, 0x00, 0x13, 0xF9, 0x29, 0x00, 0xF9, 0x20, 0x00,
  0x20, 0x00, 0xFB, 0x20, 0x00, 0xF9, 0x04, 0x00, 0xF9, 0x9B, 0x00, 0xFF,
  0x85, 0xE1, 0x65, 0xED, 0x00, 0xFF, 0xE4, 0x00, 0xF9, 0xE7, 0x00, 0xFF,
  0xC0, 0x00, 0x6E, 0xFF, 0x00, 0x57, 0xF9, 0x00, 0x5B, 0xF9, 0x00, 0x6B,
  0xF9, 0x00, 0x13, 0xF9, 0x29, 0x00, 0xF9, 0x20, 0x00, 0xF9, 0x20, 0x00,
  0x20, 0x00, 0xFB, 0x20, 0x00, 0xF9, 0x20, 0x00, 0xF9, 0x04, 0x00, 0xF9,
  0x9B, 0x00, 0xFF, 0xF9, 0x00, 0xF9, 0xEA, 0x00, 0xFF, 0xE7, 0x00, 0xFF,
  0xC0, 0x00, 0x6E, 0xFF, 0x00, 0x57, 0xF9, 0x00, 0x6B, 0xF9, 0x00, 0x13,
  0xF9, 0x29, 0x00, 0xF9, 0x20, 0x00, 0xF9, 0x20, 0x00, 0xF9, 0x20, 0x00,
  0x20, 0x00, 0xFB, 0x20, 0x00, 0xF9, 0x20, 0x00, 0xF9, 0x20, 0x00, 0xF9,
  0x04, 0x00, 0xF9, 0x98, 0x00, 0xFF, 0xAB, 0xFF, 0x8A, 0xED, 0x00, 0xFF,
  0xC0, 0x00, 0x65, 0xFF, 0x00, 0x67, 0xFC, 0x00, 0x00, 0xF9, 0x29, 0x00,
  0xF9, 0x05, 0x00, 0xF9, 0x20, 0x00, 0xF9, 0x20, 0x00, 0xF9, 0x20, 0x00,
  0x1B, 0x00, 0xFB, 0x1B, 0x00, 0xF9, 0x1B, 0x00, 0xF9, 0x1B, 0x00, 0xF9,
  0x1B, 0x00, 0xF9, 0x00, 0x00, 0xF9, 0x93, 0x00, 0xFF, 0xFD, 0x00, 0xFF,
  0xBA, 0xFF, 0xF8, 0xFF, 0x00, 0x00, 0xD6, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
  0xF9, 0xFF, 0xFF, 0xF9, 0x05, 0x00, 0xF9, 0x20, 0x00, 0xF9, 0x20, 0x00,
  0x54, 0x75, 0xFC, 0x54, 0x74, 0xF9, 0x54, 0x74, 0xFA, 0x54, 0x74, 0xFA,
  0x54, 0x74, 0xFA, 0x54, 0x74, 0xFA, 0x3D, 0x83, 0xFA, 0x8E, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFA, 0x1C, 0x00, 0xFD, 0x00, 0x00, 0xFA, 0x14, 0x00,
  0xFA, 0x00, 0x00, 0xFA, 0x14, 0x00, 0xFA, 0x14, 0x00, 0xFA, 0x14, 0x00,
  0x00, 0xE8, 0xFB, 0x00, 0xE5, 0xF9, 0x00, 0xE5, 0xF9, 0x00, 0xE1, 0xF9,
  0x00, 0xE5, 0xF9, 0x00, 0xE4, 0xFC, 0x00, 0xDD, 0xFF, 0x00, 0xFF, 0xED,
  0x31, 0xFF, 0x00, 0xFF, 0x70, 0x00, 0xFB, 0x83, 0x00, 0xFB, 0x83, 0x00,
  0xFB, 0x83, 0x00, 0xFB, 0x83, 0x00, 0xFB, 0x83, 0x00, 0xFB, 0x83, 0x00,
  0x00, 0xDB, 0xFB, 0x00, 0xD8, 0xF9, 0x00, 0xD5, 0xF9, 0xFF, 0xFF, 0xF9,
  0x00, 0xD3, 0xFC, 0xFF, 0xDE, 0xDE, 0x00, 0xFF, 0xDE, 0xFF, 0xB1, 0xE9,
  0x00, 0xFF, 0x20, 0x22, 0xFF, 0x00, 0xDB, 0xE2, 0x1F, 0xBD, 0xE9, 0x19,
  0xBD, 0xE9, 0x19, 0xBD, 0xE9, 0x19, 0xBD, 0xE9, 0x19, 0xBD, 0xE9, 0x19,
  0x00, 0xDB, 0xFB, 0x00, 0xD8, 0xF9, 0x00, 0xD9, 0xF9, 0x00, 0xD5, 0xF9,
  0x00, 0xD1, 0xFF, 0x00, 0xFF, 0xE4, 0x00, 0xF9, 0x8E, 0x00, 0xFF, 0x33,
  0x00, 0xFF, 0x15, 0xF4, 0x8A, 0xFC, 0x28, 0xFF, 0x00, 0xE1, 0xD7, 0x1C,
  0xC3, 0xDE, 0x17, 0xC3, 0xDE, 0x17, 0xC3, 0xDE, 0x17, 0xC3, 0xDE, 0x17,
  0x00, 0xDB, 0xFB, 0x00, 0xD8, 0xF9, 0x00, 0xD9, 0xF9, 0x00, 0xD1, 0xFF,
  0x00, 0xFF, 0xE1, 0x00, 0xF9, 0x84, 0x00, 0xF9, 0x9F, 0x00, 0xF9, 0x43,
  0x00, 0xF9, 0x25, 0x00, 0xFF, 0x19, 0x00, 0xF9, 0x34, 0x2B, 0xFF, 0x00,
  0xE1, 0xD7, 0x1C, 0xC3, 0xDE, 0x17, 0xC3, 0xDE, 0x17, 0xC3, 0xDE, 0x17,
  0x00, 0xDB, 0xFB, 0x00, 0xD8, 0xF9, 0x00, 0xD1, 0xFF, 0x00, 0xFF, 0xE1,
  0x00, 0xF9, 0x84, 0x00, 0xF9, 0x95, 0x00, 0xF9, 0x9F, 0x00, 0xF9, 0x43,
  0x00, 0xF9, 0x25, 0x00, 0xF9, 0x29, 0x00, 0xFF, 0x1C, 0xCF, 0x65, 0xD7,
  0x2B, 0xFF, 0x00, 0xE1, 0xD7, 0x1C, 0xC3, 0xDE, 0x17, 0xC3, 0xDE, 0x17,
  0x00, 0xDB, 0xFB, 0x00, 0xD0, 0xFF, 0x00, 0xFF, 0xE1, 0x00, 0xF9, 0x84,
  0x00, 0xF9, 0x95, 0x00, 0xF9, 0x95, 0x00, 0xF9, 0x9F, 0x00, 0xF9, 0x43,
  0x00, 0xF9, 0x25, 0x00, 0xF9, 0x29, 0x00, 0xF9, 0x29, 0x00, 0xFF, 0x1C,
  0x00, 0xF9, 0x34, 0x2E, 0xFF, 0x00, 0xE1, 0xD7, 0x1C, 0xC3, 0xDE, 0x17,
  0x00, 0xD2, 0xFF, 0x00, 0xFF, 0xE1, 0x00, 0xF9, 0x84, 0x00, 0xF9, 0x95,
  0x00, 0xF9, 0x95, 0x00, 0xF9, 0x95, 0x00, 0xF9, 0x9F, 0x00, 0xF9, 0x43,
  0x00, 0xF9, 0x25, 0x00, 0xF9, 0x29, 0x00, 0xF9, 0x29, 0x00, 0xF9, 0x29,
  0x00, 0xFF, 0x1F, 0xAD, 0x3F, 0xB2, 0x2E, 0xFF, 0x00, 0xE1, 0xD6, 0x1C,
  0x00, 0xFF, 0xE1, 0x00, 0xFC, 0x85, 0x00, 0xFC, 0x97, 0x00, 0xFC, 0x97,
  0x00, 0xFC, 0x97, 0x00, 0xFC, 0x97, 0x00, 0xFC, 0xA0, 0x00, 0xFC, 0x44,
  0x00, 0xFC, 0x26, 0x00, 0xFC, 0x2A, 0x00, 0xFC, 0x2A, 0x00, 0xFC, 0x2A,
  0x00, 0xFC, 0x2A, 0x00, 0xFF, 0x1F, 0x00, 0xFC, 0x34, 0x45, 0xFF, 0x00
};
const unsigned char ASCII_8X8_122[768] = {
  0xC8, 0x00, 0xFF, 0xFF, 0x00, 0xD5, 0xF9, 0x00, 0xDC, 0xF9, 0x00, 0xDC,
  0xF9, 0x00, 0xDC, 0xF9, 0x00, 0xDC, 0xF9, 0x00, 0xDC, 0xFF, 0x00, 0xEE,
  0xBC, 0x00, 0x46, 0xFF, 0x00, 0x24, 0xF9, 0x00, 0x29, 0xF9, 0x00, 0x29,
  0xF9, 0x00, 0x29, 0xF9, 0x00, 0x29, 0xF9, 0x00, 0x34, 0xF9, 0x0F, 0x00,
  0x37, 0x00, 0xFB, 0xCE, 0x00, 0xFF, 0xFF, 0x00, 0xE5, 0xF9, 0x00, 0xDC,
  0xF9, 0x00, 0xDC, 0xF9, 0x00, 0xDC, 0xF9, 0x00, 0xDC, 0xFF, 0x00, 0xEE,
  0xBC, 0x00, 0x46, 0xFF, 0x00, 0x24, 0xF9, 0x00, 0x29, 0xF9, 0x00, 0x29,
  0xF9, 0x00, 0x29, 0xF9, 0x00, 0x34, 0xF9, 0x0A, 0x00, 0xF9, 0x63, 0x00,
  0x53, 0x00, 0xFB, 0x3E, 0x00, 0xFF, 0x6B, 0xBE, 0x46, 0xFF, 0x00, 0xE5,
  0xF9, 0x00, 0xDC, 0xF9, 0x00, 0xDC, 0xF9, 0x00, 0xDC, 0xFF, 0x00, 0xEE,
  0xBC, 0x00, 0x46, 0xFF, 0x00, 0x24, 0xF9, 0x00, 0x29, 0xF9, 0x00, 0x29,
  0xF9, 0x00, 0x34, 0xF9, 0x0A, 0x00, 0xF9, 0x63, 0x00, 0xF9, 0x53, 0x00,
  0x53, 0x00, 0xFB, 0x52, 0x00, 0xF9, 0x3F, 0x00, 0xFF, 0xCE, 0x00, 0xFF,
  0xFF, 0x00, 0xE2, 0xF9, 0x00, 0xDC, 0xF9, 0x00, 0xDC, 0xFF, 0x00, 0xEE,
  0xBC, 0x00, 0x46, 0xFF, 0x00, 0x24, 0xF9, 0x00, 0x29, 0xF9, 0x00, 0x34,
  0xF9, 0x0A, 0x00, 0xF9, 0x63, 0x00, 0xF9, 0x53, 0x00, 0xF9, 0x53, 0x00,
  0x53, 0x00, 0xFB, 0x52, 0x00, 0xF9, 0x52, 0x00, 0xF9, 0x3C, 0x00, 0xFF,
  0x8D, 0xE0, 0x6A, 0xFF, 0x00, 0xE2, 0xF9, 0x00, 0xDC, 0xFF, 0x00, 0xEE,
  0xBC, 0x00, 0x46, 0xFF, 0x00, 0x24, 0xF9, 0x00, 0x34, 0xF9, 0x0A, 0x00,
  0xF9, 0x63, 0x00, 0xF9, 0x53, 0x00, 0xF9, 0x53, 0x00, 0xF9, 0x53, 0x00,
  0x53, 0x00, 0xFB, 0x52, 0x00, 0xF9, 0x52, 0x00, 0xF9, 0x52, 0x00, 0xF9,
  0x3C, 0x00, 0xFF, 0xCE, 0x00, 0xFF, 0xFF, 0x00, 0xDE, 0xFF, 0x00, 0xEE,
  0xBC, 0x00, 0x37, 0xFF, 0x00, 0x2F, 0xFC, 0x00, 0x00, 0xF9, 0x63, 0x00,
  0xF9, 0x3E, 0x00, 0xF9, 0x53, 0x00, 0xF9, 0x53, 0x00, 0xF9, 0x53, 0x00,
  0x55, 0x00, 0xFB, 0x53, 0x00, 0xF9, 0x54, 0x00, 0xF9, 0x54, 0x00, 0xF9,
  0x54, 0x00, 0xF9, 0x3A, 0x00, 0xFF, 0xB7, 0xFE, 0x93, 0xFF, 0x00, 0xE1,
  0xB5, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xD6, 0xFF, 0xFF, 0xFC, 0x2C, 0x00,
  0xF9, 0xFF, 0xFF, 0xF9, 0x3E, 0x00, 0xF9, 0x53, 0x00, 0xF9, 0x53, 0x00,
  0x4C, 0x4D, 0xFC, 0x4C, 0x4C, 0xF9, 0x4C, 0x4C, 0xF9, 0x4C, 0x4C, 0xF9,
  0x4C, 0x4C, 0xF9, 0x4C, 0x4C, 0xF9, 0x31, 0x40, 0xFF, 0xDA, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFA, 0x57, 0x00, 0xFD, 0x35, 0x00, 0xFA, 0x47, 0x00,
  0xFA, 0x32, 0x00, 0xFA, 0x47, 0x00, 0xFA, 0x47, 0x00, 0xFA, 0x47, 0x00,
  0x00, 0xB3, 0xFB, 0x00, 0xB2, 0xF9, 0x00, 0xB2, 0xF9, 0x00, 0xA8, 0xF9,
  0x00, 0xB2, 0xF9, 0x00, 0xAB, 0xFC, 0x00, 0xA2, 0xF9, 0x00, 0xFF, 0xFF,
  0x00, 0xFF, 0x00, 0xFF, 0xB7, 0x00, 0xFE, 0xBA, 0x00, 0xFE, 0xBA, 0x00,
  0xFE, 0xBA, 0x00, 0xFE, 0xBA, 0x00, 0xFE, 0xBA, 0x00, 0xFE, 0xBA, 0x00,
  0x00, 0xA8, 0xFB, 0x00, 0xA7, 0xF9, 0x00, 0x9D, 0xF9, 0xFF, 0xFF, 0xF9,
  0x00, 0x96, 0xFC, 0xFF, 0xEE, 0xD6, 0x00, 0xF3, 0xFF, 0xFF, 0xB3, 0xD2,
  0x00, 0xFF, 0x4E, 0xD6, 0x98, 0xEF, 0x9D, 0xE4, 0x09, 0x8F, 0xE2, 0x19,
  0x8F, 0xE2, 0x19, 0x8F, 0xE2, 0x19, 0x8F, 0xE2, 0x19, 0x8F, 0xE2, 0x19,
  0x00, 0xA8, 0xFB, 0x00, 0xA7, 0xF9, 0x00, 0xA7, 0xF9, 0x00, 0x9D, 0xF9,
  0x00, 0x97, 0xF9, 0x00, 0xED, 0xFF, 0x00, 0xFE, 0xC4, 0x00, 0xFF, 0x6D,
  0x00, 0xF9, 0x57, 0x00, 0xFF, 0x5C, 0x00, 0xFF, 0x00, 0xAB, 0xE2, 0x09,
  0x9A, 0xDD, 0x17, 0x9A, 0xDD, 0x17, 0x9A, 0xDD, 0x17, 0x9A, 0xDD, 0x17,
  0x00, 0xA8, 0xFB, 0x00, 0xA7, 0xF9, 0x00, 0xA7, 0xF9, 0x00, 0x97, 0xF9,
  0x00, 0xF4, 0xFF, 0x00, 0xFE, 0xBA, 0x00, 0xF9, 0xD0, 0x00, 0xF9, 0x77,
  0x00, 0xF9, 0x57, 0x00, 0xF9, 0x5B, 0x00, 0xFF, 0x5F, 0xB9, 0x6A, 0xC4,
  0xAB, 0xE2, 0x09, 0x9A, 0xDD, 0x17, 0x9A, 0xDD, 0x17, 0x9A, 0xDD, 0x17,
  0x00, 0xA8, 0xFB, 0x00, 0xA7, 0xF9, 0x00, 0x97, 0xF9, 0x00, 0xF4, 0xFF,
  0x00, 0xFE, 0xBA, 0x00, 0xF9, 0xC7, 0x00, 0xF9, 0xD0, 0x00, 0xF9, 0x77,
  0x00, 0xF9, 0x57, 0x00, 0xF9, 0x5B, 0x00, 0xF9, 0x5B, 0x00, 0xFF, 0x5F,
  0x00, 0xFF, 0x00, 0xAE, 0xE5, 0x0D, 0x9A, 0xDD, 0x17, 0x9A, 0xDD, 0x17,
  0x00, 0xA8, 0xFB, 0x00, 0x97, 0xF9, 0x00, 0xF4, 0xFF, 0x00, 0xFE, 0xBA,
  0x00, 0xF9, 0xC7, 0x00, 0xF9, 0xC7, 0x00, 0xF9, 0xD0, 0x00, 0xF9, 0x77,
  0x00, 0xF9, 0x57, 0x00, 0xF9, 0x5B, 0x00, 0xF9, 0x5B, 0x00, 0xF9, 0x5B,
  0x00, 0xFF, 0x62, 0x97, 0x49, 0x9F, 0xAE, 0xE5, 0x0D, 0x9A, 0xDD, 0x17,
  0x00, 0x97, 0xFB, 0x00, 0xF4, 0xFF, 0x00, 0xFD, 0xBA, 0x00, 0xF9, 0xC7,
  0x00, 0xF9, 0xC7, 0x00, 0xF9, 0xC7, 0x00, 0xF9, 0xD0, 0x00, 0xF9, 0x77,
  0x00, 0xF9, 0x57, 0x00, 0xF9, 0x5B, 0x00, 0xF9, 0x5B, 0x00, 0xF9, 0x5B,
  0x00, 0xF9, 0x5B, 0x00, 0xFF, 0x62, 0x00, 0xFF, 0x00, 0xBB, 0xD5, 0x1C,
  0x00, 0xF4, 0xFF, 0x00, 0xFF, 0xBC, 0x00, 0xFC, 0xC9, 0x00, 0xFC, 0xC9,
  0x00, 0xFC, 0xC9, 0x00, 0xFC, 0xC9, 0x00, 0xFC, 0xD2, 0x00, 0xFC, 0x79,
  0x00, 0xFC, 0x57, 0x00, 0xFC, 0x5C, 0x00, 0xFC, 0x5C, 0x00, 0xFC, 0x5C,
  0x00, 0xFC, 0x5C, 0x00, 0xFC, 0x5C, 0x00, 0xFC, 0x72, 0x0B, 0xFF, 0x00
};
const unsigned char ASCII_8X8_123[768] = {
  0xF1, 0x00, 0xFF, 0xFE, 0x00, 0xA5, 0xF9, 0x00, 0xB6, 0xF9, 0x00, 0xB6,
  0xF9, 0x00, 0xB6, 0xF9, 0x00, 0xB6, 0xF9, 0x00, 0xB6, 0xFF, 0x00, 0xC6,
  0xBC, 0x00, 0x2B, 0xFF, 0x00, 0x00, 0xF9, 0x00, 0x04, 0xF9, 0x00, 0x04,
  0xF9, 0x00, 0x04, 0xF9, 0x00, 0x04, 0xF9, 0x00, 0x05, 0xF9, 0x38, 0x00,
  0x5E, 0x00, 0xFB, 0xFB, 0x00, 0xFF, 0xFE, 0x00, 0xA5, 0xF9, 0x00, 0xB6,
  0xF9, 0x00, 0xB6, 0xF9, 0x00, 0xB6, 0xF9, 0x00, 0xB6, 0xFF, 0x00, 0xC6,
  0xBC, 0x00, 0x2B, 0xFF, 0x00, 0x00, 0xF9, 0x00, 0x04, 0xF9, 0x00, 0x04,
  0xF9, 0x00, 0x04, 0xF9, 0x00, 0x05, 0xFA, 0x37, 0x00, 0xF9, 0x88, 0x00,
  0x7A, 0x00, 0xFB, 0x5D, 0x00, 0xF9, 0xFB, 0x00, 0xFF, 0xFE, 0x00, 0xA5,
  0xF9, 0x00, 0xB6, 0xF9, 0x00, 0xB6, 0xF9, 0x00, 0xB6, 0xFF, 0x00, 0xC6,
  0xBC, 0x00, 0x2B, 0xFF, 0x00, 0x00, 0xF9, 0x00, 0x04, 0xF9, 0x00, 0x04,
  0xF9, 0x00, 0x05, 0xFA, 0x37, 0x00, 0xF9, 0x88, 0x00, 0xF9, 0x79, 0x00,
  0x7A, 0x00, 0xFB, 0x77, 0x00, 0xFF, 0x68, 0xBC, 0x3E, 0xFB, 0x00, 0xFF,
  0xFE, 0x00, 0xA5, 0xF9, 0x00, 0xB6, 0xF9, 0x00, 0xB6, 0xFF, 0x00, 0xC6,
  0xBC, 0x00, 0x2B, 0xFF, 0x00, 0x00, 0xF9, 0x00, 0x04, 0xF9, 0x00, 0x05,
  0xFA, 0x37, 0x00, 0xF9, 0x88, 0x00, 0xF9, 0x79, 0x00, 0xF9, 0x79, 0x00,
  0x7A, 0x00, 0xFB, 0x78, 0x00, 0xF9, 0x78, 0x00, 0xFF, 0x5D, 0x00, 0xF9,
  0xF8, 0x00, 0xFF, 0xFE, 0x00, 0xA5, 0xF9, 0x00, 0xB6, 0xFF, 0x00, 0xC6,
  0xBC, 0x00, 0x2B, 0xFF, 0x00, 0x00, 0xF9, 0x00, 0x05, 0xFA, 0x37, 0x00,
  0xF9, 0x88, 0x00, 0xF9, 0x79, 0x00, 0xF9, 0x79, 0x00, 0xF9, 0x79, 0x00,
  0x7A, 0x00, 0xFB, 0x78, 0x00, 0xF9, 0x79, 0x00, 0xF9, 0x75, 0x00, 0xFF,
  0x89, 0xE0, 0x63, 0xF8, 0x00, 0xFF, 0xFF, 0x00, 0xAE, 0xFF, 0x00, 0xC6,
  0xBC, 0x00, 0x19, 0xFF, 0x00, 0x00, 0xFD, 0x2A, 0x00, 0xF9, 0x88, 0x00,
  0xF9, 0x69, 0x00, 0xF9, 0x79, 0x00, 0xF9, 0x79, 0x00, 0xF9, 0x79, 0x00,
  0x7E, 0x00, 0xFB, 0x7C, 0x00, 0xF9, 0x7D, 0x00, 0xF9, 0x7D, 0x00, 0xF9,
  0x79, 0x00, 0xFF, 0x68, 0x00, 0xFF, 0xB0, 0xFF, 0x9C, 0xFF, 0x00, 0xAC,
  0xB5, 0xFF, 0xFF, 0xFF, 0x11, 0x00, 0xD5, 0xFF, 0xFF, 0xFC, 0x5B, 0x00,
  0xF9, 0xFF, 0xFF, 0xF9, 0x69, 0x00, 0xF9, 0x79, 0x00, 0xF9, 0x79, 0x00,
  0x5F, 0x47, 0xFC, 0x5F, 0x46, 0xFA, 0x5F, 0x46, 0xFA, 0x5F, 0x46, 0xFA,
  0x5F, 0x46, 0xFA, 0x5F, 0x46, 0xFA, 0x47, 0x39, 0xFF, 0xFF, 0x00, 0xFF,
  0xFF, 0x0E, 0x00, 0xFA, 0x7D, 0x00, 0xFD, 0x60, 0x00, 0xFA, 0x6D, 0x00,
  0xFA, 0x5D, 0x00, 0xFA, 0x6D, 0x00, 0xFA, 0x6D, 0x00, 0xFA, 0x6D, 0x00,
  0x00, 0x89, 0xFB, 0x00, 0x88, 0xF9, 0x00, 0x88, 0xF9, 0x00, 0x79, 0xF9,
  0x00, 0x88, 0xF9, 0x00, 0x7C, 0xFC, 0x00, 0x77, 0xF9, 0x00, 0xDC, 0xFF,
  0x00, 0xFF, 0x00, 0xFF, 0xE4, 0x00, 0xFF, 0xE3, 0x00, 0xFF, 0xE3, 0x00,
  0xFF, 0xE3, 0x00, 0xFF, 0xE3, 0x00, 0xFF, 0xE3, 0x00, 0xFF, 0xE3, 0x00,
  0x00, 0x82, 0xFB, 0x00, 0x80, 0xF9, 0x00, 0x71, 0xF9, 0xFF, 0xFF, 0xF9,
  0x00, 0x65, 0xFC, 0xFF, 0xFF, 0xD5, 0x00, 0xC0, 0xFF, 0xFF, 0xBC, 0xC9,
  0x00, 0xFF, 0x80, 0xDA, 0x93, 0xE5, 0x78, 0xDF, 0x06, 0x6C, 0xE6, 0x08,
  0x6F, 0xDD, 0x18, 0x6F, 0xDD, 0x18, 0x6F, 0xDD, 0x18, 0x6F, 0xDD, 0x18,
  0x00, 0x82, 0xFB, 0x00, 0x80, 0xF9, 0x00, 0x81, 0xF9, 0x00, 0x71, 0xF9,
  0x00, 0x70, 0xF9, 0x00, 0xBA, 0xFF, 0x00, 0xFF, 0xF4, 0x00, 0xFF, 0x97,
  0x00, 0xF9, 0x7C, 0x00, 0xFF, 0x89, 0x00, 0xFF, 0x00, 0xC1, 0x6A, 0xD8,
  0x7B, 0xE6, 0x06, 0x7E, 0xDD, 0x16, 0x7E, 0xDD, 0x16, 0x7E, 0xDD, 0x16,
  0x00, 0x82, 0xFB, 0x00, 0x80, 0xF9, 0x00, 0x81, 0xF9, 0x00, 0x70, 0xF9,
  0x00, 0xC6, 0xFD, 0x00, 0xFF, 0xEA, 0x00, 0xF9, 0xF7, 0x00, 0xF9, 0x9B,
  0x00, 0xF9, 0x7C, 0x00, 0xF9, 0x80, 0x00, 0xF9, 0x9E, 0x00, 0xFF, 0x00,
  0x9D, 0xD5, 0x18, 0x7D, 0xE9, 0x09, 0x7E, 0xDD, 0x16, 0x7E, 0xDD, 0x16,
  0x00, 0x82, 0xFB, 0x00, 0x80, 0xF9, 0x00, 0x70, 0xF9, 0x00, 0xC6, 0xFD,
  0x00, 0xFF, 0xEA, 0x00, 0xF9, 0xED, 0x00, 0xF9, 0xF7, 0x00, 0xF9, 0x9B,
  0x00, 0xF9, 0x7C, 0x00, 0xF9, 0x80, 0x00, 0xF9, 0x80, 0x00, 0xF9, 0x9E,
  0x00, 0xFF, 0x00, 0xA0, 0x46, 0xB2, 0x7D, 0xE9, 0x09, 0x7E, 0xDD, 0x16,
  0x00, 0x82, 0xFB, 0x00, 0x70, 0xF9, 0x00, 0xC6, 0xFD, 0x00, 0xFF, 0xEA,
  0x00, 0xF9, 0xED, 0x00, 0xF9, 0xED, 0x00, 0xF9, 0xF7, 0x00, 0xF9, 0x9B,
  0x00, 0xF9, 0x7C, 0x00, 0xF9, 0x80, 0x00, 0xF9, 0x80, 0x00, 0xF9, 0x80,
  0x00, 0xF9, 0x9E, 0x00, 0xFF, 0x00, 0x9D, 0xD5, 0x18, 0x7E, 0xDD, 0x16,
  0x00, 0x71, 0xFB, 0x00, 0xC5, 0xFC, 0x00, 0xFF, 0xEA, 0x00, 0xF9, 0xED,
  0x00, 0xF9, 0xED, 0x00, 0xF9, 0xED, 0x00, 0xF9, 0xF7, 0x00, 0xF9, 0x9B,
  0x00, 0xF9, 0x7C, 0x00, 0xF9, 0x80, 0x00, 0xF9, 0x80, 0x00, 0xF9, 0x80,
  0x00, 0xF9, 0x80, 0x00, 0xF9, 0x9E, 0x00, 0xFF, 0x00, 0x9D, 0xD5, 0x18,
  0x00, 0xC9, 0xFF, 0x00, 0xFF, 0xEC, 0x00, 0xFC, 0xF0, 0x00, 0xFC, 0xF0,
  0x00, 0xFC, 0xF0, 0x00, 0xFC, 0xF0, 0x00, 0xFC, 0xF9, 0x00, 0xFC, 0x9D,
  0x00, 0xFC, 0x7E, 0x00, 0xFC, 0x82, 0x00, 0xFC, 0x82, 0x00, 0xFC, 0x82,
  0x00, 0xFC, 0x82, 0x00, 0xFC, 0x82, 0x00, 0xFC, 0x9F, 0x00, 0xFF, 0x00
};
const unsigned char ASCII_8X8_124[768] = {
  0xFF, 0x00, 0xEF, 0xF9, 0x00, 0x77, 0xF9, 0x00, 0x8D, 0xF9, 0x00, 0x8D,
  0xF9, 0x00, 0x8D, 0xF9, 0x00, 0x8D, 0xF9, 0x00, 0x8D, 0xFF, 0x00, 0x9D,
  0xBC, 0x00, 0x07, 0xFF, 0x29, 0x00, 0xF9, 0x24, 0x00, 0xF9, 0x24, 0x00,
  0xF9, 0x24, 0x00, 0xF9, 0x24, 0x00, 0xF9, 0x15, 0x00, 0xFA, 0x61, 0x00,
  0x8D, 0x00, 0xFF, 0xFF, 0x00, 0xF5, 0xF9, 0x00, 0x78, 0xF9, 0x00, 0x8D,
  0xF9, 0x00, 0x8D, 0xF9, 0x00, 0x8D, 0xF9, 0x00, 0x8D, 0xFF, 0x00, 0x9D,
  0xBC, 0x00, 0x07, 0xFF, 0x29, 0x00, 0xF9, 0x24, 0x00, 0xF9, 0x24, 0x00,
  0xF9, 0x24, 0x00, 0xF9, 0x15, 0x00, 0xFA, 0x61, 0x00, 0xF9, 0xB2, 0x00,
  0xA3, 0x00, 0xFB, 0x8C, 0x00, 0xFE, 0xFF, 0x00, 0xF5, 0xF9, 0x00, 0x78,
  0xF9, 0x00, 0x8D, 0xF9, 0x00, 0x8D, 0xF9, 0x00, 0x8D, 0xFF, 0x00, 0x9D,
  0xBC, 0x00, 0x07, 0xFF, 0x29, 0x00, 0xF9, 0x24, 0x00, 0xF9, 0x24, 0x00,
  0xF9, 0x15, 0x00, 0xFA, 0x61, 0x00, 0xF9, 0xB2, 0x00, 0xF9, 0xA2, 0x00,
  0xA3, 0x00, 0xFB, 0xA2, 0x00, 0xF9, 0x91, 0x00, 0xFF, 0xFF, 0x00, 0xF5,
  0xF9, 0x00, 0x78, 0xF9, 0x00, 0x8D, 0xF9, 0x00, 0x8D, 0xFF, 0x00, 0x9D,
  0xBC, 0x00, 0x07, 0xFF, 0x29, 0x00, 0xF9, 0x24, 0x00, 0xF9, 0x15, 0x00,
  0xFA, 0x61, 0x00, 0xF9, 0xB2, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0xA2, 0x00,
  0xA3, 0x00, 0xFB, 0xA6, 0x00, 0xFF, 0x6F, 0xC0, 0x44, 0x91, 0x00, 0xFF,
  0xFF, 0x00, 0xF5, 0xF9, 0x00, 0x78, 0xF9, 0x00, 0x8D, 0xFF, 0x00, 0x9D,
  0xBC, 0x00, 0x07, 0xFF, 0x29, 0x00, 0xF9, 0x15, 0x00, 0xFA, 0x61, 0x00,
  0xF9, 0xB2, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0xA2, 0x00,
  0xA3, 0x00, 0xFB, 0xA2, 0x00, 0xF9, 0xA6, 0x00, 0xFF, 0xA2, 0x00, 0xF9,
  0x8E, 0x00, 0xFF, 0xFF, 0x00, 0xF5, 0xFF, 0x00, 0x7E, 0xFF, 0x00, 0x9D,
  0xBC, 0x00, 0x00, 0xFF, 0x1A, 0x00, 0xFD, 0x59, 0x00, 0xF9, 0xB2, 0x00,
  0xF9, 0x97, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0xA2, 0x00,
  0xA9, 0x00, 0xFB, 0xA8, 0x00, 0xF9, 0xA8, 0x00, 0xF9, 0xA9, 0x00, 0xFF,
  0x96, 0xD9, 0x65, 0x9D, 0x00, 0xFF, 0xA4, 0xFC, 0xA3, 0xFF, 0x00, 0x77,
  0xB7, 0xFF, 0xFF, 0xFF, 0x45, 0x00, 0xD4, 0xFF, 0xFF, 0xFC, 0x90, 0x00,
  0xF9, 0xFF, 0xFF, 0xF9, 0x97, 0x00, 0xF9, 0xA2, 0x00, 0xF9, 0xA2, 0x00,
  0x80, 0x4D, 0xFC, 0x7F, 0x4B, 0xF9, 0x7F, 0x4B, 0xF9, 0x7F, 0x4B, 0xF9,
  0x80, 0x39, 0xFF, 0x7F, 0x4B, 0xF9, 0x6D, 0x3E, 0xFF, 0xFF, 0x00, 0xFF,
  0xFF, 0x46, 0x00, 0xFB, 0xA8, 0x00, 0xFF, 0x90, 0x00, 0xFB, 0x98, 0x00,
  0xFB, 0x8D, 0x00, 0xFB, 0x98, 0x00, 0xFB, 0x98, 0x00, 0xFB, 0x98, 0x00,
  0x00, 0x5A, 0xFB, 0x00, 0x59, 0xF9, 0x00, 0x59, 0xF9, 0x00, 0x45, 0xF9,
  0x00, 0x59, 0xF9, 0x00, 0x48, 0xFC, 0x00, 0x48, 0xF9, 0x00, 0xA5, 0xFF,
  0x00, 0xFF, 0x1D, 0xFF, 0xFF, 0x00, 0xF8, 0xFF, 0x00, 0xF0, 0xFF, 0x00,
  0xF8, 0xFF, 0x00, 0xF8, 0xFF, 0x00, 0xF8, 0xFF, 0x00, 0xF8, 0xFF, 0x00,
  0x00, 0x58, 0xFB, 0x00, 0x57, 0xF9, 0x00, 0x43, 0xF9, 0xFF, 0xFF, 0xF9,
  0x00, 0x32, 0xFC, 0xFF, 0xFF, 0xD4, 0x00, 0x8C, 0xFF, 0xFF, 0xC8, 0xC0,
  0x00, 0xFF, 0xB5, 0xDD, 0x8D, 0xD7, 0x43, 0xE5, 0x00, 0xA2, 0x70, 0xD9,
  0x42, 0xE3, 0x09, 0x49, 0xDA, 0x19, 0x49, 0xDA, 0x19, 0x49, 0xDA, 0x19,
  0x00, 0x58, 0xFB, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x43, 0xF9,
  0x00, 0x46, 0xF9, 0x00, 0x8A, 0xFC, 0x00, 0xE9, 0xFF, 0x00, 0xFF, 0xCA,
  0x00, 0xF9, 0xA7, 0x00, 0xFF, 0xB9, 0x00, 0xFF, 0x21, 0x6A, 0xDE, 0x00,
  0x5B, 0xDD, 0x17, 0x56, 0xE8, 0x09, 0x5B, 0xDD, 0x17, 0x5B, 0xDD, 0x17,
  0x00, 0x58, 0xFB, 0x00, 0x57, 0xF9, 0x00, 0x57, 0xF9, 0x00, 0x46, 0xF9,
  0x00, 0x9B, 0xF9, 0x00, 0xED, 0xF9, 0x00, 0xD9, 0xFF, 0x00, 0xFD, 0xCA,
  0x00, 0xF9, 0xA7, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xC8, 0x00, 0xFF, 0x21,
  0x6D, 0xE1, 0x01, 0x93, 0x52, 0xB5, 0x56, 0xE8, 0x09, 0x5B, 0xDD, 0x17,
  0x00, 0x58, 0xFB, 0x00, 0x57, 0xF9, 0x00, 0x46, 0xF9, 0x00, 0x9B, 0xF9,
  0x00, 0xED, 0xF9, 0x00, 0xDC, 0xF9, 0x00, 0xD9, 0xFF, 0x00, 0xFD, 0xCA,
  0x00, 0xF9, 0xA7, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xC8,
  0x00, 0xFF, 0x21, 0x6D, 0xE1, 0x01, 0x5B, 0xDD, 0x17, 0x5B, 0xDD, 0x17,
  0x00, 0x58, 0xFB, 0x00, 0x46, 0xF9, 0x00, 0x9B, 0xF9, 0x00, 0xED, 0xF9,
  0x00, 0xDC, 0xF9, 0x00, 0xDC, 0xF9, 0x00, 0xD9, 0xFF, 0x00, 0xFD, 0xCA,
  0x00, 0xF9, 0xA7, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB,
  0x00, 0xF9, 0xC8, 0x00, 0xFF, 0x21, 0x72, 0xD5, 0x0F, 0x5B, 0xDD, 0x17,
  0x00, 0x47, 0xFB, 0x00, 0x9B, 0xF9, 0x00, 0xED, 0xF9, 0x00, 0xDC, 0xF9,
  0x00, 0xDC, 0xF9, 0x00, 0xDC, 0xF9, 0x00, 0xD9, 0xFF, 0x00, 0xFD, 0xCA,
  0x00, 0xF9, 0xA7, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xAB,
  0x00, 0xF9, 0xAB, 0x00, 0xF9, 0xC8, 0x00, 0xFF, 0x21, 0x72, 0xD5, 0x0F,
  0x00, 0x9D, 0xFE, 0x00, 0xEF, 0xFC, 0x00, 0xDF, 0xFC, 0x00, 0xDF, 0xFC,
  0x00, 0xDF, 0xFC, 0x00, 0xDF, 0xFC, 0x00, 0xDB, 0xFF, 0x00, 0xFF, 0xCC,
  0x00, 0xFC, 0xA9, 0x00, 0xFC, 0xAD, 0x00, 0xFC, 0xAD, 0x00, 0xFC, 0xAD,
  0x00, 0xFC, 0xAD, 0x00, 0xFC, 0xAD, 0x00, 0xFC, 0xCA, 0x00, 0xFF, 0x2C
};
const unsigned char ASCII_8X8_125[768] = {
  0xFF, 0x00, 0xC0, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x64, 0xF9, 0x00, 0x64,
  0xF9, 0x00, 0x64, 0xF9, 0x00, 0x64, 0xF9, 0x00, 0x64, 0xFF, 0x00, 0x70,
  0xBD, 0x06, 0x00, 0xFF, 0x56, 0x00, 0xF9, 0x4E, 0x00, 0xF9, 0x4E, 0x00,
  0xF9, 0x4E, 0x00, 0xF9, 0x4E, 0x00, 0xF9, 0x3E, 0x00, 0xF9, 0x8E, 0x00,
  0xC1, 0x00, 0xFF, 0xFF, 0x00, 0xC2, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x64,
  0xF9, 0x00, 0x64, 0xF9, 0x00, 0x64, 0xF9, 0x00, 0x64, 0xFF, 0x00, 0x70,
  0xBD, 0x06, 0x00, 0xFF, 0x56, 0x00, 0xF9, 0x4E, 0x00, 0xF9, 0x4E, 0x00,
  0xF9, 0x4E, 0x00, 0xF9, 0x3E, 0x00, 0xF9, 0x8E, 0x00, 0xF9, 0xDB, 0x00,
  0xCD, 0x00, 0xFB, 0xBF, 0x00, 0xFF, 0xFF, 0x00, 0xC2, 0xF9, 0x00, 0x4E,
  0xF9, 0x00, 0x64, 0xF9, 0x00, 0x64, 0xF9, 0x00, 0x64, 0xFF, 0x00, 0x70,
  0xBD, 0x06, 0x00, 0xFF, 0x56, 0x00, 0xF9, 0x4E, 0x00, 0xF9, 0x4E, 0x00,
  0xF9, 0x3E, 0x00, 0xF9, 0x8E, 0x00, 0xF9, 0xDB, 0x00, 0xF9, 0xCC, 0x00,
  0xCD, 0x00, 0xFB, 0xCB, 0x00, 0xF9, 0xBF, 0x00, 0xFF, 0xFF, 0x00, 0xC2,
  0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x64, 0xF9, 0x00, 0x64, 0xFF, 0x00, 0x70,
  0xBD, 0x06, 0x00, 0xFF, 0x56, 0x00, 0xF9, 0x4E, 0x00, 0xF9, 0x3E, 0x00,
  0xF9, 0x8E, 0x00, 0xF9, 0xDB, 0x00, 0xF9, 0xCC, 0x00, 0xF9, 0xCC, 0x00,
  0xCD, 0x00, 0xFB, 0xCB, 0x00, 0xF9, 0xD5, 0x00, 0xFF, 0xBF, 0x00, 0xFF,
  0xFF, 0x00, 0xC2, 0xF9, 0x00, 0x4E, 0xF9, 0x00, 0x64, 0xFF, 0x00, 0x70,
  0xBD, 0x06, 0x00, 0xFF, 0x56, 0x00, 0xF9, 0x3E, 0x00, 0xF9, 0x8E, 0x00,
  0xF9, 0xDB, 0x00, 0xF9, 0xCC, 0x00, 0xF9, 0xCC, 0x00, 0xF9, 0xCC, 0x00,
  0xCD, 0x00, 0xFB, 0xD4, 0x00, 0xFF, 0x57, 0xBF, 0x42, 0xD5, 0x00, 0xFF,
  0xC6, 0x00, 0xFF, 0xFF, 0x00, 0xC2, 0xFF, 0x00, 0x4F, 0xFF, 0x00, 0x70,
  0xBD, 0x00, 0x00, 0xFF, 0x46, 0x00, 0xFC, 0x8B, 0x00, 0xF9, 0xDB, 0x00,
  0xF9, 0xC6, 0x00, 0xF9, 0xCC, 0x00, 0xF9, 0xCC, 0x00, 0xF9, 0xCC, 0x00,
  0xD4, 0x00, 0xFB, 0xD2, 0x00, 0xF9, 0xDB, 0x00, 0xFF, 0xD8, 0x00, 0xFF,
  0x84, 0xDA, 0x66, 0xD6, 0x00, 0xFF, 0x9E, 0xFF, 0xB1, 0xFF, 0x00, 0x43,
  0xB5, 0xFF, 0xFF, 0xFF, 0x7C, 0x00, 0xD5, 0xFC, 0xFF, 0xFC, 0xC3, 0x00,
  0xF9, 0xFF, 0xFF, 0xF9, 0xC6, 0x00, 0xF9, 0xCC, 0x00, 0xF9, 0xCC, 0x00,
  0xA0, 0x51, 0xFC, 0x9F, 0x51, 0xF9, 0x9F, 0x51, 0xFA, 0x9F, 0x51, 0xFA,
  0xA5, 0x3E, 0xFF, 0x9F, 0x51, 0xFA, 0x95, 0x43, 0xFF, 0xFF, 0x00, 0xCE,
  0xFF, 0x83, 0x00, 0xFF, 0xD6, 0x00, 0xFF, 0xC4, 0x00, 0xFF, 0xC7, 0x00,
  0xFF, 0xC1, 0x00, 0xFF, 0xC7, 0x00, 0xFF, 0xC7, 0x00, 0xFF, 0xC7, 0x00,
  0x00, 0x2A, 0xFB, 0x00, 0x2A, 0xF9, 0x00, 0x2A, 0xF9, 0x00, 0x11, 0xF9,
  0x00, 0x2A, 0xF9, 0x00, 0x14, 0xFC, 0x00, 0x19, 0xF9, 0x00, 0x6C, 0xFF,
  0x00, 0xFF, 0x53, 0xD1, 0xFF, 0x00, 0xC8, 0xFB, 0x00, 0xBD, 0xFF, 0x00,
  0xC8, 0xFB, 0x00, 0xC8, 0xFB, 0x00, 0xC8, 0xFB, 0x00, 0xC8, 0xFB, 0x00,
  0x00, 0x2D, 0xFB, 0x00, 0x2D, 0xF9, 0x00, 0x14, 0xF9, 0xFF, 0xFF, 0xF9,
  0x00, 0x00, 0xFC, 0xFF, 0xFF, 0xD5, 0x00, 0x59, 0xFF, 0xFF, 0xD1, 0xB4,
  0x00, 0xFF, 0xE8, 0xE9, 0x8F, 0xD0, 0x17, 0xE6, 0x00, 0xB5, 0x71, 0xDA,
  0x1E, 0xE4, 0x09, 0x21, 0xE7, 0x0C, 0x2A, 0xDB, 0x19, 0x2A, 0xDB, 0x19,
  0x00, 0x2D, 0xFB, 0x00, 0x2D, 0xF9, 0x00, 0x2D, 0xF9, 0x00, 0x14, 0xF9,
  0x00, 0x1C, 0xF9, 0x00, 0x5C, 0xFC, 0x00, 0xB8, 0xFA, 0x00, 0xFF, 0xFD,
  0x00, 0xF9, 0xD0, 0x00, 0xFF, 0xE7, 0x00, 0xFF, 0x52, 0x3D, 0xDF, 0x00,
  0x32, 0xE9, 0x09, 0x9F, 0x50, 0xB4, 0x32, 0xE9, 0x09, 0x3A, 0xDE, 0x17,
  0x00, 0x2D, 0xFB, 0x00, 0x2D, 0xF9, 0x00, 0x2D, 0xF9, 0x00, 0x1C, 0xF9,
  0x00, 0x72, 0xF9, 0x00, 0xC1, 0xF9, 0x00, 0xA8, 0xFA, 0x00, 0xFF, 0xF7,
  0x00, 0xF9, 0xD0, 0x00, 0xF9, 0xD4, 0x00, 0xF9, 0xF1, 0x00, 0xFF, 0x52,
  0x49, 0xD6, 0x05, 0x32, 0xE9, 0x09, 0x3A, 0xDE, 0x17, 0x3A, 0xDE, 0x17,
  0x00, 0x2D, 0xFB, 0x00, 0x2D, 0xF9, 0x00, 0x1C, 0xF9, 0x00, 0x72, 0xF9,
  0x00, 0xC1, 0xF9, 0x00, 0xB1, 0xF9, 0x00, 0xA8, 0xFA, 0x00, 0xFF, 0xF7,
  0x00, 0xF9, 0xD0, 0x00, 0xF9, 0xD4, 0x00, 0xF9, 0xD4, 0x00, 0xF9, 0xF1,
  0x00, 0xFF, 0x52, 0x49, 0xD6, 0x05, 0x3A, 0xDE, 0x17, 0x3A, 0xDE, 0x17,
  0x00, 0x2D, 0xFB, 0x00, 0x1C, 0xF9, 0x00, 0x72, 0xF9, 0x00, 0xC1, 0xF9,
  0x00, 0xB1, 0xF9, 0x00, 0xB1, 0xF9, 0x00, 0xA8, 0xFA, 0x00, 0xFF, 0xF7,
  0x00, 0xF9, 0xD0, 0x00, 0xF9, 0xD4, 0x00, 0xF9, 0xD4, 0x00, 0xF9, 0xD4,
  0x00, 0xF9, 0xF1, 0x00, 0xFF, 0x52, 0x49, 0xD6, 0x05, 0x3A, 0xDE, 0x17,
  0x00, 0x1C, 0xFB, 0x00, 0x72, 0xF9, 0x00, 0xC1, 0xF9, 0x00, 0xB1, 0xF9,
  0x00, 0xB1, 0xF9, 0x00, 0xB1, 0xF9, 0x00, 0xA8, 0xFA, 0x00, 0xFF, 0xF7,
  0x00, 0xF9, 0xCF, 0x00, 0xF9, 0xD3, 0x00, 0xF9, 0xD3, 0x00, 0xF9, 0xD3,
  0x00, 0xF9, 0xD3, 0x00, 0xF9, 0xF1, 0x00, 0xFF, 0x52, 0x49, 0xD6, 0x05,
  0x00, 0x72, 0xFE, 0x00, 0xC3, 0xFC, 0x00, 0xB3, 0xFC, 0x00, 0xB3, 0xFC,
  0x00, 0xB3, 0xFC, 0x00, 0xB3, 0xFC, 0x00, 0xAA, 0xFC, 0x00, 0xFF, 0xFA,
  0x00, 0xFC, 0xD2, 0x00, 0xFC, 0xD6, 0x00, 0xFC, 0xD6, 0x00, 0xFC, 0xD6,
  0x00, 0xFC, 0xD6, 0x00, 0xFC, 0xD6, 0x00, 0xFB, 0xF3, 0x00, 0xFF, 0x59
};
const unsigned char HOLTEK_32x32[128] =
{
  0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x00,
    0x00, 0x00, 0x60, 0x08,
    0x00, 0x00, 0xE0, 0x18,
    0x00, 0x01, 0xE0, 0x38,
    0x00, 0x03, 0xE0, 0x78,
    0x00, 0x07, 0xE0, 0xF8,
    0x00, 0x0F, 0xE1, 0xF8,
    0x07, 0xFF, 0xFF, 0xF8,
    0x3C, 0x7F, 0x8F, 0xFC,
    0x40, 0xFF, 0x1F, 0xE6,
    0x81, 0xFE, 0x3F, 0xC1,
    0x83, 0xFC, 0x7F, 0x81,
    0x47, 0xF8, 0xFF, 0x02,
    0x3F, 0xF1, 0xFE, 0x0C,
    0x0F, 0xE3, 0xFF, 0xF0,
    0x0F, 0xFF, 0xFF, 0x00,
    0x0F, 0x87, 0xF0, 0x00,
    0x0F, 0x07, 0xE0, 0x00,
    0x0E, 0x07, 0xC0, 0x00,
    0x0C, 0x07, 0x80, 0x00,
    0x08, 0x07, 0x00, 0x00,
    0x00, 0x06, 0x00, 0x00,
    0x00, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
};
#endif
