
#ifndef _PROJECT_GLOBAL_H_
#define _PROJECT_GLOBAL_H_

// 系統頻率設置
#define SYS_CLOCK_FREQ 8000000  // 高速系統頻率
#define _HIRC_8M_   // 高速時鐘選擇 _HIRC_4M_ , _HIRC_8M_ , _HIRC_12M_  , _HXT_10M_BELOW_ , _HXT_10M_OVER_
#define _LIRC_      // 低速時鐘選擇  _LXT_ , _LIRC_

#define CFGVer  14  // V版本=13  F版本=14


enum WORKMODEStatus_t
{
	MODE_NONE,
    MODE_INIT,
    MODE_STATE,
    MODE_FINISH,
    MODE_EXIT,
};

/*! 模塊電源開關*/
enum OnOff_t
{
    OFF = 0, //!< 關閉電源
    ON = 1,  //!< 開啟電源
};
enum STATUS_t
{
    ERROR = 0,
    SUCCESS = 1,
};
/*! 模塊功能開關*/
enum BOOL_t
{
    FALSE = 0, //!<
    TRUE = 1,  //!<
};
/*! 模塊功能開關*/
enum FunctionOnOff_t
{
    DISABLE = 0, //!< 關閉功能
    ENABLE = 1,  //!< 開啟功能
};

typedef char			s8;
typedef int				s16;
typedef long			s32;
typedef unsigned char 	u8;
typedef unsigned int    u16;
typedef unsigned long   u32;


typedef unsigned char __1_byte;
typedef struct {
    unsigned char b0:1;
    unsigned char b1:1;
    unsigned char b2:1;
    unsigned char b3:1;
    unsigned char b4:1;
    unsigned char b5:1;
    unsigned char b6:1;
    unsigned char b7:1;
} __8_bits;
typedef union {
    __8_bits bits;
    __1_byte u8;
    __1_byte s8;
} __byte_type;


typedef union {
    struct
    {
        unsigned char byte0;
        unsigned char byte1;
    }byte;
    int		 		 s16;
    unsigned int	 u16;
} __16_type;

typedef union {
    struct
    {
        unsigned char byte0;
        unsigned char byte1;
        unsigned char byte2;
        unsigned char byte3;
    }byte;
    unsigned long 	u32;
    long			s32;
} __32_type;

typedef union {
    struct
    {
        unsigned char byte0;
        unsigned char byte1;
        unsigned char byte2;
    }byte;
    float 	uf24;
} __24_type;


#endif