/**
 * @file SDK_phase.c
 * @author 陳挺 (tony@e-besthealth.com)
 * @brief
 * @version 0.1
 * @date 2019-11-29
 *
 * @copyright BEST HEALTH ELECTRONIC INC (c) 2019
 *
 * @par 修改日志:
 * Compiler   Ver.
 * IDE3000    Ver.
 */

/**
 * @file phase.c
 * @author 陳挺 (tony@e-besthealth.com)
 * @brief 相角計算
 * @version 0.1
 * @date 2019-06-05
 *
 * @copyright BEST HEALTH ELECTRONIC INC (c) 2019
 *
 */
#include "..\source\common.h"
#include <math.h>
#define M_PI_1  3.14159265358979
#define M_PI_2  1.57079632679489

/**
 * @brief 根據實部和虛部值計算相角值
 *
 * @param re 實部值,MOD1ON~MOD1OP
 * @param im 虛部值,MOD2ON~MOD2OP
 * @return double v 相角值
 */
double GetPhase(double re,double im)
{
    double v;
    if(fabs(re) >= fabs(im))
    {
        v = atan(im/re);
        if( re < 0.0)
        {
            if(im >= 0.0)
                v += M_PI_1;
            else
                v -= M_PI_1;
        }
    }
    else
    {
        v = -atan(re/im);
        if(im < 0.)
            v -= M_PI_2;
        else
            v += M_PI_2;
    }
    v = v*180 / M_PI_1;
    return v;
}

/**
 * @brief 根據實部和虛部值計算Z值
 *
 * @param a 實部值,MOD1ON~MOD1OP
 * @param b 虛部值,MOD2ON~MOD2OP
 * @return c Z_adc值
 */
double Pythagoreantheorem(double re,double im)
{
    double c;
    c = (double)re*re+(double)im*im;
    c = sqrt(c);
    return c;
}