/**
 * @file SDK_ADCFilter_IIR.c
 * @author 陳挺 (tony@e-besthealth.com)
 * @brief IIR 濾波
 * 1. IIR 濾波數據
 * 2. 原始數據為24/20Bit
 * 3. 濾波輸出結果可以為20/16Bit
 * 4. 濾波穩定參數可動態調整
 * @version 0.1
 * @date 2020-07-06
 *
 * @copyright BEST HEALTH ELECTRONIC INC (c) 2020
 *
 * Compiler Ver. : V3.57
 * IDE3000  Ver. : V8.02
 * MCU / CFG Ver. :BH66F5362/1.1
 */

#include "..\BH66F2663_Drv\Drv_AFE_ADC.h"
#include "SDK_ADCFilter_IIR.h"
#include "stdlib.h"
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                                  功能說明                                            @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
/*
1. IIR 濾波數據
2. 原始數據為24/20Bit
3. 濾波輸出結果可以為20/16Bit
4. 濾波穩定參數可動態調整
*/

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                                  封庫設置                                            @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#define ADCFilterUseBit 20 // 16 or 20  20精度更高,但ROM & RAM 佔用更大


ADCFilter_t SDKADCFilterData;
long SDKADCSourceData20BitCurrent;
long SDKADCSourceData20BitLast;
/***********************************************
 Function: 濾波參數初始化
 INPUT	:
 OUTPUT	:
 NOTE	:
 **********************************************/
void fun_FilterInit()
{
	SDKADCFilterData.BufMax = 0x80000000;
	SDKADCFilterData.BufMin = 0x7FFFFFFF;
	SDKADCFilterData.Current = 0;
	SDKADCFilterData.StableCntCurrent = 0;
	SDKADCFilterData.flag.b.IsStable = 0;
	SDKADCFilterData.flag.b.IsReady = 0;
}
/***********************************************
 Function: 對採樣的ADC濾波處理
 INPUT	:
 OUTPUT	:
 NOTE	: IIR
 **********************************************/
void fun_Filtering()
{
	if (ADCSourceData.flag.b.IsReady)
	{
		ADCSourceData.flag.b.IsReady = 0;
		// 去除正負轉換為單向線性
//		__32_type temp;
//		temp.byte.byte0 = ADCSourceData.data.byte.ByteLow;
//		temp.byte.byte1 = ADCSourceData.data.byte.ByteMid;
//		temp.byte.byte2 = ADCSourceData.data.byte.ByteHigh + 0x80;
//		temp.byte.byte3 = 0x00;
		SDKADCSourceData20BitCurrent = ADCSourceData.data.ADCData >> 4;

		//快速穩定數據，縮短濾波器滯後的時間參數
		if (labs(SDKADCSourceData20BitCurrent -  SDKADCFilterData.Current) > 6*SDKADCFilterData.StableThreshold)
		{
			fun_FilterInit();
			SDKADCSourceData20BitLast = SDKADCSourceData20BitCurrent;
			SDKADCFilterData.Current = SDKADCSourceData20BitCurrent;
		}
		//濾波器的實現 最新濾波數據 = (a*(上一筆原始ADC值+當前筆原始ADC值)+b*上一次濾波數據)/(a*2+b)
		SDKADCFilterData.Current = 8 * (SDKADCSourceData20BitCurrent + SDKADCSourceData20BitLast) + 112 * SDKADCFilterData.Current;
		SDKADCFilterData.Current /= 128;
		SDKADCSourceData20BitLast = SDKADCSourceData20BitCurrent;
		//取得變化的最大值和最小值
		if (SDKADCFilterData.Current > SDKADCFilterData.BufMax)
		{
			SDKADCFilterData.BufMax = SDKADCFilterData.Current;
		}
		if (SDKADCFilterData.Current < SDKADCFilterData.BufMin)
		{
			SDKADCFilterData.BufMin = SDKADCFilterData.Current;
		}
		//如果連續多次範圍內最大值和最小值差值較小(變化平衡)，鎖定該值
		if ((SDKADCFilterData.BufMax - SDKADCFilterData.BufMin) < SDKADCFilterData.StableThreshold)
		{
			SDKADCFilterData.StableCntCurrent++;
			if (SDKADCFilterData.StableCntCurrent > SDKADCFilterData.StableCntTag)
			{
				SDKADCFilterData.StableCntCurrent = 0;
				SDKADCFilterData.flag.b.IsStable = 1;
			}
		}
		else
		{
			SDKADCFilterData.flag.b.IsStable = 0;
			SDKADCFilterData.StableCntCurrent = 0;
			SDKADCFilterData.BufMax = 0x80000000;
			SDKADCFilterData.BufMin = 0x7FFFFFFF;
		}
#if ADCFilterUseBit == 16
		SDKADCFilterData.Current = SDKADCFilterData.Current >> 4; // 20Bit 取16bit
#endif
		SDKADCFilterData.flag.b.IsReady = 1;
	}
}

///**
// * @brief 取a b兩個無符號long型數據的差值
// *
// * @param a 參數a
// * @param b 參數b
// * @return unsigned long 返回結果
// */
//unsigned long fun_unsigned32BitABS(long a, long b)
//{
//	if (a > b)	{ return (a - b); }
//	else		{ return (b - a); }
//}