#ifndef SDK_BODY_SCALES_H
#define SDK_BODY_SCALES_H

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                                稱重規格  設置                                       @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#define SET_ADC_DATARATE_AUTOON()  {SET_ADC_DATARATE3_1300HZ();}
#define SET_ADC_DATARATE_NORMAL()  {SET_ADC_DATARATE3_10HZ();}

// operate : Bit        function: weight auto calibration Control
#define WEIGHT_AUTOCAL          1   // Range 0~1  1 Enable  0 Disable  Default 1
// operate : Bit        function: weight auto unlock Control
#define WEIGHT_AUTOUNLOCK       1   // Range 0~1  1 Enable  0 Disable  Default 1
// operate : numeric    function: weight auto unlock weight
#define WEIGHT_UNLOCK_TEMP      60  // Range 20~100 臨時解鎖重量= x公斤*20 ,SDK都以0.1斤分辨率 Default 60
#define WEIGHT_UNLOCK_STATE     60  // Range 20~100 穩定解鎖重量= x公斤*20 ,SDK都以0.1斤分辨率 Default 60
// operate : numeric    function: max weight
#define WEIGHT_MAX              3100    // Range 3100~4000 最大稱重重量= x公斤*20 ,SDK都以0.1斤分辨率 Default 3100
// operate : numeric    function: min weight
#define WEIGHT_MIN              100     // Range    70~100 最小稱重重量= x公斤*20 ,SDK都以0.1斤分辨率 Default 100
// operate : numeric    function: scales auto on from halt weight
#define WEIGHT_AUTOON           100     // Range   100~140 自動喚醒重量= x公斤*20 ,SDK都以0.1斤分辨率 Default 100
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                                稱重濾波  設置                                       @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//operate : numeric  	fution: ~~
#define ADCSTABLE_WEIGHT_CNT        10 //  range:  8~20 	數值越大，濾波要求越嚴格
//operate : numeric  	fution: ~~
#define ADCSTABLE_WEIGHT_THRESHOLD  10 // range: 1000~3000    數值越大，濾波比較寬松,建議使用1個分辨率對應的ADC值
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

typedef long typedefWeight;

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                                  對外參數                                            @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
typedef enum
{
    // 普通稱重
    STATE_WEIGHT_PREPARE = 1,  // 3 稱重準備中
    STATE_WEIGHT_NOLOAD = 2,   // 4 空載/當前重量小於最小稱重重量
    STATE_WEIGHT_LOADUP = 3,   // 5 有上稱動作/鎖定狀態下加載解鎖重量,重量由0點變成>最小稱重重量
    STATE_WEIGHT_LOADOK = 4,   // 6完成一次稱重測量
    STATE_WEIGHT_LOADFIX= 5,  // 7 完成一次稱重測量后重量穩定沒有解鎖
    STATE_WEIGHT_LOADDOWN= 6, // 8 下秤動作
    STATE_WEIGHT_OVERLOAD= 7, // 9 超重,當前重量大於最大稱重重量

    // 自動上稱
    STATE_AUTOON_FASTMODE= 8, // 11 快速ADC自動上稱判斷
    STATE_AUTOON_SLOWMODE= 9, // 12 慢速ADC自動上稱判斷
    STATE_AUTOON_PASS= 10,     // 13 自動上稱OK, 此時可以點亮顯示,并切換到普通稱重模式進行MCU的正常工作
    STATE_AUTOON_FAIL= 11,     // 14 自動上秤失敗,此時請繼續讓 MCU 進入HALT狀態
    // 重量校準標定
    STATE_WEIGHT_CAL0= 12,     // 16 正在標定零點
    STATE_WEIGHT_CAL1= 13,     // 17 正在標定第1點
    STATE_WEIGHT_CAL2= 14,     // 18 正在標定第2點
    STATE_WEIGHT_CAL3= 15,     // 19 正在標定第3點
    STATE_WEIGHT_CALCHECK= 16, // 20 標定判斷
    STATE_WEIGHT_CALPASS= 17,  // 21 標定成功
    STATE_WEIGHT_CALFAIL= 18,  // 22 標定失敗
} BHSDKState_t;

typedef struct
{
    unsigned char status;
    unsigned char Span;	        // R    ADC值 - 1個分辨率
    struct
    {
        typedefWeight Cal0;	    // R    ADC值 - 零點重量
        typedefWeight Cal1;	    // R    ADC值 - 第1個標定重量
        typedefWeight Cal2;	    // R    ADC值 - 第2個標定重量
        typedefWeight Cal3;	    // R    ADC值 - 第3個標定重量
    }CalADCData;// 校準數據
    struct
    {
        typedefWeight Cal0;	    // R    ADC值 - 零點重量
        typedefWeight Cal1;	    // R    ADC值 - 第1個標定重量
        typedefWeight Cal2;	    // R    ADC值 - 第2個標定重量
        typedefWeight Cal3;	    // R    ADC值 - 第3個標定重量
    }CalADCDataTemp; // 校準中數據,for debug
	union {
		struct
		{
			unsigned char IsNeedTare : 1;  // RW 去皮,當前重量為穩定重量時當前重量為0
		} b;
		unsigned char byte;
	} flag;
}WeightCal_t;

typedef struct
{
    union {
        struct
        {
            unsigned char IsAutoCalOn : 1;    // 自動校準开启
            unsigned char IsAutoUnlockOn : 1; // 自動解鎖开启
        } b;
        unsigned char byte;
    } flag;
    unsigned char statusRead;
    unsigned char statusSet;
    unsigned int  DataCurrent;  // R    当前重量值,單位為jin,放大10倍, 若500,表示重量為50.0斤
    unsigned int  DataStable;   // R    穩定重量值,單位為jin,放大10倍, 若500,表示重量為50.0斤
}Weight_t;






extern Weight_t SDKWeight;
extern WeightCal_t SDKWeightCal;


void fun_WeightPowerOn();
void fun_WeightPowerDown();

void fun_Weight_Normal();

void fun_Weight_AutoOn();

void fun_weight_Cal();


#endif