#include "common.h"

void main()
{
	// 判斷是否為上電復位或者非正常情況下的復位
	// 如果是上電復位，執行上電復位初始化，反之執行WDT溢出初始化
	if (_to == 0 || _pdf ==0)
	{
		Drv_GPIOPowerOnInit();
		Drv_SysClockInit();
		Drv_RamInit();
		Drv_WDTTIME_125MS();
		Drv_LVR_2_1V();
		Drv_PTMn_Timer_Init(0,TIMECLOCK_FH_16,1000);
		Drv_PTMn_COUNTER_POWER(0,ON);

		Drv_TIMEBASE_8MS(0);
		Drv_TIMEBASE_ENABLE(0);
		Drv_TIMEBASE_1000MS(1);
		Drv_TIMEBASE_ENABLE(1);
		Drv_UartFormatSetting();
		Drv_UART_ENABLE();

		// LED Display
		SDK_LED_PowerOnInit();
		// Weight
		fun_WeightPowerOn();



		ADCState = ADC_WEIGHT_NORMAL;
		SDKWeight.statusSet = MODE_INIT;
       	SDKWeightCal.flag.b.IsNeedTare = 1;
		haltTime = HALTTIME_DEFAULT - HALTTIME15S;
	}
	else
	{
		// WDT溢出復位初始化
		GCC_CLRWDT();
	}
	//主循環
	while(1)
	{
		haltTime = 0;
		GCC_CLRWDT();
		UserUi();
		fun_Protocol_Manger();
	}
}