/**
 * @file Drv_AFE_ADC.c
 * @author 陳挺 (tony@e-besthealth.com)
 * @brief
 * @version 0.1
 * @date 2019-11-29
 *
 * @copyright BEST HEALTH ELECTRONIC INC (c) 2019
 *
 * Compiler Ver. : V3.57
 * IDE3000  Ver. : V8.03
 * MCU / CFG Ver. :BH66F2663/1.3
 */

#include "Project_Global.h"
#include "BH66F2663.h"
#include "Drv_AFE_ADC.h"

volatile ADCSource_t ADCSourceData; //*< 原始ADC數據, 中斷內有使用，使用 volatile 修飾

/**
 * @brief 開啟ADC電源并開始ADC轉換
 * @note 調用此函數后會開啟全局中斷 emi,默認使用中斷方式獲取ADC數據
 * @warning 調用此函數前請完成ADC採樣率、放大倍率、採樣通道等配置
 */
void Drv_ADCStart()
{
	// SET_ADC_INPUT_SHORT(ENABLE);	// for ENOB test
	SET_ADCPOWER(ON);
	SET_ADCINTERRUPT_ENABLE();
	SET_ADC_STARTCONVERT();
	ADCSourceData.SamplingCnt = 0;
	ADCSourceData.flag.b.IsReady = 0;
}
/**
 * @brief 停止ADC轉換并關閉ADC電源
 *
 */
void Drv_ADCStop()
{
	ADCSourceData.flag.b.IsReady = 0;
	ADCSourceData.SamplingCnt = 0;
	SET_ADCPOWER(OFF);
}

/**
 * @brief ADC 中斷函數
 *
 */
DEFINE_ISR(ADC_ISR, 0x00C)
{
	if (_eoc == 1)
	{ //ADC 轉換完成
		ADCSourceData.SamplingCnt++;
		if (ADCSourceData.SamplingCnt > 3)	//Delta Sigma ADC 前三筆數據丟掉，第四筆才開始處理
		{
			_adcdl = 1;// before Read current ADC  need lock current Data
			ADCSourceData.data.byte.ByteLow  = 0x00;
			ADCSourceData.data.byte.ByteMid  = _adrl;
			ADCSourceData.data.byte.ByteHigh = _adrm;
			ADCSourceData.data.byte.ByteRes  = _adrh;
			ADCSourceData.data.ADCData = ADCSourceData.data.ADCData/256;
			_adcdl = 0; //數據讀取完成，取消鎖存
			ADCSourceData.flag.b.IsReady = 1;
		}
		_eoc = 0;
	}
}
