/**
 * @file Drv_BIA.c
 * @author 陳挺 (tony@e-besthealth.com)
 * @brief
 * @version 0.1
 * @date 2019-11-29
 *
 * @copyright BEST HEALTH ELECTRONIC INC (c) 2019
 *
 * Compiler Ver. : V3.57
 * IDE3000  Ver. : V8.02
 * MCU / CFG Ver. :BH66F2663/1.2
 */

#include "Project_Global.h"
#include "BH66F2663.h"
#include "Drv_AFE_Power.h"
#include "Drv_BIA.h"
#include "Drv_AFE_ADC.h"

static  volatile  unsigned int SinDataRam[32] __attribute__ ((at(0x300)));
/**
 * @brief Sine Wave 波形描繪點,依據不同的系統頻率 & sine wave 頻率設置載入不同的 TABLE
 *
 * @remarks 輸出的Sine Wave 峰峰值= Voreg*BIA8Setting.PeaKScales
 */
const unsigned int SinData_32[32] = {
  0,  50, 100,	148 ,196 ,241 ,284 ,324 ,361 ,395 ,425 ,451,472 ,489 ,501 ,509 ,511 ,509 ,501 ,489 ,
472, 451, 425,  395, 361 ,324 ,284 ,241 ,196 ,148 ,100 ,50,
};
const unsigned int SinData_24[32] = {
  0,  67, 132, 196, 256, 311, 361, 405, 443, 472, 494, 507, 511, 507, 494, 472, 443, 405, 361, 311,
256, 196, 132,  67,   0,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
};
const unsigned int SinData_20[32] = {
  0,  80, 158, 232, 300, 361, 413, 455, 486, 505, 511, 505, 486, 455, 413, 361, 300, 232, 158,  80,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};
const unsigned int SinData_16[32] = {
  0, 100, 196, 284, 361, 425, 472, 501, 511, 501, 472, 425, 361, 284, 196, 100,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};
const unsigned int SinData_12[32] = {
  0, 132, 256, 361, 443, 494, 511, 494, 443, 361, 256, 132,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};
const unsigned int SinData_8[32] = {
  0, 196, 361, 472, 511, 472, 361, 196,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};
const unsigned int SinData_4[32] = {
  0, 361, 511, 361,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};


//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ======================================================@
//                Drv_BIA.c 預處理接口                    @
// ======================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                              BIA OPA    基本設置                                     @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// OPA
#define SET_BODY_OPA_POWER(x)      {_opaen = x; _bren = x;}

// 玄波發送器開關
#define SET_SINE_POWER(x)           {  _sgen = x; }  //!< sine Wave 輸出 關閉
#define SET_SINE_RESET()            {_sgiqrs = 1; _sgiqrs = 0; }

#define SET_BODY_OPA_MODE_CALOFFSET()   {_opa1c = 0xC0;}
#define SET_BODY_OPA_MODE_NORMAL()      {_op1ofm = 0;}
// SYNC Mode
#define SET_SYNC_MODE_INTERNAL()    { _extsync = 0;}    //!< SYNC mode selection: Internal sync mode
#define SET_SYNC_MODE_EXTERNAL()    { _extsync = 1;}    //!< SYNC mode selection: External sync mode
// OPA 放大倍數設定
#define	SET_BODYFAT_OPAGAIN_1()			{ _opac &= 0xF0; _opac |= 0x00;}
#define	SET_BODYFAT_OPAGAIN_1_14()		{ _opac &= 0xF0; _opac |= 0x01;}
#define	SET_BODYFAT_OPAGAIN_1_31()		{ _opac &= 0xF0; _opac |= 0x02;}
#define	SET_BODYFAT_OPAGAIN_1_5()		{ _opac &= 0xF0; _opac |= 0x03;}
#define	SET_BODYFAT_OPAGAIN_1_73()		{ _opac &= 0xF0; _opac |= 0x04;}
#define	SET_BODYFAT_OPAGAIN_2()			{ _opac &= 0xF0; _opac |= 0x05;}
#define	SET_BODYFAT_OPAGAIN_2_33()		{ _opac &= 0xF0; _opac |= 0x06;}
#define	SET_BODYFAT_OPAGAIN_2_75()		{ _opac &= 0xF0; _opac |= 0x07;}
#define	SET_BODYFAT_OPAGAIN_3_285()		{ _opac &= 0xF0; _opac |= 0x08;}
#define	SET_BODYFAT_OPAGAIN_4()			{ _opac &= 0xF0; _opac |= 0x09;}
#define	SET_BODYFAT_OPAGAIN_5() 		{ _opac &= 0xF0; _opac |= 0x0A;}
// IQ/FWR mode selection
#define SET_BODYFAT_MODE_IQ()            { _iq_fwr = 0;}//!< Demodulator 輸出模式 IQ Mode  MOD1OP&MOD1ON 為實部信息,MOD2OP&MOD2ON 為虛部信息
#define SET_BODYFAT_MODE_FWR()           { _iq_fwr = 1;}//!< Demodulator 輸出模式 FWR Mode MOD1OP&MOD1ON 為Z值信息 ,MOD2OP&MOD2ON 無效
// 體阻抗開關列表
#define SET_BODYFAT_SWC_OPEN()          { _swc0 = 0x00; _swc1 = 0x00; _swc2 = 0x00; _swc3 = 0x00;}	// 所有斷開
// 參考電阻
#define SET_BODYFAT_SWC_RF4_RF1()       { _swc0 = 0x00; _swc1 = 0xAC; _swc2 = 0x00; _swc3 = 0x00;}	// 開啟RF1電路
#define SET_BODYFAT_SWC_RF4_RF2()       { _swc0 = 0x00; _swc1 = 0x66; _swc2 = 0x00; _swc3 = 0x00;}	// 開啟RF2電路
#define SET_BODYFAT_SWC_RF4_RF3()       { _swc0 = 0x00; _swc1 = 0x99; _swc2 = 0x00; _swc3 = 0x00;}	// 開啟RF3電路
#define SET_BODYFAT_SWC_RF4_RF4()       { _swc0 = 0x00; _swc1 = 0x53; _swc2 = 0x00; _swc3 = 0x00;}	// 開啟RF4電路
//
// 量測通道
#define SET_BODYFAT_SWC3_TWOLEGS()       { _swc0 = 0x00; _swc1 = 0x00; _swc2 = 0x1E; _swc3 = 0x00;}	// 雙腳
#define SET_BODYFAT_SWC1_TWOARMS()       { _swc0 = 0xF0; _swc1 = 0x00; _swc2 = 0x00; _swc3 = 0x00;}  // 雙手
#define SET_BODYFAT_SWC1_LEFTARM()       { _swc0 = 0x70; _swc1 = 0x00; _swc2 = 0x04; _swc3 = 0x00;}  // 左手
#define SET_BODYFAT_SWC3_LEFTLEG()       { _swc0 = 0x07; _swc1 = 0x00; _swc2 = 0x01; _swc3 = 0x00;}  // 左腳
#define SET_BODYFAT_SWC1_LEFTBODY()      { _swc0 = 0x30; _swc1 = 0x00; _swc2 = 0x14; _swc3 = 0x00;}  // 左手+ 軀幹 + 左腳
#define SET_BODYFAT_SWC3_RIGHTBODY()     { _swc0 = 0xC0; _swc1 = 0x00; _swc2 = 0x0A; _swc3 = 0x00;}  // 右手+ 軀幹 + 右腳
#define SET_BODYFAT_SWC3_RIGHTARM()      { _swc0 = 0x08; _swc1 = 0x00; _swc2 = 0xE0; _swc3 = 0x00;}  // 右手
#define SET_BODYFAT_SWC1_RIGHTLEG()      { _swc0 = 0x80; _swc1 = 0x00; _swc2 = 0x1A; _swc3 = 0x00;}  // 右腳
#define SET_BODYFAT_SWC3_TRUNK2()	     { _swc0 = 0x81; _swc1 = 0x00; _swc2 = 0x82; _swc3 = 0x00;}  // 躯干
#define SET_BODYFAT_SWC3_RIGHTRAMANDLEFTLEG() { _swc0 = 0xC3; _swc1 = 0x00; _swc2 = 0x00; _swc3 = 0x00;} // 右手左腳
#define SET_BODYFAT_SWC1_LEFTRAMANDRIGHTLEG() { _swc0 = 0x3C; _swc1 = 0x00; _swc2 = 0x00; _swc3 = 0x00;} // 左手右腳

// DEBUG 開關測試
#define SET_BODYFAT_DEBUGSWC1_TWOLEGS()       { _swc0 = 0x0A; _swc1 = 0x00; _swc2 = 0x00; _swc3 = 0x00;}	// 雙腳	電流開關SW1-3同2662 電壓開關ALLOFF
#define SET_BODYFAT_DEBUGSWC2_TWOLEGS()       { _swc0 = 0x0B; _swc1 = 0x00; _swc2 = 0x00; _swc3 = 0x00;}	// 雙腳	電流開關SW1-3同2662 電壓開關SW0
#define SET_BODYFAT_DEBUGSWC3_TWOLEGS()       { _swc0 = 0x0A; _swc1 = 0x00; _swc2 = 0x08; _swc3 = 0x00;}	// 雙腳	電流開關SW1-3同2662 電壓開關SWK
#define SET_BODYFAT_DEBUGSWC4_TWOLEGS()       { _swc0 = 0x0A; _swc1 = 0x00; _swc2 = 0x10; _swc3 = 0x00;}	// 雙腳	電流開關SW1-3同2662 電壓開關SWL
#define SET_BODYFAT_DEBUGSWC5_TWOLEGS()       { _swc0 = 0x0E; _swc1 = 0x00; _swc2 = 0x00; _swc3 = 0x00;}	// 雙腳	電流開關SW1-3同2662 電壓開關SW2
#define SET_BODYFAT_DEBUGSWC6_TWOLEGS()       { _swc0 = 0x0A; _swc1 = 0x00; _swc2 = 0x18; _swc3 = 0x00;}	// 雙腳	電流開關SW1-3同2662 電壓開關SWL-K
#define SET_BODYFAT_DEBUGSWC7_TWOLEGS()       { _swc0 = 0x0F; _swc1 = 0x00; _swc2 = 0x00; _swc3 = 0x00;}	// 雙腳	電流開關SW1-3同2662 電壓開關SW2-0	+
#define SET_BODYFAT_DEBUGSWC8_TWOLEGS()       { _swc0 = 0x0B; _swc1 = 0x00; _swc2 = 0x10; _swc3 = 0x00;}	// 雙腳	電流開關SW1-3同2662 電壓開關SWL-0
#define SET_BODYFAT_DEBUGSWC9_TWOLEGS()       { _swc0 = 0x0E; _swc1 = 0x00; _swc2 = 0x08; _swc3 = 0x00;}	// 雙腳	電流開關SW1-3同2662 電壓開關SW2-K

// SINE Freq
#if SYS_CLOCK_FREQ == 4000000
#define SET_SINTABLE_5KHz           SinData_20
#define SET_SINTABLE_10KHz          SinData_20
#define SET_SINTABLE_20KHz          SinData_20
#define SET_SINTABLE_25KHz          SinData_20
#define SET_SINTABLE_50KHz          SinData_20
#define SET_SINTABLE_100KHz         SinData_20
#define SET_SINTABLE_250KHz         SinData_8
#define SET_SINTABLE_500KHz         SinData_4
#define SET_SINFREQ_5KHz()			{ _sgn = 19; _sgdnr = 19;}
#define SET_SINFREQ_10KHz()			{ _sgn =  9; _sgdnr = 19;}
#define SET_SINFREQ_20KHz()			{ _sgn =  4; _sgdnr = 19;}
#define SET_SINFREQ_25KHz()			{ _sgn =  3; _sgdnr = 19;}
#define SET_SINFREQ_50KHz()			{ _sgn =  1; _sgdnr = 19;}
#define SET_SINFREQ_100KHz()		{ _sgn =  0; _sgdnr = 19;}
#define SET_SINFREQ_250KHz()		{ _sgn =  0; _sgdnr =  7;}
#define SET_SINFREQ_500KHz()		{ _sgn =  0; _sgdnr =  3;}
#endif
#if SYS_CLOCK_FREQ == 8000000
#define SET_SINTABLE_5KHz           SinData_32
#define SET_SINTABLE_10KHz          SinData_20
#define SET_SINTABLE_20KHz          SinData_20
#define SET_SINTABLE_25KHz          SinData_32
#define SET_SINTABLE_50KHz          SinData_20
#define SET_SINTABLE_100KHz         SinData_20
#define SET_SINTABLE_200KHz         SinData_20
#define SET_SINTABLE_250KHz         SinData_16
#define SET_SINTABLE_500KHz         SinData_8
#define SET_SINTABLE_1000KHz        SinData_4
#define SET_SINFREQ_5KHz()			{ _sgn = 24; _sgdnr = 31;}
#define SET_SINFREQ_10KHz()			{ _sgn = 19; _sgdnr = 19;}
#define SET_SINFREQ_20KHz()			{ _sgn =  9; _sgdnr = 19;}
#define SET_SINFREQ_25KHz()			{ _sgn =  4; _sgdnr = 31;}
#define SET_SINFREQ_50KHz()			{ _sgn =  3; _sgdnr = 19;}
#define SET_SINFREQ_100KHz()		{ _sgn =  1; _sgdnr = 19;}
#define SET_SINFREQ_200KHz()		{ _sgn =  0; _sgdnr = 19;}
#define SET_SINFREQ_250KHz()		{ _sgn =  0; _sgdnr = 15;}
#define SET_SINFREQ_500KHz()		{ _sgn =  0; _sgdnr =  7;}
#define SET_SINFREQ_1000KHz()		{ _sgn =  0; _sgdnr =  3;}
#endif
#if SYS_CLOCK_FREQ == 12000000
#define SET_SINTABLE_5KHz           SinData_24
#define SET_SINTABLE_10KHz          SinData_24
#define SET_SINTABLE_20KHz          SinData_20
#define SET_SINTABLE_25KHz          SinData_24
#define SET_SINTABLE_50KHz          SinData_24
#define SET_SINTABLE_100KHz         SinData_20
#define SET_SINTABLE_250KHz         SinData_24
#define SET_SINTABLE_500KHz         SinData_12
#define SET_SINTABLE_1000KHz        SinData_8
#define SET_SINFREQ_5KHz()			{ _sgn = 49; _sgdnr = 23;}
#define SET_SINFREQ_10KHz()			{ _sgn = 24; _sgdnr = 23;}
#define SET_SINFREQ_20KHz()			{ _sgn = 14; _sgdnr = 19;}
#define SET_SINFREQ_25KHz()			{ _sgn =  9; _sgdnr = 23;}
#define SET_SINFREQ_50KHz()			{ _sgn =  4; _sgdnr = 23;}
#define SET_SINFREQ_100KHz()		{ _sgn =  2; _sgdnr = 19;}
#define SET_SINFREQ_250KHz()		{ _sgn =  0; _sgdnr = 23;}
#define SET_SINFREQ_500KHz()		{ _sgn =  0; _sgdnr = 11;}
#define SET_SINFREQ_1000KHz()		{ _sgn =  0; _sgdnr =  7;}
#endif




BIA8Setting_t BIA8Setting;

/**
 * @brief 開啟BREN&OPA1  並校準Vos 校準完成後 關閉 OPA1&BREN
 *
 * @warning  OPA1 電源來自 Voreg 調用此函數前必須開啟 Voreg
 */
void Drv_CalOPA1Offset()
{
	volatile bit OPAStatus;
	volatile unsigned char i, OPAVosData0 , OPAVosData1;
	SET_BODY_OPA_MODE_CALOFFSET();
	SET_BODY_OPA_POWER(ON);
	_opa1c &= 0xE0;
	GCC_DELAY(1000);
	if (_op1do)	{ OPAStatus = 0x01;	}
	else		{ OPAStatus = 0x00;	}
	for (i = 0; i < 32; i++)
	{
		_opa1c++;
		GCC_DELAY(1000);
		if (_op1do != OPAStatus)
		{ OPAVosData0 = _opa1c & 0x1f;	break;}
	}
	_opa1c |= 0x1F;
	GCC_DELAY(1000);
	if (_op1do) { OPAStatus = 0x01;	}
	else		{ OPAStatus = 0x00;	}
	for (i = 0; i < 32; i++)
	{
		_opa1c--;
		GCC_DELAY(1000);
		if (_op1do != OPAStatus)
		{	OPAVosData1 = _opa1c & 0x1f;	break;}
	}
	_opa1c = (OPAVosData0 + OPAVosData1)/2;
	SET_BODY_OPA_POWER(OFF);
	SET_BODY_OPA_MODE_NORMAL();
}


/**
 * @brief 設置 Sine wave 輸出固定頻率或者關閉sine wave 輸出
 *
 * @param SineWaveSet.Freq   頻率設置 SINWAVEFREQ_OFF為關閉輸出
 * @note 每個系統頻率的峰峰值都可以單獨調節，默認為0.5* voreg電壓
 */
void Drv_BIAPowerOn()
{
    Drv_CalOPA1Offset();
    SET_BODYFAT_OPAGAIN_1_5();
    SET_BODY_OPA_POWER(ON); // reset 前OPA必須開啟
    SET_SINE_POWER(OFF); // 載入Sine wave Data 前必須關閉 Sine 發生器
    unsigned char i;
    switch (BIA8Setting.Freq)
    {
    case SINWAVEFREQ_5KHZ:
        for (i = 0; i < 32; i++)
        {
            SinDataRam[i] = BIA8Setting.PeaKScales * SET_SINTABLE_5KHz[i];
        }
        SET_SINFREQ_5KHz();
        break;
    case SINWAVEFREQ_10KHZ:
        for (i = 0; i < 32; i++)
        {
            SinDataRam[i] = BIA8Setting.PeaKScales * SET_SINTABLE_10KHz[i];
        }
        SET_SINFREQ_10KHz();
        break;
    case SINWAVEFREQ_20KHZ:
        for (i = 0; i < 32; i++)
        {
            SinDataRam[i] = BIA8Setting.PeaKScales * SET_SINTABLE_20KHz[i];
        }
        SET_SINFREQ_20KHz();
        break;
    case SINWAVEFREQ_25KHZ:
        for (i = 0; i < 32; i++)
        {
            SinDataRam[i] = BIA8Setting.PeaKScales * SET_SINTABLE_25KHz[i];
        }
        SET_SINFREQ_25KHz();
        break;
    case SINWAVEFREQ_50KHZ:
        for (i = 0; i < 32; i++)
        {
            SinDataRam[i] = BIA8Setting.PeaKScales * SET_SINTABLE_50KHz[i];
        }
        SET_SINFREQ_50KHz();
        break;
    case SINWAVEFREQ_100KHZ:
        for (i = 0; i < 32; i++)
        {
            SinDataRam[i] = BIA8Setting.PeaKScales * SET_SINTABLE_100KHz[i];
        }
        SET_SINFREQ_100KHz();
        break;
#if SYS_CLOCK_FREQ == 8000000
    case SINWAVEFREQ_200KHZ:
        for (i = 0; i < 32; i++)
        {
            SinDataRam[i] = BIA8Setting.PeaKScales * SET_SINTABLE_200KHz[i];
        }
        SET_SINFREQ_200KHz();
        break;
#endif
    case SINWAVEFREQ_250KHZ:
        for (i = 0; i < 32; i++)
        {
            SinDataRam[i] = BIA8Setting.PeaKScales * SET_SINTABLE_250KHz[i];
        }
        SET_SINFREQ_250KHz();
        break;
    case SINWAVEFREQ_500KHZ:
        for (i = 0; i < 32; i++)
        {
            SinDataRam[i] = BIA8Setting.PeaKScales * SET_SINTABLE_500KHz[i];
        }
        SET_SINFREQ_500KHz();
        break;
#if (SYS_CLOCK_FREQ == 8000000 || SYS_CLOCK_FREQ == 12000000)
    case SINWAVEFREQ_1000KHZ:
        for (i = 0; i < 32; i++)
        {
            SinDataRam[i] = BIA8Setting.PeaKScales * SET_SINTABLE_1000KHz[i];
        }
        SET_SINFREQ_1000KHz();
        break;
#endif
    default:
        break;
    }
    SET_SYNC_MODE_INTERNAL();
    if (BIA8Setting.IQ_FWR)
    {
        SET_BODYFAT_MODE_IQ();
    }
    else
    {
        SET_BODYFAT_MODE_FWR();
    }
    SET_SINE_RESET();
    SET_SINE_POWER(ON);
}


void Drv_BIAPowerDown()
{
	Drv_ADCStop();
	Drv_VOREG_OUTPUT(VOREG_POWEROFF);	
    SET_SINE_POWER(OFF);
    SET_BODY_OPA_POWER(OFF);
}



void Drv_BIA8ChannelSwich(enum BIA8_CHANNEL_t BIA8channel)
{
    if (BIA8channel & BIA8_CHANNEL_RF1)
    {
        SET_BODYFAT_SWC_RF4_RF1();
    }
    else if (BIA8channel & BIA8_CHANNEL_RF2)
    {
        SET_BODYFAT_SWC_RF4_RF2();
    }
    else if (BIA8channel & BIA8_CHANNEL_RF3)
    {
        SET_BODYFAT_SWC_RF4_RF3();
    }
    else if (BIA8channel & BIA8_CHANNEL_RF4)
    {
        SET_BODYFAT_SWC_RF4_RF4();
    }
    else if (BIA8channel & BIA8_CHANNEL_TWOLEGS)
    {
        SET_BODYFAT_SWC3_TWOLEGS();
    }
    else if (BIA8channel & BIA8_CHANNEL_TWOARMS)
    {
        SET_BODYFAT_SWC1_TWOARMS();
    }
    else if (BIA8channel & BIA8_CHANNEL_LEFTARM)
    {
        SET_BODYFAT_SWC1_LEFTARM();
    }
    else if (BIA8channel & BIA8_CHANNEL_RIGHTARM)
    {
        SET_BODYFAT_SWC3_RIGHTARM();
    }
    else if (BIA8channel & BIA8_CHANNEL_LEFTLEG)
    {
        SET_BODYFAT_SWC3_LEFTLEG();
    }
    else if (BIA8channel & BIA8_CHANNEL_RIGHTLEG)
    {
        SET_BODYFAT_SWC1_RIGHTLEG();
    }
    else if (BIA8channel & BIA8_CHANNEL_LEFTBODY)
    {
        SET_BODYFAT_SWC1_LEFTBODY();
    }
    else if (BIA8channel & BIA8_CHANNEL_RIGHTBODY)
    {
        SET_BODYFAT_SWC3_RIGHTBODY();
    }
    else if (BIA8channel & BIA8_CHANNEL_LEFTRAMANDRIGHTLEG)
    {
        SET_BODYFAT_SWC1_LEFTRAMANDRIGHTLEG();
    }
    else if (BIA8channel & BIA8_CHANNEL_RIGHTRAMANDLEFTLEG)
    {
        SET_BODYFAT_SWC3_RIGHTRAMANDLEFTLEG();
    }
    else if (BIA8channel & BIA8_CHANNEL_TRUNK)
    {
        SET_BODYFAT_SWC3_TRUNK2();
    }
}