/**
 * @file Drv_GPIO.c
 * @author 陳挺 (tony@e-besthealth.com)
 * @brief  GPIO調用接口
 * @version 0.1
 * @date 2020-06-30
 *
 * @copyright BEST HEALTH ELECTRONIC INC (c) 2019
 *
 * Compiler Ver. : V3.57
 * IDE3000  Ver. : V8.03
 * MCU/CFG  Ver. : BH66F2663/1.3
 */

#include "Project_Global.h"
#include "BH66F2663.h"
#include "Drv_GPIO.h"

/**
 * @brief GPIO初始化，未使用IO
 * @warning 需要根據實際硬件配置所有IO
 *
 * @note 所有未使用IO設置為輸出 Low
 * @attention 以下複用腳使用第一個功能
 */
void Drv_GPIOPowerOnInit()
{
// PA0-XT1      PA1-LVDIN
// PA2-XT2      PA3-OSC2
// PA4-OSC1     PA5-TXD
// PA6-RXD      PA7-SDA
	_pa   = 0B00000000;
	_pac  = 0B00000010;
	_papu = 0B00000010;
	_pawu = 0B00000000;
	_pas0 = 0B00000000;
	_pas1 = 0B00000000;
// PB0-SCL      PB1-AN5
// PB2-SCKA     PB3-SDIA
// PB4-AN2      PB5-AN3
// PB6-Unused   PB7-Unused
	_pb   = 0B00000000;
	_pbc  = 0B00000000;
	_pbpu = 0B00000000;
	_pbs0 = 0B00000000;
	_pbs1 = 0B00000000;
// PC0-Unused   PC1-Unused
// PC2-Unused   PC3-Unused
// PC4-SCSA     PC5-SDOA
// PC6-PC6      PC7-LED-S0
	_pc   = 0B00000000;
	_pcc  = 0B00000000;
	_pcpu = 0B00000000;
	_pcs0 = 0B00000000;
	_pcs1 = 0B00000000;
// PD0-LED-S1   PD1-LED-S2
// PD2-LED-S3   PD3-LED-S4
// PD4-LED-S5   PD5-LED-S6
// PD6-KEY3     PD7-KEY2
	_pd   = 0B00000000;
	_pdc  = 0B11000000;
	_pdpu = 0B11000000;
// PE0-KEY1     PE1-Unused
// PE2-Unused
	_pe   = 0B00000000;
	_pec  = 0B00000001;
	_pepu = 0B00000001;

	_ifs0 = 0B00000000;
	_ifs1 = 0B00000000;
	// Source Current  Bit7~6  Bit5~4  Bit3~2  Bit1~0
	_sledc0 = 0xFF;	// PB7~PB4 PB3~PB0 PA7~PA4 PA3~PA0
	_sledc1 = 0xFF; // PD7~PD4 PD3~PD0 PC7~PC4 PC3~PC0
	_sledc2 = 0xFF;	//  					   PE2~PE0
}

/**
 * @brief 休眠GPIO配置，未使用 IO 輸出 Low
 *
 */
void Drv_GPIOPowerDownInit()
{
// PA0-XT1      PA1-LVDIN
// PA2-XT2      PA3-OSC2
// PA4-OSC1     PA5-TXD
// PA6-RXD      PA7-SDA
	_pa   = 0B00000000;
	_pac  = 0B00000000;
	_papu = 0B00000000;
	_pawu = 0B00000000;
	_pas0 = 0B00000000;
	_pas1 = 0B00000000;
// PB0-SCL      PB1-AN5
// PB2-SCKA     PB3-SDIA
// PB4-AN2      PB5-AN3
// PB6-Unused   PB7-Unused
	_pb   = 0B00000000;
	_pbc  = 0B00000000;
	_pbpu = 0B00000000;
	_pbs0 = 0B00000000;
	_pbs1 = 0B00000000;
// PC0-Unused   PC1-Unused
// PC2-Unused   PC3-Unused
// PC4-SCSA     PC5-SDOA
// PC6-PC6      PC7-LED-S0	 	
	_pc   = 0B00000000;
	_pcc  = 0B00000000;
	_pcpu = 0B00000000;
	_pcs0 = 0B00000000;
	_pcs1 = 0B00000000;
// PD0-LED-S1   PD1-LED-S2
// PD2-LED-S3   PD3-LED-S4
// PD4-LED-S5   PD5-LED-S6
// PD6-KEY3     PD7-KEY2
	_pd   = 0B00000000;
	_pdc  = 0B00000000;
	_pdpu = 0B00000000;
// PE0-KEY1     PE1-Unused
// PE2-Unused	 
	_pe   = 0B00000000;
	_pec  = 0B00000000;
	_pepu = 0B00000000;
}