#ifndef _DRV_UART_H_
#define _DRV_UART_H_

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 共用變量 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#define  UART_LENGTH_TX	100	// 協議中最大的長度
#define  UART_LENGTH_RX	20	// 協議中最大的長度
struct DrvUartFormat_t
{
    unsigned char TxBuf[UART_LENGTH_TX];
    unsigned char RxBuf[UART_LENGTH_RX];
    unsigned char TxBufoffset;
    unsigned char RxBufoffset;
    unsigned char RxTimeOutCnt;
    unsigned char TxCycle;
    unsigned char TxLength;
    unsigned char RxLength;
    union {
		struct
		{
			unsigned char IsBusyTx : 1;  // R 有一筆原始ADC數據
			unsigned char IsRxSuccess : 1;  // R 有一筆原始ADC數據
		} b;
		unsigned char byte;
	} flag;
};
extern volatile struct DrvUartFormat_t DrvUartFormat;

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 共用函數 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
void Drv_UartFormatSetting();
void Drv_UartStartTx( unsigned char TxLength);
unsigned char Drv_WriteTxBuf(char* src, unsigned char startaddr, unsigned char len);
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                                UART  基本設置                                        @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#define Drv_UART_ENABLE()	{ _uarten = 1;_rxen = 1;_txen = 1;_urf = 0;_txif = 0; _ure = 1; _emi = 1; _ure = 1;}
#define Drv_UART_DISABLE()	{ _uarten = 0;_rxen = 0;_txen = 0;}

#define SET_UART_RX_PIN_PA6()   {_pas15 = 1; _pas14 = 1; _rxps1 = 0; _rxps0 = 0;}
#define SET_UART_RX_PIN_PB3()   {_pbs07 = 0; _pbs06 = 1; _rxps1 = 0; _rxps0 = 1;}
#define SET_UART_RX_PIN_PB6()   {_pbs15 = 1; _pbs14 = 0; _rxps1 = 1; _rxps0 = 0;}
#define SET_UART_TX_PIN_PA5()   {_pas13 = 1; _pas12 = 1;}
#define SET_UART_TX_PIN_PC5()   {_pcs13 = 1; _pcs12 = 0;}
#define SET_UART_TX_PIN_PB7()   {_pbs17 = 1; _pbs16 = 0;}

#define SET_UART_Format_D8_P0_S1()			{ _ucr1 = 0x00; }// 傳輸8bit = (8bit-Data  None-Parity  None-Add)1bit-Stop
#define SET_UART_Format_D7_PEVEN_S1()		{ _ucr1 = 0x20; }// 傳輸8bit = (7bit-Data  Even-Parity  None-Add)1bit-Stop
#define SET_UART_Format_D7_PODD_S1()		{ _ucr1 = 0x30; }// 傳輸8bit = (7bit-Data  Odd -Parity  None-Add)1bit-Stop
#define SET_UART_Format_D9_P0_S1()			{ _ucr1 = 0x40; }// 傳輸9bit = (9bit-Data  None-Parity  None-Add)1bit-Stop
#define SET_UART_Format_D8_PEVEN_S1()		{ _ucr1 = 0x60; }// 傳輸9bit = (8bit-Data  Even-Parity  None-Add)1bit-Stop
#define SET_UART_Format_D8_PODD_S1()		{ _ucr1 = 0x70; }// 傳輸9bit = (8bit-Data  Odd-Parity   None-Add)1bit-Stop

#define SET_UART_Format_D8_P0_S2()			{ _ucr1 = 0x00; }// 傳輸8bit = (8bit-Data  None-Parity  None-Add)2bit-Stop
#define SET_UART_Format_D7_PEVEN_S2()		{ _ucr1 = 0x20; }// 傳輸8bit = (7bit-Data  Even-Parity  None-Add)2bit-Stop
#define SET_UART_Format_D7_PODD_S2()		{ _ucr1 = 0x30; }// 傳輸8bit = (7bit-Data  Odd -Parity  None-Add)2bit-Stop
#define SET_UART_Format_D9_P0_S2()			{ _ucr1 = 0x40; }// 傳輸9bit = (9bit-Data  None-Parity  None-Add)2bit-Stop
#define SET_UART_Format_D8_PEVEN_S2()		{ _ucr1 = 0x60; }// 傳輸9bit = (8bit-Data  Even-Parity  None-Add)2bit-Stop
#define SET_UART_Format_D8_PODD_S2()		{ _ucr1 = 0x70; }// 傳輸9bit = (8bit-Data  Odd-Parity   None-Add)2bit-Stop

#define SET_UART_WAKEUP_ENABLE()				{ _wake  = 1;}
#define SET_UART_WAKEUP_DISABLE()				{ _wake  = 0;}
#define SET_UART_ADDRESS_ENABLE()				{ _adden = 1;}
#define SET_UART_ADDRESS_DISABLE()				{ _adden = 0;}
#define SET_UART_RECEIVER_IE_ENABLE()			{ _rie  = 1;} // OERR(溢出)/RXIF(有有效數據)置位時可置中斷標誌位
#define SET_UART_RECEIVER_IE_DISABLE()			{ _rie  = 0;}
#define SET_UART_TRANSMITTER_IE_ENABLE()		{ _tiie = 1;} // TIDLE(無數據傳輸)置位，可置中斷標誌位
#define SET_UART_TRANSMITTER_IE_DISABLE()		{ _tiie = 0;}
#define SET_UART_TRANSMITTER_EMPTY_ENABLE()		{ _teie = 1;} // TXIF(數據已加載到移位暫存器，TXR為空)置位時，可置中斷標誌位
#define SET_UART_TRANSMITTER_EMPTY_DISABLE()    { _teie = 0;}

#if SYS_CLOCK_FREQ == 4000000
    #define SET_UART_BAUD_RATE_300()			{ _brgh = 0; _brg = 207;}
    #define SET_UART_BAUD_RATE_1200()			{ _brgh = 1; _brg = 207;}
    #define SET_UART_BAUD_RATE_2400()			{ _brgh = 1; _brg = 103;}
    #define SET_UART_BAUD_RATE_4800()			{ _brgh = 1; _brg =  51;}
    #define SET_UART_BAUD_RATE_9600()			{ _brgh = 1; _brg =  25;}
    #define SET_UART_BAUD_RATE_19200()		    { _brgh = 1; _brg =  12;}
    #define SET_UART_BAUD_RATE_250000()		    { _brgh = 1; _brg =   0;}
#endif
#if SYS_CLOCK_FREQ == 8000000
    #define SET_UART_BAUD_RATE_1200()			{ _brgh = 0; _brg = 103;}
    #define SET_UART_BAUD_RATE_2400()			{ _brgh = 1; _brg = 207;}
    #define SET_UART_BAUD_RATE_4800()			{ _brgh = 1; _brg = 103;}
    #define SET_UART_BAUD_RATE_9600()			{ _brgh = 1; _brg =  51;}
    #define SET_UART_BAUD_RATE_19200()		    { _brgh = 1; _brg =  25;}
    #define SET_UART_BAUD_RATE_38400()		    { _brgh = 1; _brg =  12;}
    #define SET_UART_BAUD_RATE_250000()		    { _brgh = 1; _brg =   1;}
#endif
#if SYS_CLOCK_FREQ == 12000000
    #define SET_UART_BAUD_RATE_1200()			{ _brgh = 0; _brg = 155;}
    #define SET_UART_BAUD_RATE_2400()			{ _brgh = 0; _brg =  77;}
    #define SET_UART_BAUD_RATE_4800()			{ _brgh = 1; _brg = 155;}
    #define SET_UART_BAUD_RATE_9600()			{ _brgh = 1; _brg =  77;}
    #define SET_UART_BAUD_RATE_19200()		    { _brgh = 1; _brg =  38;}
    #define SET_UART_BAUD_RATE_57600()		    { _brgh = 1; _brg =  12;}
    #define SET_UART_BAUD_RATE_250000()		    { _brgh = 1; _brg =   2;}
#endif

#endif
