#ifndef _LEDSCAN6X5_API_H_
#define _LEDSCAN6X5_API_H_

#include "LedScan7x6.h"
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ======================================================@
//              SDK接口  函數接口                         @
// ======================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
void SDK_LED_PowerOnInit(void);     // 上電初始化
void SDK_LED_Scan(void);            // 定時輪詢，建議2ms
void fun_FW_LEDBuf2HW_LEDBuf();     // 將要顯示的值更新
void fun_HEX2BCD4(unsigned int DisplayNum);
extern SDK_LED_t LED_FW_Map;
extern unsigned char gu8v_LED_BCD_Buffer[4];
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ======================================================@
//              LED符號  LED編號對應表                    @
// ======================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#include "BH66F2663.h"
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                                LED IO config                                        @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// Port data
#define PINSEG_D0     _pc7
#define PINSEG_D1     _pd0
#define PINSEG_D2     _pd1
#define PINSEG_D3     _pd2
#define PINSEG_D4     _pd3
#define PINSEG_D5     _pd4
#define PINSEG_D6     _pd5
// port input or output
#define PINSEG_C0     _pcc7
#define PINSEG_C1     _pdc0
#define PINSEG_C2     _pdc1
#define PINSEG_C3     _pdc2
#define PINSEG_C4     _pdc3
#define PINSEG_C5     _pdc4
#define PINSEG_C6     _pdc5
// port pump high
#define PINSEG_P0     _pcpu7
#define PINSEG_P1     _pdpu0
#define PINSEG_P2     _pdpu1
#define PINSEG_P3     _pdpu2
#define PINSEG_P4     _pdpu3
#define PINSEG_P5     _pdpu4
#define PINSEG_P6     _pdpu5
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                                LED map to IO map                                    @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// 比如LED 對應的IO為，負端接SEG4，正端接SEG5，則#define MAP_LED1    LED_HW_MAP.Buf4.bits.BIT5
#define MAP_LED1    LED_HW_MAP.Buf0.bits.BIT1
#define MAP_LED2    LED_HW_MAP.Buf1.bits.BIT0
#define MAP_LED3    LED_HW_MAP.Buf2.bits.BIT0
#define MAP_LED4    LED_HW_MAP.Buf3.bits.BIT0
#define MAP_LED5    LED_HW_MAP.Buf0.bits.BIT2

#define MAP_LED6    LED_HW_MAP.Buf0.bits.BIT3
#define MAP_LED7    LED_HW_MAP.Buf1.bits.BIT2
#define MAP_LED8    LED_HW_MAP.Buf1.bits.BIT3
#define MAP_LED9    LED_HW_MAP.Buf2.bits.BIT1
#define MAP_LED10   LED_HW_MAP.Buf2.bits.BIT3
#define MAP_LED11   LED_HW_MAP.Buf3.bits.BIT1
#define MAP_LED12   LED_HW_MAP.Buf3.bits.BIT2
#define MAP_LED13   LED_HW_MAP.Buf0.bits.BIT4

#define MAP_LED14   LED_HW_MAP.Buf1.bits.BIT4
#define MAP_LED15   LED_HW_MAP.Buf2.bits.BIT4
#define MAP_LED16   LED_HW_MAP.Buf3.bits.BIT4
#define MAP_LED17   LED_HW_MAP.Buf0.bits.BIT5
#define MAP_LED18   LED_HW_MAP.Buf0.bits.BIT6
#define MAP_LED19   LED_HW_MAP.Buf1.bits.BIT5
#define MAP_LED20   LED_HW_MAP.Buf1.bits.BIT6

#define MAP_LED21   LED_HW_MAP.Buf2.bits.BIT5
#define MAP_LED22   LED_HW_MAP.Buf2.bits.BIT6
#define MAP_LED23   LED_HW_MAP.Buf3.bits.BIT5
#define MAP_LED24   LED_HW_MAP.Buf3.bits.BIT6
#define MAP_LED25   LED_HW_MAP.Buf4.bits.BIT0
#define MAP_LED26   LED_HW_MAP.Buf4.bits.BIT1
#define MAP_LED27   LED_HW_MAP.Buf4.bits.BIT2

#define MAP_LED28   LED_HW_MAP.Buf4.bits.BIT3
#define MAP_LED29   LED_HW_MAP.Buf4.bits.BIT5
#define MAP_LED30   LED_HW_MAP.Buf4.bits.BIT6
#define MAP_LED31   LED_HW_MAP.Buf5.bits.BIT0
#define MAP_LED32   LED_HW_MAP.Buf5.bits.BIT1
#define MAP_LED33   LED_HW_MAP.Buf5.bits.BIT2
#define MAP_LED34   LED_HW_MAP.Buf5.bits.BIT3
#define MAP_LED35   LED_HW_MAP.Buf5.bits.BIT4
#define MAP_LED36   LED_HW_MAP.Buf5.bits.BIT6
#define MAP_LED37   LED_HW_MAP.Buf6.bits.BIT0
#define MAP_LED38   LED_HW_MAP.Buf6.bits.BIT1
#define MAP_LED39   LED_HW_MAP.Buf6.bits.BIT2
#define MAP_LED40   LED_HW_MAP.Buf6.bits.BIT3
#define MAP_LED41   LED_HW_MAP.Buf6.bits.BIT4
#define MAP_LED42   LED_HW_MAP.Buf6.bits.BIT5
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                            7段數碼管 map to LED map                                  @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//   __		A
//  |  |  F	  B
//   __		G
//  |  |  E   C
//   __  	D
#define SEG0_A      MAP_LED1
#define SEG0_B      MAP_LED6
#define SEG0_C      MAP_LED18
#define SEG0_D      MAP_LED25
#define SEG0_E      MAP_LED17
#define SEG0_F      MAP_LED5
#define SEG0_G      MAP_LED13

#define SEG1_A      MAP_LED2
#define SEG1_B      MAP_LED8
#define SEG1_C      MAP_LED20
#define SEG1_D      MAP_LED26
#define SEG1_E      MAP_LED19
#define SEG1_F      MAP_LED7
#define SEG1_G      MAP_LED14


#define SEG2_A      MAP_LED3
#define SEG2_B      MAP_LED10
#define SEG2_C      MAP_LED22
#define SEG2_D      MAP_LED27
#define SEG2_E      MAP_LED21
#define SEG2_F      MAP_LED9
#define SEG2_G      MAP_LED15

#define SEG3_A      MAP_LED4
#define SEG3_B      MAP_LED12
#define SEG3_C      MAP_LED24
#define SEG3_D      MAP_LED28
#define SEG3_E      MAP_LED23
#define SEG3_F      MAP_LED11
#define SEG3_G      MAP_LED16


#define SIGN_O1     MAP_LED31
#define SIGN_O2     MAP_LED32
#define SIGN_O3     MAP_LED33
#define SIGN_O4     MAP_LED34
#define SIGN_P1     MAP_LED29
#define SIGN_P2     MAP_LED30
#define SIGN_BLE    MAP_LED35

#define SIGN_HR     MAP_LED36
#define SIGN_KG     MAP_LED37
#define SIGN_LINK   MAP_LED38
#define SIGN_JIN    MAP_LED39
#define SIGN_BAT    MAP_LED41
#define SIGN_RE1    MAP_LED40
#define SIGN_RE2    MAP_LED40

#define SIG_O1     LED_FW_Map.Buf4.bits.BIT0
#define SIG_O2     LED_FW_Map.Buf4.bits.BIT1
#define SIG_O3     LED_FW_Map.Buf4.bits.BIT2
#define SIG_O4     LED_FW_Map.Buf4.bits.BIT3
#define SIG_P1     LED_FW_Map.Buf4.bits.BIT4
#define SIG_P2     LED_FW_Map.Buf4.bits.BIT5
#define SIG_BLE    LED_FW_Map.Buf4.bits.BIT6

#define SIG_HR     LED_FW_Map.Buf5.bits.BIT0
#define SIG_KG     LED_FW_Map.Buf5.bits.BIT1
#define SIG_LINK   LED_FW_Map.Buf5.bits.BIT2
#define SIG_JIN    LED_FW_Map.Buf5.bits.BIT3
#define SIG_BAT    LED_FW_Map.Buf5.bits.BIT4
#define SIG_RE1    LED_FW_Map.Buf5.bits.BIT5
#define SIG_RE2    LED_FW_Map.Buf5.bits.BIT6


#define CHAR_0	   0
#define CHAR_1	   1
#define CHAR_2	   2
#define CHAR_3	   3
#define CHAR_4	   4
#define CHAR_5	   5
#define CHAR_6	   6
#define CHAR_7	   7
#define CHAR_8	   8
#define CHAR_9	   9
#define CHAR_A	  10
#define CHAR_B	  11
#define CHAR_C	  12
#define CHAR_D	  13
#define CHAR_E	  14
#define CHAR_F	  15
#define CHAR_G	  16
#define CHAR_H	  17
#define CHAR_I	  18
#define CHAR_J	  19
#define CHAR_L	  20
#define CHAR_N	  21
#define CHAR_n	  22
#define CHAR_o	  23
#define CHAR_P	  24
#define CHAR_Q	  25
#define CHAR_r    26
#define CHAR_U	  27
#define CHAR_u	  28
#define CHAR_Y	  29
#define CHAR__	  30
#define CHAR_	  31
#define CHAR_OFF  32
#define CHAR_ALL  33



#endif