#ifndef _DRV_AFE_ADC_H_
#define _DRV_AFE_ADC_H_

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ======================================================@
//                Drv_ADC.c 對外接口                      @
// ======================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
typedef struct
{
	union
	{
		struct
		{
            unsigned char ByteLow;		// R ADC 原始數據低位
            unsigned char ByteMid;		// R ADC 原始數據中位
            unsigned char ByteHigh;		// R ADC 原始數據高位
            unsigned char ByteRes;		// R ADC 預留位
		}byte;
		long ADCData;
	}data;
	unsigned char SamplingCnt;	// R ADC 採集次數計數
	union {
		struct
		{
			unsigned char IsReady : 1;  // R 有一筆原始ADC數據
		} b;
		unsigned char byte;
	} flag;
} ADCSource_t;

extern volatile ADCSource_t ADCSourceData; //*< 原始ADC數據, 中斷內有使用，使用 volatile 修飾
void Drv_ADCStart();
void Drv_ADCStop();


//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ======================================================@
//                Drv_ADC.c 預處理接口                    @
// ======================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

#define SET_ADCPOWER(x)			    { _adoff = !x; _adslp = !x;}    //!< ADC電源開關
#define SET_ADC_STARTCONVERT()		{ _adrst = 0; _adrst = 1; _adrst = 0; _adcdl = 0; _eoc = 0; }   //!< 開始ADC轉換，開啟后即可連續獲取ADC值無需再開啟
#define SET_ADCINTERRUPT_ENABLE()   { _adf = 0; _ade = 1; _emi = 1;}    //!< 開啟ADC中斷和全局中斷
#define SET_ADCINTERRUPT_DISABLE()  { _ade = 0;}    //!< 關閉ADC中斷

//!< 參考電壓選擇
#define SET_ADC_REF_VCM_AVSS()		{ _vrefs = 0;}
#define SET_ADC_REF_VREFP_VREFN()	{ _vrefs = 1;}
#define SET_ADC_VRP_BUF(x)			{ _vrbufp = x;}
#define SET_ADC_VRN_BUF(x)			{ _vrbufn = x;}

#define SET_VREF_GAIN_1()		{ _vgs1=0; _vgs0 = 0;}  //!< 參考電壓放大倍率設置為1
#define SET_VREF_GAIN_0_5()		{ _vgs1=0; _vgs0 = 1;}  //!< 參考電壓放大倍率設置為0.5*(VREFP~VREFN)
#define SET_VREF_GAIN_0_25()	{ _vgs1=1; _vgs0 = 0;}  //!< 參考電壓放大倍率設置為0.25*(VREFP~VREFN)
#define SET_ADC_GAIN_1()		{ _ags1=0; _ags0 = 0;}  //!< ADC數位放大設置為1
#define SET_ADC_GAIN_2()		{ _ags1=0; _ags0 = 1;}  //!< ADC數位放大設置為2
#define SET_ADC_GAIN_4()		{ _ags1=1; _ags0 = 0;}  //!< ADC數位放大設置為4

//!< PGA放大倍率選擇
#define SET_PGA_GAIN_1()		{ _pgs2=0; _pgs1 = 0; _pgs0 = 0;}    //!< PGA倍率為1倍
#define SET_PGA_GAIN_2()		{ _pgs2=0; _pgs1 = 0; _pgs0 = 1;}    //!< PGA倍率為2倍
#define SET_PGA_GAIN_4()		{ _pgs2=0; _pgs1 = 1; _pgs0 = 0;}    //!< PGA倍率為4倍
#define SET_PGA_GAIN_8()		{ _pgs2=0; _pgs1 = 1; _pgs0 = 1;}    //!< PGA倍率為8倍
#define SET_PGA_GAIN_16()		{ _pgs2=1; _pgs1 = 0; _pgs0 = 0;}    //!< PGA倍率為16倍
#define SET_PGA_GAIN_32()		{ _pgs2=1; _pgs1 = 0; _pgs0 = 1;}    //!< PGA倍率為32倍
#define SET_PGA_GAIN_64()		{ _pgs2=1; _pgs1 = 1; _pgs0 = 0;}    //!< PGA倍率為64倍
#define SET_PGA_GAIN_128()		{ _pgs2=1; _pgs1 = 1; _pgs0 = 1;}    //!< PGA倍率為128倍
//!< 差分输入信号 PGAOP/PGAON 偏置选择位
#define SET_ADC_DCSET_0V()			{ _dcset2=0; _dcset1 = 0; _dcset0 = 0;}     //!< DCSET=+0V
#define SET_ADC_DCSET_UP_0_25()		{ _dcset2=0; _dcset1 = 0; _dcset0 = 1;}     //!< DCSET= +0.25 × ΔVR_I
#define SET_ADC_DCSET_UP_0_5()		{ _dcset2=0; _dcset1 = 1; _dcset0 = 0;}     //!< DCSET= +0.5  × ΔVR_I
#define SET_ADC_DCSET_UP_0_75()		{ _dcset2=0; _dcset1 = 1; _dcset0 = 1;}     //!< DCSET= +0.75 × ΔVR_I
#define SET_ADC_DCSET_DOWN_0_25()	{ _dcset2=1; _dcset1 = 0; _dcset0 = 1;}     //!< DCSET= -0.25 × ΔVR_I
#define SET_ADC_DCSET_DOWN_0_5()	{ _dcset2=1; _dcset1 = 1; _dcset0 = 0;}     //!< DCSET= -0.5  × ΔVR_I
#define SET_ADC_DCSET_DOWN_0_75()	{ _dcset2=1; _dcset1 = 1; _dcset0 = 1;}     //!< DCSET= -0.75 × ΔVR_I
// ADC通道D-選擇
#define SET_ADC_INPUT_SHORT(x)    { _inis = x;} //!< ADC內短開關  正常應用必須設置為DISABLE  ENABLE后ADC輸出為0 主要用於debug使用
#define SET_ADC_CHANNEL_MODE_FWR()	{ _pgacs= 0x43;}
#define SET_ADC_CHANNEL_MODE_IQ_R()	{ _pgacs= 0x43;}
#define SET_ADC_CHANNEL_MODE_IQ_I()	{ _pgacs= 0x54;}

#define SET_ADC_CHANNEL_N_AN0()		{ _chsn3=0; _chsn2=0; _chsn1=0; _chsn0=0;}  //!< 外部ADC通道-AN0
#define SET_ADC_CHANNEL_N_AN1()		{ _chsn3=0; _chsn2=0; _chsn1=0; _chsn0=1;}  //!< 外部ADC通道-AN1
#define SET_ADC_CHANNEL_N_AN3()		{ _chsn3=0; _chsn2=0; _chsn1=1; _chsn0=0;}  //!< 外部ADC通道-AN3
#define SET_ADC_CHANNEL_N_AN5()		{ _chsn3=0; _chsn2=0; _chsn1=1; _chsn0=1;}  //!< 外部ADC通道-AN5
#define SET_ADC_CHANNEL_N_MOD1ON()	{ _chsn3=0; _chsn2=1; _chsn1=0; _chsn0=0;}  //!< 內部ADC通道-搭配MOD1OP一起使用:FWR模式為Z值N端/IQ模式為RE N端
#define SET_ADC_CHANNEL_N_MOD2ON()	{ _chsn3=0; _chsn2=1; _chsn1=0; _chsn0=1;}  //!< 內部ADC通道-搭配MOD2OP一起使用:FWR模式無用    /IQ模式為IM N端
#define SET_ADC_CHANNEL_N_OPIP()	{ _chsn3=1; _chsn2=0; _chsn1=0; _chsn0=1;}  //!< 內部ADC通道-OPIP
#define SET_ADC_CHANNEL_N_VCM()		{ _chsn3=1; _chsn2=0; _chsn1=1; _chsn0=1;}  //!< 內部ADC通道-VCM
#define SET_ADC_CHANNEL_N_TSON()	{ _chsn3=1; _chsn2=1; _chsn1=0; _chsn0=0;}  //!< 內部ADC通道-搭配TSOP一起使用,Temperature sensor output


#define SET_ADC_CHANNEL_P_AN0()		{ _chsp3=0; _chsp2=0; _chsp1=0; _chsp0=0;}  //!< 外部ADC通道-AN0
#define SET_ADC_CHANNEL_P_AN2()		{ _chsp3=0; _chsp2=0; _chsp1=0; _chsp0=1;}  //!< 外部ADC通道-AN2
#define SET_ADC_CHANNEL_P_AN4()		{ _chsp3=0; _chsp2=0; _chsp1=1; _chsp0=0;}  //!< 外部ADC通道-AN4
#define SET_ADC_CHANNEL_P_MOD1OP()	{ _chsp3=0; _chsp2=0; _chsp1=1; _chsp0=1;}  //!< 內部ADC通道-搭配MOD1ON一起使用:FWR模式為Z值P端/IQ模式為RE P端
#define SET_ADC_CHANNEL_P_MOD2OP()	{ _chsp3=0; _chsp2=1; _chsp1=0; _chsp0=0;}  //!< 內部ADC通道-搭配MOD2ON一起使用:FWR模式無用    /IQ模式為IM P端
#define SET_ADC_CHANNEL_P_OPIP()	{ _chsp3=1; _chsp2=0; _chsp1=0; _chsp0=1;}  //!< 內部ADC通道-OPIP
#define SET_ADC_CHANNEL_P_VCM()		{ _chsp3=1; _chsp2=0; _chsp1=1; _chsp0=1;}  //!< 內部ADC通道-VCM
#define SET_ADC_CHANNEL_P_TSOP()	{ _chsp3=1; _chsp2=1; _chsp1=0; _chsp0=0;}  //!< 內部ADC通道-搭配TSON一起使用,Temperature sensor output

//!< ADC DATA RARE 計算方式如下:
//!< FMCLK = fSYS/2/(ADCS+1) if ADCS=0x1F, FMCLK = fSYS
//!< SINC2 DataRate = FMCLK/(OSR*CHOP*N)
//!< SINC3 DataRate = FMCLK/(OSR*CHOP)
#define CHOP2_FLMS30()              { _flms2=0; _flms1=0; _flms0=0;}
#define CHOP2_FLMS12()              { _flms2=0; _flms1=1; _flms0=0;}
#define CHOP1_FLMS30()              { _flms2=1; _flms1=0; _flms0=0;}
#define CHOP1_FLMS12()              { _flms2=1; _flms1=1; _flms0=0;}

#define OSR3_32768()                { _ador3 = 0; _ador2=0; _ador1=0; _ador0=0;}
#define OSR3_16384()                { _ador3 = 0; _ador2=0; _ador1=0; _ador0=1;}
#define OSR3_8192()                 { _ador3 = 0; _ador2=0; _ador1=1; _ador0=0;}
#define OSR3_4096()                 { _ador3 = 0; _ador2=0; _ador1=1; _ador0=1;}
#define OSR3_2048()                 { _ador3 = 0; _ador2=1; _ador1=0; _ador0=0;}
#define OSR3_1024()                 { _ador3 = 0; _ador2=1; _ador1=0; _ador0=1;}
#define OSR3_512()                  { _ador3 = 0; _ador2=1; _ador1=1; _ador0=0;}
#define OSR3_256()                  { _ador3 = 0; _ador2=1; _ador1=1; _ador0=1;}
#define OSR3_128()                	{ _ador3 = 1; _ador2=0; _ador1=0; _ador0=0;}

#define OSR2_16384()                { _ador3 = 0; _ador2=0; _ador1=0; _ador0=0;}
#define OSR2_8192()                 { _ador3 = 0; _ador2=0; _ador1=0; _ador0=1;}
#define OSR2_4096()                 { _ador3 = 0; _ador2=0; _ador1=1; _ador0=0;}
#define OSR2_2048()                 { _ador3 = 0; _ador2=0; _ador1=1; _ador0=1;}
#define OSR2_1024()                 { _ador3 = 0; _ador2=1; _ador1=0; _ador0=0;}
#define OSR2_512()                  { _ador3 = 0; _ador2=1; _ador1=0; _ador0=1;}
#define OSR2_256()                  { _ador3 = 0; _ador2=1; _ador1=1; _ador0=0;}
#define OSR2_128()                  { _ador3 = 0; _ador2=1; _ador1=1; _ador0=1;}

#if SYS_CLOCK_FREQ == 4000000
#define SET_ADC_DATARATE2_10HZ()	{ _sinc3 = 0x00; _adcs=0x1F; CHOP2_FLMS12(); OSR2_16384();}
#define SET_ADC_DATARATE2_20HZ()	{ _sinc3 = 0x00; _adcs=0x1F; CHOP2_FLMS12(); OSR2_8192(); }
#define SET_ADC_DATARATE2_40HZ()	{ _sinc3 = 0x00; _adcs=0x1F; CHOP2_FLMS12(); OSR2_4096(); }
#define SET_ADC_DATARATE2_80HZ()	{ _sinc3 = 0x00; _adcs=0x1F; CHOP2_FLMS12(); OSR2_2048(); }
#define SET_ADC_DATARATE2_160HZ()	{ _sinc3 = 0x00; _adcs=0x1F; CHOP2_FLMS12(); OSR2_1024(); }
#define SET_ADC_DATARATE2_320HZ()	{ _sinc3 = 0x00; _adcs=0x1F; CHOP2_FLMS12(); OSR2_512();  }
#define SET_ADC_DATARATE2_640HZ()	{ _sinc3 = 0x00; _adcs=0x1F; CHOP2_FLMS12(); OSR2_256();  }
#define SET_ADC_DATARATE2_1300HZ()	{ _sinc3 = 0x00; _adcs=0x1F; CHOP2_FLMS12(); OSR2_128();  }

#define SET_ADC_DATARATE2_4HZ()		{ _sinc3 = 0X00; _adcs=0x1F; CHOP2_FLMS30(); OSR2_16384();}
#define SET_ADC_DATARATE2_8HZ()		{ _sinc3 = 0X00; _adcs=0x1F; CHOP2_FLMS30(); OSR2_8192(); }
#define SET_ADC_DATARATE2_16HZ()	{ _sinc3 = 0X00; _adcs=0x1F; CHOP2_FLMS30(); OSR2_4096(); }
#define SET_ADC_DATARATE2_32HZ()	{ _sinc3 = 0X00; _adcs=0x1F; CHOP2_FLMS30(); OSR2_2048(); }
#define SET_ADC_DATARATE2_64HZ()	{ _sinc3 = 0X00; _adcs=0x1F; CHOP2_FLMS30(); OSR2_1024(); }
#define SET_ADC_DATARATE2_128HZ()	{ _sinc3 = 0X00; _adcs=0x1F; CHOP2_FLMS30(); OSR2_512();  }
#define SET_ADC_DATARATE2_256HZ()	{ _sinc3 = 0X00; _adcs=0x1F; CHOP2_FLMS30(); OSR2_256();  }
#define SET_ADC_DATARATE2_512HZ()	{ _sinc3 = 0X00; _adcs=0x1F; CHOP2_FLMS30(); OSR2_128();  }

#define SET_ADC_DATARATE3_10HZ()	{ _sinc3 = 0x03; _adcs=0x1F; CHOP1_FLMS12(); OSR3_32768();}
#define SET_ADC_DATARATE3_20HZ()	{ _sinc3 = 0x03; _adcs=0x1F; CHOP1_FLMS12(); OSR3_16384();}
#define SET_ADC_DATARATE3_40HZ()	{ _sinc3 = 0x03; _adcs=0x1F; CHOP1_FLMS12(); OSR3_8192(); }
#define SET_ADC_DATARATE3_80HZ()	{ _sinc3 = 0x03; _adcs=0x1F; CHOP1_FLMS12(); OSR3_4096(); }
#define SET_ADC_DATARATE3_160HZ()	{ _sinc3 = 0x03; _adcs=0x1F; CHOP1_FLMS12(); OSR3_2048(); }
#define SET_ADC_DATARATE3_320HZ()	{ _sinc3 = 0x03; _adcs=0x1F; CHOP1_FLMS12(); OSR3_1024(); }
#define SET_ADC_DATARATE3_640HZ()	{ _sinc3 = 0x03; _adcs=0x1F; CHOP1_FLMS12(); OSR3_512();  }
#define SET_ADC_DATARATE3_1300HZ()	{ _sinc3 = 0x03; _adcs=0x1F; CHOP1_FLMS12(); OSR3_256();  }
#define SET_ADC_DATARATE3_2600HZ()	{ _sinc3 = 0x03; _adcs=0x1F; CHOP1_FLMS12(); OSR3_128();  }

#define SET_ADC_DATARATE3_4HZ()		{ _sinc3 = 0x03; _adcs=0x1F; CHOP1_FLMS30(); OSR3_32768();}
#define SET_ADC_DATARATE3_8HZ()		{ _sinc3 = 0x03; _adcs=0x1F; CHOP1_FLMS30(); OSR3_16384();}
#define SET_ADC_DATARATE3_16HZ()	{ _sinc3 = 0x03; _adcs=0x1F; CHOP1_FLMS30(); OSR3_8192(); }
#define SET_ADC_DATARATE3_32HZ()	{ _sinc3 = 0x03; _adcs=0x1F; CHOP1_FLMS30(); OSR3_4096(); }
#define SET_ADC_DATARATE3_64HZ()	{ _sinc3 = 0x03; _adcs=0x1F; CHOP1_FLMS30(); OSR3_2048(); }
#define SET_ADC_DATARATE3_128HZ()	{ _sinc3 = 0x03; _adcs=0x1F; CHOP1_FLMS30(); OSR3_1024(); }
#define SET_ADC_DATARATE3_256HZ()	{ _sinc3 = 0x03; _adcs=0x1F; CHOP1_FLMS30(); OSR3_512();  }
#define SET_ADC_DATARATE3_512HZ()	{ _sinc3 = 0x03; _adcs=0x1F; CHOP1_FLMS30(); OSR3_256();  }
#define SET_ADC_DATARATE3_1041HZ()	{ _sinc3 = 0x03; _adcs=0x1F; CHOP1_FLMS30(); OSR3_128();  }

#endif

#if SYS_CLOCK_FREQ == 8000000
#define SET_ADC_DATARATE2_10HZ()	{ _sinc3 = 0x00; _adcs=0x00; CHOP2_FLMS12(); OSR2_16384();}
#define SET_ADC_DATARATE2_20HZ()	{ _sinc3 = 0x00; _adcs=0x00; CHOP2_FLMS12(); OSR2_8192(); }
#define SET_ADC_DATARATE2_40HZ()	{ _sinc3 = 0x00; _adcs=0x00; CHOP2_FLMS12(); OSR2_4096(); }
#define SET_ADC_DATARATE2_80HZ()	{ _sinc3 = 0x00; _adcs=0x00; CHOP2_FLMS12(); OSR2_2048(); }
#define SET_ADC_DATARATE2_160HZ()	{ _sinc3 = 0x00; _adcs=0x00; CHOP2_FLMS12(); OSR2_1024(); }
#define SET_ADC_DATARATE2_320HZ()	{ _sinc3 = 0x00; _adcs=0x00; CHOP2_FLMS12(); OSR2_512();  }
#define SET_ADC_DATARATE2_640HZ()	{ _sinc3 = 0x00; _adcs=0x00; CHOP2_FLMS12(); OSR2_256();  }
#define SET_ADC_DATARATE2_1300HZ()	{ _sinc3 = 0x00; _adcs=0x00; CHOP2_FLMS12(); OSR2_128();  }

#define SET_ADC_DATARATE2_4HZ()		{ _sinc3 = 0X00; _adcs=0x00; CHOP2_FLMS30(); OSR2_16384();}
#define SET_ADC_DATARATE2_8HZ()		{ _sinc3 = 0X00; _adcs=0x00; CHOP2_FLMS30(); OSR2_8192(); }
#define SET_ADC_DATARATE2_16HZ()	{ _sinc3 = 0X00; _adcs=0x00; CHOP2_FLMS30(); OSR2_4096(); }
#define SET_ADC_DATARATE2_32HZ()	{ _sinc3 = 0X00; _adcs=0x00; CHOP2_FLMS30(); OSR2_2048(); }
#define SET_ADC_DATARATE2_64HZ()	{ _sinc3 = 0X00; _adcs=0x00; CHOP2_FLMS30(); OSR2_1024(); }
#define SET_ADC_DATARATE2_128HZ()	{ _sinc3 = 0X00; _adcs=0x00; CHOP2_FLMS30(); OSR2_512();  }
#define SET_ADC_DATARATE2_256HZ()	{ _sinc3 = 0X00; _adcs=0x00; CHOP2_FLMS30(); OSR2_256();  }
#define SET_ADC_DATARATE2_512HZ()	{ _sinc3 = 0X00; _adcs=0x00; CHOP2_FLMS30(); OSR2_128();  }

#if CFGVer == 13
// OSR3_128   = 1000  ===== Ver13 100+0  = OSR1024
// OSR3_32768 = 0000  ===== Ver13 000+0  = OSR16384
#define SET_ADC_DATARATE3_64HZ()	{ _adcs=0x00; CHOP2_FLMS30(); OSR3_128();  }	// ver13 4000000/2/30/1024 =64hz
#define SET_ADC_DATARATE3_10HZ()	{ _adcs=0x00; CHOP2_FLMS12(); OSR3_32768();}	// ver13 4000000/2/12/16384=10hz
#else
#define SET_ADC_DATARATE3_10HZ()	{ _sinc3 = 0x03; _adcs=0x00; CHOP1_FLMS12(); OSR3_32768();}
#define SET_ADC_DATARATE3_64HZ()	{ _sinc3 = 0x03; _adcs=0x00; CHOP1_FLMS30(); OSR3_2048(); }
#endif
#define SET_ADC_DATARATE3_20HZ()	{ _sinc3 = 0x03; _adcs=0x00; CHOP1_FLMS12(); OSR3_16384();}
#define SET_ADC_DATARATE3_40HZ()	{ _sinc3 = 0x03; _adcs=0x00; CHOP1_FLMS12(); OSR3_8192(); }
#define SET_ADC_DATARATE3_80HZ()	{ _sinc3 = 0x03; _adcs=0x00; CHOP1_FLMS12(); OSR3_4096(); }
#define SET_ADC_DATARATE3_160HZ()	{ _sinc3 = 0x03; _adcs=0x00; CHOP1_FLMS12(); OSR3_2048(); }
#define SET_ADC_DATARATE3_320HZ()	{ _sinc3 = 0x03; _adcs=0x00; CHOP1_FLMS12(); OSR3_1024(); }
#define SET_ADC_DATARATE3_640HZ()	{ _sinc3 = 0x03; _adcs=0x00; CHOP1_FLMS12(); OSR3_512();  }
#define SET_ADC_DATARATE3_1300HZ()	{ _sinc3 = 0x03; _adcs=0x00; CHOP1_FLMS12(); OSR3_256();  }
#define SET_ADC_DATARATE3_2600HZ()	{ _sinc3 = 0x03; _adcs=0x00; CHOP1_FLMS12(); OSR3_128();  }

#define SET_ADC_DATARATE3_4HZ()		{ _sinc3 = 0x03; _adcs=0x00; CHOP1_FLMS30(); OSR3_32768();}
#define SET_ADC_DATARATE3_8HZ()		{ _sinc3 = 0x03; _adcs=0x00; CHOP1_FLMS30(); OSR3_16384();}
#define SET_ADC_DATARATE3_16HZ()	{ _sinc3 = 0x03; _adcs=0x00; CHOP1_FLMS30(); OSR3_8192(); }
#define SET_ADC_DATARATE3_32HZ()	{ _sinc3 = 0x03; _adcs=0x00; CHOP1_FLMS30(); OSR3_4096(); }
#define SET_ADC_DATARATE3_128HZ()	{ _sinc3 = 0x03; _adcs=0x00; CHOP1_FLMS30(); OSR3_1024(); }
#define SET_ADC_DATARATE3_256HZ()	{ _sinc3 = 0x03; _adcs=0x00; CHOP1_FLMS30(); OSR3_512();  }
#define SET_ADC_DATARATE3_512HZ()	{ _sinc3 = 0x03; _adcs=0x00; CHOP1_FLMS30(); OSR3_256();  }
#define SET_ADC_DATARATE3_1041HZ()	{ _sinc3 = 0x03; _adcs=0x00; CHOP1_FLMS30(); OSR3_128();  }
#endif

#if SYS_CLOCK_FREQ == 12000000

#endif

#endif