#ifndef _DRV_AFE_POWER_H_
#define _DRV_AFE_POWER_H_



//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                                AFE Power  基本設置                                   @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

/*! Voreg輸出電壓 ADC OPA 等電源來自 VOREG*/
enum VoregOuput_t
{
    VOREG_POWEROFF = 0x00,       //!< 穩壓輸出關閉
    VOREG_POWERON_2V4 = 0x80,    //!< 穩壓輸出2.4V
    VOREG_POWERON_2V6 = 0x81,    //!< 穩壓輸出2.6V
    VOREG_POWERON_2V9 = 0x82,    //!< 穩壓輸出2.9V
    VOREG_POWERON_3V3 = 0x83,    //!< 穩壓輸出3.3V
    VOREG_POWERON_BYPASS = 0x84, //!< AVDD bypass 輸出
};
//                         -----VOREG Definition------;
#define Drv_VOREG_OUTPUT(x)     { _pwrc = x;}   //!< 設置 VOREG 的輸出電壓 x = enum VoregOuput_t


#endif
