#ifndef _DRV_BIA_H_
#define _DRV_BIA_H_

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ======================================================@
//                Drv_BIA.c 對外接口                      @
// ======================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
/*! sine wave 輸出頻率 */
enum SINEWAVEFREQ_t
{
    SINWAVEFREQ_OFF = 0,      //!< 關閉Sine Wave 輸出
    SINWAVEFREQ_5KHZ = 1,     //!< 5khz
    SINWAVEFREQ_10KHZ = 2,    //!< 10khz
    SINWAVEFREQ_20KHZ = 3,    //!< 20khz
    SINWAVEFREQ_25KHZ = 4,    //!< 25khz
    SINWAVEFREQ_50KHZ = 5,    //!< 50khz
    SINWAVEFREQ_100KHZ = 6,   //!< 100khz
    SINWAVEFREQ_200KHZ = 7,   //!< 200khz    只有在系統頻率=8MHz下才可以
    SINWAVEFREQ_250KHZ = 8,   //!< 250khz
    SINWAVEFREQ_500KHZ = 9,   //!< 500khz
    SINWAVEFREQ_1000KHZ = 10, //!< 1000khz   只有在系統頻率=8MHz/12MHz下才可以
};
enum BIA8_CHANNEL_t{
    BIA8_CHANNEL_RF1 = 0x01,  	// 量測參考電阻1
    BIA8_CHANNEL_RF2 = 0x02,  	// 量測參考電阻2
    BIA8_CHANNEL_RF3 = 0x04,  	// 量測參考電阻3
    BIA8_CHANNEL_RF4 = 0x08,  	// 量測參考電阻4
    BIA8_CHANNEL_TWOLEGS = 0x10,  	// 量測雙腳阻抗
    BIA8_CHANNEL_TWOARMS = 0x20,      // 量測雙手阻抗
    BIA8_CHANNEL_LEFTARM = 0x40,      // 量測左手阻抗
    BIA8_CHANNEL_RIGHTARM = 0x80,     // 量測右手阻抗
    BIA8_CHANNEL_LEFTLEG = 0x0100,      // 量測左腳阻抗
    BIA8_CHANNEL_RIGHTLEG= 0x0200,     // 量測右腳阻抗
    BIA8_CHANNEL_LEFTBODY= 0x0400,     // 量測左全身阻抗
    BIA8_CHANNEL_RIGHTBODY = 0x0800,    // 量測右全身阻抗
    BIA8_CHANNEL_RIGHTRAMANDLEFTLEG = 0x1000, // 量測左手右腳
    BIA8_CHANNEL_LEFTRAMANDRIGHTLEG = 0X2000, // 量測右手左腳
    BIA8_CHANNEL_TRUNK = 0x4000,        // 量測軀幹
    BIA8_FINISH = 0x8000,        // 量測結束
};

enum BIA8_MODE_t{
    BIA8_MODE_FWR ,  	// 0 全波整流模式，只有阻抗值無相角等信息
    BIA8_MODE_IQ ,  	// 0 IQ調製模式，可量測相角，實部 虛部信息
};


/*! sine Wave 可設置參數 */
typedef struct
{
    float PeaKScales;        // RW Sine Wave輸出峰峰值比例,0~1*Voreg
    unsigned char IQ_FWR;    // RW IQ/FWR mode selection
    enum SINEWAVEFREQ_t Freq; // RW Sine Wave輸出頻率設置
    enum BIA8_CHANNEL_t Channel;   // RW
} BIA8Setting_t;

extern BIA8Setting_t BIA8Setting;


void Drv_BIAPowerOn();
void Drv_BIAPowerDown();
void Drv_BIA8ChannelSwich(enum BIA8_CHANNEL_t BIA8channel);

#endif