/**
 * @file Drv_GPIO.c
 * @brief  GPIO調用接口
 * @version 0.1
 * @date 2020-06-30
 *
 * @copyright BEST HEALTH ELECTRONIC INC (c) 2019
 *
 * Compiler Ver. : V3.57
 * IDE3000  Ver. : V8.03
 * MCU/CFG  Ver. : BH66F2663/1.
 */

#ifndef _DRV_GPIO_H
#define _DRV_GPIO_H
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 共用函數 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
void Drv_GPIOPowerOnInit();
void Drv_GPIOPowerDownInit();
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 變量聲明 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#define SET_PA0_GPIO()      { _pas01 = 0; _pas00 = 0;}
#define SET_PA0_PTP0I()     { _pas01 = 0; _pas00 = 0;}
#define SET_PA0_PTP0()      { _pas01 = 1; _pas00 = 0;}
#define SET_PA0_XT1()       { _pas01 = 1; _pas00 = 1;}

#define SET_PA1_GPIO()      { _pas03 = 0; _pas02 = 0;}
#define SET_PA1_INT0()      { _pas03 = 0; _pas02 = 0;}
#define SET_PA1_STCK()      { _pas03 = 0; _pas02 = 0; _stckps = 0;}
#define SET_PA1_LVDIN()     { _pas03 = 1; _pas02 = 0;}
#define SET_PA1_PTP0B()     { _pas03 = 1; _pas02 = 1;}

#define SET_PA2_GPIO()      { _pas05 = 0; _pas04 = 0;}
#define SET_PA2_PTCK0()     { _pas05 = 0; _pas04 = 0;}
#define SET_PA2_XT2()       { _pas05 = 1; _pas04 = 1;}

#define SET_PA3_GPIO()      { _pas07 = 0; _pas06 = 0;}
#define SET_PA3_PTP1I()     { _pas07 = 0; _pas06 = 0; _ptp1ips = 0;}
#define SET_PA3_PTP1()      { _pas07 = 0; _pas06 = 1;}
#define SET_PA3_SDOA()      { _pas07 = 1; _pas06 = 0;}
#define SET_PA3_OSC2()      { _pas07 = 1; _pas06 = 1;}

#define SET_PA4_GPIO()      { _pas11 = 0; _pas10 = 0;}
#define SET_PA4_PTP2I()     { _pas11 = 0; _pas10 = 0; _ptp2ips = 0;}
#define SET_PA4_PTP2()      { _pas11 = 0; _pas10 = 1;}
#define SET_PA4_SCSA()      { _pas11 = 1; _pas10 = 0; _scsaps = 0;}
#define SET_PA4_OSC1()  	{ _pas11 = 1; _pas10 = 1;}

#define SET_PA5_GPIO()      { _pas13 = 0; _pas12 = 0;}
#define SET_PA5_STPI()      { _pas13 = 0; _pas12 = 0;}
#define SET_PA5_STP()       { _pas13 = 0; _pas12 = 1;}
#define SET_PA5_SCKA()      { _pas13 = 1; _pas12 = 0; _sckaps = 0;}
#define SET_PA5_TX()        { _pas13 = 1; _pas12 = 1;}

#define SET_PA6_GPIO()      { _pas15 = 0; _pas14 = 0;}
#define SET_PA6_STCK()      { _pas15 = 0; _pas14 = 0; _stckps = 1;}
#define SET_PA6_SDIA()      { _pas15 = 0; _pas14 = 1; _sdiaps = 0;}
#define SET_PA6_RX_TX()     { _pas15 = 1; _pas14 = 1; _rxps1 = 0; _rxps0 = 0;}

#define SET_PA7_GPIO()      { _pas17 = 0; _pas16 = 0;}
#define SET_PA7_PTCK2()     { _pas17 = 0; _pas16 = 0; _ptck2ps = 1;}
#define SET_PA7_SDI_SDA()   { _pas17 = 1; _pas16 = 1;}

#define SET_PB0_GPIO()      { _pbs01 = 0; _pbs00 = 0;}
#define SET_PB0_AN4()       { _pbs01 = 0; _pbs00 = 1;}
#define SET_PB0_OPIP()      { _pbs01 = 1; _pbs00 = 0;}
#define SET_PB0_SCK_SCL()   { _pbs01 = 1; _pbs00 = 1;}

#define SET_PB1_GPIO()      { _pbs03 = 0; _pbs02 = 0;}
#define SET_PB1_INT1()      { _pbs03 = 0; _pbs02 = 0;}
#define SET_PB1_AN5()       { _pbs03 = 0; _pbs02 = 1;}
#define SET_PB1_OPIN()      { _pbs03 = 1; _pbs02 = 0;}
#define SET_PB1_STPB()      { _pbs03 = 1; _pbs02 = 1;}

#define SET_PB2_GPIO()      { _pbs05 = 0; _pbs04 = 0;}
#define SET_PB2_SCS()       { _pbs05 = 1; _pbs04 = 0;}
#define SET_PB2_SCKA()      { _pbs05 = 1; _pbs04 = 1; _sckaps = 1;}

#define SET_PB3_GPIO()      { _pbs07 = 0; _pbs06 = 0;}
#define SET_PB3_RX_TX()     { _pbs07 = 0; _pbs06 = 1; _rxps1 = 0; _rxps0 = 1;}
#define SET_PB3_SDIA()      { _pbs07 = 1; _pbs06 = 0; _sdiaps = 1;}
#define SET_PB3_SDO()       { _pbs07 = 1; _pbs06 = 1;}

#define SET_PB4_GPIO()      { _pbs11 = 0; _pbs10 = 0;}
#define SET_PB4_AN2()       { _pbs11 = 0; _pbs10 = 1;}

#define SET_PB5_GPIO()      { _pbs13 = 0; _pbs12 = 0;}
#define SET_PB5_AN3()       { _pbs13 = 0; _pbs12 = 1;}

#define SET_PB6_GPIO()      { _pbs15 = 0; _pbs14 = 0;}
#define SET_PB6_RX_TX()     { _pbs15 = 1; _pbs14 = 0; _rxps1 = 1; _rxps0 = 0;}

#define SET_PB7_GPIO()      { _pbs17 = 0; _pbs16 = 0;}
#define SET_PB7_TX()        { _pbs17 = 1; _pbs16 = 0;}

#define SET_PC0_GPIO()      { _pcs01 = 0; _pcs00 = 0;}
#define SET_PC0_PTP1I()     { _pcs01 = 0; _pcs00 = 0; _ptp1ips = 1;}
#define SET_PC0_PTP1()      { _pcs01 = 1; _pcs00 = 0;}

#define SET_PC2_GPIO()      { _pcs05 = 0; _pcs04 = 0;}
#define SET_PC2_PTP2I()     { _pcs05 = 0; _pcs04 = 0; _ptp2ips = 1;}
#define SET_PC2_PTP2()      { _pcs05 = 0; _pcs04 = 1;}
#define SET_PC2_MODSYNC()   { _pcs05 = 1; _pcs04 = 0;}

#define SET_PC3_PTCK2()     { _ptck2ps = 0;}

#define SET_PC4_GPIO()      { _pcs11 = 0; _pcs10 = 0;}
#define SET_PC4_SCSA()      { _pcs11 = 1; _pcs10 = 1; _scsaps = 1;}

#define SET_PC5_GPIO()      { _pcs13 = 0; _pcs12 = 0;}
#define SET_PC5_TX()        { _pcs13 = 1; _pcs12 = 0;}
#define SET_PC5_SDOA()      { _pcs13 = 1; _pcs12 = 1;}

#endif