/**
 * @file Drv_LVD.c
 * @author 吳星萍 (iris@e-besthealth.com)
 * @brief  LVD Low Voltage Detector 調用接口
 * @version 1.0
 * @date 2020-06-19
 *
 * @copyright BEST HEALTH ELECTRONIC INC (c) 2019
 *
 * Compiler Ver. : V3.57
 * IDE3000  Ver. : V8.03
 * MCU/CFG  Ver. : BH66F5362/1.1
 */

#include "Project_Global.h"
#include "BH66F2663.h"
#include "Drv_LVD.h"
#include "Drv_GPIO.h"

/**
 * @brief Low Voltage Detector
 *
 * @param lvdStatus 0(No Low Voltage Detected)  1(Low Voltage Detected)
 */
void Drv_LVD(unsigned char *lvdStatus)
{
	SET_PA1_LVDIN();
    SET_LVD_2V4();
    SET_LVD_Enable();
    GCC_DELAY(150);
    *lvdStatus = _lvdo;
    SET_LVD_Disable();
}
//@-------MuFunction3 中斷入口函數-----------@
DEFINE_ISR(MuFunction2_ISP, 0x018)
{
	if(_lvf==1)
	{
		_lvf=0;	
		//user code
	}
}