/**
 * @file Drv_SysClock.c
 * @author 陳挺 (tony@e-besthealth.com)
 * @brief  系統頻率
 * @version 0.1
 * @date 2020-06-30
 *
 * @copyright BEST HEALTH ELECTRONIC INC (c) 2020
 *
 * Compiler Ver. : V3.57
 * IDE3000  Ver. : V8.03
 * MCU/CFG  Ver. : BH66F2663/1.3
 */
#include "Project_Global.h"
#include "BH66F2663.h"
#include "Drv_SysClock.h"
#include "Drv_GPIO.h"
/********************************************************************
Function: 配置系統頻率
INPUT	: none
OUTPUT	: none
NOTE	: 適用HIRC±2%的 IP的 MCU
********************************************************************/
void Drv_SysClockInit()
{
    // *********系統時鐘設定********//
    #ifdef _HIRC_4M_
        _fhs   = 0;
        _hircc = 0x01;
        while (!_hircf);    // Wait HIRC Oscillator Stable
    #endif // _HIRC_4M_
    #ifdef _HIRC_8M_
        _fhs   = 0;
        _hircc = 0x05;
        while (!_hircf);    // Wait HIRC Oscillator Stable
    #endif // _HIRC_8M_
    #ifdef _HIRC_12M_
        _fhs   = 0;
        _hircc = 0x09;
        while (!_hircf);    // Wait HIRC Oscillator Stable
    #endif // _HIRC_12M_
    #ifdef _HXT_10M_BELOW_
        _pas11 = 1;         // SET PA4 TO OSC1
        _pas10 = 1;
        _pas07 = 1;         // SET PA4 TO OSC2
        _pas06 = 1;
        _fhs  = 1;
        _hxtc = 0x01;       // HXTM = 0，HXT Frequency<=10MHz,HXT Oscillator Enable
        while (!_hxtf);     // Wait HXT Oscillator Stable
    #endif // _HXT_10M_BELOW_
    #ifdef _HXT_10M_OVER_
        _pas11 = 1;         // SET PA4 TO OSC1
        _pas10 = 1;
        _pas07 = 1;         // SET PA4 TO OSC2
        _pas06 = 1;
        _fhs  = 1;
        _hxtc = 0x05;       // HXTM = 1，HXT Frequency>10MHz,HXT Oscillator Enable
        while (!_hxtf);     // Wait HXT Oscillator Stable
    #endif // _HXT_10M_OVER_
    #ifdef _LXT_
        _lxten = 1;
        _fss   = 1;
		_fsiden = 1;		// Enter Halt LXT Is Enable
        SET_PA0_XT1();
        SET_PA2_XT2();
		unsigned char i;
		for(i=0;i<10;i++)
		{
		#ifdef _HIRC_4M_
			GCC_DELAY(10);
		#endif // _HIRC_4M_
		#ifdef _HIRC_8M_
			GCC_DELAY(20);
		#endif // _HIRC_8M_
		#ifdef _HIRC_12M_
			GCC_DELAY(30);
		#endif // _HIRC_12M_
		}
        while (!_lxtf)
        {
        	GCC_CLRWDT();     // Wait LXT Oscillator Stable
        }
    #endif // _LXT_
    #ifdef _LIRC_
        _fss   = 0;
        _lxten = 0;
		_fsiden = 1;		// Enter Halt LIRC Is Enable
    #endif // _LIRC_
}