/**
 * @file Drv_Timers.c
 * @author 吳星萍 (Iris@e-besthealth.com)
 * @brief
 * @version 1.0
 * @date 2020-06-09
 *
 * @copyright BEST HEALTH ELECTRONIC INC (c) 2019
 *
 * Compiler Ver. : V3.57
 * IDE3000  Ver. : V8.03
 * MCU/CFG  Ver. : BH66F5362/1.1
 */
#include "Project_Global.h"
#include "BH66F2663.h"
#include "Drv_Timers.h"
#include "Drv_GPIO.h"
#include "..\source\common.h"
/**
 * @brief PTMn設置為計時/計數模式
 *
 * @param PTMn  0~2
 * @param timeClock enum TimerClock_t
 * @param Count 10bit PTM <1024
 * @note Tus = 1000000 / TimeClock * Count
 * @warning 默認開啟中斷
 */
void Drv_PTMn_Timer_Init(unsigned char PTMn, enum TimerClock_t timeClock, unsigned int Count)
{
    if (PTMn == 0)
    {
        SET_PTMn_COUNT(0, Count);
        SET_PTMn_CLOCK(0, timeClock);
        SET_PTMn_MODE_TIMER(0);
        SET_PTMnA_ISR_ENABLE(0);
        SET_M_FUNCT_N_ENABLE(0);
    }
    else if (PTMn == 1)
    {
        SET_PTMn_COUNT(1,Count);
        SET_PTMn_CLOCK(1, timeClock);
        SET_PTMn_MODE_TIMER(1);
        SET_PTMnA_ISR_ENABLE(1);
        SET_M_FUNCT_N_ENABLE(1);
    }
    else if (PTMn == 2)
    {
        SET_PTMn_COUNT(2,Count);
        SET_PTMn_CLOCK(2, timeClock);
        SET_PTMn_MODE_TIMER(2);
        SET_PTMnA_ISR_ENABLE(2);
        SET_M_FUNCT_N_ENABLE(2);
    }

    _emi = 1;
}

/**
 * @brief PTMn設置為PWM模式
 *
 * @param PTMn  0~3
 * @param timeClock enum TimerClock_t
 * @param Count 10bit PTM  1~1023
 * @note PWM Fre = timeClock / CCRP   Duty = CCRA / CCRP (if CCRA > CCRP duty=100)
 * @warning 默認開啟中斷
 */
void Drv_PTMn_PWM_Init(unsigned char PTMn, enum TimerClock_t timeClock, unsigned int Count)
{
    if (PTMn == 0)
    {
        SET_PTMn_COUNT(0, Count);
        SET_PTMn_CLOCK(0, timeClock);
        SET_PTMn_MODE_PWM(0);
        SET_PA0_PTP0();
        SET_PTMnA_ISR_ENABLE(0);
        SET_M_FUNCT_N_ENABLE(0);
    }
    else if (PTMn == 1)
    {
        SET_PTMn_COUNT(1,Count);
        SET_PTMn_CLOCK(1, timeClock);
        SET_PA3_PTP1();
        SET_PTMn_MODE_PWM(1);
        SET_PTMnA_ISR_ENABLE(1);
        SET_M_FUNCT_N_ENABLE(1);
    }
    else if (PTMn == 2)
    {
        SET_PTMn_COUNT(2,Count);
        SET_PTMn_CLOCK(2, timeClock);
        SET_PA4_PTP2();
        SET_PTMn_MODE_PWM(2);
        SET_PTMnA_ISR_ENABLE(2);
        SET_M_FUNCT_N_ENABLE(2);
    }

}

//@-------MuFunction0 中斷入口函數------------@
// PTM0 & STM0 共用
// 復合中斷需要自行清除Request Flags
DEFINE_ISR(MuFunction0_ISR, 0x010)
{
    if (_ptm0af)
    {
        _ptm0af = 0;
        SDK_LED_Scan();
        // User Code
    }
    else if (_ptm0pf)
    {
        _ptm0pf = 0;
        // User Code
    }

}
//@-------MuFunction1 中斷入口函數-----------@
// PTM1 & PTM2 共用
DEFINE_ISR(MuFunction1_ISR, 0x014)
{
    if (_ptm1af)
    {
        _ptm1af = 0;
        // User Code
    }
    else if (_ptm1pf)
    {
        _ptm1pf = 0;
        // User Code
    }
}



//@----------Timebase0 中斷入口函數-----------@
DEFINE_ISR(TIMEBASE0_ISR, 0x020)
{
    DrvUartFormat.RxTimeOutCnt++;
    DrvUartFormat.TxCycle++;
    PollingDisplayCycle++;
    haltTime++;
}
//@----------Timebase1 中斷入口函數-----------@
DEFINE_ISR(TIMEBASE1_ISR, 0x024)
{
    // User Code
}