/**
 * @file Drv_Uart.c
 * @author 陳挺 (tony@e-besthealth.com)
 * @brief
 * @version 0.1
 * @date 2019-11-29
 *
 * @copyright BEST HEALTH ELECTRONIC INC (c) 2019
 *
 * Compiler Ver. : V3.57
 * IDE3000  Ver. : V8.02
 * MCU / CFG Ver. :BH66F2663/1.2
 */
#include "Project_Global.h"
#include "BH66f2663.h"
#include "Drv_UART.h"
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 變量定義 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
volatile struct DrvUartFormat_t DrvUartFormat;
/**
 * @brief UART 波特率 數據格式等基礎設定
 *
 */
void Drv_UartFormatSetting()
{
    // 數據傳輸格式設定
	SET_UART_Format_D8_P0_S1();
    // 波特率設定
	SET_UART_BAUD_RATE_38400();
	SET_UART_ADDRESS_DISABLE();
	SET_UART_RECEIVER_IE_ENABLE();
	SET_UART_TRANSMITTER_IE_ENABLE();
	SET_UART_TRANSMITTER_EMPTY_ENABLE();
	// UART IO 設定
	SET_UART_RX_PIN_PA6();
	SET_UART_TX_PIN_PA5();
    DrvUartFormat.RxLength = 8;
}
void  Drv_UartStartTx( unsigned char TxLength)
{
	DrvUartFormat.TxLength = TxLength;
	// Start TX
	DrvUartFormat.flag.b.IsBusyTx = 1;// uart 忙碌
	DrvUartFormat.TxBufoffset = 0;	// 因為0已經直接發送了
	_acc = _usr;
	_txr_rxr = DrvUartFormat.TxBuf[0];
}
/***********************************
Function:  UART 數據發送和接收中斷子程序
INPUT	:
OUTPUT	:
NOTE	:
***********************************/
DEFINE_ISR(UART_ISR, 0x028)
{
	// 奇偶校验出错
	// if (_perr0)
	// {
	// 	_acc = _usr;
	// 	_acc = _txr_rxr;
	// }
	// 錯誤處理
	if (_nf | _ferr | _oerr)	//  噪声干扰错误 | 帧错误 | 溢出错误
	{
		_acc = _usr;
		_acc = _txr_rxr;
		DrvUartFormat.RxBufoffset = 0;
	}
	// 发送数据
	if (_txif && DrvUartFormat.flag.b.IsBusyTx)
	{
		// 數據幀發送完成判斷
		DrvUartFormat.TxBufoffset++;
		if ( DrvUartFormat.TxBufoffset < DrvUartFormat.TxLength)
		{
			_txr_rxr = DrvUartFormat.TxBuf[DrvUartFormat.TxBufoffset];
		}
		else
		{
			if (_tidle)
			{
				DrvUartFormat.flag.b.IsBusyTx = 0;
			}
		}
	}
	// 接收数据
	if (_rxif)
	{
		DrvUartFormat.RxBuf[DrvUartFormat.RxBufoffset] = _txr_rxr;
		DrvUartFormat.RxTimeOutCnt = 0;
        DrvUartFormat.RxBufoffset++;
        // 用戶需要在此寫Rx數據長度
        // 1 固定長度,則在初始化的時候初始化話lu8v_RxBufLength
        // 2 協議自帶長度信息
//        if (DrvUartFormat.RxBufoffset == 3)
//        {
//        	DrvUartFormat.RxBufoffset = DrvUartFormat.RxBuf[2];
//        }
        if (DrvUartFormat.RxBufoffset >= DrvUartFormat.RxLength)
        {
            DrvUartFormat.RxBufoffset = 0;
            DrvUartFormat.RxLength = 8;
            DrvUartFormat.flag.b.IsRxSuccess = 1;
        }
	}
}

#if 0
#define UART_OK		0x00;
#define UART_OVER	0x02;
/**
 * @brief 將字符串寫入TxBuf
 *
 * @param src string字符串
 * @param startaddr  tx buf開始地址
 * @param len	字符串長度
 * @return unsigned char
 */
unsigned char Drv_WriteTxBuf(char* src, unsigned char startaddr, unsigned char len)
{
	if (len+startaddr > UART_LENGTH_TX)
	{
		return UART_OVER;
	}
	else
	{
		unsigned char i;
		for ( i = startaddr; i < startaddr+len; i++)
		{
			DrvUartFormat.TxBuf[i] = *src++;
		}
		return UART_OK;
	}
}
#endif
