#ifndef SDK_ADCFilter_IIR_h
#define SDK_ADCFilter_IIR_h

//
////@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//// ====================================================================================@
////                                4. 稱重濾波  設置                                     @
//// ====================================================================================@
////@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
////operate : numeric  	fution: ~~
//#define ADCSTABLE_WEIGHT_CNT        8  //  range:  8~20 	數值越小，去皮&校準時間越快,建議8
////operate : numeric  	fution: ~~
//#define ADCSTABLE_WEIGHT_THRESHOLD  15 // range: 0 ~65535  數值越大，起皮&校準時間越快,建議2*weightSpan



//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ======================================================@
//              SDK接口  ADC濾波接口                      @
// ======================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
typedef struct
{
	long Current;			// R 當前濾波ADC數據
	long BufMax;			// R 濾波 buf 中最大的ADC值,如果為0x00000000,說明跳動值超過設置濾波範圍
	long BufMin;			// R 濾波 buf 中最小的ADC值,如果為0xFFFFFFFF,說明跳動值超過設置濾波範圍
	unsigned int StableThreshold;   // RW 目標穩度閥值,用戶在SDK_UserSetting.h設定值
	unsigned char StableCntTag;		// RW 目標穩度次數,用戶在SDK_UserSetting.h設定值
	unsigned char StableCntCurrent; // R 當前穩度次數
	union {
		struct
		{
			unsigned char IsReady : 1;  // R 有一筆濾波ADC數據
			unsigned char IsStable : 1; // R 濾波ADC數據處於穩定狀態
		} b;
		unsigned char byte;
	} flag;
} ADCFilter_t;

void fun_FilterInit();
void fun_Filtering();
extern ADCFilter_t SDKADCFilterData;        // 濾波ADC數據,詳細參考SDK_typedef.h ADCFilter_t

#endif