/**
 * @file AP_BIA8_IQMode.c
 * @author 陳挺 (tony@e-besthealth.com)
 * @brief IQ Mode阻抗掃描，尋找相關性
 * @version 0.1
 * @date 2019-12-04
 *
 * @copyright BEST HEALTH ELECTRONIC INC (c) 2019
 *
 * Compiler Ver. : V3.57
 * IDE3000  Ver. : V8.02
 * MCU / CFG Ver. :BH66F2663/1.3
 */
#include "..\BH66F2663_Drv\Project_Global.h"
#include "BH66F2663.h"
#include "..\BH66F2663_Drv\Drv_AFE_ADC.h"
#include "..\BH66F2663_Drv\Drv_AFE_Power.h"
#include "..\BH66F2663_Drv\Drv_BIA.h"

#include "..\BH66F2663_Lib\SDK_ADCFilter_IIR.h"
#include "AP_BIA8_FWR.h"
#include "AP_BIA8_IQ.h"
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@阻抗變設定@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
volatile typedefImpedance *IQPointerImpedanceScan;

BIA8FWRScan_t BIA8FWRScan;

#define Impedance_RF1   14.96f        // 實際參考電阻阻值放大100倍，例RF1 = 14.96ohm
#define Impedance_RF2   98.39f		// 98.39f
#define Impedance_RF3   839.10f		// 839.10f
#define Impedance_RF4   914.96f		// 914.96f
/**
 * @brief 根據ADC值計算阻抗值
 *
 */
void GetBIA_Z()
{
	IQPointerImpedanceScan = &BIA8FWRScan.fitterADC_TWOLEGS;
	unsigned char i;
	for (i = 0; i < 11; i++)
	{
		if (*IQPointerImpedanceScan == 0)
		{
			*IQPointerImpedanceScan = 0x00;
		}
		else if (*IQPointerImpedanceScan < BIA8FWRScan.fitterADC_RF2)
		{
			*IQPointerImpedanceScan = (Impedance_RF1 + ((*IQPointerImpedanceScan-BIA8FWRScan.fitterADC_RF1)*(Impedance_RF2 - Impedance_RF1))/(BIA8FWRScan.fitterADC_RF2-BIA8FWRScan.fitterADC_RF1));
		}
		else if (*IQPointerImpedanceScan < BIA8FWRScan.fitterADC_RF3)
		{
			*IQPointerImpedanceScan = (Impedance_RF2 + ((*IQPointerImpedanceScan-BIA8FWRScan.fitterADC_RF2)*(Impedance_RF3 - Impedance_RF2))/(BIA8FWRScan.fitterADC_RF3-BIA8FWRScan.fitterADC_RF2));
		}
		else
		{
			*IQPointerImpedanceScan = (Impedance_RF3 + ((*IQPointerImpedanceScan-BIA8FWRScan.fitterADC_RF3)*(Impedance_RF4 - Impedance_RF3))/(BIA8FWRScan.fitterADC_RF4-BIA8FWRScan.fitterADC_RF3));
		}
		IQPointerImpedanceScan++;
	}
}

/**
 * @brief 八電極阻抗相角測量
 * @note RF1=R7//(R9+R10+R11) RF2=R9//(R7+R10+R11) RF3=R10//(R7+R7+R11) RF4=R11//(R7+R9+R10)
 * @note 開發板V1.2 R7=15ohm  R9=100ohm R10=1000ohm R11=5100ohm
 * @note 開發板V1.4 R7=15ohm R10=100ohm R11=1000ohm R9=5100ohm  開發板V1.4參考電阻的計算方式: RF1=R7//(R9+R10+R11) RF2=R10//(R7+R7+R11) RF3=R11//(R7+R9+R10) RF4=R9//(R7+R10+R11)
 *
 */
void AP_BIA8_FWR_Loop()
{
	static unsigned char ChannelState;
	if (BIA8FWRScan.statusSet == MODE_INIT)
	{
		// AFE Power
		Drv_VOREG_OUTPUT(VOREG_POWERON_2V6);
		// SINE WAVE
		Drv_BIAPowerOn();

		ChannelState = MODE_INIT;
		BIA8FWRScan.statusRead = BIA8_CHANNEL_RF1;
		IQPointerImpedanceScan = &BIA8FWRScan.fitterADC_RF1;
		// ADC
		SET_VREF_GAIN_0_5();
		SET_ADC_GAIN_1();
		SET_PGA_GAIN_1();
		SET_ADC_DATARATE3_64HZ();
		SDKADCFilterData.StableThreshold = 50;
		SDKADCFilterData.StableCntTag  = 10;
		BIA8FWRScan.statusSet = MODE_STATE;
	}
	else if (BIA8FWRScan.statusSet == MODE_STATE)
	{
		switch (ChannelState)
		{
		case MODE_INIT:
			if (BIA8Setting.Channel & BIA8FWRScan.statusRead)
			{
				SET_ADC_CHANNEL_MODE_IQ_R();
				Drv_BIA8ChannelSwich(BIA8Setting.Channel & BIA8FWRScan.statusRead);
				Drv_ADCStart();
				// 濾波設置初始化
				fun_FilterInit();
				ChannelState =  MODE_STATE;
			}
			else
			{
				if (BIA8FWRScan.statusRead == BIA8_CHANNEL_TRUNK)
				{
					*IQPointerImpedanceScan = 0;
					IQPointerImpedanceScan++;
					GetBIA_Z();
					BIA8FWRScan.statusRead = BIA8_FINISH;
				}
				else
				{
					*IQPointerImpedanceScan = 0;
					IQPointerImpedanceScan++;
					BIA8FWRScan.statusRead <<= 1;
				}
			}
			break;
		case MODE_STATE:
			fun_Filtering();
			if (SDKADCFilterData.flag.b.IsStable)
			{
				*IQPointerImpedanceScan = SDKADCFilterData.Current;
				IQPointerImpedanceScan++;
				if (BIA8FWRScan.statusRead == BIA8_CHANNEL_TRUNK)
				{
					GetBIA_Z();
					BIA8FWRScan.statusRead = BIA8_FINISH;
				}
				else
				{
					BIA8FWRScan.statusRead <<= 1;
				}
				ChannelState =  MODE_INIT;
			}
		case MODE_FINISH:
			break;
		default:
			break;
		}
	}
	else if (BIA8FWRScan.statusSet == MODE_EXIT)
	{
        Drv_BIAPowerDown();
	}
}
