//___________________________________________________________________
//___________________________________________________________________
//  Copyright : 2015 BY HOLTEK SEMICONDUCTOR INC
//  File Name : KeyScan.c
// Description: 按鍵掃描程序
//   Customer :
//Targer Board: BFA-9043
//   MCU      : HT45F75
//___________________________________________________________________
//___________________________________________________________________
#include "common.h"

volatile unsigned char 	gu8v_ShortPushCnt;	// 短按的次數

volatile unsigned char 	gu8v_KeyState_Now;	   	// 按鍵的狀態
volatile unsigned char 	gu8v_KeyState_Last;	   	// 按鍵的狀態

volatile unsigned char 	gu8v_KeyMap;	   	// 按鍵的鍵值
volatile unsigned int  gu8v_KeyDebounceCnt; // 按鍵Debounce的次數

volatile bit  gbv_KeyScancycleMs;		// Time 2ms標誌位,用於按鍵偵測等動作
volatile bit gbv_KeyState_Changed;
volatile bit gbv_KeyLongPush;
volatile bit gbv_KeyShortPush;
volatile bit gbv_RTestMode;
volatile bit gbv_Key_Long_Keeping;
volatile bit gbv_Check_LongKey;
volatile bit gbv_Check_ShorKey;

#define KEY_SCAN_CYCLE_MS	8
volatile enum KEY_t KeyStatus;
/********************************************************************
Function: 按鍵掃描
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_KeyScan()
{
	if(gbv_KeyScancycleMs)
	{
		gbv_KeyScancycleMs = 0 ;
		gu8v_KeyState_Now =  KEY_PORT & KEY_MAP;
		if( gu8v_KeyState_Now != gu8v_KeyState_Last)
		{
			if (gu8v_KeyDebounceCnt < (2000/KEY_SCAN_CYCLE_MS) && gu8v_KeyDebounceCnt > (60/KEY_SCAN_CYCLE_MS))
			{
				gbv_KeyShortPush = 1;
				gbv_KeyLongPush  = 0;
				gu8v_KeyMap = gu8v_KeyState_Last;
			}
			gu8v_KeyState_Last = gu8v_KeyState_Now;
			gu8v_KeyDebounceCnt = 0;
			gbv_Key_Long_Keeping = 0;
		}
		else
		{
			gu8v_KeyDebounceCnt++;
			if (gu8v_KeyDebounceCnt > (2000/KEY_SCAN_CYCLE_MS) && !gbv_Key_Long_Keeping)
			{
				gbv_KeyShortPush = 0;
				gbv_KeyLongPush  = 1;
				gbv_Key_Long_Keeping = 1;
				gu8v_KeyMap = gu8v_KeyState_Now;
			}
		}

		// 按鍵任務判斷
		if(gbv_KeyShortPush)
		{
			gbv_KeyShortPush = 0;
//			if (gu8v_KeyMap == KEY_1)
//			{
//				KeyStatus = KEY1_SHORT;					// user code
//			}
			if (gu8v_KeyMap == KEY_2)
			{
//				KeyStatus = KEY2_SHORT;					// user code
				AP_BIA8_Start(); // 阻抗掃描應用
			}
			if (gu8v_KeyMap == KEY_3)
			{
//				KeyStatus = KEY3_SHORT;					// user code
				BIA8FWRScan.Status = MODE_NONE;
				Drv_ADCStop();
			}
		}
		if(gbv_KeyLongPush)
		{
			gbv_KeyLongPush = 0;
//			if (gu8v_KeyMap == KEY_1)
//			{
//				KeyStatus = KEY1_LONG;					// user code
//			}
			if (gu8v_KeyMap == KEY_2)
			{
//				KeyStatus = KEY2_LONG;					// user code
			}
			if (gu8v_KeyMap == KEY_3)
			{
//				KeyStatus = KEY3_LONG;					// user code
			}
		}
	}
}