
#include "..\BH66F2663_Drv\Project_Global.h"
#include "BH66F2663.h"
#include "..\BH66F2663_Lib\SDK_ADCFilter_IIR.h"
#include "..\BH66F2663_Drv\Drv_EEPROM.h"
#include "..\BH66F2663_Drv\Drv_AFE_ADC.h"
#include "..\BH66F2663_Drv\Drv_AFE_Power.h"
#include "stdlib.h"
#include "SDK_BodyScales.h"
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                                    功能說明    				             		    @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
/*
1. 自動標定,標定重量固定為50Kg/50Kg/50Kg
2. 手動標定,標定重量固定為50Kg/50Kg/50Kg
3. 穩定重量解鎖,重量用戶可自行設置
4. 臨時重量解鎖,重量用戶可自行設置
5. 自動喚醒,重量用戶可自行設置

1. 若用戶不需要自動標定 CalADCDataTemp 可用CalADCData共用,不然不行
*/

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                                  封庫設置                                            @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#define SET_ADCGAIN_WEIGHT()        { _pgac0 = 0x27;}   // 稱重ADC放大設置,VGS=0.5,ADGN =1,PGA=128
#define SET_DCSET_WEIGHT()          { _pgac1 = 0x00;}   // 稱重DCSET設置,DCSET = 0V
#define SET_ADCCHAN_WEIGHT()        { _pgacs = 0x10;}   // 稱重ADC 通道AN0&AN1
#define SET_ADCVREF_WEIGHT()	    { _vrefs = 1; }     // 稱重ADC 外部參考電壓

#define CALSPANCHECK 30				// 重量標定結束，砝碼之間的允許差異的最大值16*Span
#define WEIGHT_CAL1 (50 * 20)		// 重量校準點1
#define WEIGHT_CAL2 (50 * 20)		// 重量校準點2
#define WEIGHT_CAL3 (50 * 20)		// 重量校準點3

#define EEPROM_DATA_CALID_CODE 0xAA // 校準成功標誌數據,偵測到此數據,認為校準成功




#define EEPROM_ADDR_START 0x01		// EEPROM 存儲開始位置
#define EEPROM_ADDR_END (4 * 4 + EEPROM_ADDR_START + 2)
#define EEPROM_SPAN_ADDR (4 * 4 + EEPROM_ADDR_START+1 )
#define CAL_Diff_ADC_DEFAULT 2000
//**************量校準參數預設***********
#define CAL0DATA_DEFAULT 1942		// 0點默認校準值
#define CAL1DATA_DEFAULT 32000		// 第1點默認校準值
#define CAL2DATA_DEFAULT 32000		// 第2點默認校準值
#define CAL3DATA_DEFAULT 32000		// 第3點默認校準值
#define CALDATASPAN_DEFAULT 6		// 默認分辨率對應ADC值


//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                                  源代碼                                             @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@


Weight_t SDKWeight;
WeightCal_t SDKWeightCal;
volatile typedefWeight *WeightPointer; // 指針使用特別注意範圍,防止越界更改值！！！

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ========================================@
//                  校準 代碼	    	    @
// ========================================@
#define weightCalADCDataLast SDKWeightCal.CalADCDataTemp.Cal3 // 最後一步才用到buf3,此處共用RAM


void fun_LoadWeightSetting()
{
	SET_ADC_DATARATE_NORMAL();
	SDKADCFilterData.StableCntTag = ADCSTABLE_WEIGHT_CNT;
	SDKADCFilterData.StableThreshold   = ADCSTABLE_WEIGHT_THRESHOLD;
}
/****************************************
 Function: 標定判斷
 INPUT	:
 OUTPUT	:
NOTE	:  連續三次相等重量放上去
*****************************************/
void fun_weightAutoCal()
{
	if (SDKADCFilterData.Current > (weightCalADCDataLast + CAL_Diff_ADC_DEFAULT)) //這次ADC值比上次大
	{
		WeightPointer++;
		SDKWeightCal.status++;
		weightCalADCDataLast = SDKADCFilterData.Current; // 更新
		*WeightPointer = SDKADCFilterData.Current;
		if (SDKWeightCal.status == STATE_WEIGHT_CALCHECK)
		{
			WeightPointer = &SDKWeightCal.CalADCDataTemp.Cal0; // 三次放置重物,不管結果指針回復初值,防止異常寫值
			SDKWeightCal.CalADCDataTemp.Cal3 = SDKWeightCal.CalADCDataTemp.Cal3 - SDKWeightCal.CalADCDataTemp.Cal2;
			SDKWeightCal.CalADCDataTemp.Cal2 = SDKWeightCal.CalADCDataTemp.Cal2 - SDKWeightCal.CalADCDataTemp.Cal1;
			SDKWeightCal.CalADCDataTemp.Cal1 = SDKWeightCal.CalADCDataTemp.Cal1 - SDKWeightCal.CalADCData.Cal0;
			SDKWeightCal.CalADCDataTemp.Cal0 = SDKWeightCal.CalADCData.Cal0;
			SDKWeightCal.Span = SDKWeightCal.CalADCDataTemp.Cal1 / WEIGHT_CAL1;
			// 每段斜率之間差值不能超過8倍Span
			if (labs(SDKWeightCal.CalADCDataTemp.Cal3 - SDKWeightCal.CalADCDataTemp.Cal2) < (unsigned int)SDKWeightCal.Span * CALSPANCHECK &&
				labs(SDKWeightCal.CalADCDataTemp.Cal2 - SDKWeightCal.CalADCDataTemp.Cal1) < (unsigned int)SDKWeightCal.Span * CALSPANCHECK)
			{
				SDKWeightCal.CalADCData.Cal0 = SDKWeightCal.CalADCDataTemp.Cal0;
				SDKWeightCal.CalADCData.Cal1 = SDKWeightCal.CalADCDataTemp.Cal1;
				SDKWeightCal.CalADCData.Cal2 = SDKWeightCal.CalADCDataTemp.Cal2;
				SDKWeightCal.CalADCData.Cal3 = SDKWeightCal.CalADCDataTemp.Cal3;
				SDKWeightCal.status = STATE_WEIGHT_CALPASS;
				unsigned char *p;
				unsigned char eepromAddress = EEPROM_ADDR_START;
				p = &SDKWeightCal.status;
				for (; eepromAddress < EEPROM_ADDR_END; eepromAddress++)
				{
					Write_EEPROMByte(eepromAddress, *p);
					p++;
				}
				// 此部分賦值,這樣迫使生產需要掉電后在看數據
				// 防止EEPROM未正常寫入,但產線未掉電而流出
				SDKWeightCal.CalADCData.Cal0 = 0x00;
				SDKWeightCal.CalADCData.Cal1 = 0x00;
				SDKWeightCal.CalADCData.Cal2 = 0x00;
				SDKWeightCal.CalADCData.Cal3 = 0x00;
				//BHSDKState = STATE_WEIGHT_CALPASS;
			}
			else
			{
				SDKWeightCal.status = STATE_WEIGHT_CALFAIL;
			}
			SDKWeight.statusSet = MODE_EXIT;
		}
		SDKWeight.statusRead = SDKWeightCal.status;// 自動標定下,無法看到標定中間過程.此句會改變原來的狀態,但是外面在重新幅值
	}
}
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ========================================@
//               正常稱重 代碼	     	    @
// ========================================@
// 接口變量
volatile typedefWeight haltWeightADCData;  // 休眠殘留ADC值，用於自動喚醒,休眠前重量可能滿量程,需要使用typedefWeight
volatile unsigned int AutoOnWeightADCData; // 自動開機ADC值,自動開機重量較小,int 型即可

void fun_WeightPowerOn()
{
	SDKWeight.flag.b.IsAutoCalOn    = WEIGHT_AUTOCAL;
	SDKWeight.flag.b.IsAutoUnlockOn = WEIGHT_AUTOUNLOCK;
	// weight PowerOn config
	unsigned char *p;
	unsigned char eepromAddress;
	eepromAddress = EEPROM_ADDR_START;
	p = &SDKWeightCal.status;
	for (; eepromAddress < EEPROM_ADDR_END; eepromAddress++)
	{
		*p = Read_EEPROMByte(eepromAddress);
		p++;
	}
	if(SDKWeightCal.status != STATE_WEIGHT_CALPASS)
	{
		SDKWeightCal.CalADCData.Cal0 = CAL0DATA_DEFAULT;
		SDKWeightCal.CalADCData.Cal1 = CAL1DATA_DEFAULT;
		SDKWeightCal.CalADCData.Cal2 = CAL2DATA_DEFAULT;
		SDKWeightCal.CalADCData.Cal3 = CAL3DATA_DEFAULT;
		SDKWeightCal.Span = CALDATASPAN_DEFAULT;
	}
	AutoOnWeightADCData = SDKWeightCal.Span * WEIGHT_AUTOON;
	SDKWeight.statusRead = STATE_WEIGHT_PREPARE;
}
void fun_WeightPowerDown()
{
	SDKWeight.flag.b.IsAutoCalOn = 0;
	Drv_ADCStop();
	Drv_VOREG_OUTPUT(VOREG_POWEROFF);
}
/***********************************
Function: 稱重硬件配置
INPUT	:
OUTPUT	:
NOTE	:
***********************************/
void fun_WeightHardwareSetting()
{
	SET_ADCCHAN_WEIGHT();
	SET_ADCGAIN_WEIGHT();
	SET_DCSET_WEIGHT();
	SET_ADCVREF_WEIGHT();
}
/***********************************
Function: 利用ADC值得到體重值
INPUT	:
OUTPUT	:
NOTE	:
***********************************/
void fun_GetWeighData()
{
	if (SDKADCFilterData.Current < SDKWeightCal.CalADCData.Cal0) // TODO 直接在此做小於秤台重量更新為0
	{
		SDKWeight.DataCurrent = 0;
		haltWeightADCData = 0;
	}
	else
	{
		haltWeightADCData = SDKADCFilterData.Current - SDKWeightCal.CalADCData.Cal0;
		if (haltWeightADCData <= SDKWeightCal.CalADCData.Cal1)
		{
			SDKWeight.DataCurrent = WEIGHT_CAL1 * (u32)haltWeightADCData / SDKWeightCal.CalADCData.Cal1;
		}
		else if (haltWeightADCData <= (SDKWeightCal.CalADCData.Cal1 + SDKWeightCal.CalADCData.Cal2))
		{
			SDKWeight.DataCurrent = WEIGHT_CAL1 + WEIGHT_CAL2 * (u32)(haltWeightADCData - SDKWeightCal.CalADCData.Cal1) / (u32)SDKWeightCal.CalADCData.Cal2;
		}
		else
		{
			SDKWeight.DataCurrent = WEIGHT_CAL1 + WEIGHT_CAL2 + WEIGHT_CAL3 * (u32)(haltWeightADCData - SDKWeightCal.CalADCData.Cal2 - SDKWeightCal.CalADCData.Cal1) / (u32)SDKWeightCal.CalADCData.Cal3;
		}
		// 四捨五入
		// SDKWeight.DataCurrent = (SDKWeight.DataCurrent + 5) / 10;
	}
}
/***********************************
Function: 普通稱重模式
INPUT	:
OUTPUT	:
NOTE	: 包含初次上電的校準
************************************/
void fun_Weight_Normal()
{
	if (SDKWeight.statusSet == MODE_EXIT)
	{
		fun_WeightPowerDown();
	}
	else if (SDKWeight.statusSet == MODE_INIT)
	{
		// BHSDKState = SDKWeight.status;
		// 防止中間ADC模式，在切回時狀態丟失
		if (SDKWeight.statusRead == STATE_WEIGHT_LOADOK)
		{
			SDKWeight.statusRead = STATE_WEIGHT_LOADFIX;
		}
		SDKWeight.statusSet = MODE_STATE;
		fun_WeightHardwareSetting();
		fun_LoadWeightSetting();
		Drv_VOREG_OUTPUT(VOREG_POWERON_2V9);
		Drv_ADCStart();
		fun_FilterInit();
	}
	else if (SDKWeight.statusSet == MODE_STATE)
	{
		fun_Filtering();
		if (SDKADCFilterData.flag.b.IsReady)
		{
			SDKADCFilterData.flag.b.IsReady = 0;
			ADCSourceData.SamplingCnt = 10; // 賦值固定，稱重不需要知道當前筆數，放置255溢出造成三筆丟失有幾筆獲取數據較慢
			fun_GetWeighData();
			// 人為更新零點,常用與上電第一次重量直接為零點重量
			if (SDKWeightCal.flag.b.IsNeedTare && SDKADCFilterData.flag.b.IsStable)
			{
				SDKWeightCal.flag.b.IsNeedTare = 0;
				SDKWeightCal.CalADCData.Cal0 = SDKADCFilterData.Current;
				SDKWeight.DataCurrent = 0x00;
				// TODO 零點寫入EEPROM
			}
			// 小於稱重範圍
			if (SDKWeight.DataCurrent < WEIGHT_MIN)
			{
				// 小重量追零動作
				SDKWeight.DataCurrent = 0;
				if (SDKADCFilterData.flag.b.IsStable)
				{
					SDKWeightCal.CalADCData.Cal0 = SDKADCFilterData.Current;
					// for auto weight cal
					WeightPointer = &SDKWeightCal.CalADCDataTemp.Cal0;
					weightCalADCDataLast = SDKWeightCal.CalADCData.Cal0;
					SDKWeightCal.status = STATE_WEIGHT_CAL1;
				}
				if (SDKWeight.statusRead == STATE_WEIGHT_LOADOK || SDKWeight.statusRead == STATE_WEIGHT_LOADFIX || SDKWeight.statusRead == STATE_WEIGHT_LOADDOWN)
				{
					SDKWeight.statusRead = STATE_WEIGHT_LOADDOWN; // 當前重量為0且得到一筆有效重量,為下秤動作
				}
				else
				{
					SDKWeight.statusRead = STATE_WEIGHT_NOLOAD; //	當前重量為0且沒有得到有效重量,為空載
				}
			}
			// 大於稱重範圍
			else if (SDKWeight.DataCurrent > WEIGHT_MAX && !SDKWeight.flag.b.IsAutoCalOn) // 開啟自動校準不做超載處理
			{
				SDKWeight.statusRead = STATE_WEIGHT_OVERLOAD;
			}
			// 正常稱重範圍
			else
			{
				if (SDKADCFilterData.flag.b.IsStable) // 當前重量為穩定的
				{
					if (SDKWeight.statusRead == STATE_WEIGHT_LOADOK || SDKWeight.statusRead == STATE_WEIGHT_LOADFIX)
					{
						SDKWeight.statusRead = STATE_WEIGHT_LOADFIX;
						if (labs(SDKWeight.DataCurrent - SDKWeight.DataStable) > WEIGHT_UNLOCK_STATE)
						{
							SDKWeight.DataStable = SDKWeight.DataCurrent;
							SDKWeight.statusRead = STATE_WEIGHT_LOADOK;
						}
					}
					if (SDKWeight.statusRead == STATE_WEIGHT_LOADUP || SDKWeight.statusRead == STATE_WEIGHT_OVERLOAD)
					{
						if (SDKWeight.flag.b.IsAutoCalOn) // 啟用自動校準
						{
							fun_weightAutoCal();
						}
						SDKWeight.DataStable = SDKWeight.DataCurrent;
						if (SDKWeight.statusRead != STATE_WEIGHT_CALPASS)
						{
							SDKWeight.statusRead = STATE_WEIGHT_LOADOK;
						}
					}
				}
				else //  當前重量為不穩定
				{
					if (SDKWeight.statusRead == STATE_WEIGHT_LOADOK || SDKWeight.statusRead == STATE_WEIGHT_LOADFIX)
					{
						// 自動解鎖功能 3KG
						if (SDKWeight.flag.b.IsAutoUnlockOn)
						{
							if ((SDKWeight.DataCurrent > SDKWeight.DataStable) && (SDKWeight.DataCurrent - SDKWeight.DataStable > WEIGHT_UNLOCK_TEMP)) // 下秤即歸零
							{
								SDKWeight.statusRead = STATE_WEIGHT_LOADUP;
							}
						}
					}
					else
					{
						SDKWeight.statusRead = STATE_WEIGHT_LOADUP;
					}
				}
			}
			// SDKWeight.status = SDKWeight.status; // 作為不同切換時的保存值
		}
	}
}
/**************************************
Function: 自動上稱判斷
INPUT	:
OUTPUT	:
NOTE	: 用於快速喚醒
***************************************/
void fun_Weight_AutoOn()
{
	if (SDKWeight.statusSet == MODE_EXIT)
	{
		fun_WeightPowerDown();
	}
	else if (SDKWeight.statusSet == MODE_INIT)
	{
		SDKWeight.statusRead = STATE_AUTOON_FASTMODE;
		SDKWeight.statusSet = MODE_STATE;
		fun_WeightHardwareSetting();
		SET_ADC_DATARATE_AUTOON();
		Drv_VOREG_OUTPUT(VOREG_POWERON_2V9);
		Drv_ADCStart();
		fun_FilterInit();
	}
	else if (SDKWeight.statusSet == MODE_STATE)
	{
		if (ADCSourceData.flag.b.IsReady)
		{
			ADCSourceData.flag.b.IsReady = 0;
			if (SDKWeight.statusRead == STATE_AUTOON_SLOWMODE)
			{
				SDKADCFilterData.Current = 0;
			}
			//自動上秤累加數據4筆求平均
			SDKADCFilterData.Current = SDKADCFilterData.Current + (ADCSourceData.data.ADCData >> 4);
			if (ADCSourceData.SamplingCnt == 7)
			{
				if (SDKWeight.statusRead == STATE_AUTOON_FASTMODE)
				{
					SDKADCFilterData.Current = SDKADCFilterData.Current / 4; // 快速頻率,四筆求平均
				}
				// 是否達到自動上稱重量判斷
				if (SDKADCFilterData.Current > SDKWeightCal.CalADCData.Cal0)
				{
					if (((SDKADCFilterData.Current - SDKWeightCal.CalADCData.Cal0) > AutoOnWeightADCData) && (haltWeightADCData < AutoOnWeightADCData))
					{
						if (SDKWeight.statusRead == STATE_AUTOON_SLOWMODE)
						{
							SDKWeight.statusRead = STATE_AUTOON_PASS;
							// Drv_ADCStop();
						}
						else
						{
							fun_WeightHardwareSetting();
							Drv_ADCStart();
							SDKWeight.statusRead = STATE_AUTOON_SLOWMODE; // 這個數據會極大限制，需要特別注意
							ADCSourceData.SamplingCnt = 3;   // 低速只需要一筆數據即可,這樣去除前三筆第四筆即可
						}
					}
					else
					{
						haltWeightADCData = SDKADCFilterData.Current - SDKWeightCal.CalADCData.Cal0;
						SDKWeight.statusRead = STATE_AUTOON_FAIL;
						Drv_ADCStop();
						Drv_VOREG_OUTPUT(VOREG_POWEROFF);
					}
				}
				else
				{
					haltWeightADCData = 0;
					SDKWeight.statusRead = STATE_AUTOON_FAIL;
					Drv_ADCStop();
					Drv_VOREG_OUTPUT(VOREG_POWEROFF);
				}
			}
		}
	}
}

void fun_weight_Cal()
{
	if (SDKWeight.statusSet == MODE_EXIT)
	{
		fun_WeightPowerDown();
	}
	else if (SDKWeight.statusSet == MODE_INIT)
	{
		SDKWeight.statusRead = STATE_WEIGHT_CAL0;
		SDKWeight.statusSet = MODE_STATE;
		SDKWeightCal.status = STATE_WEIGHT_CAL0;
		WeightPointer = &SDKWeightCal.CalADCData.Cal0;
		SDKWeightCal.CalADCData.Cal0 = 0;
		SDKWeightCal.CalADCData.Cal1 = 0;
		SDKWeightCal.CalADCData.Cal2 = 0;
		SDKWeightCal.CalADCData.Cal3 = 0;
		fun_WeightHardwareSetting();
		fun_LoadWeightSetting();
		Drv_VOREG_OUTPUT(VOREG_POWERON_2V9);
		Drv_ADCStart();
		fun_FilterInit();
	}
	else if (SDKWeight.statusSet == MODE_STATE)
	{
		fun_Filtering();
		if (SDKADCFilterData.flag.b.IsStable)
		{
			SDKADCFilterData.flag.b.IsStable = 0;
			if (SDKWeightCal.status == STATE_WEIGHT_CAL0)
			{
				SDKWeightCal.CalADCData.Cal0 = SDKADCFilterData.Current;
				// for weight cal
				WeightPointer = &SDKWeightCal.CalADCDataTemp.Cal0;
				weightCalADCDataLast = SDKWeightCal.CalADCData.Cal0;
				SDKWeightCal.status = STATE_WEIGHT_CAL1;
			}
			else
			{
				fun_weightAutoCal();
				SDKWeight.statusRead = SDKWeightCal.status;
			}
		}
	}
}