/*
 * @Description:
 * @Date: 2019-11-05 13:04:00
 * @Author: 陳挺 tony@e-besthealth.com
 * @LastEditors: 陳挺 tony@e-besthealth.com
 * @LastEditTime: 2019-11-29 11:29:19
 * @copyright: BEST HEALTH ELECTRONIC INC (c) 2019
 */
#include "common.h"
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 共用變量 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
volatile bit gbv_WeightStatus;
volatile bit gbv_BIA8FWR_Data_Z;
volatile bit gbv_BIA8IQ_Data_Z;
volatile bit gbv_BIA8IQ_Data_Phase;
volatile bit gbv_WeightCalStatus;

volatile unsigned int TxSineWaveFreq;
/********************************************************************
Function: UART管理
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void fun_Protocol_Manger()
{
//	volatile long *pointer;
//	volatile unsigned char i;
	//	UART TX
	if((DrvUartFormat.TxCycle > 40/TIMEBASE0_CYCLE8MS) && !DrvUartFormat.flag.b.IsBusyTx)
	{
		DrvUartFormat.TxCycle = 0;
		if (gbv_BIA8FWR_Data_Z)
		{
			gbv_BIA8FWR_Data_Z = 0;
			DrvUartFormat.TxBuf[0] = 0x55;
			DrvUartFormat.TxBuf[1] = ADC_BIA8_FWR;
			DrvUartFormat.TxBuf[2] = BIA8Setting.IQ_FWR;
			DrvUartFormat.TxBuf[3] = BIA8Setting.Freq;
			volatile __16_type tempInt;
			unsigned char i;
			volatile typedefImpedance *TempPointer;
			TempPointer = &BIA8FWRScan.fitterADC_TWOLEGS;
			for ( i = 4; i < 25; i++)
			{
				tempInt.u16 = *TempPointer * 10;
				DrvUartFormat.TxBuf[i] = tempInt.byte.byte1;
				i++;
				DrvUartFormat.TxBuf[i] = tempInt.byte.byte0;
				TempPointer++;
			}
			tempInt.u16 = BIA8FWRScan.statusRead;
			DrvUartFormat.TxBuf[26] = tempInt.byte.byte1;
			DrvUartFormat.TxBuf[27] = tempInt.byte.byte0;
			DrvUartFormat.TxBuf[28] = 0x00;
			volatile unsigned char checkSum = 0;
			for ( i = 0; i < 28; i++)
			{
				checkSum += DrvUartFormat.TxBuf[i];
			}
			checkSum = ~checkSum + 1;
			DrvUartFormat.TxBuf[28] = checkSum;
			DrvUartFormat.TxBuf[29] = 0xAA;
			Drv_UartStartTx(30);
		}
		else if (gbv_BIA8IQ_Data_Z)
		{
			gbv_BIA8IQ_Data_Z = 0;
			DrvUartFormat.TxBuf[0] = 0x55;
			DrvUartFormat.TxBuf[1] = ADC_BIA8_IQ;
			DrvUartFormat.TxBuf[2] = 0x01;		// Z-data
			DrvUartFormat.TxBuf[3] = BIA8Setting.Freq;
			volatile __16_type tempInt;
			unsigned char i;
			volatile typedefImpedance *TempPointer;
			TempPointer = &BIA8IQScan.TwoLegs_Z;
			for ( i = 4; i < 25; i++)
			{
				tempInt.u16 = *TempPointer * 10;
				DrvUartFormat.TxBuf[i] = tempInt.byte.byte1;
				i++;
				DrvUartFormat.TxBuf[i] = tempInt.byte.byte0;
				TempPointer = TempPointer + 2;
			}
			tempInt.u16 = BIA8IQScan.statusRead;
			DrvUartFormat.TxBuf[26] = tempInt.byte.byte1;
			DrvUartFormat.TxBuf[27] = tempInt.byte.byte0;
			DrvUartFormat.TxBuf[28] = 0x00;
			volatile unsigned char checkSum = 0;
			for ( i = 0; i < 28; i++)
			{
				checkSum += DrvUartFormat.TxBuf[i];
			}
			checkSum = ~checkSum + 1;
			DrvUartFormat.TxBuf[28] = checkSum;
			DrvUartFormat.TxBuf[29] = 0xAA;
			Drv_UartStartTx(30);
		}
		else if (gbv_BIA8IQ_Data_Phase)
		{
			gbv_BIA8IQ_Data_Phase = 0;
			DrvUartFormat.TxBuf[0] = 0x55;
			DrvUartFormat.TxBuf[1] = ADC_BIA8_IQ;
			DrvUartFormat.TxBuf[2] = 0x02;		// Phase-Data
			DrvUartFormat.TxBuf[3] = BIA8Setting.Freq;
			volatile __16_type tempInt;
			unsigned char i;
			volatile typedefImpedance *TempPointer;
			TempPointer = &BIA8IQScan.TwoLegs_Phase;
			for ( i = 4; i < 25; i++)
			{
				tempInt.s16 = *TempPointer * 10;
				DrvUartFormat.TxBuf[i] = tempInt.byte.byte1;
				i++;
				DrvUartFormat.TxBuf[i] = tempInt.byte.byte0;
				TempPointer = TempPointer + 2;
			}
			tempInt.u16 = BIA8IQScan.statusRead;
			DrvUartFormat.TxBuf[26] = tempInt.byte.byte1;
			DrvUartFormat.TxBuf[27] = tempInt.byte.byte0;
			DrvUartFormat.TxBuf[28] = 0x00;
			volatile unsigned char checkSum = 0;
			for ( i = 0; i < 28; i++)
			{
				checkSum += DrvUartFormat.TxBuf[i];
			}
			checkSum = ~checkSum + 1;
			DrvUartFormat.TxBuf[28] = checkSum;
			DrvUartFormat.TxBuf[29] = 0xAA;
			Drv_UartStartTx(30);
		}
		else if (gbv_WeightStatus)
		{
			gbv_WeightStatus = 0;
			DrvUartFormat.TxBuf[0] = 0x55;
			DrvUartFormat.TxBuf[1] = ADC_WEIGHT_NORMAL;
			DrvUartFormat.TxBuf[2] = SDKWeight.statusRead;
			__32_type temp;
			temp.s32 = SDKADCFilterData.Current;
			DrvUartFormat.TxBuf[3] = temp.byte.byte3;
			DrvUartFormat.TxBuf[4] = temp.byte.byte2;
			DrvUartFormat.TxBuf[5] = temp.byte.byte1;
			DrvUartFormat.TxBuf[6] = temp.byte.byte0;
			temp.s32 = SDKWeight.DataCurrent;
			DrvUartFormat.TxBuf[7] = temp.byte.byte3;
			DrvUartFormat.TxBuf[8] = temp.byte.byte2;
			DrvUartFormat.TxBuf[9] = temp.byte.byte1;
			DrvUartFormat.TxBuf[10] = temp.byte.byte0;
			temp.s32 = SDKWeight.DataStable;
			DrvUartFormat.TxBuf[11] = temp.byte.byte3;
			DrvUartFormat.TxBuf[12] = temp.byte.byte2;
			DrvUartFormat.TxBuf[13] = temp.byte.byte1;
			DrvUartFormat.TxBuf[14] = temp.byte.byte0;
			DrvUartFormat.TxBuf[15] = SDKWeightCal.flag.b.IsNeedTare;
			DrvUartFormat.TxBuf[16] = 0x00;
			DrvUartFormat.TxBuf[17] = 0x00;

			DrvUartFormat.TxBuf[28] = 0x00;
			unsigned char i;
			volatile unsigned char checkSum = 0;
			for ( i = 0; i < 28; i++)
			{
				checkSum += DrvUartFormat.TxBuf[i];
			}
			checkSum = ~checkSum + 1;
			DrvUartFormat.TxBuf[28] = checkSum;
			DrvUartFormat.TxBuf[29] = 0xAA;
			Drv_UartStartTx(30);
		}
		else if (gbv_WeightCalStatus)
		{
			gbv_WeightCalStatus = 0;
			DrvUartFormat.TxBuf[0] = 0x55;
			DrvUartFormat.TxBuf[1] = ADC_WEIGHT_CAL;
			DrvUartFormat.TxBuf[2] = SDKWeight.statusRead;
			__32_type temp;
			temp.s32 = SDKADCFilterData.Current;
			DrvUartFormat.TxBuf[3] = temp.byte.byte3;
			DrvUartFormat.TxBuf[4] = temp.byte.byte2;
			DrvUartFormat.TxBuf[5] = temp.byte.byte1;
			DrvUartFormat.TxBuf[6] = temp.byte.byte0;
			temp.s32 = SDKWeight.DataCurrent;
			DrvUartFormat.TxBuf[7] = temp.byte.byte3;
			DrvUartFormat.TxBuf[8] = temp.byte.byte2;
			DrvUartFormat.TxBuf[9] = temp.byte.byte1;
			DrvUartFormat.TxBuf[10] = temp.byte.byte0;
			temp.s32 = SDKWeight.DataStable;
			DrvUartFormat.TxBuf[11] = temp.byte.byte3;
			DrvUartFormat.TxBuf[12] = temp.byte.byte2;
			DrvUartFormat.TxBuf[13] = temp.byte.byte1;
			DrvUartFormat.TxBuf[14] = temp.byte.byte0;
			DrvUartFormat.TxBuf[15] = SDKWeightCal.flag.b.IsNeedTare;
			DrvUartFormat.TxBuf[16] = 0x00;
			DrvUartFormat.TxBuf[17] = 0x00;
			DrvUartFormat.TxBuf[28] = 0x00;
			unsigned char i;
			volatile unsigned char checkSum = 0;
			for ( i = 0; i < 28; i++)
			{
				checkSum += DrvUartFormat.TxBuf[i];
			}
			checkSum = ~checkSum + 1;
			DrvUartFormat.TxBuf[28] = checkSum;
			DrvUartFormat.TxBuf[29] = 0xAA;
			Drv_UartStartTx(30);
		}
	}
	// UART RX
	if (DrvUartFormat.flag.b.IsRxSuccess)	// UART RX
	{
		DrvUartFormat.flag.b.IsRxSuccess = 0;
		unsigned char checkSum,i;
		checkSum = 0;
		for (i = 0; i < 7; i++)
		{
			checkSum += DrvUartFormat.RxBuf[i];
		}
		if (checkSum == 0 && DrvUartFormat.RxBuf[0] == 0xAA && DrvUartFormat.RxBuf[7] == 0x55)
		{
			switch (DrvUartFormat.RxBuf[1])
			{
			case ADC_WEIGHT_NORMAL:
				ADCState = ADC_WEIGHT_NORMAL;
				SDKWeight.statusSet = MODE_INIT;
				break;
			case ADC_WEIGHT_AUTOON:
				ADCState = ADC_WEIGHT_NORMAL;
				SDKWeight.statusSet = MODE_INIT;
				break;
			case ADC_WEIGHT_CAL:
				ADCState = ADC_WEIGHT_CAL;
				SDKWeight.statusSet = MODE_INIT;
				break;
			case ADC_BIA8_FWR:
				ADCState = ADC_BIA8_FWR;
				BIA8FWRScan.statusSet = MODE_INIT;
				BIA8Setting.IQ_FWR = DrvUartFormat.RxBuf[2];
				BIA8Setting.Freq = DrvUartFormat.RxBuf[3];;
				BIA8Setting.PeaKScales = 0.6;
				BIA8Setting.Channel = (DrvUartFormat.RxBuf[4]<< 8) + DrvUartFormat.RxBuf[5];
				break;
			case ADC_BIA8_IQ:
				ADCState = ADC_BIA8_IQ;
				BIA8IQScan.statusSet = MODE_INIT;
				BIA8Setting.IQ_FWR = DrvUartFormat.RxBuf[2];
				BIA8Setting.Freq = DrvUartFormat.RxBuf[3];;
				BIA8Setting.PeaKScales = 0.6;
				BIA8Setting.Channel = (DrvUartFormat.RxBuf[4]<< 8) + DrvUartFormat.RxBuf[5];
				break;
			default:
				break;
			}
		}
	}
	//
	if (DrvUartFormat.RxTimeOutCnt> 4)
	{
		DrvUartFormat.RxTimeOutCnt = 0;
		DrvUartFormat.RxBufoffset = 0;
		DrvUartFormat.flag.b.IsRxSuccess  = 0;
	}
}


