#include "common.h"



unsigned char  ADCState;
unsigned char  PollingDisplay_Cnt;
volatile unsigned char  PollingDisplayCycle;
volatile unsigned int haltTime;

void Dis_characterWeight()
{
    SIG_O1 = 0;
    SIG_O2 = 0;
    SIG_O3 = 0;
    SIG_O4 = 0;
    SIG_P1 = 0;
    SIG_P2 = 1;
    SIG_BLE = 0;

    SIG_HR = 0;
    SIG_KG = 0;
    SIG_LINK = 0;
    SIG_JIN = 1;
    SIG_BAT = 0;
    SIG_RE1 = 0;
    SIG_RE2 = 0;
    fun_FW_LEDBuf2HW_LEDBuf();
}

void Dis_BIA_OOOO()
{
    if (PollingDisplayCycle > 500 / 8)
    {
        PollingDisplayCycle = 0;
        PollingDisplay_Cnt++;
        switch (PollingDisplay_Cnt)
        {
        case 1:
            SIG_O1 = 1;
            SIG_O2 = 0;
            SIG_O3 = 0;
            SIG_O4 = 0;
            break;
        case 2:
            SIG_O1 = 0;
            SIG_O2 = 1;
            SIG_O3 = 0;
            SIG_O4 = 0;
            break;
        case 3:
            SIG_O1 = 0;
            SIG_O2 = 0;
            SIG_O3 = 1;
            SIG_O4 = 0;
            break;
        case 4:
            SIG_O1 = 0;
            SIG_O2 = 0;
            SIG_O3 = 0;
            SIG_O4 = 1;
            PollingDisplay_Cnt = 0;
            break;
        default:
            PollingDisplay_Cnt = 0;
            break;
        }
        fun_FW_LEDBuf2HW_LEDBuf();
    }
}


void UserUi()
{
    // 切換工作模式
    if (ADCState == ADC_WEIGHT_NORMAL)
    {
    	if (ADCSourceData.flag.b.IsReady)
        {
            gbv_WeightStatus = 1;
        }
        fun_Weight_Normal();
        if (!SDKWeightCal.flag.b.IsNeedTare)
        {
            Dis_characterWeight();
            switch (SDKWeight.statusRead)
            {
                case STATE_WEIGHT_PREPARE:
                case STATE_WEIGHT_NOLOAD:
                    fun_HEX2BCD4(SDKWeight.DataCurrent);
                    break;
                case STATE_WEIGHT_LOADUP:
                    fun_HEX2BCD4(SDKWeight.DataCurrent);
                    haltTime = HALTTIME_DEFAULT - HALTTIME10S;
                    break;
                case STATE_WEIGHT_LOADOK:
                    fun_HEX2BCD4(SDKWeight.DataStable);
                    break;
                case STATE_WEIGHT_LOADFIX:
                case STATE_WEIGHT_LOADDOWN:
                    fun_HEX2BCD4(SDKWeight.DataStable);
                    break;
                case STATE_WEIGHT_OVERLOAD:
                    gu8v_LED_BCD_Buffer[0] = CHAR_E;
                    gu8v_LED_BCD_Buffer[1] = CHAR_o;
                    gu8v_LED_BCD_Buffer[2] = CHAR_r;
                    gu8v_LED_BCD_Buffer[3] = CHAR_1;
                    fun_FW_LEDBuf2HW_LEDBuf();
                    break;
                case STATE_WEIGHT_CALPASS:
                    gu8v_LED_BCD_Buffer[0] = CHAR_P;
                    gu8v_LED_BCD_Buffer[1] = CHAR_A;
                    gu8v_LED_BCD_Buffer[2] = CHAR_5;
                    gu8v_LED_BCD_Buffer[3] = CHAR_5;
                    fun_FW_LEDBuf2HW_LEDBuf();
                    break;
            }
        }
    }
    else if (ADCState == ADC_WEIGHT_AUTOON)
    {
        fun_Weight_AutoOn();
        switch (SDKWeight.statusRead)
        {
        case STATE_AUTOON_FASTMODE:
        case STATE_AUTOON_SLOWMODE:
            break;
        case STATE_AUTOON_PASS:
			ADCState = ADC_WEIGHT_NORMAL;
            SDKWeight.statusSet = MODE_INIT;
            Drv_PTMn_COUNTER_POWER(0,ON);
            Drv_TIMEBASE_ENABLE(0);
            Drv_TIMEBASE_ENABLE(1);
            Drv_UART_ENABLE();
            break;
        case STATE_AUTOON_FAIL:
//			fun_BodyFatScalesSDK_PowerDown();
	        ADCState = ADC_WEIGHT_AUTOON;
	        SDKWeight.statusSet = MODE_INIT;
			GCC_HALT();
            break;
        }
    }
    else if (ADCState == ADC_WEIGHT_CAL)
    {
    	if (ADCSourceData.flag.b.IsReady)
        {
            gbv_WeightCalStatus = 1;
        }    	
        fun_weight_Cal();
        Dis_characterWeight();
        switch (SDKWeight.statusRead)
        {
        case STATE_WEIGHT_CAL0:
			gu8v_LED_BCD_Buffer[0] = CHAR_C;
			gu8v_LED_BCD_Buffer[1] = CHAR_OFF;
			gu8v_LED_BCD_Buffer[2] = CHAR_0;
			gu8v_LED_BCD_Buffer[3] = CHAR_0;
			haltTime = HALTTIME_DEFAULT - HALTTIME10S;
            break;
        case STATE_WEIGHT_CAL1:
			gu8v_LED_BCD_Buffer[0] = CHAR_C;
			gu8v_LED_BCD_Buffer[1] = CHAR_OFF;
			gu8v_LED_BCD_Buffer[2] = CHAR_5;
			gu8v_LED_BCD_Buffer[3] = CHAR_0;
			haltTime = HALTTIME_DEFAULT - HALTTIME10S;
            break;
        case STATE_WEIGHT_CAL2:
			gu8v_LED_BCD_Buffer[0] = CHAR_C;
			gu8v_LED_BCD_Buffer[1] = CHAR_1;
			gu8v_LED_BCD_Buffer[2] = CHAR_0;
			gu8v_LED_BCD_Buffer[3] = CHAR_0;
			haltTime = HALTTIME_DEFAULT - HALTTIME10S;
            break;
        case STATE_WEIGHT_CAL3:
			gu8v_LED_BCD_Buffer[0] = CHAR_C;
			gu8v_LED_BCD_Buffer[1] = CHAR_1;
			gu8v_LED_BCD_Buffer[2] = CHAR_5;
			gu8v_LED_BCD_Buffer[3] = CHAR_0;
			haltTime = HALTTIME_DEFAULT - HALTTIME10S;
            break;
        case STATE_WEIGHT_CALCHECK:
            break;
        case STATE_WEIGHT_CALPASS:
			gu8v_LED_BCD_Buffer[0] = CHAR_P;
			gu8v_LED_BCD_Buffer[1] = CHAR_A;
			gu8v_LED_BCD_Buffer[2] = CHAR_5;
			gu8v_LED_BCD_Buffer[3] = CHAR_5;
			break;
        case STATE_WEIGHT_CALFAIL:
			gu8v_LED_BCD_Buffer[0] = CHAR_F;
			gu8v_LED_BCD_Buffer[1] = CHAR_A;
			gu8v_LED_BCD_Buffer[2] = CHAR_I;
			gu8v_LED_BCD_Buffer[3] = CHAR_L;
        break;
        default:
            break;
        }
        fun_FW_LEDBuf2HW_LEDBuf();
    }
    else if (ADCState == ADC_BIA8_FWR)
    {
    	if (ADCSourceData.flag.b.IsReady)
        {
            gbv_BIA8FWR_Data_Z = 1;
        }     	
        AP_BIA8_FWR_Loop();
        switch (BIA8FWRScan.statusRead)
        {
        case BIA8_CHANNEL_RF1:
        case BIA8_CHANNEL_RF2:
        case BIA8_CHANNEL_RF3:
        case BIA8_CHANNEL_RF4:
        case BIA8_CHANNEL_TWOLEGS:
        case BIA8_CHANNEL_TWOARMS:
        case BIA8_CHANNEL_LEFTARM:
        case BIA8_CHANNEL_RIGHTARM:
        case BIA8_CHANNEL_LEFTLEG:
        case BIA8_CHANNEL_RIGHTLEG:
        case BIA8_CHANNEL_LEFTBODY:
        case BIA8_CHANNEL_RIGHTBODY:
        case BIA8_CHANNEL_RIGHTRAMANDLEFTLEG:
        case BIA8_CHANNEL_LEFTRAMANDRIGHTLEG:
        case BIA8_CHANNEL_TRUNK:
            Dis_BIA_OOOO();
        break;
        case  BIA8_FINISH:
            BIA8FWRScan.statusSet = MODE_EXIT;
        break;
        default:
            break;
        }
    }
    else if (ADCState == ADC_BIA8_IQ)
    {
    	if (ADCSourceData.flag.b.IsReady)
        {
	        gbv_BIA8IQ_Data_Z = 1;
	        gbv_BIA8IQ_Data_Phase = 1;
        }     	
        AP_BIA8_IQ_Loop();
        switch (BIA8IQScan.statusRead)
        {
        case BIA8_CHANNEL_RF1:
        case BIA8_CHANNEL_RF2:
        case BIA8_CHANNEL_RF3:
        case BIA8_CHANNEL_RF4:
        case BIA8_CHANNEL_TWOLEGS:
        case BIA8_CHANNEL_TWOARMS:
        case BIA8_CHANNEL_LEFTARM:
        case BIA8_CHANNEL_RIGHTARM:
        case BIA8_CHANNEL_LEFTLEG:
        case BIA8_CHANNEL_RIGHTLEG:
        case BIA8_CHANNEL_LEFTBODY:
        case BIA8_CHANNEL_RIGHTBODY:
        case BIA8_CHANNEL_RIGHTRAMANDLEFTLEG:
        case BIA8_CHANNEL_LEFTRAMANDRIGHTLEG:
        case BIA8_CHANNEL_TRUNK:
            Dis_BIA_OOOO();
        break;
        case  BIA8_FINISH:
            BIA8IQScan.statusSet = MODE_EXIT;
        break;
        default:
            break;
        }
    }
    if (haltTime > HALTTIME_DEFAULT)
    {
        Drv_GPIOPowerDownInit();
        Drv_WDTTIME_1000MS();
        Drv_PTMn_COUNTER_POWER(0,OFF);
        Drv_TIMEBASE_DISABLE(0);
        Drv_TIMEBASE_DISABLE(1);
        Drv_UART_DISABLE();
        fun_WeightPowerDown();
        ADCState = ADC_WEIGHT_AUTOON;
        SDKWeight.statusSet = MODE_INIT;
        SDKWeight.DataStable = 0;
        haltTime = 0;
        GCC_HALT();
    }
}