#ifndef USER_UI_H
#define USER_UI_H

#define ADC_NONE           0
#define ADC_WEIGHT_NORMAL  1   // 正常稱重模式
#define ADC_WEIGHT_AUTOON  2   // 自動上稱模式
#define ADC_WEIGHT_CAL     3   // 重量校準模式
#define ADC_BIA8_FWR       4   // 阻抗-FWR模式
#define ADC_BIA8_IQ        5   // 阻抗-IQ模式


// 系統自動休眠時間設定
#define TIMEBASE0_CYCLE8MS    	8	    // 8ms
#define TIMEBASE1_CYCLE1S    	1000 	// 1000ms
#define HALTTIME120S		(120000/TIMEBASE0_CYCLE8MS)
#define HALTTIME60S			(60000/TIMEBASE0_CYCLE8MS)
#define HALTTIME40S			(40000/TIMEBASE0_CYCLE8MS)
#define HALTTIME30S			(30000/TIMEBASE0_CYCLE8MS)
#define HALTTIME20S			(20000/TIMEBASE0_CYCLE8MS)
#define HALTTIME17S			(17000/TIMEBASE0_CYCLE8MS)
#define HALTTIME15S			(15000/TIMEBASE0_CYCLE8MS)
#define HALTTIME12S			(12000/TIMEBASE0_CYCLE8MS)
#define HALTTIME10S			(10000/TIMEBASE0_CYCLE8MS)
#define HALTTIME5S			(5000/TIMEBASE0_CYCLE8MS)
#define HALTTIME4S			(4000/TIMEBASE0_CYCLE8MS)
#define HALTTIME3S			(3000/TIMEBASE0_CYCLE8MS)
#define HALTTIME2S			(2000/TIMEBASE0_CYCLE8MS)
#define HALTTIME1S			(1000/TIMEBASE0_CYCLE8MS)
#define HALTTIME_DEFAULT	HALTTIME120S

void UserUi();


extern unsigned char  ADCState;
extern volatile unsigned char  PollingDisplayCycle;
extern volatile unsigned int haltTime;

#endif



