/*********************************************************************************************************//**
 * @file    BM32S3021_1_HT32/example_distanceLearning/main.c
 * @version V1.0.1
 * @date    2024-08-22
 * @brief   Main program.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/

/* Includes ------------------------------------------------------------------------------------------------*/
#include "BM32S3021_1.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Private types -------------------------------------------------------------------------------------------*/
/* Private constants ---------------------------------------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------------------------------------*/

/* Global variables ----------------------------------------------------------------------------------------*/
uint8_t irStatus = 0;  

/* Private variables ---------------------------------------------------------------------------------------*/
/* Global functions ----------------------------------------------------------------------------------------*/
/*********************************************************************************************************//**
  * @brief  Main program.
  * @retval None
  ***********************************************************************************************************/
int main(void)
{
	RETARGET_Configuration();           //Initialise the serial monitor with a baud rate of 115200
	BM32S3021_1_Init(); // Module initialization using UART communication.   
	BM32S3021_1_distanceLearning();  //Distance learning 
	irStatus = BM32S3021_1_getIRStatus();
	if(!(irStatus&0x08))          //Calibration is completed when BIT3 = 0
    {
			printf("Distance learning success");
		  printf("\r\n");
    }  
  else   
    {
			printf("Distance learning fail");
		  printf("\r\n");
    }  
	while(1)
	{
		 if(!BM32S3021_1_getINT()) //Get INT Status 
    {
     irStatus = BM32S3021_1_getIRStatus();  //Get gesture sensing status
     if(!(irStatus&0x08))          //Calibration is completed when BIT3 = 0
      {
        if(irStatus&0x02)         //Swipe right gesture works
         {
          printf("Swipe right");
		      printf("\r\n");
         }
        else if(irStatus&0x04)    //Swipe lift gesture works
         {
           printf("Swipe left");
		       printf("\r\n");
         }
       }
    }
	}
}


