/*********************************************************************************************************//**
 * @file    BM25S2021_1_HT32/src/BM25S2021_1.h
 * @version V1.0.1
 * @date    2024-08-12
 * @brief   The header file of BM25S2021_1 driver.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __BM25S2021_1_H
#define __BM25S2021_1_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32.h"
#include "i2c_master_config.h"
#include "ht32_board_config.h"
#include "bmduino_check.h"

#include "middleware/i2c_master.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Exported typedef ----------------------------------------------------------------------------------------*/
typedef enum {
  BM25S2021_1_SUCCESS,
  BM25S2021_1_FAILURE
} BM25S2021_1_selStatus;
/* Exported constants --------------------------------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------------------------------------*/
#define BM25S2021_1_COMM_IIC          0
#define BM25S2021_1_COMM_ONEWIRE      1

#define BM25S2021_1_MASTERADDR     0x5C
#define BM25S2021_1_CLKFREQ        40000

/*return status*/
#define BM25S2021_1_READ_OK         0
#define BM25S2021_1_READ_ERROR      1
#define BM25S2021_1_ERROR_NOACK     2
#define BM25S2021_1_ERROR_TIMEOUT   3
#define BM25S2021_1_ERROR_CHECKSUM  4

/* Exported variables --------------------------------------------------------------------------------------*/
/* Exported functions --------------------------------------------------------------------------------------*/
BM25S2021_1_selStatus BM62S2201_1_selWire(uint32_t wire_number);
void BM25S2021_1_I2C_Init(void);
void BM25S2021_1_OneWire_Init(void);

float BM25S2021_1_readTemperature(bool isFahrenheit);
float BM25S2021_1_readHumidity(void);
uint8_t  BM25S2021_1_getFWVer(void);
uint16_t BM25S2021_1_getPID(void);
uint32_t BM25S2021_1_getSN(void);

/*private*/
uint16_t BM25S2021_1_readRawTemperature(void);
uint16_t BM25S2021_1_readRawHumidity(void);
void BM25S2021_1_clearBuff(void);
   
/*IIC*/
void BM25S2021_1_writeBytes(uint8_t wbuf[], uint8_t wlen);
uint8_t BM25S2021_1_readBytes(uint8_t rbuf[], uint8_t rlen);
uint8_t BM25S2021_1_cheackCRC(uint8_t *buff,uint8_t len);
   
/*One Wire*/
uint8_t BM25S2021_1_readOneWireData(void); //start,ACK,Data,STOP
int BM25S2021_1_checkSum(void);

void _BM25S2021_1_SYSTICK_Init(void);     //SYSTICK as Timer
void _BM25S2021_1_delay_ms(vu32 count);   //delay 1ms
void _BM25S2021_1_delay_10us(vu32 count); //delay 10us



#ifdef __cplusplus
}
#endif

#endif

