/*********************************************************************************************************//**
 * @file    BM22S4221_1_HT32/src/BM22S4221_1.h
 * @version V1.0.1
 * @date    2024-09-23
 * @brief   The header file of BM22S4221_1 driver.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _BM22S4221_1_H
#define _BM22S4221_1_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32.h"
#include "i2c_master_config.h"
#include "ht32_board_config.h"
#include "bmduino_check.h"

#include "middleware/i2c_master.h"
#include "middleware/uart_module.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Exported typedef ----------------------------------------------------------------------------------------*/
typedef enum {
  BM22S4221_1_SUCCESS,
  BM22S4221_1_FAILURE
} BM22S4221_1_selStatus;
/* Exported constants --------------------------------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------------------------------------*/

#define BM22S4221_1_UART_TXTIMEOUT          1000   //uint:baud clock
#define BM22S4221_1_UART_RXTIMEOUT_BYTE     10      //uint:ms

#define BM22S4221_1_READ_OK          0
#define BM22S4221_1_READ_ERROR       1
#define BM22S4221_1_NO_ACK           2
#define BM22S4221_1_TIMEOUT_ERROR    3

#define BM22S4221_1_DISABLE         0
#define BM22S4221_1_ENABLE          1 
#define BM22S4221_1_HIGH_LEVEL 0x08
#define BM22S4221_1_LOW_LEVEL 0x00
#define BM22S4221_1_AUTO 0x08
#define BM22S4221_1_PASSIVE  0x00
/* Exported variables --------------------------------------------------------------------------------------*/
/* Exported functions --------------------------------------------------------------------------------------*/
BM22S4221_1_selStatus BM22S4221_1_selSerial(uint32_t serial_number);
void BM22S4221_1_Init(void);
uint8_t BM22S4221_1_getSTATUS(void);
uint8_t BM22S4221_1_requestInfoPackage(uint8_t buff[]);
uint16_t BM22S4221_1_getFWVer(void);
uint8_t BM22S4221_1_getProDate(uint8_t buff[]); 
uint8_t BM22S4221_1_isAutoTx(void);
uint8_t BM22S4221_1_getStatusPinActiveMode(void);
uint8_t BM22S4221_1_getVBG(void);
bool BM22S4221_1_isInfoAvailable(void);
void BM22S4221_1_readInfoPackage(uint8_t array[]);
uint8_t BM22S4221_1_resetModule(void);
uint8_t BM22S4221_1_restoreDefault(void);
uint8_t BM22S4221_1_setAutoTx(uint8_t state);
uint8_t BM22S4221_1_setStatusPinActiveMode(uint8_t state);
uint8_t BM22S4221_1_setOpaGain(uint8_t value);
uint8_t BM22S4221_1_setAlarmThreshold(uint8_t Threshold);
uint8_t BM22S4221_1_setAlarmDetectDelay(uint8_t time);
uint8_t BM22S4221_1_setAlarmOutputTime(uint8_t time);
uint8_t BM22S4221_1_setPreheaTime(uint8_t time);

void BM22S4221_1_writeBytes(uint8_t wbuf[], uint8_t wlen);
uint8_t BM22S4221_1_readBytes(uint8_t rbuf[], uint8_t rlen);

uint8_t  BM22S4221_1_analysis(void);
void _BM22S4221_1_clearBuf(void);
void _BM22S4221_1_delay(vu32 count);



#ifdef __cplusplus
}
#endif

#endif

