/*********************************************************************************************************//**
 * @file    BMD26M088_HT32/gradient/ht32_board_config.h
 * @version V1.0.1
 * @date    2024-08-01
 * @brief   The configuration file.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
// <<< Use Configuration Wizard in Context Menu >>>

/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __HT32_BOARD_CONFIG_H
#define __HT32_BOARD_CONFIG_H

/* Includes ------------------------------------------------------------------------------------------------*/
#include "bmduino_board.h"

/* Settings ------------------------------------------------------------------------------------------------*/
//<o0> WIRE Clock Speed (Hz) <1-1000000:1>
// <i> WIRE clock speed in Hz.
//<o1> WIRE Master Address <0x01-0x7F:1>
// <i> The WIRE master address is in the 7-bit mode range (0x0 ~ 0x7F).
// <i> This value cannot be used by slave address.
#define WIRE_CLOCK_SPEED                          (400000)
#define WIRE_MASTER_ADDRESS                       (0x0A)

#define BMD26M088_WIRE                            (2)  // BMD26M088_WIRE Default Using WIRE2 (BMCOM2) for BMduino EVB.

#if defined(USE_HT32F52352_SK)
/*----------------------------------------------------------------------------------------------------------*/
/* I2C Master Setting                                                                                       */
/*----------------------------------------------------------------------------------------------------------*/
  #undef  BMD26M088_WIRE                               // BMD26M088_WIRE Starter Kit Demo Using WIRE, so NEED TO #undef first.
  #define BMD26M088_WIRE                          (0)  // Default Using WIRE for Starter Kit.

  #define HTCFG_I2CM_CH0                          I2C1
  #define HTCFG_M0_SCL_GPIO_PORT                  A
  #define HTCFG_M0_SCL_GPIO_PIN                   0
  #define HTCFG_M0_SDA_GPIO_PORT                  A
  #define HTCFG_M0_SDA_GPIO_PIN                   1
#endif

#endif
