/*********************************************************************************************************//**
 * @file    BMD26M088_HT32/src/BMD26M088.h
 * @version V1.0.1
 * @date    2024-08-01
 * @brief   The header file of the BMD26M088 libray.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __BMD26M088_H
#define __BMD26M088_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------------------------------------*/
/*
  !!! PORTING !!!
  Include related header files.
*/

#include "ht32.h"
#include "i2c_master_config.h"
#include "ht32_board_config.h"
#include "bmduino_check.h"

#include "middleware/i2c_master.h"

/* Exported typedef ----------------------------------------------------------------------------------------*/
#define MAX_DATA_LENGTH                         (256) /* Reserve 256 bytes for store data length            */
typedef struct
{
  uint8_t registerAddress;
  uint8_t data[MAX_DATA_LENGTH];
} I2C_WriteTypeDef;

/* Exported macro ------------------------------------------------------------------------------------------*/
#define BMD26M088_CCR_3MA                       (0)
#define BMD26M088_CCR_6MA                       (1)
#define BMD26M088_CCR_9MA                       (2)
#define BMD26M088_CCR_12MA                      (3)
#define BMD26M088_CCR_15MA                      (4)
#define BMD26M088_CCR_18MA                      (5)
#define BMD26M088_CCR_21MA                      (6)
#define BMD26M088_CCR_24MA                      (7)
#define BMD26M088_CCR_27MA                      (8)
#define BMD26M088_CCR_30MA                      (9)
#define BMD26M088_CCR_33MA                      (10)
#define BMD26M088_CCR_36MA                      (11)
#define BMD26M088_CCR_39MA                      (12)
#define BMD26M088_CCR_42MA                      (13)
#define BMD26M088_CCR_45MA                      (14)
#define BMD26M088_CCR_48MA                      (15)

#define BMD26M088_DISPLAY_STATIC                (0)
#define BMD26M088_DISPLAY_DYNAMICS              (1)
#define BMD26M088_DISPLAY_VALUE                 (0x00)
#define BMD26M088_DISPLAY_BIN                   (0x80)
#define BMD26M088_MATRIX_9x10                   (1)
#define BMD26M088_MATRIX_12x12                  (2)
#define BMD26M088_MATRIX_16x16                  (3)

#define BMD26M088_SYS_STANDBY                   (0)
#define BMD26M088_SYS_OSC_ON                    (2)
#define BMD26M088_SYS_DIS_ON                    (3)

#define BMD26M088_I2C_ADDRESS_VDD               (0x67)
#define BMD26M088_I2C_ADDRESS_GND               (0x64)
#define BMD26M088_I2C_ADDRESS_SCL               (0x65)
#define BMD26M088_I2C_ADDRESS_SDA               (0x66)
#define BMD26M088_I2C_ADDRESS_BOARDCAST         (0x2E)

#define BMD26M088_HT16D33_CMD_DISPLAY_MODE                (0x30)
#define BMD26M088_HT16D33_CMD_CONFIG_MODE                 (0x31)
#define BMD26M088_HT16D33_CMD_CONNECT_MODE                (0x34)
#define BMD26M088_HT16D33_CMD_SYS_CONTROL                 (0x35)
#define BMD26M088_HT16D33_CMD_SET_CURRENT                 (0x36)
#define BMD26M088_HT16D33_CMD_SET_BRIGHTNESS              (0x37)
#define BMD26M088_HT16D33_CMD_SET_V_BLANK                 (0x39)
#define BMD26M088_HT16D33_CMD_WRITE_LED_DATA              (0x80)
#define BMD26M088_HT16D33_CMD_SET_LED_ON_OFF              (0x84)
#define BMD26M088_HT16D33_CMD_RESET                       (0xCC)

#define BMD26M088_GFS_GRADIENT_GARMA                      (0)
#define BMD26M088_GFS_GRADIENT_LINEAR                     (1)
#define BMD26M088_GFS_BLINK                               (2)
#define BMD26M088_GFT_OFF                                 (0)
#define BMD26M088_GFT_T1_256_FRAME                        (1)
#define BMD26M088_GFT_T1_512_FRAME                        (2)
#define BMD26M088_GFT_T1_1024_FRAME                       (3)
#define BMD26M088_GFT_T1_1536_FRAME                       (4)
#define BMD26M088_GFT_T1_2048_FRAME                       (5)
#define BMD26M088_GFT_T1_2560_FRAME                       (6)
#define BMD26M088_GFT_T1_3072_FRAME                       (7)

#define BMD26M088_T3_IS_T1                                (0)
#define BMD26M088_T3_IS_T1x2                              (1)
#define BMD26M088_T4_IS_T1x1_4                            (0)
#define BMD26M088_T4_IS_T1x1_2                            (1)
#define BMD26M088_T4_IS_T1                                (2)
#define BMD26M088_T4_IS_T1x2                              (3)
#define BMD26M088_T2_IS_T1x1_4                            (0)
#define BMD26M088_T2_IS_T1x1_2                            (1)
#define BMD26M088_T2_IS_T1                                (2)
#define BMD26M088_T2_IS_T1x2                              (3)

/* Exported variables --------------------------------------------------------------------------------------*/
extern uint32_t gBMD26M088_WIRE;

/* Exported typedef ----------------------------------------------------------------------------------------*/
typedef enum {
  BMD26M088_SUCCESS,
  BMD26M088_FAILURE
} BMD26M088_selStatus;

/* Exported functions --------------------------------------------------------------------------------------*/
BMD26M088_selStatus BMD26M088_selWire(uint32_t wire_number);
void BMD26M088_Init(uint8_t i2c_addr, uint32_t i2c_clock);
void BMD26M088_reset(uint8_t i2c_addr);
bool BMD26M088_isConnected(uint8_t i2c_addr, uint32_t i2c_clock);

void BMD26M088_writeCmd(uint8_t i2c_addr, uint8_t cmd, uint8_t data);
uint8_t BMD26M088_readCmd(uint8_t i2c_addr, uint8_t cmd);

void BMD26M088_setOverTemperatureProtect(uint8_t i2c_addr, uint8_t status, bool auto_control);
bool BMD26M088_getOverTemperatureFlag(uint8_t i2c_addr);

void BMD26M088_setLedRAMEnable(uint8_t i2c_addr);
void BMD26M088_setLedRAMDisable(uint8_t i2c_addr);
void BMD26M088_setBrightness( uint8_t i2c_addr, uint8_t brightness);
void BMD26M088_setCurrent(uint8_t i2c_addr, uint8_t level);

void BMD26M088_clearAll(uint8_t i2c_addr);
void BMD26M088_clearRGB(uint8_t i2c_addr, uint8_t RGB_Number);
void BMD26M088_clearRow(uint8_t i2c_addr, uint8_t RowIndex);
void BMD26M088_clearColumn(uint8_t i2c_addr, uint8_t ColumnIndex);

void BMD26M088_writeRGB(uint8_t i2c_addr, uint8_t RGB_Number, uint8_t R, uint8_t G, uint8_t B);
void BMD26M088_writeAllRGB(uint8_t i2c_addr, uint8_t R, uint8_t G, uint8_t B);
void BMD26M088_writeColumn(uint8_t i2c_addr, uint8_t ColumnIndex, uint8_t R, uint8_t G, uint8_t B);
void BMD26M088_writeRow(uint8_t i2c_addr, uint8_t RowIndex, uint8_t R, uint8_t G, uint8_t B);
void BMD26M088_DrawAsciiChar(uint8_t i2c_addr, unsigned char Ch, uint8_t R, uint8_t G, uint8_t B);

void BMD26M088_setGradient(uint8_t i2c_addr, uint8_t mode, uint8_t T1, uint8_t T2, uint8_t T3, uint8_t T4);

#ifdef __cplusplus
}
#endif

#endif

