/*********************************************************************************************************//**
 * @file    BMD26M088_HT32/blink/main.c
 * @version V1.0.1
 * @date    2024-08-01
 * @brief   Main program.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32.h"
#include "ht32_board.h"
#include "ht32_board_config.h"

#include "BMD26M088.h"

/* Private function prototypes -----------------------------------------------------------------------------*/
static void __Delay(u32 count);

/* Global functions ----------------------------------------------------------------------------------------*/
/*********************************************************************************************************//**
  * @brief  Main program.
  * @retval None
  ***********************************************************************************************************/
int main(void)
{
	
  /*
    !!! NOTICE !!!
    BMD26M088 Module I2C slave address should be one of the following values (7-bit Addressing Mode):
    (Please check the jumper on the back of the module, and set the corresponding I2C slave address)
    - BMD26M088_I2C_ADDRESS_VDD       : 0x67 (Factory Default)
    - BMD26M088_I2C_ADDRESS_GND       : 0x64
    - BMD26M088_I2C_ADDRESS_SCL       : 0x65
    - BMD26M088_I2C_ADDRESS_SDA       : 0x66
    - BMD26M088_I2C_ADDRESS_BOARDCAST : 0x2E (Boardcast Address)
  */
  BMD26M088_Init(BMD26M088_I2C_ADDRESS_VDD, WIRE_CLOCK_SPEED);

  BMD26M088_setBrightness(BMD26M088_I2C_ADDRESS_VDD, 0xFF); /* Set global brightness, Max                   */

  BMD26M088_setCurrent(BMD26M088_I2C_ADDRESS_VDD, BMD26M088_CCR_6MA); /* Set drive current 6mA              */

  while (1)                           /* Infinite loop                                                      */
  {
    /* Set init color from color table by index                                                             */
    BMD26M088_writeAllRGB(BMD26M088_I2C_ADDRESS_VDD, 0xFF, 0, 0);
    __Delay(5000000);

    BMD26M088_clearAll(BMD26M088_I2C_ADDRESS_VDD);
    __Delay(5000000);
  }
}

#if (HT32_LIB_DEBUG == 1)
/*********************************************************************************************************//**
  * @brief  Report both the error name of the source file and the source line number.
  * @param  filename: pointer to the source file name.
  * @param  uline: error line source number.
  * @retval None
  ***********************************************************************************************************/
void assert_error(u8* filename, u32 uline)
{
  /*
     This function is called by IP library that the invalid parameters has been passed to the library API.
     Debug message can be added here.
     Example: printf("Parameter Error: file %s on line %d\r\n", filename, uline);
  */

  while (1)
  {
  }
}
#endif

/* Private functions ---------------------------------------------------------------------------------------*/
/*********************************************************************************************************//**
  * @brief  delay function
  * @param  count: delay count for loop
  * @retval None
  ***********************************************************************************************************/
static void __Delay(u32 count)
{
  while (count--)
  {
    __NOP(); // Prevent delay loop be optimized
  }
}
