/*********************************************************************************************************//**
 * @file    BMS81M001_HT32/src/BMS81M001.h
 * @version V1.0.1
 * @date    2024-08-26
 * @brief   The header file of BMS81M001 driver.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __BMS81M001_H
#define __BMS81M001_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32.h"
#include "i2c_master_config.h"
#include "ht32_board_config.h"
#include "bmduino_check.h"

#include "middleware/i2c_master.h"
#include "middleware/uart_module.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Exported typedef ----------------------------------------------------------------------------------------*/
typedef enum {
  BMS81M001_SUCCESS,
  BMS81M001_FAILURE
} BMS81M001_selStatus;
/* Exported constants --------------------------------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------------------------------------*/
#define BMS81M001_CLKFREQ        100000
#define BMS81M001_R_SUCCESS      0
#define BMS81M001_R_FAIL         1
#define BMS81M001_CHECK_OK        0
#define BMS81M001_CHECK_ERROR     1
#define BMS81M001_TIMEOUT_ERROR   2

/* Exported variables --------------------------------------------------------------------------------------*/
/* Exported functions --------------------------------------------------------------------------------------*/
BMS81M001_selStatus BMS81M001_selWire(uint32_t wire_number);
void BMS81M001_Init(void); 
uint8_t BMS81M001_getSTATUS(void);
uint8_t BMS81M001_setShake(uint8_t thr,uint8_t dur); 
uint8_t BMS81M001_setIdleModeDelay(uint8_t idle_delay);
uint8_t BMS81M001_setWorkMode(uint8_t rate,bool isEnable);
uint8_t BMS81M001_getShakeStatus(void);
uint8_t BMS81M001_getParameterSetting(uint8_t *thr,uint8_t *dur,uint8_t *idle_delay);
uint16_t BMS81M001_getFWVer(void);
uint8_t BMS81M001_reset(void);

uint8_t _BMS81M001_wakeup(void);
void _BMS81M001_writeBytes(uint8_t wbuf[], uint8_t wlen);
uint8_t _BMS81M001_readBytes(uint8_t rbuf[], uint8_t rlen);
void _BMS81M001_delay(vu32 count);

#ifdef __cplusplus
}
#endif

#endif

