/*********************************************************************************************************//**
 * @file    BM22S2021_1_HT32/example_airCalibration/main.c
 * @version V1.0.1
 * @date    2025-06-18
 * @brief   Main program.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32_board.h"
#include "BM22S2021_1.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Private types -------------------------------------------------------------------------------------------*/
/* Private constants ---------------------------------------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------------------------------------*/

/* Global variables ----------------------------------------------------------------------------------------*/
uint8_t DATA[1] = {0};
uint8_t calibrateStatus;
/* Private variables ---------------------------------------------------------------------------------------*/
/* Global functions ----------------------------------------------------------------------------------------*/
void SerialMonitor_Init(void);
uint8_t SerialMonitor_Read(uint8_t rbuf[], uint8_t rlen);
/*********************************************************************************************************//**
  * @brief  Main program.
  * @retval None
  ***********************************************************************************************************/
int main(void)
{
	SerialMonitor_Init(); // Initialise the serial monitor with a baud rate of 115200
	BM22S2021_1_Init(); // Module initialization using UART communication. 
    if(BM22S2021_1_setAutoTx(0x00)==0)
    {
      printf("Module connected");          
      printf("\r\n");          
    }
	while(1)
	{

      SerialMonitor_Read(DATA,1);
      if(DATA[0]==0x32)//Send 2 to the serial port monitor for air calibration
      {
        printf("Air calibration begin");          
        printf("\r\n");            
        calibrateStatus=BM22S2021_1_calibrateModule();//Wait for 8s
        if(calibrateStatus==0)
        {
          printf("Air calibration successful");          
          printf("\r\n"); 
        }
        else
        {
          printf("Air calibration failed");          
          printf("\r\n"); 
        }        
      }
      DATA[0]=0;
	}
}

/***********************************************************************************************************
 * @brief  Serial monitor init.
 * @param  void
 * @retval void
 ***********************************************************************************************************/
void SerialMonitor_Init(void)
{
  RETARGET_Configuration();
  { /* Enable peripheral clock of Rx GPIO                                                                 */
    CKCU_PeripClockConfig_TypeDef CKCUClock = {{0}};
    CKCUClock.Bit.HTCFG_UART_RX_GPIO_CLK = 1;
    CKCU_PeripClockConfig(CKCUClock, ENABLE);
  }
  /* Turn on UxART Rx internal pull up resistor to prevent unknow state                                    */
  GPIO_PullResistorConfig(HTCFG_UART_RX_GPIO_PORT, HTCFG_UART_RX_GPIO_PIN, GPIO_PR_UP); // PA5 pull up
}
/***********************************************************************************************************
 * @brief  Read data to serial monitor
 * @param  rbuf:Variables for storing Data to be obtained
 * @param  rlen:Length of data to be obtained
 * @retval result
 *    @arg 0: Read successed
 *    @arg 1: Read fail, Timeout
 ************************************************************************************************************/
uint8_t SerialMonitor_Read(uint8_t rbuf[], uint8_t rlen)
{
  uint8_t i = 0, delayCount = 0;
  for (i = 0; i < rlen; i++)
  {
    delayCount = 0;
    while (USART_GetFIFOStatus(RETARGET_USART_PORT, USART_FIFO_RX) == 0)
    {
      if (delayCount > 50)
      {
        return 1;
      }
      _BM22S2021_1_delay(1);
      delayCount++;
    }
    rbuf[i] = USART_ReceiveData(RETARGET_USART_PORT);
  }
  return 0;
}
