/*********************************************************************************************************//**
 * @file    BM22S2021_1_HT32/example_readSmokeValue/main.c
 * @version V1.0.1
 * @date    2025-06-19
 * @brief   Main program.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/

/* Includes ------------------------------------------------------------------------------------------------*/
#include "BM22S2021_1.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Private types -------------------------------------------------------------------------------------------*/
/* Private constants ---------------------------------------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------------------------------------*/

/* Global variables ----------------------------------------------------------------------------------------*/
uint16_t smokeA;
uint16_t smokeB;
uint8_t Data[41]; 

/* Private variables ---------------------------------------------------------------------------------------*/
/* Global functions ----------------------------------------------------------------------------------------*/
/*********************************************************************************************************//**
  * @brief  Main program.
  * @retval None
  ***********************************************************************************************************/
int main(void)
{
	RETARGET_Configuration();           //Initialise the serial monitor with a baud rate of 115200
    BM22S2021_1_Init(); // Module initialization using UART communication.   
	while(1)
	{
     if (BM22S2021_1_isInfoAvailable() == true)
     {
      BM22S2021_1_readInfoPackage(Data);
     
      smokeA=((uint16_t)Data[17]<<8 | Data[16]);   
      printf("The current smoke detection value of channel A is: ");
      printf("%d ",smokeA);          
      printf("\r\n"); 
     
      smokeB=((uint16_t)Data[19]<<8 | Data[18]);   
      printf("The current smoke detection value of channel B is: ");
      printf("%d ",smokeB);          
      printf("\r\n");          
      printf("\r\n"); 
     }
	}
}
