/*********************************************************************************************************//**
 * @file    BM22S2021_1_HT32/src/BM22S2021_1.h
 * @version V1.0.1
 * @date    2025-06-19
 * @brief   The header file of BM22S2021_1 driver.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __BM22S2021_1_H
#define __BM22S2021_1_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32.h"
#include "i2c_master_config.h"
#include "ht32_board_config.h"
#include "bmduino_check.h"

#include "middleware/i2c_master.h"
#include "middleware/uart_module.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Exported typedef ----------------------------------------------------------------------------------------*/
typedef enum {
  BM22S2021_1_SUCCESS,
  BM22S2021_1_FAILURE
} BM22S2021_1_selStatus;
/* Exported constants --------------------------------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------------------------------------*/

#define   BM22S2021_1_UART_TXTIMEOUT     100
#define   BM22S2021_1_BAUD  9600
#define   BM22S2021_1_CHECK_OK        0
#define   BM22S2021_1_CHECK_ERROR     1
#define   BM22S2021_1_TIMEOUT_ERROR   2


/* Exported variables --------------------------------------------------------------------------------------*/
/* Exported functions --------------------------------------------------------------------------------------*/
BM22S2021_1_selStatus BM22S2021_1_selSerial(uint32_t serial_number);
void BM22S2021_1_Init(void);
uint8_t BM22S2021_1_getSTATUS(void);
uint16_t BM22S2021_1_getFWVer(void);
uint8_t BM22S2021_1_getProDate(uint8_t buff[]);
uint8_t BM22S2021_1_requestInfoPackage(uint8_t buff[]);
bool BM22S2021_1_isInfoAvailable(void);
void BM22S2021_1_readInfoPackage(uint8_t array[]); 
uint8_t BM22S2021_1_readRegister(uint8_t addr);
uint8_t BM22S2021_1_readRunningVariables(uint8_t addr);
uint8_t BM22S2021_1_getAutoTx(void);
uint8_t BM22S2021_1_getStatusPinActiveMode(void);   
uint8_t BM22S2021_1_getT0ATopLimit(void);
uint8_t BM22S2021_1_getT0ABottomLimit(void);
uint8_t BM22S2021_1_getT0BTopLimit(void);
uint8_t BM22S2021_1_getT0BBottomLimit(void);
uint16_t BM22S2021_1_getT0AThreshold(void);
uint16_t BM22S2021_1_getT0BThreshold(void);
uint8_t BM22S2021_1_getDetectCycle(void);     //Set the standby smoke detection cycle
uint8_t BM22S2021_1_calibrateModule(void);
uint8_t BM22S2021_1_resetModule(void);
uint8_t BM22S2021_1_restoreDefault(void);
uint8_t BM22S2021_1_writeRegister(uint8_t addr,uint8_t data);
uint8_t BM22S2021_1_setAutoTx(uint8_t mode);
uint8_t BM22S2021_1_setStatusPinActiveMode(uint8_t state);  
uint8_t BM22S2021_1_setT0ACalibrateRange(uint8_t toplimit,uint8_t bottomlimit);
uint8_t BM22S2021_1_setT0BCalibrateRange(uint8_t toplimit,uint8_t bottomlimit);
uint8_t BM22S2021_1_setT0AThreshold(uint16_t value);
uint8_t BM22S2021_1_setT0BThreshold(uint16_t value);
uint8_t BM22S2021_1_setDetectCycle(uint8_t Cycle);

void _BM22S2021_1_clear_UART_FIFO(void);
void _BM22S2021_1_writeBytes(uint8_t wbuf[], uint8_t wlen);
uint8_t _BM22S2021_1_readBytes(uint8_t rbuf[], uint8_t rlen, uint16_t timOut);
void _BM22S2021_1_delay(vu32 count);

#ifdef __cplusplus
}
#endif

#endif

