/*********************************************************************************************************//**
 * @file    BM22S3221_1_HT32/example_readCOValue/main.c
 * @version V1.0.1
 * @date    2025-06-18
 * @brief   Main program.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/

/* Includes ------------------------------------------------------------------------------------------------*/
#include "BM22S3221_1.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Private types -------------------------------------------------------------------------------------------*/
/* Private constants ---------------------------------------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------------------------------------*/

/* Global variables ----------------------------------------------------------------------------------------*/
uint8_t moduleInfo[32] = {0};
uint16_t ADValue, COValue, COAlarmThreshold;

/* Private variables ---------------------------------------------------------------------------------------*/
/* Global functions ----------------------------------------------------------------------------------------*/
/*********************************************************************************************************//**
  * @brief  Main program.
  * @retval None
  ***********************************************************************************************************/
int main(void)
{
	RETARGET_Configuration();           //Initialise the serial monitor with a baud rate of 115200
    BM22S3221_1_Init(); // Module initialization using UART communication.   
    printf("Module preheat...(about 2 mins)");
	printf("\r\n");
    BM22S3221_1_preheatCountdown();
    printf("End of module preheat.");
	printf("\r\n");
	while(1)
	{
     if (BM22S3221_1_isInfoAvailable() == true)
     {
      BM22S3221_1_readInfoPackage(moduleInfo);
     
      COAlarmThreshold = ((uint16_t)moduleInfo[21] << 8) + moduleInfo[22];   
      printf("CO alarm threshold: ");
      printf("%d ",COAlarmThreshold);  
      printf(" ppm");         
      printf("\r\n"); 
         
      COValue = ((uint16_t)moduleInfo[9] << 8) + moduleInfo[10];   
      printf("CO concentration: ");
      printf("%d ",COValue);  
      printf(" ppm");         
      printf("\r\n");
         
      ADValue = ((uint16_t)moduleInfo[5] << 8) + moduleInfo[6];   
      printf("CO AD Value: ");
      printf("%d ",ADValue);         
      printf("\r\n");
     }
	}
}
