/*************************************************************************************************************
 * @file    BM25S2621_1_HT32/example_getData/main.c
 * @version V1.0.1
 * @date    2025-06-20
 * @brief   Main program.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32.h"
#include "ht32_board.h"
#include "ht32_board_config.h"
#include "BM25S2621_1.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Private types -------------------------------------------------------------------------------------------*/
/* Private constants ---------------------------------------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------------------------------------*/
/* Global variables ----------------------------------------------------------------------------------------*/

uint8_t mois1, mois2, mois3; // Soil moisture value
uint8_t temp1, temp2, temp3; // Soil temperature value
uint8_t module1_id = 2;      // Module 1 ID
uint8_t module2_id = 3;      // Module 2 ID
uint8_t module3_id = 4;      // Module 3 ID

/* Private variables ---------------------------------------------------------------------------------------*/
/* Global functions ----------------------------------------------------------------------------------------*/
void delay(vu32 count);
/***********************************************************************************************************
 * @brief  Main program.
 * @retval None
 ***********************************************************************************************************/
int main(void)
{
  RETARGET_Configuration(); // Initialise the serial monitor with a baud rate of 115200
  BM25S2621_1_Init();       // Module initialization using UART communication.
  delay(100);
  /* Uncomment when setting the ID, only one module can be connected at a time.
  After all settings are completed, comment out the command and then attach all modules to the RS485 bus.
  if (BM25S2621_1_setID(1, modulex_id, true) == BM25S2621_1_CHECK_OK) // x: 1~3
  {
    printf("ID setting successful! New ID: %d\n", newID);
  }
  else
  {
    printf("ID setting fail!\n");
  }
  delay(300);
  */
  while (1)
  {
    if (BM25S2621_1_readTemperatureAndMoisture(module1_id, &temp1, &mois1, false) == BM25S2621_1_CHECK_OK)
    {
      printf("temperature1: %d('C)  moisture1: %d(%%RH)\n", temp1, mois1);
    }
    else
    {
      printf("module1 get temperature and moisture error.\n");
    }
    delay(10);

    if (BM25S2621_1_readTemperatureAndMoisture(module2_id, &temp2, &mois2, false) == BM25S2621_1_CHECK_OK)
    {
      printf("temperature2: %d('C)  moisture2: %d(%%RH)\n", temp2, mois2);
    }
    else
    {
      printf("module2 get temperature and moisture error.\n");
    }
    delay(10);

    if (BM25S2621_1_readTemperatureAndMoisture(module3_id, &temp3, &mois3, false) == BM25S2621_1_CHECK_OK)
    {
      printf("temperature3: %d('C)  moisture3: %d(%%RH)\n", temp3, mois3);
    }
    else
    {
      printf("module3 get temperature and moisture error.\n");
    }
    printf("\n");
    delay(1000);
  }
}

/* Private functions ---------------------------------------------------------------------------------------*/
/***********************************************************************************************************
 * @brief  delay ms.
 * @param  count
 * @retval void
 ************************************************************************************************************/
void delay(vu32 count)
{
  count = SystemCoreClock / 8000 * count;
  while (count--)
    ;
}
