/*************************************************************************************************************
 * @file    BM25S2621_1_HT32/example_readTemperatureAndHumidity/main.c
 * @version V1.0.1
 * @date    2025-06-20
 * @brief   Main program.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32.h"
#include "ht32_board.h"
#include "ht32_board_config.h"
#include "BM25S2621_1.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Private types -------------------------------------------------------------------------------------------*/
/* Private constants ---------------------------------------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------------------------------------*/
/* Global variables ----------------------------------------------------------------------------------------*/
uint8_t Target_ID; // Target ID
uint8_t mois = 0;      // Soil moisture value
uint8_t temp = 0;      // Soil temperature value

/* Private variables ---------------------------------------------------------------------------------------*/
/* Global functions ----------------------------------------------------------------------------------------*/
void delay(vu32 count);
/***********************************************************************************************************
 * @brief  Main program.
 * @retval None
 ***********************************************************************************************************/
int main(void)
{
  Target_ID = 1;            // Target ID
  RETARGET_Configuration(); // Initialise the serial monitor with a baud rate of 115200
  BM25S2621_1_Init();   // Module initialization using UART communication.
  delay(100);
  while (1)
  {
    if (BM25S2621_1_readTemperatureAndMoisture(Target_ID, &temp, &mois, false) == 0)
    {
      printf("Temperature: %d('C)  Moisture: %d(%%RH)\n", temp, mois);
    }
    else
    {
      printf("get temperature and moisture fail!\n");
    }
    delay(1000);
  }
}

/* Private functions ---------------------------------------------------------------------------------------*/
/***********************************************************************************************************
 * @brief  delay ms.
 * @param  count
 * @retval void
 ************************************************************************************************************/
void delay(vu32 count)
{
  count = SystemCoreClock / 8000 * count;
  while (count--)
    ;
}
