/*************************************************************************************************************
 * @file    BM25S2621_1_HT32/src/BM25S2621_1.h
 * @version V1.0.1
 * @date    2025-06-20
 * @brief   The header file of BM25S2621_1 driver.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __BM25S2621_1_H
#define __BM25S2621_1_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------------------------------------*/
/*
  !!! PORTING !!!
  Include related header files.
*/
#include "ht32.h"
#include "i2c_master_config.h"
#include "ht32_board_config.h"
#include "bmduino_check.h"

#include "middleware/uart_module.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Exported typedef ----------------------------------------------------------------------------------------*/
typedef enum {
  BM25S2621_1_SUCCESS,
  BM25S2621_1_FAILURE
} BM25S2621_1_selStatus;

typedef enum // Data storage address
{
  BM25S2621_1_ADDR_ID = 0x00,
  BM25S2621_1_ADDR_MOIS = 0x01,
  BM25S2621_1_ADDR_TEMP = 0x02,
  BM25S2621_1_ADDR_TEMPCALI = 0x03,
  BM25S2621_1_ADDR_MOISCALI = 0x04,
  BM25S2621_1_ADDR_EMPTYWATER = 0X05
} BM25S2621_1_DATA_ADDR;

typedef enum // Function code
{
  BM25S2621_1_FUNCODE_READ = 0x03,
  BM25S2621_1_FUNCODE_WRITE = 0x06,
  BM25S2621_1_FUNCODE_TEMPCALI = 0x0A,
  BM25S2621_1_FUNCODE_MOISCALI = 0X0B,
  BM25S2621_1_FUNCODE_EMPTYWATER = 0X0C
} BM25S2621_1_FUNCODE;
/* Exported constants --------------------------------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------------------------------------*/
#define BM25S2621_1_CHECK_OK                 (0)
#define BM25S2621_1_CHECK_ERROR              (1)
#define BM25S2621_1_TIMEOUT_ERROR            (2)

#define BM25S2621_1_UART_TXTIMEOUT           (1000) // uint:baud clock
#define BM25S2621_1_UART_RXTIMEOUT_BYTE      (50) // uint:ms
/* Exported variables --------------------------------------------------------------------------------------*/
/* Exported functions --------------------------------------------------------------------------------------*/
BM25S2621_1_selStatus BM25S2621_1_selSerial(uint32_t serial_number);
void BM25S2621_1_Init(void);
uint8_t BM25S2621_1_setID(uint8_t currentID, uint8_t newID, bool broadcast);
uint8_t BM25S2621_1_getID(void);
uint8_t BM25S2621_1_readTemperature(uint8_t id, bool broadcast);
uint8_t BM25S2621_1_readMoisture(uint8_t id, bool broadcast);
uint8_t BM25S2621_1_readTemperatureAndMoisture(uint8_t id, uint8_t *temp, uint8_t *mois, bool broadcast);
uint8_t BM25S2621_1_restoreDefault(bool broadcast);

uint8_t BM25S2621_1_sendCommand(uint8_t *ptr_command, uint8_t *ptr_ack);
uint8_t BM25S2621_1_calibrateTemperature(uint8_t id, uint8_t currentTemp, bool broadcast);
uint8_t BM25S2621_1_calibrateMoisture(uint8_t id, uint8_t currentMois, bool broadcast);
uint8_t BM25S2621_1_emptyWaterCalibrate(uint8_t id, bool broadcast);
void _BM25S2621_1_Modbus_CRCcaculate(unsigned char *ptr, int len, u8 *crc_H, u8 *crc_L);
uint8_t _BM25S2621_1_RS485_request(uint8_t id, uint8_t funcode, uint16_t start, uint16_t len, uint8_t *readbuffer);

void BM25S2621_1_writeBytes(uint8_t wbuf[], uint8_t wlen);
uint8_t BM25S2621_1_readBytes(uint8_t rbuf[], uint8_t rlen);
void _BM25S2621_1_delayMs(uint32_t count);
#ifdef __cplusplus
}
#endif

#endif

