/*********************************************************************************************************//**
 * @file    BMS81M001_HT32/example_shift/main.c
 * @version V1.0.1
 * @date    2024-08-26
 * @brief   Main program.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/

/* Includes ------------------------------------------------------------------------------------------------*/
#include "BMD11M134.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Private types -------------------------------------------------------------------------------------------*/
/* Private constants ---------------------------------------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------------------------------------*/

/* Global variables ----------------------------------------------------------------------------------------*/
char sdata[100] = "BEST";
uint8_t i; 
/* Private variables ---------------------------------------------------------------------------------------*/
/* Global functions ----------------------------------------------------------------------------------------*/
/*********************************************************************************************************//**
  * @brief  Main program.
  * @retval None
  ***********************************************************************************************************/
int main(void)
{
	RETARGET_Configuration();           //Initialise the serial monitor with a baud rate of 115200
	BMD11M134_Init(); // Module initialization using IIC communication. 
	while(1)
  {
		BMD11M134_printStr(sdata); //Display the string "BEST"
	  for(i = 0; i < 4; i++)
   {
    _BMD11M134_delay(300);
    BMD11M134_shiftRight(1); //Move the string "BEST" 1 bit to the right
   }
	 _BMD11M134_delay(1000);
	 BMD11M134_printStr(sdata);  //Display the string "BEST"
	 for(i = 0; i < 4; i++) 
   {
    _BMD11M134_delay(300);
    BMD11M134_shiftLeft(1);  //Move the string "BEST" 1 bit to the left
   }
	 _BMD11M134_delay(1000);
  }
}



