/*********************************************************************************************************//**
 * @file    BMD11M134_HT32/src/BMD11M134.h
 * @version V1.0.1
 * @date    2024-08-27
 * @brief   The header file of BMD11M134 driver.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __BMD11M134_H
#define __BMD11M134_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32.h"
#include "i2c_master_config.h"
#include "ht32_board_config.h"
#include "bmduino_check.h"

#include "middleware/i2c_master.h"
#include "middleware/uart_module.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Exported typedef ----------------------------------------------------------------------------------------*/
typedef enum {
  BMD11M134_SUCCESS,
  BMD11M134_FAILURE
} BMD11M134_selStatus;
/* Exported constants --------------------------------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------------------------------------*/
#define BMD11M134_CLKFREQ        100000
#define BMD11M134_R_SUCCESS      0
#define BMD11M134_R_FAIL         1
#define BMD11M134_CHECK_OK        0
#define BMD11M134_CHECK_ERROR     1
#define BMD11M134_TIMEOUT_ERROR   2

/* Exported variables --------------------------------------------------------------------------------------*/
/* Exported functions --------------------------------------------------------------------------------------*/
BMD11M134_selStatus BMD11M134_selWire(uint32_t wire_number);
void BMD11M134_Init(void); 
uint8_t BMD11M134_getNumber(void);
uint8_t BMD11M134_clear(void);
uint8_t BMD11M134_decimalOnSingle(uint8_t displayNumber);
uint8_t BMD11M134_decimalOffSingle(uint8_t displayNumber);
uint8_t BMD11M134_decimalOn(void);
uint8_t BMD11M134_decimalOff(void);
uint8_t BMD11M134_colonOnSingle(uint8_t displayNumber);
uint8_t BMD11M134_colonOffSingle(uint8_t displayNumber);        
uint8_t BMD11M134_colonOn(void);
uint8_t BMD11M134_colonOff(void);
uint8_t BMD11M134_shiftRight(uint8_t shiftAmt);
uint8_t BMD11M134_shiftLeft(uint8_t shiftAmt);    
void BMD11M134_printChar(uint8_t displayNumber, uint8_t displayChar, uint8_t digit);
uint8_t BMD11M134_updateDisplay(void);
uint8_t BMD11M134_printStr(char buffer[]);
uint8_t BMD11M134_setBrightness(uint8_t displayNumber, uint8_t brightness);
uint16_t BMD11M134_getFWVer(uint8_t displayNumber);

uint8_t _BMD11M134_strlen(char *string);
void _BMD11M134_writeBytes(uint8_t wbuf[], uint8_t wlen);
uint8_t _BMD11M134_readBytes(uint8_t rbuf[], uint8_t rlen);
void _BMD11M134_delay(vu32 count);

#ifdef __cplusplus
}
#endif

#endif

